package azqueue

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"bytes"
	"context"
	"encoding/xml"
	"github.com/Azure/azure-pipeline-go/pipeline"
	"io"
	"io/ioutil"
	"net/http"
	"net/url"
	"strconv"
)

// messageIDClient is the client for the MessageID methods of the Azqueue service.
type messageIDClient struct {
	managementClient
}

// newMessageIDClient creates an instance of the messageIDClient client.
func newMessageIDClient(url url.URL, p pipeline.Pipeline) messageIDClient {
	return messageIDClient{newManagementClient(url, p)}
}

// Delete the Delete operation deletes the specified message.
//
// popReceipt is required. Specifies the valid pop receipt value returned from an earlier call to the Get Messages or
// Update Message operation. timeout is the The timeout parameter is expressed in seconds. For more information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations>Setting
// Timeouts for Queue Service Operations.</a> requestID is provides a client-generated, opaque value with a 1 KB
// character limit that is recorded in the analytics logs when storage analytics logging is enabled.
func (client messageIDClient) Delete(ctx context.Context, popReceipt string, timeout *int32, requestID *string) (*MessageIDDeleteResponse, error) {
	if err := validate([]validation{
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.deletePreparer(popReceipt, timeout, requestID)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.deleteResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*MessageIDDeleteResponse), err
}

// deletePreparer prepares the Delete request.
func (client messageIDClient) deletePreparer(popReceipt string, timeout *int32, requestID *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("DELETE", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	params.Set("popreceipt", popReceipt)
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if requestID != nil {
		req.Header.Set("x-ms-client-request-id", *requestID)
	}
	return req, nil
}

// deleteResponder handles the response to the Delete request.
func (client messageIDClient) deleteResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusNoContent)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &MessageIDDeleteResponse{rawResponse: resp.Response()}, err
}

// Update the Update operation was introduced with version 2011-08-18 of the Queue service API. The Update Message
// operation updates the visibility timeout of a message. You can also use this operation to update the contents of a
// message. A message must be in a format that can be included in an XML request with UTF-8 encoding, and the encoded
// message can be up to 64KB in size.
//
// queueMessage is a Message object which can be stored in a Queue popReceipt is required. Specifies the valid pop
// receipt value returned from an earlier call to the Get Messages or Update Message operation. visibilitytimeout is
// optional. Specifies the new visibility timeout value, in seconds, relative to server time. The default value is 30
// seconds. A specified value must be larger than or equal to 1 second, and cannot be larger than 7 days, or larger
// than 2 hours on REST protocol versions prior to version 2011-08-18. The visibility timeout of a message can be set
// to a value later than the expiry time. timeout is the The timeout parameter is expressed in seconds. For more
// information, see <a
// href="https://docs.microsoft.com/en-us/rest/api/storageservices/setting-timeouts-for-queue-service-operations>Setting
// Timeouts for Queue Service Operations.</a> requestID is provides a client-generated, opaque value with a 1 KB
// character limit that is recorded in the analytics logs when storage analytics logging is enabled.
func (client messageIDClient) Update(ctx context.Context, queueMessage QueueMessage, popReceipt string, visibilitytimeout int32, timeout *int32, requestID *string) (*MessageIDUpdateResponse, error) {
	if err := validate([]validation{
		{targetValue: visibilitytimeout,
			constraints: []constraint{{target: "visibilitytimeout", name: inclusiveMaximum, rule: 604800, chain: nil},
				{target: "visibilitytimeout", name: inclusiveMinimum, rule: 0, chain: nil}}},
		{targetValue: timeout,
			constraints: []constraint{{target: "timeout", name: null, rule: false,
				chain: []constraint{{target: "timeout", name: inclusiveMinimum, rule: 0, chain: nil}}}}}}); err != nil {
		return nil, err
	}
	req, err := client.updatePreparer(queueMessage, popReceipt, visibilitytimeout, timeout, requestID)
	if err != nil {
		return nil, err
	}
	resp, err := client.Pipeline().Do(ctx, responderPolicyFactory{responder: client.updateResponder}, req)
	if err != nil {
		return nil, err
	}
	return resp.(*MessageIDUpdateResponse), err
}

// updatePreparer prepares the Update request.
func (client messageIDClient) updatePreparer(queueMessage QueueMessage, popReceipt string, visibilitytimeout int32, timeout *int32, requestID *string) (pipeline.Request, error) {
	req, err := pipeline.NewRequest("PUT", client.url, nil)
	if err != nil {
		return req, pipeline.NewError(err, "failed to create request")
	}
	params := req.URL.Query()
	params.Set("popreceipt", popReceipt)
	params.Set("visibilitytimeout", strconv.FormatInt(int64(visibilitytimeout), 10))
	if timeout != nil {
		params.Set("timeout", strconv.FormatInt(int64(*timeout), 10))
	}
	req.URL.RawQuery = params.Encode()
	req.Header.Set("x-ms-version", ServiceVersion)
	if requestID != nil {
		req.Header.Set("x-ms-client-request-id", *requestID)
	}
	b, err := xml.Marshal(queueMessage)
	if err != nil {
		return req, pipeline.NewError(err, "failed to marshal request body")
	}
	req.Header.Set("Content-Type", "application/xml")
	err = req.SetBody(bytes.NewReader(b))
	if err != nil {
		return req, pipeline.NewError(err, "failed to set request body")
	}
	return req, nil
}

// updateResponder handles the response to the Update request.
func (client messageIDClient) updateResponder(resp pipeline.Response) (pipeline.Response, error) {
	err := validateResponse(resp, http.StatusOK, http.StatusNoContent)
	if resp == nil {
		return nil, err
	}
	io.Copy(ioutil.Discard, resp.Response().Body)
	resp.Response().Body.Close()
	return &MessageIDUpdateResponse{rawResponse: resp.Response()}, err
}
