//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azblob

import (
	"encoding/xml"
	"time"
)

// AccessPolicy - An Access policy
type AccessPolicy struct {
	// the date-time the policy expires
	Expiry *time.Time `xml:"Expiry"`

	// the permissions for the acl policy
	Permission *string `xml:"Permission"`

	// the date-time the policy is active
	Start *time.Time `xml:"Start"`
}

// MarshalXML implements the xml.Marshaller interface for type AccessPolicy.
func (a AccessPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias AccessPolicy
	aux := &struct {
		*alias
		Expiry *timeRFC3339 `xml:"Expiry"`
		Start  *timeRFC3339 `xml:"Start"`
	}{
		alias:  (*alias)(&a),
		Expiry: (*timeRFC3339)(a.Expiry),
		Start:  (*timeRFC3339)(a.Start),
	}
	return e.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type AccessPolicy.
func (a *AccessPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type alias AccessPolicy
	aux := &struct {
		*alias
		Expiry *timeRFC3339 `xml:"Expiry"`
		Start  *timeRFC3339 `xml:"Start"`
	}{
		alias: (*alias)(a),
	}
	if err := d.DecodeElement(aux, &start); err != nil {
		return err
	}
	a.Expiry = (*time.Time)(aux.Expiry)
	a.Start = (*time.Time)(aux.Start)
	return nil
}

// AppendBlobAppendBlockFromURLOptions contains the optional parameters for the AppendBlob.AppendBlockFromURL method.
type AppendBlobAppendBlockFromURLOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Specify the md5 calculated for the range of bytes that must be read from the copy source.
	SourceContentMD5 []byte
	// Specify the crc64 calculated for the range of bytes that must be read from the copy source.
	SourceContentcrc64 []byte
	// Bytes of source data in the specified range.
	SourceRange *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Specify the transactional md5 for the body, to be validated by the service.
	TransactionalContentMD5 []byte
}

// AppendBlobAppendBlockOptions contains the optional parameters for the AppendBlob.AppendBlock method.
type AppendBlobAppendBlockOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Specify the transactional crc64 for the body, to be validated by the service.
	TransactionalContentCRC64 []byte
	// Specify the transactional md5 for the body, to be validated by the service.
	TransactionalContentMD5 []byte
}

// AppendBlobCreateOptions contains the optional parameters for the AppendBlob.Create method.
type AppendBlobCreateOptions struct {
	// Optional. Used to set blob tags in various blob operations.
	BlobTagsString *string
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// AppendBlobSealOptions contains the optional parameters for the AppendBlob.Seal method.
type AppendBlobSealOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// AppendPositionAccessConditions contains a group of parameters for the AppendBlob.AppendBlock method.
type AppendPositionAccessConditions struct {
	// Optional conditional header, used only for the Append Block operation. A number indicating the byte offset to compare. Append Block will succeed only
	// if the append position is equal to this number. If it is not, the request will fail with the AppendPositionConditionNotMet error (HTTP status code 412
	// - Precondition Failed).
	AppendPosition *int64
	// Optional conditional header. The max length in bytes permitted for the append blob. If the Append Block operation would cause the blob to exceed that
	// limit or if the blob size is already greater than the value specified in this header, the request will fail with MaxBlobSizeConditionNotMet error (HTTP
	// status code 412 - Precondition Failed).
	MaxSize *int64
}

// BlobAbortCopyFromURLOptions contains the optional parameters for the Blob.AbortCopyFromURL method.
type BlobAbortCopyFromURLOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobAcquireLeaseOptions contains the optional parameters for the Blob.AcquireLease method.
type BlobAcquireLeaseOptions struct {
	// Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires. A non-infinite lease can be between 15 and 60 seconds.
	// A lease duration cannot be changed using renew or change.
	Duration *int32
	// Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See
	// Guid Constructor (String) for a list of valid GUID string formats.
	ProposedLeaseID *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobBreakLeaseOptions contains the optional parameters for the Blob.BreakLease method.
type BlobBreakLeaseOptions struct {
	// For a break operation, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60. This break period is only used
	// if it is shorter than the time remaining on the lease. If longer, the time remaining on the lease is used. A new lease will not be available before the
	// break period has expired, but the lease may be held for longer than the break period. If this header does not appear with a break operation, a fixed-duration
	// lease breaks after the remaining lease period elapses, and an infinite lease breaks immediately.
	BreakPeriod *int32
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobChangeLeaseOptions contains the optional parameters for the Blob.ChangeLease method.
type BlobChangeLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobCopyFromURLOptions contains the optional parameters for the Blob.CopyFromURL method.
type BlobCopyFromURLOptions struct {
	// Optional. Used to set blob tags in various blob operations.
	BlobTagsString *string
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Specify the md5 calculated for the range of bytes that must be read from the copy source.
	SourceContentMD5 []byte
	// Optional. Indicates the tier to be set on the blob.
	Tier *AccessTier
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobCreateSnapshotOptions contains the optional parameters for the Blob.CreateSnapshot method.
type BlobCreateSnapshotOptions struct {
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobDeleteOptions contains the optional parameters for the Blob.Delete method.
type BlobDeleteOptions struct {
	// Required if the blob has associated snapshots. Specify one of the following two options: include: Delete the base blob and all of its snapshots. only:
	// Delete only the blob's snapshots and not the blob itself
	DeleteSnapshots *DeleteSnapshotsOptionType
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// The version id parameter is an opaque DateTime value that, when present, specifies the version of the blob to operate on. It's for service version 2019-10-10
	// and newer.
	VersionID *string
}

// BlobDownloadOptions contains the optional parameters for the Blob.Download method.
type BlobDownloadOptions struct {
	// Return only the bytes of the blob in the specified range.
	Range *string
	// When set to true and specified together with the Range, the service returns the CRC64 hash for the range, as long as the range is less than or equal
	// to 4 MB in size.
	RangeGetContentCRC64 *bool
	// When set to true and specified together with the Range, the service returns the MD5 hash for the range, as long as the range is less than or equal to
	// 4 MB in size.
	RangeGetContentMD5 *bool
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// The version id parameter is an opaque DateTime value that, when present, specifies the version of the blob to operate on. It's for service version 2019-10-10
	// and newer.
	VersionID *string
}

type BlobFlatListSegment struct {
	// REQUIRED
	BlobItems []*BlobItemInternal `xml:"Blob"`
}

// MarshalXML implements the xml.Marshaller interface for type BlobFlatListSegment.
func (b BlobFlatListSegment) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias BlobFlatListSegment
	aux := &struct {
		*alias
		BlobItems *[]*BlobItemInternal `xml:"Blob"`
	}{
		alias: (*alias)(&b),
	}
	if b.BlobItems != nil {
		aux.BlobItems = &b.BlobItems
	}
	return e.EncodeElement(aux, start)
}

// BlobGetAccessControlOptions contains the optional parameters for the Blob.GetAccessControl method.
type BlobGetAccessControlOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Optional. Valid only when Hierarchical Namespace is enabled for the account. If "true", the identity values returned in the x-ms-owner, x-ms-group, and
	// x-ms-acl response headers will be transformed from Azure Active Directory Object IDs to User Principal Names. If "false", the values will be returned
	// as Azure Active Directory Object IDs. The default value is false.
	Upn *bool
}

// BlobGetAccountInfoOptions contains the optional parameters for the Blob.GetAccountInfo method.
type BlobGetAccountInfoOptions struct {
	// placeholder for future optional parameters
}

// BlobGetPropertiesOptions contains the optional parameters for the Blob.GetProperties method.
type BlobGetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// The version id parameter is an opaque DateTime value that, when present, specifies the version of the blob to operate on. It's for service version 2019-10-10
	// and newer.
	VersionID *string
}

// BlobGetTagsOptions contains the optional parameters for the Blob.GetTags method.
type BlobGetTagsOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// The version id parameter is an opaque DateTime value that, when present, specifies the version of the blob to operate on. It's for service version 2019-10-10
	// and newer.
	VersionID *string
}

// BlobHTTPHeaders contains a group of parameters for the Blob.SetHTTPHeaders method.
type BlobHTTPHeaders struct {
	// Optional. Sets the blob's cache control. If specified, this property is stored with the blob and returned with a read request.
	BlobCacheControl *string
	// Optional. Sets the blob's Content-Disposition header.
	BlobContentDisposition *string
	// Optional. Sets the blob's content encoding. If specified, this property is stored with the blob and returned with a read request.
	BlobContentEncoding *string
	// Optional. Set the blob's content language. If specified, this property is stored with the blob and returned with a read request.
	BlobContentLanguage *string
	// Optional. An MD5 hash of the blob content. Note that this hash is not validated, as the hashes for the individual blocks were validated when each was
	// uploaded.
	BlobContentMD5 []byte
	// Optional. Sets the blob's content type. If specified, this property is stored with the blob and returned with a read request.
	BlobContentType *string
}

type BlobHierarchyListSegment struct {
	// REQUIRED
	BlobItems    []*BlobItemInternal `xml:"Blob"`
	BlobPrefixes []*BlobPrefix       `xml:"BlobPrefix"`
}

// MarshalXML implements the xml.Marshaller interface for type BlobHierarchyListSegment.
func (b BlobHierarchyListSegment) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias BlobHierarchyListSegment
	aux := &struct {
		*alias
		BlobItems    *[]*BlobItemInternal `xml:"Blob"`
		BlobPrefixes *[]*BlobPrefix       `xml:"BlobPrefix"`
	}{
		alias: (*alias)(&b),
	}
	if b.BlobItems != nil {
		aux.BlobItems = &b.BlobItems
	}
	if b.BlobPrefixes != nil {
		aux.BlobPrefixes = &b.BlobPrefixes
	}
	return e.EncodeElement(aux, start)
}

// BlobItemInternal - An Azure Storage blob
type BlobItemInternal struct {
	// REQUIRED
	Deleted *bool `xml:"Deleted"`

	// REQUIRED
	Name *string `xml:"Name"`

	// REQUIRED; Properties of a blob
	Properties *BlobPropertiesInternal `xml:"Properties"`

	// REQUIRED
	Snapshot *string `xml:"Snapshot"`

	// Blob tags
	BlobTags         *BlobTags          `xml:"Tags"`
	IsCurrentVersion *bool              `xml:"IsCurrentVersion"`
	Metadata         map[string]*string `xml:"Metadata"`

	// Dictionary of
	ObjectReplicationMetadata map[string]*string `xml:"OrMetadata"`
	VersionID                 *string            `xml:"VersionId"`
}

// UnmarshalXML implements the xml.Unmarshaller interface for type BlobItemInternal.
func (b *BlobItemInternal) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type alias BlobItemInternal
	aux := &struct {
		*alias
		Metadata                  additionalProperties `xml:"Metadata"`
		ObjectReplicationMetadata additionalProperties `xml:"OrMetadata"`
	}{
		alias: (*alias)(b),
	}
	if err := d.DecodeElement(aux, &start); err != nil {
		return err
	}
	b.Metadata = (map[string]*string)(aux.Metadata)
	b.ObjectReplicationMetadata = (map[string]*string)(aux.ObjectReplicationMetadata)
	return nil
}

type BlobPrefix struct {
	// REQUIRED
	Name *string `xml:"Name"`
}

// BlobPropertiesInternal - Properties of a blob
type BlobPropertiesInternal struct {
	// REQUIRED
	Etag *string `xml:"Etag"`

	// REQUIRED
	LastModified         *time.Time     `xml:"Last-Modified"`
	AccessTier           *AccessTier    `xml:"AccessTier"`
	AccessTierChangeTime *time.Time     `xml:"AccessTierChangeTime"`
	AccessTierInferred   *bool          `xml:"AccessTierInferred"`
	ArchiveStatus        *ArchiveStatus `xml:"ArchiveStatus"`
	BlobSequenceNumber   *int64         `xml:"x-ms-blob-sequence-number"`
	BlobType             *BlobType      `xml:"BlobType"`
	CacheControl         *string        `xml:"Cache-Control"`
	ContentDisposition   *string        `xml:"Content-Disposition"`
	ContentEncoding      *string        `xml:"Content-Encoding"`
	ContentLanguage      *string        `xml:"Content-Language"`

	// Size in bytes
	ContentLength             *int64          `xml:"Content-Length"`
	ContentMD5                []byte          `xml:"Content-MD5"`
	ContentType               *string         `xml:"Content-Type"`
	CopyCompletionTime        *time.Time      `xml:"CopyCompletionTime"`
	CopyID                    *string         `xml:"CopyId"`
	CopyProgress              *string         `xml:"CopyProgress"`
	CopySource                *string         `xml:"CopySource"`
	CopyStatus                *CopyStatusType `xml:"CopyStatus"`
	CopyStatusDescription     *string         `xml:"CopyStatusDescription"`
	CreationTime              *time.Time      `xml:"Creation-Time"`
	CustomerProvidedKeySHA256 *string         `xml:"CustomerProvidedKeySha256"`
	DeletedTime               *time.Time      `xml:"DeletedTime"`
	DestinationSnapshot       *string         `xml:"DestinationSnapshot"`

	// The name of the encryption scope under which the blob is encrypted.
	EncryptionScope *string            `xml:"EncryptionScope"`
	ExpiresOn       *time.Time         `xml:"Expiry-Time"`
	IncrementalCopy *bool              `xml:"IncrementalCopy"`
	IsSealed        *bool              `xml:"IsSealed"`
	LeaseDuration   *LeaseDurationType `xml:"LeaseDuration"`
	LeaseState      *LeaseStateType    `xml:"LeaseState"`
	LeaseStatus     *LeaseStatusType   `xml:"LeaseStatus"`

	// If an object is in rehydrate pending state then this header is returned with priority of rehydrate. Valid values are High and Standard.
	RehydratePriority      *RehydratePriority `xml:"RehydratePriority"`
	RemainingRetentionDays *int32             `xml:"RemainingRetentionDays"`
	ServerEncrypted        *bool              `xml:"ServerEncrypted"`
	TagCount               *int32             `xml:"TagCount"`
}

// MarshalXML implements the xml.Marshaller interface for type BlobPropertiesInternal.
func (b BlobPropertiesInternal) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias BlobPropertiesInternal
	aux := &struct {
		*alias
		AccessTierChangeTime *timeRFC1123 `xml:"AccessTierChangeTime"`
		ContentMD5           *[]byte      `xml:"Content-MD5"`
		CopyCompletionTime   *timeRFC1123 `xml:"CopyCompletionTime"`
		CreationTime         *timeRFC1123 `xml:"Creation-Time"`
		DeletedTime          *timeRFC1123 `xml:"DeletedTime"`
		ExpiresOn            *timeRFC1123 `xml:"Expiry-Time"`
		LastModified         *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias:                (*alias)(&b),
		AccessTierChangeTime: (*timeRFC1123)(b.AccessTierChangeTime),
		CopyCompletionTime:   (*timeRFC1123)(b.CopyCompletionTime),
		CreationTime:         (*timeRFC1123)(b.CreationTime),
		DeletedTime:          (*timeRFC1123)(b.DeletedTime),
		ExpiresOn:            (*timeRFC1123)(b.ExpiresOn),
		LastModified:         (*timeRFC1123)(b.LastModified),
	}
	if b.ContentMD5 != nil {
		aux.ContentMD5 = &b.ContentMD5
	}
	return e.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type BlobPropertiesInternal.
func (b *BlobPropertiesInternal) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type alias BlobPropertiesInternal
	aux := &struct {
		*alias
		AccessTierChangeTime *timeRFC1123 `xml:"AccessTierChangeTime"`
		ContentMD5           *[]byte      `xml:"Content-MD5"`
		CopyCompletionTime   *timeRFC1123 `xml:"CopyCompletionTime"`
		CreationTime         *timeRFC1123 `xml:"Creation-Time"`
		DeletedTime          *timeRFC1123 `xml:"DeletedTime"`
		ExpiresOn            *timeRFC1123 `xml:"Expiry-Time"`
		LastModified         *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias: (*alias)(b),
	}
	if err := d.DecodeElement(aux, &start); err != nil {
		return err
	}
	b.AccessTierChangeTime = (*time.Time)(aux.AccessTierChangeTime)
	b.CopyCompletionTime = (*time.Time)(aux.CopyCompletionTime)
	b.CreationTime = (*time.Time)(aux.CreationTime)
	b.DeletedTime = (*time.Time)(aux.DeletedTime)
	b.ExpiresOn = (*time.Time)(aux.ExpiresOn)
	b.LastModified = (*time.Time)(aux.LastModified)
	return nil
}

// BlobQueryOptions contains the optional parameters for the Blob.Query method.
type BlobQueryOptions struct {
	// the query request
	QueryRequest *QueryRequest
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobReleaseLeaseOptions contains the optional parameters for the Blob.ReleaseLease method.
type BlobReleaseLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobRenameOptions contains the optional parameters for the Blob.Rename method.
type BlobRenameOptions struct {
	// Optional. User-defined properties to be stored with the file or directory, in the format of a comma-separated list of name and value pairs "n1=v1, n2=v2,
	// ...", where each value is base64 encoded.
	DirectoryProperties *string
	// Optional and only valid if Hierarchical Namespace is enabled for the account. Sets POSIX access permissions for the file owner, the file owning group,
	// and others. Each class may be granted read, write, or execute permission. The sticky bit is also supported. Both symbolic (rwxrw-rw-) and 4-digit octal
	// notation (e.g. 0766) are supported.
	PosixPermissions *string
	// Only valid if Hierarchical Namespace is enabled for the account. This umask restricts permission settings for file and directory, and will only be applied
	// when default Acl does not exist in parent directory. If the umask bit has set, it means that the corresponding permission will be disabled. Otherwise
	// the corresponding permission will be determined by the permission. A 4-digit octal notation (e.g. 0022) is supported here. If no umask was specified,
	// a default umask - 0027 will be used.
	PosixUmask *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// A lease ID for the source path. If specified, the source path must have an active lease and the lease ID must match.
	SourceLeaseID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobRenewLeaseOptions contains the optional parameters for the Blob.RenewLease method.
type BlobRenewLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobSetAccessControlOptions contains the optional parameters for the Blob.SetAccessControl method.
type BlobSetAccessControlOptions struct {
	// Optional. The owning group of the blob or directory.
	Group *string
	// Optional. The owner of the blob or directory.
	Owner *string
	// Sets POSIX access control rights on files and directories. The value is a comma-separated list of access control entries. Each access control entry (ACE)
	// consists of a scope, a type, a user or group identifier, and permissions in the format "[scope:][type]:[id]:[permissions]".
	PosixACL *string
	// Optional and only valid if Hierarchical Namespace is enabled for the account. Sets POSIX access permissions for the file owner, the file owning group,
	// and others. Each class may be granted read, write, or execute permission. The sticky bit is also supported. Both symbolic (rwxrw-rw-) and 4-digit octal
	// notation (e.g. 0766) are supported.
	PosixPermissions *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobSetExpiryOptions contains the optional parameters for the Blob.SetExpiry method.
type BlobSetExpiryOptions struct {
	// The time to set the blob to expiry
	ExpiresOn *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobSetHTTPHeadersOptions contains the optional parameters for the Blob.SetHTTPHeaders method.
type BlobSetHTTPHeadersOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobSetMetadataOptions contains the optional parameters for the Blob.SetMetadata method.
type BlobSetMetadataOptions struct {
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlobSetTagsOptions contains the optional parameters for the Blob.SetTags method.
type BlobSetTagsOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Blob tags
	Tags *BlobTags
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Specify the transactional crc64 for the body, to be validated by the service.
	TransactionalContentCRC64 []byte
	// Specify the transactional md5 for the body, to be validated by the service.
	TransactionalContentMD5 []byte
	// The version id parameter is an opaque DateTime value that, when present, specifies the version of the blob to operate on. It's for service version 2019-10-10
	// and newer.
	VersionID *string
}

// BlobSetTierOptions contains the optional parameters for the Blob.SetTier method.
type BlobSetTierOptions struct {
	// Optional: Indicates the priority with which to rehydrate an archived blob.
	RehydratePriority *RehydratePriority
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// The version id parameter is an opaque DateTime value that, when present, specifies the version of the blob to operate on. It's for service version 2019-10-10
	// and newer.
	VersionID *string
}

// BlobStartCopyFromURLOptions contains the optional parameters for the Blob.StartCopyFromURL method.
type BlobStartCopyFromURLOptions struct {
	// Optional. Used to set blob tags in various blob operations.
	BlobTagsString *string
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Optional: Indicates the priority with which to rehydrate an archived blob.
	RehydratePriority *RehydratePriority
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Overrides the sealed state of the destination blob. Service version 2019-12-12 and newer.
	SealBlob *bool
	// Optional. Indicates the tier to be set on the blob.
	Tier *AccessTier
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

type BlobTag struct {
	// REQUIRED
	Key *string `xml:"Key"`

	// REQUIRED
	Value *string `xml:"Value"`
}

// BlobTags - Blob tags
type BlobTags struct {
	// REQUIRED
	BlobTagSet []*BlobTag `xml:"TagSet>Tag"`
}

// MarshalXML implements the xml.Marshaller interface for type BlobTags.
func (b BlobTags) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "Tags"
	type alias BlobTags
	aux := &struct {
		*alias
		BlobTagSet *[]*BlobTag `xml:"TagSet>Tag"`
	}{
		alias: (*alias)(&b),
	}
	if b.BlobTagSet != nil {
		aux.BlobTagSet = &b.BlobTagSet
	}
	return e.EncodeElement(aux, start)
}

// BlobUndeleteOptions contains the optional parameters for the Blob.Undelete method.
type BlobUndeleteOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// Block - Represents a single block in a block blob. It describes the block's ID and size.
type Block struct {
	// REQUIRED; The base64 encoded block ID.
	Name *string `xml:"Name"`

	// REQUIRED; The block size in bytes.
	Size *int64 `xml:"Size"`
}

// BlockBlobCommitBlockListOptions contains the optional parameters for the BlockBlob.CommitBlockList method.
type BlockBlobCommitBlockListOptions struct {
	// Optional. Used to set blob tags in various blob operations.
	BlobTagsString *string
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Optional. Indicates the tier to be set on the blob.
	Tier *AccessTier
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Specify the transactional crc64 for the body, to be validated by the service.
	TransactionalContentCRC64 []byte
	// Specify the transactional md5 for the body, to be validated by the service.
	TransactionalContentMD5 []byte
}

// BlockBlobGetBlockListOptions contains the optional parameters for the BlockBlob.GetBlockList method.
type BlockBlobGetBlockListOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlockBlobStageBlockFromURLOptions contains the optional parameters for the BlockBlob.StageBlockFromURL method.
type BlockBlobStageBlockFromURLOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Specify the md5 calculated for the range of bytes that must be read from the copy source.
	SourceContentMD5 []byte
	// Specify the crc64 calculated for the range of bytes that must be read from the copy source.
	SourceContentcrc64 []byte
	// Bytes of source data in the specified range.
	SourceRange *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// BlockBlobStageBlockOptions contains the optional parameters for the BlockBlob.StageBlock method.
type BlockBlobStageBlockOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Specify the transactional crc64 for the body, to be validated by the service.
	TransactionalContentCRC64 []byte
	// Specify the transactional md5 for the body, to be validated by the service.
	TransactionalContentMD5 []byte
}

// BlockBlobUploadOptions contains the optional parameters for the BlockBlob.Upload method.
type BlockBlobUploadOptions struct {
	// Optional. Used to set blob tags in various blob operations.
	BlobTagsString *string
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Optional. Indicates the tier to be set on the blob.
	Tier *AccessTier
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Specify the transactional md5 for the body, to be validated by the service.
	TransactionalContentMD5 []byte
}

type BlockList struct {
	CommittedBlocks   []*Block `xml:"CommittedBlocks>Block"`
	UncommittedBlocks []*Block `xml:"UncommittedBlocks>Block"`
}

// MarshalXML implements the xml.Marshaller interface for type BlockList.
func (b BlockList) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias BlockList
	aux := &struct {
		*alias
		CommittedBlocks   *[]*Block `xml:"CommittedBlocks>Block"`
		UncommittedBlocks *[]*Block `xml:"UncommittedBlocks>Block"`
	}{
		alias: (*alias)(&b),
	}
	if b.CommittedBlocks != nil {
		aux.CommittedBlocks = &b.CommittedBlocks
	}
	if b.UncommittedBlocks != nil {
		aux.UncommittedBlocks = &b.UncommittedBlocks
	}
	return e.EncodeElement(aux, start)
}

type BlockLookupList struct {
	Committed   []*string `xml:"Committed"`
	Latest      []*string `xml:"Latest"`
	Uncommitted []*string `xml:"Uncommitted"`
}

// MarshalXML implements the xml.Marshaller interface for type BlockLookupList.
func (b BlockLookupList) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "BlockList"
	type alias BlockLookupList
	aux := &struct {
		*alias
		Committed   *[]*string `xml:"Committed"`
		Latest      *[]*string `xml:"Latest"`
		Uncommitted *[]*string `xml:"Uncommitted"`
	}{
		alias: (*alias)(&b),
	}
	if b.Committed != nil {
		aux.Committed = &b.Committed
	}
	if b.Latest != nil {
		aux.Latest = &b.Latest
	}
	if b.Uncommitted != nil {
		aux.Uncommitted = &b.Uncommitted
	}
	return e.EncodeElement(aux, start)
}

type ClearRange struct {
	// REQUIRED
	End *int64 `xml:"End"`

	// REQUIRED
	Start *int64 `xml:"Start"`
}

// ContainerAcquireLeaseOptions contains the optional parameters for the Container.AcquireLease method.
type ContainerAcquireLeaseOptions struct {
	// Specifies the duration of the lease, in seconds, or negative one (-1) for a lease that never expires. A non-infinite lease can be between 15 and 60 seconds.
	// A lease duration cannot be changed using renew or change.
	Duration *int32
	// Proposed lease ID, in a GUID string format. The Blob service returns 400 (Invalid request) if the proposed lease ID is not in the correct format. See
	// Guid Constructor (String) for a list of valid GUID string formats.
	ProposedLeaseID *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerBreakLeaseOptions contains the optional parameters for the Container.BreakLease method.
type ContainerBreakLeaseOptions struct {
	// For a break operation, proposed duration the lease should continue before it is broken, in seconds, between 0 and 60. This break period is only used
	// if it is shorter than the time remaining on the lease. If longer, the time remaining on the lease is used. A new lease will not be available before the
	// break period has expired, but the lease may be held for longer than the break period. If this header does not appear with a break operation, a fixed-duration
	// lease breaks after the remaining lease period elapses, and an infinite lease breaks immediately.
	BreakPeriod *int32
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerChangeLeaseOptions contains the optional parameters for the Container.ChangeLease method.
type ContainerChangeLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerCpkScopeInfo contains a group of parameters for the Container.Create method.
type ContainerCpkScopeInfo struct {
	// Optional. Version 2019-07-07 and later. Specifies the default encryption scope to set on the container and use for all future writes.
	DefaultEncryptionScope *string
	// Optional. Version 2019-07-07 and newer. If true, prevents any request from specifying a different encryption scope than the scope set on the container.
	PreventEncryptionScopeOverride *bool
}

// ContainerCreateOptions contains the optional parameters for the Container.Create method.
type ContainerCreateOptions struct {
	// Specifies whether data in the container may be accessed publicly and the level of access
	Access *PublicAccessType
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerDeleteOptions contains the optional parameters for the Container.Delete method.
type ContainerDeleteOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerGetAccessPolicyOptions contains the optional parameters for the Container.GetAccessPolicy method.
type ContainerGetAccessPolicyOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerGetAccountInfoOptions contains the optional parameters for the Container.GetAccountInfo method.
type ContainerGetAccountInfoOptions struct {
	// placeholder for future optional parameters
}

// ContainerGetPropertiesOptions contains the optional parameters for the Container.GetProperties method.
type ContainerGetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerItem - An Azure Storage container
type ContainerItem struct {
	// REQUIRED
	Name *string `xml:"Name"`

	// REQUIRED; Properties of a container
	Properties *ContainerProperties `xml:"Properties"`
	Deleted    *bool                `xml:"Deleted"`

	// Dictionary of
	Metadata map[string]*string `xml:"Metadata"`
	Version  *string            `xml:"Version"`
}

// UnmarshalXML implements the xml.Unmarshaller interface for type ContainerItem.
func (c *ContainerItem) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type alias ContainerItem
	aux := &struct {
		*alias
		Metadata additionalProperties `xml:"Metadata"`
	}{
		alias: (*alias)(c),
	}
	if err := d.DecodeElement(aux, &start); err != nil {
		return err
	}
	c.Metadata = (map[string]*string)(aux.Metadata)
	return nil
}

// ContainerListBlobFlatSegmentOptions contains the optional parameters for the Container.ListBlobFlatSegment method.
type ContainerListBlobFlatSegmentOptions struct {
	// Include this parameter to specify one or more datasets to include in the response.
	Include []ListBlobsIncludeItem
	// A string value that identifies the portion of the list of containers to be returned with the next listing operation. The operation returns the NextMarker
	// value within the response body if the listing operation did not return all containers remaining to be listed with the current page. The NextMarker value
	// can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
	Marker *string
	// Specifies the maximum number of containers to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server
	// will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for
	// retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or
	// than the default of 5000.
	Maxresults *int32
	// Filters the results to return only containers whose name begins with the specified prefix.
	Prefix *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerListBlobHierarchySegmentOptions contains the optional parameters for the Container.ListBlobHierarchySegment method.
type ContainerListBlobHierarchySegmentOptions struct {
	// Include this parameter to specify one or more datasets to include in the response.
	Include []ListBlobsIncludeItem
	// A string value that identifies the portion of the list of containers to be returned with the next listing operation. The operation returns the NextMarker
	// value within the response body if the listing operation did not return all containers remaining to be listed with the current page. The NextMarker value
	// can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
	Marker *string
	// Specifies the maximum number of containers to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server
	// will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for
	// retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or
	// than the default of 5000.
	Maxresults *int32
	// Filters the results to return only containers whose name begins with the specified prefix.
	Prefix *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerProperties - Properties of a container
type ContainerProperties struct {
	// REQUIRED
	Etag *string `xml:"Etag"`

	// REQUIRED
	LastModified                   *time.Time         `xml:"Last-Modified"`
	DefaultEncryptionScope         *string            `xml:"DefaultEncryptionScope"`
	DeletedTime                    *time.Time         `xml:"DeletedTime"`
	HasImmutabilityPolicy          *bool              `xml:"HasImmutabilityPolicy"`
	HasLegalHold                   *bool              `xml:"HasLegalHold"`
	LeaseDuration                  *LeaseDurationType `xml:"LeaseDuration"`
	LeaseState                     *LeaseStateType    `xml:"LeaseState"`
	LeaseStatus                    *LeaseStatusType   `xml:"LeaseStatus"`
	PreventEncryptionScopeOverride *bool              `xml:"DenyEncryptionScopeOverride"`
	PublicAccess                   *PublicAccessType  `xml:"PublicAccess"`
	RemainingRetentionDays         *int32             `xml:"RemainingRetentionDays"`
}

// MarshalXML implements the xml.Marshaller interface for type ContainerProperties.
func (c ContainerProperties) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias ContainerProperties
	aux := &struct {
		*alias
		DeletedTime  *timeRFC1123 `xml:"DeletedTime"`
		LastModified *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias:        (*alias)(&c),
		DeletedTime:  (*timeRFC1123)(c.DeletedTime),
		LastModified: (*timeRFC1123)(c.LastModified),
	}
	return e.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type ContainerProperties.
func (c *ContainerProperties) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type alias ContainerProperties
	aux := &struct {
		*alias
		DeletedTime  *timeRFC1123 `xml:"DeletedTime"`
		LastModified *timeRFC1123 `xml:"Last-Modified"`
	}{
		alias: (*alias)(c),
	}
	if err := d.DecodeElement(aux, &start); err != nil {
		return err
	}
	c.DeletedTime = (*time.Time)(aux.DeletedTime)
	c.LastModified = (*time.Time)(aux.LastModified)
	return nil
}

// ContainerReleaseLeaseOptions contains the optional parameters for the Container.ReleaseLease method.
type ContainerReleaseLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerRenewLeaseOptions contains the optional parameters for the Container.RenewLease method.
type ContainerRenewLeaseOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerRestoreOptions contains the optional parameters for the Container.Restore method.
type ContainerRestoreOptions struct {
	// Optional. Version 2019-12-12 and later. Specifies the name of the deleted container to restore.
	DeletedContainerName *string
	// Optional. Version 2019-12-12 and later. Specifies the version of the deleted container to restore.
	DeletedContainerVersion *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerSetAccessPolicyOptions contains the optional parameters for the Container.SetAccessPolicy method.
type ContainerSetAccessPolicyOptions struct {
	// Specifies whether data in the container may be accessed publicly and the level of access
	Access *PublicAccessType
	// the acls for the container
	ContainerACL []*SignedIdentifier
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ContainerSetMetadataOptions contains the optional parameters for the Container.SetMetadata method.
type ContainerSetMetadataOptions struct {
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// CorsRule - CORS is an HTTP feature that enables a web application running under one domain to access resources in another domain. Web browsers implement
// a security restriction known as same-origin policy that
// prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin domain) to call APIs in another
// domain
type CorsRule struct {
	// REQUIRED; the request headers that the origin domain may specify on the CORS request.
	AllowedHeaders *string `xml:"AllowedHeaders"`

	// REQUIRED; The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods *string `xml:"AllowedMethods"`

	// REQUIRED; The origin domains that are permitted to make a request against the storage service via CORS. The origin domain is the domain from which the
	// request originates. Note that the origin must be an exact
	// case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*' to allow all origin domains
	// to make requests via CORS.
	AllowedOrigins *string `xml:"AllowedOrigins"`

	// REQUIRED; The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer
	ExposedHeaders *string `xml:"ExposedHeaders"`

	// REQUIRED; The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds *int32 `xml:"MaxAgeInSeconds"`
}

// CpkInfo contains a group of parameters for the Blob.Download method.
type CpkInfo struct {
	// The algorithm used to produce the encryption key hash. Currently, the only accepted value is "AES256". Must be provided if the x-ms-encryption-key header
	// is provided.
	EncryptionAlgorithm *string
	// Optional. Specifies the encryption key to use to encrypt the data provided in the request. If not specified, encryption is performed with the root account
	// encryption key. For more information, see Encryption at Rest for Azure Storage Services.
	EncryptionKey *string
	// The SHA-256 hash of the provided encryption key. Must be provided if the x-ms-encryption-key header is provided.
	EncryptionKeySHA256 *string
}

// CpkScopeInfo contains a group of parameters for the Blob.SetMetadata method.
type CpkScopeInfo struct {
	// Optional. Version 2019-07-07 and later. Specifies the name of the encryption scope to use to encrypt the data provided in the request. If not specified,
	// encryption is performed with the default account encryption scope. For more information, see Encryption at Rest for Azure Storage Services.
	EncryptionScope *string
}

// Implements the error and azcore.HTTPResponse interfaces.
type DataLakeStorageError struct {
	raw string
	// The service error response object.
	DataLakeStorageErrorDetails *DataLakeStorageErrorError `json:"error,omitempty"`
}

// DataLakeStorageErrorError - The service error response object.
type DataLakeStorageErrorError struct {
	// The service error code.
	Code *string `json:"Code,omitempty"`

	// The service error message.
	Message *string `json:"Message,omitempty"`
}

// DelimitedTextConfiguration - delimited text configuration
type DelimitedTextConfiguration struct {
	// REQUIRED; column separator
	ColumnSeparator *string `xml:"ColumnSeparator"`

	// REQUIRED; escape char
	EscapeChar *string `xml:"EscapeChar"`

	// REQUIRED; field quote
	FieldQuote *string `xml:"FieldQuote"`

	// REQUIRED; has headers
	HeadersPresent *bool `xml:"HasHeaders"`

	// REQUIRED; record separator
	RecordSeparator *string `xml:"RecordSeparator"`
}

// DirectoryCreateOptions contains the optional parameters for the Directory.Create method.
type DirectoryCreateOptions struct {
	// Optional. User-defined properties to be stored with the file or directory, in the format of a comma-separated list of name and value pairs "n1=v1, n2=v2,
	// ...", where each value is base64 encoded.
	DirectoryProperties *string
	// Optional and only valid if Hierarchical Namespace is enabled for the account. Sets POSIX access permissions for the file owner, the file owning group,
	// and others. Each class may be granted read, write, or execute permission. The sticky bit is also supported. Both symbolic (rwxrw-rw-) and 4-digit octal
	// notation (e.g. 0766) are supported.
	PosixPermissions *string
	// Only valid if Hierarchical Namespace is enabled for the account. This umask restricts permission settings for file and directory, and will only be applied
	// when default Acl does not exist in parent directory. If the umask bit has set, it means that the corresponding permission will be disabled. Otherwise
	// the corresponding permission will be determined by the permission. A 4-digit octal notation (e.g. 0022) is supported here. If no umask was specified,
	// a default umask - 0027 will be used.
	PosixUmask *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// DirectoryDeleteOptions contains the optional parameters for the Directory.Delete method.
type DirectoryDeleteOptions struct {
	// When renaming a directory, the number of paths that are renamed with each invocation is limited. If the number of paths to be renamed exceeds this limit,
	// a continuation token is returned in this response header. When a continuation token is returned in the response, it must be specified in a subsequent
	// invocation of the rename operation to continue renaming the directory.
	Marker *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// DirectoryGetAccessControlOptions contains the optional parameters for the Directory.GetAccessControl method.
type DirectoryGetAccessControlOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Optional. Valid only when Hierarchical Namespace is enabled for the account. If "true", the identity values returned in the x-ms-owner, x-ms-group, and
	// x-ms-acl response headers will be transformed from Azure Active Directory Object IDs to User Principal Names. If "false", the values will be returned
	// as Azure Active Directory Object IDs. The default value is false.
	Upn *bool
}

// DirectoryHTTPHeaders contains a group of parameters for the Directory.Create method.
type DirectoryHTTPHeaders struct {
	// Cache control for given resource
	CacheControl *string
	// Content disposition for given resource
	ContentDisposition *string
	// Content encoding for given resource
	ContentEncoding *string
	// Content language for given resource
	ContentLanguage *string
	// Content type for given resource
	ContentType *string
}

// DirectoryRenameOptions contains the optional parameters for the Directory.Rename method.
type DirectoryRenameOptions struct {
	// Optional. User-defined properties to be stored with the file or directory, in the format of a comma-separated list of name and value pairs "n1=v1, n2=v2,
	// ...", where each value is base64 encoded.
	DirectoryProperties *string
	// When renaming a directory, the number of paths that are renamed with each invocation is limited. If the number of paths to be renamed exceeds this limit,
	// a continuation token is returned in this response header. When a continuation token is returned in the response, it must be specified in a subsequent
	// invocation of the rename operation to continue renaming the directory.
	Marker *string
	// Optional and only valid if Hierarchical Namespace is enabled for the account. Sets POSIX access permissions for the file owner, the file owning group,
	// and others. Each class may be granted read, write, or execute permission. The sticky bit is also supported. Both symbolic (rwxrw-rw-) and 4-digit octal
	// notation (e.g. 0766) are supported.
	PosixPermissions *string
	// Only valid if Hierarchical Namespace is enabled for the account. This umask restricts permission settings for file and directory, and will only be applied
	// when default Acl does not exist in parent directory. If the umask bit has set, it means that the corresponding permission will be disabled. Otherwise
	// the corresponding permission will be determined by the permission. A 4-digit octal notation (e.g. 0022) is supported here. If no umask was specified,
	// a default umask - 0027 will be used.
	PosixUmask *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// A lease ID for the source path. If specified, the source path must have an active lease and the lease ID must match.
	SourceLeaseID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// DirectorySetAccessControlOptions contains the optional parameters for the Directory.SetAccessControl method.
type DirectorySetAccessControlOptions struct {
	// Optional. The owning group of the blob or directory.
	Group *string
	// Optional. The owner of the blob or directory.
	Owner *string
	// Sets POSIX access control rights on files and directories. The value is a comma-separated list of access control entries. Each access control entry (ACE)
	// consists of a scope, a type, a user or group identifier, and permissions in the format "[scope:][type]:[id]:[permissions]".
	PosixACL *string
	// Optional and only valid if Hierarchical Namespace is enabled for the account. Sets POSIX access permissions for the file owner, the file owning group,
	// and others. Each class may be granted read, write, or execute permission. The sticky bit is also supported. Both symbolic (rwxrw-rw-) and 4-digit octal
	// notation (e.g. 0766) are supported.
	PosixPermissions *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// FilterBlobItem - Blob info from a Filter Blobs API call
type FilterBlobItem struct {
	// REQUIRED
	ContainerName *string `xml:"ContainerName"`

	// REQUIRED
	Name *string `xml:"Name"`

	// REQUIRED
	TagValue *string `xml:"TagValue"`
}

// FilterBlobSegment - The result of a Filter Blobs API call
type FilterBlobSegment struct {
	// REQUIRED
	Blobs []*FilterBlobItem `xml:"Blobs>Blob"`

	// REQUIRED
	ServiceEndpoint *string `xml:"ServiceEndpoint,attr"`

	// REQUIRED
	Where      *string `xml:"Where"`
	NextMarker *string `xml:"NextMarker"`
}

// MarshalXML implements the xml.Marshaller interface for type FilterBlobSegment.
func (f FilterBlobSegment) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias FilterBlobSegment
	aux := &struct {
		*alias
		Blobs *[]*FilterBlobItem `xml:"Blobs>Blob"`
	}{
		alias: (*alias)(&f),
	}
	if f.Blobs != nil {
		aux.Blobs = &f.Blobs
	}
	return e.EncodeElement(aux, start)
}

// GeoReplication - Geo-Replication information for the Secondary Storage Service
type GeoReplication struct {
	// REQUIRED; A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available for read operations at the secondary.
	// Primary writes after this point in time may or may
	// not be available for reads.
	LastSyncTime *time.Time `xml:"LastSyncTime"`

	// REQUIRED; The status of the secondary location
	Status *GeoReplicationStatusType `xml:"Status"`
}

// MarshalXML implements the xml.Marshaller interface for type GeoReplication.
func (g GeoReplication) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias GeoReplication
	aux := &struct {
		*alias
		LastSyncTime *timeRFC1123 `xml:"LastSyncTime"`
	}{
		alias:        (*alias)(&g),
		LastSyncTime: (*timeRFC1123)(g.LastSyncTime),
	}
	return e.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type GeoReplication.
func (g *GeoReplication) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type alias GeoReplication
	aux := &struct {
		*alias
		LastSyncTime *timeRFC1123 `xml:"LastSyncTime"`
	}{
		alias: (*alias)(g),
	}
	if err := d.DecodeElement(aux, &start); err != nil {
		return err
	}
	g.LastSyncTime = (*time.Time)(aux.LastSyncTime)
	return nil
}

// JSONTextConfiguration - json text configuration
type JSONTextConfiguration struct {
	// REQUIRED; record separator
	RecordSeparator *string `xml:"RecordSeparator"`
}

// KeyInfo - Key information
type KeyInfo struct {
	// REQUIRED; The date-time the key expires in ISO 8601 UTC time
	Expiry *string `xml:"Expiry"`

	// REQUIRED; The date-time the key is active in ISO 8601 UTC time
	Start *string `xml:"Start"`
}

// LeaseAccessConditions contains a group of parameters for the Container.GetProperties method.
type LeaseAccessConditions struct {
	// If specified, the operation only succeeds if the resource's lease is active and matches this ID.
	LeaseID *string
}

// ListBlobsFlatSegmentResponse - An enumeration of blobs
type ListBlobsFlatSegmentResponse struct {
	// REQUIRED
	ContainerName *string `xml:"ContainerName,attr"`

	// REQUIRED
	Segment *BlobFlatListSegment `xml:"Blobs"`

	// REQUIRED
	ServiceEndpoint *string `xml:"ServiceEndpoint,attr"`
	Marker          *string `xml:"Marker"`
	MaxResults      *int32  `xml:"MaxResults"`
	NextMarker      *string `xml:"NextMarker"`
	Prefix          *string `xml:"Prefix"`
}

// ListBlobsHierarchySegmentResponse - An enumeration of blobs
type ListBlobsHierarchySegmentResponse struct {
	// REQUIRED
	ContainerName *string `xml:"ContainerName,attr"`

	// REQUIRED
	Segment *BlobHierarchyListSegment `xml:"Blobs"`

	// REQUIRED
	ServiceEndpoint *string `xml:"ServiceEndpoint,attr"`
	Delimiter       *string `xml:"Delimiter"`
	Marker          *string `xml:"Marker"`
	MaxResults      *int32  `xml:"MaxResults"`
	NextMarker      *string `xml:"NextMarker"`
	Prefix          *string `xml:"Prefix"`
}

// ListContainersSegmentResponse - An enumeration of containers
type ListContainersSegmentResponse struct {
	// REQUIRED
	ContainerItems []*ContainerItem `xml:"Containers>Container"`

	// REQUIRED
	ServiceEndpoint *string `xml:"ServiceEndpoint,attr"`
	Marker          *string `xml:"Marker"`
	MaxResults      *int32  `xml:"MaxResults"`
	NextMarker      *string `xml:"NextMarker"`
	Prefix          *string `xml:"Prefix"`
}

// MarshalXML implements the xml.Marshaller interface for type ListContainersSegmentResponse.
func (l ListContainersSegmentResponse) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias ListContainersSegmentResponse
	aux := &struct {
		*alias
		ContainerItems *[]*ContainerItem `xml:"Containers>Container"`
	}{
		alias: (*alias)(&l),
	}
	if l.ContainerItems != nil {
		aux.ContainerItems = &l.ContainerItems
	}
	return e.EncodeElement(aux, start)
}

// Logging - Azure Analytics Logging settings.
type Logging struct {
	// REQUIRED; Indicates whether all delete requests should be logged.
	Delete *bool `xml:"Delete"`

	// REQUIRED; Indicates whether all read requests should be logged.
	Read *bool `xml:"Read"`

	// REQUIRED; the retention policy which determines how long the associated data should persist
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`

	// REQUIRED; The version of Storage Analytics to configure.
	Version *string `xml:"Version"`

	// REQUIRED; Indicates whether all write requests should be logged.
	Write *bool `xml:"Write"`
}

// Metrics - a summary of request statistics grouped by API in hour or minute aggregates for blobs
type Metrics struct {
	// REQUIRED; Indicates whether metrics are enabled for the Blob service.
	Enabled *bool `xml:"Enabled"`

	// Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs *bool `xml:"IncludeAPIs"`

	// the retention policy which determines how long the associated data should persist
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`

	// The version of Storage Analytics to configure.
	Version *string `xml:"Version"`
}

// ModifiedAccessConditions contains a group of parameters for the containerClient.Delete method.
type ModifiedAccessConditions struct {
	// Specify an ETag value to operate only on blobs with a matching value.
	IfMatch *string
	// Specify this header value to operate only on a blob if it has been modified since the specified date/time.
	IfModifiedSince *time.Time
	// Specify an ETag value to operate only on blobs without a matching value.
	IfNoneMatch *string
	// Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
	IfTags *string
	// Specify this header value to operate only on a blob if it has not been modified since the specified date/time.
	IfUnmodifiedSince *time.Time
}

// PageBlobClearPagesOptions contains the optional parameters for the PageBlob.ClearPages method.
type PageBlobClearPagesOptions struct {
	// Return only the bytes of the blob in the specified range.
	Range *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobCopyIncrementalOptions contains the optional parameters for the PageBlob.CopyIncremental method.
type PageBlobCopyIncrementalOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobCreateOptions contains the optional parameters for the PageBlob.Create method.
type PageBlobCreateOptions struct {
	// Set for page blobs only. The sequence number is a user-controlled value that you can use to track requests. The value of the sequence number must be
	// between 0 and 2^63 - 1.
	BlobSequenceNumber *int64
	// Optional. Used to set blob tags in various blob operations.
	BlobTagsString *string
	// Optional. Specifies a user-defined name-value pair associated with the blob. If no name-value pairs are specified, the operation will copy the metadata
	// from the source blob or file to the destination blob. If one or more name-value pairs are specified, the destination blob is created with the specified
	// metadata, and metadata is not copied from the source blob or file. Note that beginning with version 2009-09-19, metadata names must adhere to the naming
	// rules for C# identifiers. See Naming and Referencing Containers, Blobs, and Metadata for more information.
	Metadata map[string]string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Optional. Indicates the tier to be set on the page blob.
	Tier *PremiumPageBlobAccessTier
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobGetPageRangesDiffOptions contains the optional parameters for the PageBlob.GetPageRangesDiff method.
type PageBlobGetPageRangesDiffOptions struct {
	// Optional. This header is only supported in service versions 2019-04-19 and after and specifies the URL of a previous snapshot of the target blob. The
	// response will only contain pages that were changed between the target blob and its previous snapshot.
	PrevSnapshotURL *string
	// Optional in version 2015-07-08 and newer. The prevsnapshot parameter is a DateTime value that specifies that the response will contain only pages that
	// were changed between target blob and previous snapshot. Changed pages include both updated and cleared pages. The target blob may be a snapshot, as long
	// as the snapshot specified by prevsnapshot is the older of the two. Note that incremental snapshots are currently supported only for blobs created on
	// or after January 1, 2016.
	Prevsnapshot *string
	// Return only the bytes of the blob in the specified range.
	Range *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobGetPageRangesOptions contains the optional parameters for the PageBlob.GetPageRanges method.
type PageBlobGetPageRangesOptions struct {
	// Return only the bytes of the blob in the specified range.
	Range *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The snapshot parameter is an opaque DateTime value that, when present, specifies the blob snapshot to retrieve. For more information on working with
	// blob snapshots, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/creating-a-snapshot-of-a-blob">Creating a Snapshot
	// of a Blob.</a>
	Snapshot *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobResizeOptions contains the optional parameters for the PageBlob.Resize method.
type PageBlobResizeOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobUpdateSequenceNumberOptions contains the optional parameters for the PageBlob.UpdateSequenceNumber method.
type PageBlobUpdateSequenceNumberOptions struct {
	// Set for page blobs only. The sequence number is a user-controlled value that you can use to track requests. The value of the sequence number must be
	// between 0 and 2^63 - 1.
	BlobSequenceNumber *int64
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobUploadPagesFromURLOptions contains the optional parameters for the PageBlob.UploadPagesFromURL method.
type PageBlobUploadPagesFromURLOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// Specify the md5 calculated for the range of bytes that must be read from the copy source.
	SourceContentMD5 []byte
	// Specify the crc64 calculated for the range of bytes that must be read from the copy source.
	SourceContentcrc64 []byte
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// PageBlobUploadPagesOptions contains the optional parameters for the PageBlob.UploadPages method.
type PageBlobUploadPagesOptions struct {
	// Return only the bytes of the blob in the specified range.
	Range *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Specify the transactional crc64 for the body, to be validated by the service.
	TransactionalContentCRC64 []byte
	// Specify the transactional md5 for the body, to be validated by the service.
	TransactionalContentMD5 []byte
}

// PageList - the list of pages
type PageList struct {
	ClearRange []*ClearRange `xml:"ClearRange"`
	PageRange  []*PageRange  `xml:"PageRange"`
}

// MarshalXML implements the xml.Marshaller interface for type PageList.
func (p PageList) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias PageList
	aux := &struct {
		*alias
		ClearRange *[]*ClearRange `xml:"ClearRange"`
		PageRange  *[]*PageRange  `xml:"PageRange"`
	}{
		alias: (*alias)(&p),
	}
	if p.ClearRange != nil {
		aux.ClearRange = &p.ClearRange
	}
	if p.PageRange != nil {
		aux.PageRange = &p.PageRange
	}
	return e.EncodeElement(aux, start)
}

type PageRange struct {
	// REQUIRED
	End *int64 `xml:"End"`

	// REQUIRED
	Start *int64 `xml:"Start"`
}

type QueryFormat struct {
	// Groups the settings used for interpreting the blob data if the blob is delimited text formatted.
	DelimitedTextConfiguration *DelimitedTextConfiguration `xml:"DelimitedTextConfiguration"`

	// json text configuration
	JSONTextConfiguration *JSONTextConfiguration `xml:"JsonTextConfiguration"`

	// The quick query format type.
	Type *QueryFormatType `xml:"Type"`
}

// QueryRequest - Groups the set of query request settings.
type QueryRequest struct {
	// REQUIRED; The query expression in SQL. The maximum size of the query expression is 256KiB.
	Expression *string `xml:"Expression"`

	// REQUIRED; Required. The type of the provided query expression.
	QueryType           *string             `xml:"QueryType"`
	InputSerialization  *QuerySerialization `xml:"InputSerialization"`
	OutputSerialization *QuerySerialization `xml:"OutputSerialization"`
}

// MarshalXML implements the xml.Marshaller interface for type QueryRequest.
func (q QueryRequest) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	start.Name.Local = "QueryRequest"
	type alias QueryRequest
	aux := &struct {
		*alias
	}{
		alias: (*alias)(&q),
	}
	return e.EncodeElement(aux, start)
}

type QuerySerialization struct {
	// REQUIRED
	Format *QueryFormat `xml:"Format"`
}

// RetentionPolicy - the retention policy which determines how long the associated data should persist
type RetentionPolicy struct {
	// REQUIRED; Indicates whether a retention policy is enabled for the storage service
	Enabled *bool `xml:"Enabled"`

	// Indicates the number of days that metrics or logging or soft-deleted data should be retained. All data older than this value will be deleted
	Days *int32 `xml:"Days"`
}

// SequenceNumberAccessConditions contains a group of parameters for the PageBlob.UploadPages method.
type SequenceNumberAccessConditions struct {
	// Specify this header value to operate only on a blob if it has the specified sequence number.
	IfSequenceNumberEqualTo *int64
	// Specify this header value to operate only on a blob if it has a sequence number less than the specified.
	IfSequenceNumberLessThan *int64
	// Specify this header value to operate only on a blob if it has a sequence number less than or equal to the specified.
	IfSequenceNumberLessThanOrEqualTo *int64
}

// ServiceFilterBlobsOptions contains the optional parameters for the Service.FilterBlobs method.
type ServiceFilterBlobsOptions struct {
	// A string value that identifies the portion of the list of containers to be returned with the next listing operation. The operation returns the NextMarker
	// value within the response body if the listing operation did not return all containers remaining to be listed with the current page. The NextMarker value
	// can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
	Marker *string
	// Specifies the maximum number of containers to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server
	// will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for
	// retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or
	// than the default of 5000.
	Maxresults *int32
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
	// Filters the results to return only to return only blobs whose tags match the specified expression.
	Where *string
}

// ServiceGetAccountInfoOptions contains the optional parameters for the Service.GetAccountInfo method.
type ServiceGetAccountInfoOptions struct {
	// placeholder for future optional parameters
}

// ServiceGetPropertiesOptions contains the optional parameters for the Service.GetProperties method.
type ServiceGetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ServiceGetStatisticsOptions contains the optional parameters for the Service.GetStatistics method.
type ServiceGetStatisticsOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ServiceGetUserDelegationKeyOptions contains the optional parameters for the Service.GetUserDelegationKey method.
type ServiceGetUserDelegationKeyOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ServiceListContainersSegmentOptions contains the optional parameters for the Service.ListContainers method.
type ServiceListContainersSegmentOptions struct {
	// Include this parameter to specify that the container's metadata be returned as part of the response body.
	Include []ListContainersIncludeType
	// A string value that identifies the portion of the list of containers to be returned with the next listing operation. The operation returns the NextMarker
	// value within the response body if the listing operation did not return all containers remaining to be listed with the current page. The NextMarker value
	// can be used as the value for the marker parameter in a subsequent call to request the next page of list items. The marker value is opaque to the client.
	Marker *string
	// Specifies the maximum number of containers to return. If the request does not specify maxresults, or specifies a value greater than 5000, the server
	// will return up to 5000 items. Note that if the listing operation crosses a partition boundary, then the service will return a continuation token for
	// retrieving the remainder of the results. For this reason, it is possible that the service will return fewer results than specified by maxresults, or
	// than the default of 5000.
	Maxresults *int32
	// Filters the results to return only containers whose name begins with the specified prefix.
	Prefix *string
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ServiceSetPropertiesOptions contains the optional parameters for the Service.SetProperties method.
type ServiceSetPropertiesOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// ServiceSubmitBatchOptions contains the optional parameters for the Service.SubmitBatch method.
type ServiceSubmitBatchOptions struct {
	// Provides a client-generated, opaque value with a 1 KB character limit that is recorded in the analytics logs when storage analytics logging is enabled.
	RequestID *string
	// The timeout parameter is expressed in seconds. For more information, see <a href="https://docs.microsoft.com/en-us/rest/api/storageservices/fileservices/setting-timeouts-for-blob-service-operations">Setting
	// Timeouts for Blob Service Operations.</a>
	Timeout *int32
}

// SignedIdentifier - signed identifier
type SignedIdentifier struct {
	// REQUIRED; An Access policy
	AccessPolicy *AccessPolicy `xml:"AccessPolicy"`

	// REQUIRED; a unique id
	ID *string `xml:"Id"`
}

// SourceModifiedAccessConditions contains a group of parameters for the Directory.Rename method.
type SourceModifiedAccessConditions struct {
	// Specify an ETag value to operate only on blobs with a matching value.
	SourceIfMatch *string
	// Specify this header value to operate only on a blob if it has been modified since the specified date/time.
	SourceIfModifiedSince *time.Time
	// Specify an ETag value to operate only on blobs without a matching value.
	SourceIfNoneMatch *string
	// Specify a SQL where clause on blob tags to operate only on blobs with a matching value.
	SourceIfTags *string
	// Specify this header value to operate only on a blob if it has not been modified since the specified date/time.
	SourceIfUnmodifiedSince *time.Time
}

// StaticWebsite - The properties that enable an account to host a static website
type StaticWebsite struct {
	// REQUIRED; Indicates whether this account is hosting a static website
	Enabled *bool `xml:"Enabled"`

	// Absolute path of the default index page
	DefaultIndexDocumentPath *string `xml:"DefaultIndexDocumentPath"`

	// The absolute path of the custom 404 page
	ErrorDocument404Path *string `xml:"ErrorDocument404Path"`

	// The default name of the index page under each directory
	IndexDocument *string `xml:"IndexDocument"`
}

//
//// Implements the error and azcore.HTTPResponse interfaces.
//type StorageError struct {
//	raw     string
//	Message *string `xml:"Message"`
//}
//

// StorageServiceProperties - Storage Service Properties.
type StorageServiceProperties struct {
	// The set of CORS rules.
	Cors []*CorsRule `xml:"Cors>CorsRule"`

	// The default version to use for requests to the Blob service if an incoming request's version is not specified. Possible values include version 2008-10-27
	// and all more recent versions
	DefaultServiceVersion *string `xml:"DefaultServiceVersion"`

	// the retention policy which determines how long the associated data should persist
	DeleteRetentionPolicy *RetentionPolicy `xml:"DeleteRetentionPolicy"`

	// a summary of request statistics grouped by API in hour or minute aggregates for blobs
	HourMetrics *Metrics `xml:"HourMetrics"`

	// Azure Analytics Logging settings.
	Logging *Logging `xml:"Logging"`

	// a summary of request statistics grouped by API in hour or minute aggregates for blobs
	MinuteMetrics *Metrics `xml:"MinuteMetrics"`

	// The properties that enable an account to host a static website
	StaticWebsite *StaticWebsite `xml:"StaticWebsite"`
}

// MarshalXML implements the xml.Marshaller interface for type StorageServiceProperties.
func (s StorageServiceProperties) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias StorageServiceProperties
	aux := &struct {
		*alias
		Cors *[]*CorsRule `xml:"Cors>CorsRule"`
	}{
		alias: (*alias)(&s),
	}
	if s.Cors != nil {
		aux.Cors = &s.Cors
	}
	return e.EncodeElement(aux, start)
}

// StorageServiceStats - Stats for the storage service.
type StorageServiceStats struct {
	// Geo-Replication information for the Secondary Storage Service
	GeoReplication *GeoReplication `xml:"GeoReplication"`
}

// UserDelegationKey - A user delegation key
type UserDelegationKey struct {
	// REQUIRED; The date-time the key expires
	SignedExpiry *time.Time `xml:"SignedExpiry"`

	// REQUIRED; The Azure Active Directory object ID in GUID format.
	SignedOid *string `xml:"SignedOid"`

	// REQUIRED; Abbreviation of the Azure Storage service that accepts the key
	SignedService *string `xml:"SignedService"`

	// REQUIRED; The date-time the key is active
	SignedStart *time.Time `xml:"SignedStart"`

	// REQUIRED; The Azure Active Directory tenant ID in GUID format
	SignedTid *string `xml:"SignedTid"`

	// REQUIRED; The service version that created the key
	SignedVersion *string `xml:"SignedVersion"`

	// REQUIRED; The key as a base64 string
	Value *string `xml:"Value"`
}

// MarshalXML implements the xml.Marshaller interface for type UserDelegationKey.
func (u UserDelegationKey) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	type alias UserDelegationKey
	aux := &struct {
		*alias
		SignedExpiry *timeRFC3339 `xml:"SignedExpiry"`
		SignedStart  *timeRFC3339 `xml:"SignedStart"`
	}{
		alias:        (*alias)(&u),
		SignedExpiry: (*timeRFC3339)(u.SignedExpiry),
		SignedStart:  (*timeRFC3339)(u.SignedStart),
	}
	return e.EncodeElement(aux, start)
}

// UnmarshalXML implements the xml.Unmarshaller interface for type UserDelegationKey.
func (u *UserDelegationKey) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	type alias UserDelegationKey
	aux := &struct {
		*alias
		SignedExpiry *timeRFC3339 `xml:"SignedExpiry"`
		SignedStart  *timeRFC3339 `xml:"SignedStart"`
	}{
		alias: (*alias)(u),
	}
	if err := d.DecodeElement(aux, &start); err != nil {
		return err
	}
	u.SignedExpiry = (*time.Time)(aux.SignedExpiry)
	u.SignedStart = (*time.Time)(aux.SignedStart)
	return nil
}
