package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNatIpCidrAttribute invokes the vpc.ModifyNatIpCidrAttribute API synchronously
func (client *Client) ModifyNatIpCidrAttribute(request *ModifyNatIpCidrAttributeRequest) (response *ModifyNatIpCidrAttributeResponse, err error) {
	response = CreateModifyNatIpCidrAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNatIpCidrAttributeWithChan invokes the vpc.ModifyNatIpCidrAttribute API asynchronously
func (client *Client) ModifyNatIpCidrAttributeWithChan(request *ModifyNatIpCidrAttributeRequest) (<-chan *ModifyNatIpCidrAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyNatIpCidrAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNatIpCidrAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNatIpCidrAttributeWithCallback invokes the vpc.ModifyNatIpCidrAttribute API asynchronously
func (client *Client) ModifyNatIpCidrAttributeWithCallback(request *ModifyNatIpCidrAttributeRequest, callback func(response *ModifyNatIpCidrAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNatIpCidrAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyNatIpCidrAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNatIpCidrAttributeRequest is the request struct for api ModifyNatIpCidrAttribute
type ModifyNatIpCidrAttributeRequest struct {
	*requests.RpcRequest
	NatIpCidrId          string           `position:"Query" name:"NatIpCidrId"`
	NatIpCidrDescription string           `position:"Query" name:"NatIpCidrDescription"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	NatIpCidrName        string           `position:"Query" name:"NatIpCidrName"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NatIpCidr            string           `position:"Query" name:"NatIpCidr"`
}

// ModifyNatIpCidrAttributeResponse is the response struct for api ModifyNatIpCidrAttribute
type ModifyNatIpCidrAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNatIpCidrAttributeRequest creates a request to invoke ModifyNatIpCidrAttribute API
func CreateModifyNatIpCidrAttributeRequest() (request *ModifyNatIpCidrAttributeRequest) {
	request = &ModifyNatIpCidrAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyNatIpCidrAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyNatIpCidrAttributeResponse creates a response to parse from ModifyNatIpCidrAttribute response
func CreateModifyNatIpCidrAttributeResponse() (response *ModifyNatIpCidrAttributeResponse) {
	response = &ModifyNatIpCidrAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
