package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMonitorGroupInstances invokes the cms.ModifyMonitorGroupInstances API synchronously
func (client *Client) ModifyMonitorGroupInstances(request *ModifyMonitorGroupInstancesRequest) (response *ModifyMonitorGroupInstancesResponse, err error) {
	response = CreateModifyMonitorGroupInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMonitorGroupInstancesWithChan invokes the cms.ModifyMonitorGroupInstances API asynchronously
func (client *Client) ModifyMonitorGroupInstancesWithChan(request *ModifyMonitorGroupInstancesRequest) (<-chan *ModifyMonitorGroupInstancesResponse, <-chan error) {
	responseChan := make(chan *ModifyMonitorGroupInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMonitorGroupInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMonitorGroupInstancesWithCallback invokes the cms.ModifyMonitorGroupInstances API asynchronously
func (client *Client) ModifyMonitorGroupInstancesWithCallback(request *ModifyMonitorGroupInstancesRequest, callback func(response *ModifyMonitorGroupInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMonitorGroupInstancesResponse
		var err error
		defer close(result)
		response, err = client.ModifyMonitorGroupInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMonitorGroupInstancesRequest is the request struct for api ModifyMonitorGroupInstances
type ModifyMonitorGroupInstancesRequest struct {
	*requests.RpcRequest
	Instances *[]ModifyMonitorGroupInstancesInstances `position:"Query" name:"Instances"  type:"Repeated"`
	GroupId   requests.Integer                        `position:"Query" name:"GroupId"`
}

// ModifyMonitorGroupInstancesInstances is a repeated param struct in ModifyMonitorGroupInstancesRequest
type ModifyMonitorGroupInstancesInstances struct {
	InstanceId   string `name:"InstanceId"`
	InstanceName string `name:"InstanceName"`
	RegionId     string `name:"RegionId"`
	Category     string `name:"Category"`
}

// ModifyMonitorGroupInstancesResponse is the response struct for api ModifyMonitorGroupInstances
type ModifyMonitorGroupInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyMonitorGroupInstancesRequest creates a request to invoke ModifyMonitorGroupInstances API
func CreateModifyMonitorGroupInstancesRequest() (request *ModifyMonitorGroupInstancesRequest) {
	request = &ModifyMonitorGroupInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "ModifyMonitorGroupInstances", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyMonitorGroupInstancesResponse creates a response to parse from ModifyMonitorGroupInstances response
func CreateModifyMonitorGroupInstancesResponse() (response *ModifyMonitorGroupInstancesResponse) {
	response = &ModifyMonitorGroupInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
