package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMonitorGroupInstances invokes the cms.CreateMonitorGroupInstances API synchronously
func (client *Client) CreateMonitorGroupInstances(request *CreateMonitorGroupInstancesRequest) (response *CreateMonitorGroupInstancesResponse, err error) {
	response = CreateCreateMonitorGroupInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMonitorGroupInstancesWithChan invokes the cms.CreateMonitorGroupInstances API asynchronously
func (client *Client) CreateMonitorGroupInstancesWithChan(request *CreateMonitorGroupInstancesRequest) (<-chan *CreateMonitorGroupInstancesResponse, <-chan error) {
	responseChan := make(chan *CreateMonitorGroupInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMonitorGroupInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMonitorGroupInstancesWithCallback invokes the cms.CreateMonitorGroupInstances API asynchronously
func (client *Client) CreateMonitorGroupInstancesWithCallback(request *CreateMonitorGroupInstancesRequest, callback func(response *CreateMonitorGroupInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMonitorGroupInstancesResponse
		var err error
		defer close(result)
		response, err = client.CreateMonitorGroupInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMonitorGroupInstancesRequest is the request struct for api CreateMonitorGroupInstances
type CreateMonitorGroupInstancesRequest struct {
	*requests.RpcRequest
	Instances *[]CreateMonitorGroupInstancesInstances `position:"Query" name:"Instances"  type:"Repeated"`
	GroupId   string                                  `position:"Query" name:"GroupId"`
}

// CreateMonitorGroupInstancesInstances is a repeated param struct in CreateMonitorGroupInstancesRequest
type CreateMonitorGroupInstancesInstances struct {
	InstanceId   string `name:"InstanceId"`
	InstanceName string `name:"InstanceName"`
	RegionId     string `name:"RegionId"`
	Category     string `name:"Category"`
}

// CreateMonitorGroupInstancesResponse is the response struct for api CreateMonitorGroupInstances
type CreateMonitorGroupInstancesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCreateMonitorGroupInstancesRequest creates a request to invoke CreateMonitorGroupInstances API
func CreateCreateMonitorGroupInstancesRequest() (request *CreateMonitorGroupInstancesRequest) {
	request = &CreateMonitorGroupInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "CreateMonitorGroupInstances", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMonitorGroupInstancesResponse creates a response to parse from CreateMonitorGroupInstances response
func CreateCreateMonitorGroupInstancesResponse() (response *CreateMonitorGroupInstancesResponse) {
	response = &CreateMonitorGroupInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
