package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutMetricRuleTargets invokes the cms.PutMetricRuleTargets API synchronously
func (client *Client) PutMetricRuleTargets(request *PutMetricRuleTargetsRequest) (response *PutMetricRuleTargetsResponse, err error) {
	response = CreatePutMetricRuleTargetsResponse()
	err = client.DoAction(request, response)
	return
}

// PutMetricRuleTargetsWithChan invokes the cms.PutMetricRuleTargets API asynchronously
func (client *Client) PutMetricRuleTargetsWithChan(request *PutMetricRuleTargetsRequest) (<-chan *PutMetricRuleTargetsResponse, <-chan error) {
	responseChan := make(chan *PutMetricRuleTargetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutMetricRuleTargets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutMetricRuleTargetsWithCallback invokes the cms.PutMetricRuleTargets API asynchronously
func (client *Client) PutMetricRuleTargetsWithCallback(request *PutMetricRuleTargetsRequest, callback func(response *PutMetricRuleTargetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutMetricRuleTargetsResponse
		var err error
		defer close(result)
		response, err = client.PutMetricRuleTargets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutMetricRuleTargetsRequest is the request struct for api PutMetricRuleTargets
type PutMetricRuleTargetsRequest struct {
	*requests.RpcRequest
	Targets *[]PutMetricRuleTargetsTargets `position:"Query" name:"Targets"  type:"Repeated"`
	RuleId  string                         `position:"Query" name:"RuleId"`
}

// PutMetricRuleTargetsTargets is a repeated param struct in PutMetricRuleTargetsRequest
type PutMetricRuleTargetsTargets struct {
	Level string `name:"Level"`
	Id    string `name:"Id"`
	Arn   string `name:"Arn"`
}

// PutMetricRuleTargetsResponse is the response struct for api PutMetricRuleTargets
type PutMetricRuleTargetsResponse struct {
	*responses.BaseResponse
	Success   bool     `json:"Success" xml:"Success"`
	Code      string   `json:"Code" xml:"Code"`
	Message   string   `json:"Message" xml:"Message"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	FailData  FailData `json:"FailData" xml:"FailData"`
}

// CreatePutMetricRuleTargetsRequest creates a request to invoke PutMetricRuleTargets API
func CreatePutMetricRuleTargetsRequest() (request *PutMetricRuleTargetsRequest) {
	request = &PutMetricRuleTargetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "PutMetricRuleTargets", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePutMetricRuleTargetsResponse creates a response to parse from PutMetricRuleTargets response
func CreatePutMetricRuleTargetsResponse() (response *PutMetricRuleTargetsResponse) {
	response = &PutMetricRuleTargetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
