// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/time_window.proto

package v2

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// TimeWindowWhen defines the "when" attributes for time windows
type TimeWindowWhen struct {
	// Days is a hash of days
	Days                 TimeWindowDays `protobuf:"bytes,1,opt,name=days,proto3" json:"days"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *TimeWindowWhen) Reset()         { *m = TimeWindowWhen{} }
func (m *TimeWindowWhen) String() string { return proto.CompactTextString(m) }
func (*TimeWindowWhen) ProtoMessage()    {}
func (*TimeWindowWhen) Descriptor() ([]byte, []int) {
	return fileDescriptor_90b03ce0229cdb41, []int{0}
}
func (m *TimeWindowWhen) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeWindowWhen) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimeWindowWhen.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimeWindowWhen) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeWindowWhen.Merge(m, src)
}
func (m *TimeWindowWhen) XXX_Size() int {
	return m.Size()
}
func (m *TimeWindowWhen) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeWindowWhen.DiscardUnknown(m)
}

var xxx_messageInfo_TimeWindowWhen proto.InternalMessageInfo

func (m *TimeWindowWhen) GetDays() TimeWindowDays {
	if m != nil {
		return m.Days
	}
	return TimeWindowDays{}
}

// TimeWindowDays defines the days of a time window
type TimeWindowDays struct {
	All                  []*TimeWindowTimeRange `protobuf:"bytes,1,rep,name=all,proto3" json:"all,omitempty"`
	Sunday               []*TimeWindowTimeRange `protobuf:"bytes,2,rep,name=sunday,proto3" json:"sunday,omitempty"`
	Monday               []*TimeWindowTimeRange `protobuf:"bytes,3,rep,name=monday,proto3" json:"monday,omitempty"`
	Tuesday              []*TimeWindowTimeRange `protobuf:"bytes,4,rep,name=tuesday,proto3" json:"tuesday,omitempty"`
	Wednesday            []*TimeWindowTimeRange `protobuf:"bytes,5,rep,name=wednesday,proto3" json:"wednesday,omitempty"`
	Thursday             []*TimeWindowTimeRange `protobuf:"bytes,6,rep,name=thursday,proto3" json:"thursday,omitempty"`
	Friday               []*TimeWindowTimeRange `protobuf:"bytes,7,rep,name=friday,proto3" json:"friday,omitempty"`
	Saturday             []*TimeWindowTimeRange `protobuf:"bytes,8,rep,name=saturday,proto3" json:"saturday,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *TimeWindowDays) Reset()         { *m = TimeWindowDays{} }
func (m *TimeWindowDays) String() string { return proto.CompactTextString(m) }
func (*TimeWindowDays) ProtoMessage()    {}
func (*TimeWindowDays) Descriptor() ([]byte, []int) {
	return fileDescriptor_90b03ce0229cdb41, []int{1}
}
func (m *TimeWindowDays) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeWindowDays) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimeWindowDays.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimeWindowDays) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeWindowDays.Merge(m, src)
}
func (m *TimeWindowDays) XXX_Size() int {
	return m.Size()
}
func (m *TimeWindowDays) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeWindowDays.DiscardUnknown(m)
}

var xxx_messageInfo_TimeWindowDays proto.InternalMessageInfo

func (m *TimeWindowDays) GetAll() []*TimeWindowTimeRange {
	if m != nil {
		return m.All
	}
	return nil
}

func (m *TimeWindowDays) GetSunday() []*TimeWindowTimeRange {
	if m != nil {
		return m.Sunday
	}
	return nil
}

func (m *TimeWindowDays) GetMonday() []*TimeWindowTimeRange {
	if m != nil {
		return m.Monday
	}
	return nil
}

func (m *TimeWindowDays) GetTuesday() []*TimeWindowTimeRange {
	if m != nil {
		return m.Tuesday
	}
	return nil
}

func (m *TimeWindowDays) GetWednesday() []*TimeWindowTimeRange {
	if m != nil {
		return m.Wednesday
	}
	return nil
}

func (m *TimeWindowDays) GetThursday() []*TimeWindowTimeRange {
	if m != nil {
		return m.Thursday
	}
	return nil
}

func (m *TimeWindowDays) GetFriday() []*TimeWindowTimeRange {
	if m != nil {
		return m.Friday
	}
	return nil
}

func (m *TimeWindowDays) GetSaturday() []*TimeWindowTimeRange {
	if m != nil {
		return m.Saturday
	}
	return nil
}

// TimeWindowTimeRange defines the time ranges of a time
type TimeWindowTimeRange struct {
	// Begin is the time which the time window should begin, in the format
	// '3:00PM', which satisfies the time.Kitchen format
	Begin string `protobuf:"bytes,1,opt,name=begin,proto3" json:"begin"`
	// End is the time which the filter should end, in the format '3:00PM', which
	// satisfies the time.Kitchen format
	End                  string   `protobuf:"bytes,2,opt,name=end,proto3" json:"end"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TimeWindowTimeRange) Reset()         { *m = TimeWindowTimeRange{} }
func (m *TimeWindowTimeRange) String() string { return proto.CompactTextString(m) }
func (*TimeWindowTimeRange) ProtoMessage()    {}
func (*TimeWindowTimeRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_90b03ce0229cdb41, []int{2}
}
func (m *TimeWindowTimeRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TimeWindowTimeRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TimeWindowTimeRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TimeWindowTimeRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeWindowTimeRange.Merge(m, src)
}
func (m *TimeWindowTimeRange) XXX_Size() int {
	return m.Size()
}
func (m *TimeWindowTimeRange) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeWindowTimeRange.DiscardUnknown(m)
}

var xxx_messageInfo_TimeWindowTimeRange proto.InternalMessageInfo

func (m *TimeWindowTimeRange) GetBegin() string {
	if m != nil {
		return m.Begin
	}
	return ""
}

func (m *TimeWindowTimeRange) GetEnd() string {
	if m != nil {
		return m.End
	}
	return ""
}

func init() {
	proto.RegisterType((*TimeWindowWhen)(nil), "sensu.core.v2.TimeWindowWhen")
	proto.RegisterType((*TimeWindowDays)(nil), "sensu.core.v2.TimeWindowDays")
	proto.RegisterType((*TimeWindowTimeRange)(nil), "sensu.core.v2.TimeWindowTimeRange")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/time_window.proto", fileDescriptor_90b03ce0229cdb41)
}

var fileDescriptor_90b03ce0229cdb41 = []byte{
	// 396 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x92, 0xcd, 0x4a, 0xeb, 0x40,
	0x14, 0xc7, 0x3b, 0x4d, 0xfa, 0x35, 0xbd, 0xf7, 0x2e, 0xe6, 0x6e, 0x72, 0x2f, 0x98, 0x94, 0xac,
	0xba, 0x71, 0x42, 0x53, 0x41, 0x70, 0x63, 0x09, 0xc5, 0x7d, 0x83, 0x50, 0x70, 0x23, 0x49, 0x33,
	0x4d, 0x03, 0xcd, 0x4c, 0xc9, 0x57, 0xe9, 0x9b, 0xf8, 0x08, 0xe2, 0x13, 0xf8, 0x08, 0x5d, 0xfa,
	0x04, 0x41, 0xe3, 0xae, 0x4f, 0xe0, 0x52, 0x66, 0x62, 0x6d, 0x05, 0x5d, 0x64, 0x73, 0x32, 0x39,
	0xf9, 0xff, 0x7e, 0x19, 0x0e, 0x07, 0x9e, 0xfb, 0x41, 0xb2, 0x48, 0x5d, 0x3c, 0x63, 0xa1, 0x11,
	0x13, 0x1a, 0xa7, 0x65, 0x3d, 0xf5, 0x99, 0xe1, 0xac, 0x02, 0x63, 0xc6, 0x22, 0x62, 0x64, 0xa6,
	0x91, 0x04, 0x21, 0xb9, 0x5d, 0x07, 0xd4, 0x63, 0x6b, 0xbc, 0x8a, 0x58, 0xc2, 0xd0, 0x6f, 0x91,
	0xc3, 0x3c, 0x80, 0x33, 0xf3, 0xff, 0xd9, 0x91, 0xc7, 0x67, 0x3e, 0x33, 0x44, 0xca, 0x4d, 0xe7,
	0xa3, 0x6c, 0x80, 0x87, 0x78, 0x20, 0x9a, 0xa2, 0x27, 0x4e, 0xa5, 0x44, 0x9f, 0xc0, 0x3f, 0xd7,
	0x41, 0x48, 0xa6, 0x42, 0x3c, 0x5d, 0x10, 0x8a, 0x2e, 0xa1, 0xec, 0x39, 0x9b, 0x58, 0x01, 0x3d,
	0xd0, 0xef, 0x9a, 0x27, 0xf8, 0xcb, 0x5f, 0xf0, 0x21, 0x3c, 0x76, 0x36, 0xb1, 0xf5, 0x6b, 0x9b,
	0x6b, 0xb5, 0x5d, 0xae, 0x09, 0xc4, 0x16, 0x55, 0x7f, 0x90, 0x8f, 0x9d, 0x3c, 0x86, 0x2e, 0xa0,
	0xe4, 0x2c, 0x97, 0x0a, 0xe8, 0x49, 0xfd, 0xae, 0xa9, 0xff, 0xa8, 0xe4, 0x27, 0xdb, 0xa1, 0x3e,
	0xb1, 0xe4, 0x6d, 0xae, 0x01, 0x9b, 0x43, 0x68, 0x04, 0x9b, 0x71, 0x4a, 0x3d, 0x67, 0xa3, 0xd4,
	0x2b, 0xe2, 0x1f, 0x1c, 0x37, 0x84, 0x4c, 0x18, 0xa4, 0xaa, 0x86, 0x92, 0x43, 0x16, 0x6c, 0x25,
	0x29, 0x89, 0xb9, 0x42, 0xae, 0xa8, 0xd8, 0x83, 0xe8, 0x0a, 0x76, 0xd6, 0xc4, 0xa3, 0xa5, 0xa5,
	0x51, 0xd1, 0x72, 0x40, 0xd1, 0x18, 0xb6, 0x93, 0x45, 0x1a, 0x09, 0x4d, 0xb3, 0xa2, 0xe6, 0x93,
	0xe4, 0x33, 0x99, 0x47, 0x01, 0x77, 0xb4, 0xaa, 0xce, 0xa4, 0xe4, 0xf8, 0x3d, 0x62, 0x27, 0x49,
	0x23, 0xee, 0x68, 0x57, 0xbd, 0xc7, 0x9e, 0xd4, 0x27, 0xf0, 0xef, 0x37, 0x31, 0xa4, 0xc1, 0x86,
	0x4b, 0xfc, 0x80, 0x8a, 0x2d, 0xec, 0x58, 0x9d, 0x5d, 0xae, 0x95, 0x0d, 0xbb, 0x7c, 0xa0, 0x7f,
	0x50, 0x22, 0xd4, 0x53, 0xea, 0xe2, 0x73, 0x6b, 0x97, 0x6b, 0xfc, 0xd5, 0xe6, 0xc5, 0xea, 0xbd,
	0xbd, 0xa8, 0xe0, 0xbe, 0x50, 0xc1, 0x63, 0xa1, 0x82, 0x6d, 0xa1, 0x82, 0xa7, 0x42, 0x05, 0xcf,
	0x85, 0x0a, 0xee, 0x5e, 0xd5, 0xda, 0x4d, 0x3d, 0x33, 0xdd, 0xa6, 0xd8, 0xfd, 0xe1, 0x7b, 0x00,
	0x00, 0x00, 0xff, 0xff, 0x27, 0x94, 0x08, 0xa8, 0x7b, 0x03, 0x00, 0x00,
}

func (this *TimeWindowWhen) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TimeWindowWhen)
	if !ok {
		that2, ok := that.(TimeWindowWhen)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Days.Equal(&that1.Days) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TimeWindowDays) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TimeWindowDays)
	if !ok {
		that2, ok := that.(TimeWindowDays)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.All) != len(that1.All) {
		return false
	}
	for i := range this.All {
		if !this.All[i].Equal(that1.All[i]) {
			return false
		}
	}
	if len(this.Sunday) != len(that1.Sunday) {
		return false
	}
	for i := range this.Sunday {
		if !this.Sunday[i].Equal(that1.Sunday[i]) {
			return false
		}
	}
	if len(this.Monday) != len(that1.Monday) {
		return false
	}
	for i := range this.Monday {
		if !this.Monday[i].Equal(that1.Monday[i]) {
			return false
		}
	}
	if len(this.Tuesday) != len(that1.Tuesday) {
		return false
	}
	for i := range this.Tuesday {
		if !this.Tuesday[i].Equal(that1.Tuesday[i]) {
			return false
		}
	}
	if len(this.Wednesday) != len(that1.Wednesday) {
		return false
	}
	for i := range this.Wednesday {
		if !this.Wednesday[i].Equal(that1.Wednesday[i]) {
			return false
		}
	}
	if len(this.Thursday) != len(that1.Thursday) {
		return false
	}
	for i := range this.Thursday {
		if !this.Thursday[i].Equal(that1.Thursday[i]) {
			return false
		}
	}
	if len(this.Friday) != len(that1.Friday) {
		return false
	}
	for i := range this.Friday {
		if !this.Friday[i].Equal(that1.Friday[i]) {
			return false
		}
	}
	if len(this.Saturday) != len(that1.Saturday) {
		return false
	}
	for i := range this.Saturday {
		if !this.Saturday[i].Equal(that1.Saturday[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TimeWindowTimeRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TimeWindowTimeRange)
	if !ok {
		that2, ok := that.(TimeWindowTimeRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Begin != that1.Begin {
		return false
	}
	if this.End != that1.End {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *TimeWindowWhen) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeWindowWhen) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimeWindowWhen) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	{
		size, err := m.Days.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintTimeWindow(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *TimeWindowDays) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeWindowDays) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimeWindowDays) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Saturday) > 0 {
		for iNdEx := len(m.Saturday) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Saturday[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Friday) > 0 {
		for iNdEx := len(m.Friday) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Friday[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.Thursday) > 0 {
		for iNdEx := len(m.Thursday) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Thursday[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Wednesday) > 0 {
		for iNdEx := len(m.Wednesday) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Wednesday[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Tuesday) > 0 {
		for iNdEx := len(m.Tuesday) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Tuesday[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Monday) > 0 {
		for iNdEx := len(m.Monday) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Monday[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Sunday) > 0 {
		for iNdEx := len(m.Sunday) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Sunday[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.All) > 0 {
		for iNdEx := len(m.All) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.All[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTimeWindow(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *TimeWindowTimeRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TimeWindowTimeRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TimeWindowTimeRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.End) > 0 {
		i -= len(m.End)
		copy(dAtA[i:], m.End)
		i = encodeVarintTimeWindow(dAtA, i, uint64(len(m.End)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Begin) > 0 {
		i -= len(m.Begin)
		copy(dAtA[i:], m.Begin)
		i = encodeVarintTimeWindow(dAtA, i, uint64(len(m.Begin)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintTimeWindow(dAtA []byte, offset int, v uint64) int {
	offset -= sovTimeWindow(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedTimeWindowWhen(r randyTimeWindow, easy bool) *TimeWindowWhen {
	this := &TimeWindowWhen{}
	v1 := NewPopulatedTimeWindowDays(r, easy)
	this.Days = *v1
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedTimeWindow(r, 2)
	}
	return this
}

func NewPopulatedTimeWindowDays(r randyTimeWindow, easy bool) *TimeWindowDays {
	this := &TimeWindowDays{}
	if r.Intn(5) != 0 {
		v2 := r.Intn(5)
		this.All = make([]*TimeWindowTimeRange, v2)
		for i := 0; i < v2; i++ {
			this.All[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v3 := r.Intn(5)
		this.Sunday = make([]*TimeWindowTimeRange, v3)
		for i := 0; i < v3; i++ {
			this.Sunday[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v4 := r.Intn(5)
		this.Monday = make([]*TimeWindowTimeRange, v4)
		for i := 0; i < v4; i++ {
			this.Monday[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v5 := r.Intn(5)
		this.Tuesday = make([]*TimeWindowTimeRange, v5)
		for i := 0; i < v5; i++ {
			this.Tuesday[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v6 := r.Intn(5)
		this.Wednesday = make([]*TimeWindowTimeRange, v6)
		for i := 0; i < v6; i++ {
			this.Wednesday[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v7 := r.Intn(5)
		this.Thursday = make([]*TimeWindowTimeRange, v7)
		for i := 0; i < v7; i++ {
			this.Thursday[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v8 := r.Intn(5)
		this.Friday = make([]*TimeWindowTimeRange, v8)
		for i := 0; i < v8; i++ {
			this.Friday[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v9 := r.Intn(5)
		this.Saturday = make([]*TimeWindowTimeRange, v9)
		for i := 0; i < v9; i++ {
			this.Saturday[i] = NewPopulatedTimeWindowTimeRange(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedTimeWindow(r, 9)
	}
	return this
}

func NewPopulatedTimeWindowTimeRange(r randyTimeWindow, easy bool) *TimeWindowTimeRange {
	this := &TimeWindowTimeRange{}
	this.Begin = string(randStringTimeWindow(r))
	this.End = string(randStringTimeWindow(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedTimeWindow(r, 3)
	}
	return this
}

type randyTimeWindow interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneTimeWindow(r randyTimeWindow) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringTimeWindow(r randyTimeWindow) string {
	v10 := r.Intn(100)
	tmps := make([]rune, v10)
	for i := 0; i < v10; i++ {
		tmps[i] = randUTF8RuneTimeWindow(r)
	}
	return string(tmps)
}
func randUnrecognizedTimeWindow(r randyTimeWindow, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldTimeWindow(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldTimeWindow(dAtA []byte, r randyTimeWindow, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateTimeWindow(dAtA, uint64(key))
		v11 := r.Int63()
		if r.Intn(2) == 0 {
			v11 *= -1
		}
		dAtA = encodeVarintPopulateTimeWindow(dAtA, uint64(v11))
	case 1:
		dAtA = encodeVarintPopulateTimeWindow(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateTimeWindow(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateTimeWindow(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateTimeWindow(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateTimeWindow(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *TimeWindowWhen) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Days.Size()
	n += 1 + l + sovTimeWindow(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimeWindowDays) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.All) > 0 {
		for _, e := range m.All {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if len(m.Sunday) > 0 {
		for _, e := range m.Sunday {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if len(m.Monday) > 0 {
		for _, e := range m.Monday {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if len(m.Tuesday) > 0 {
		for _, e := range m.Tuesday {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if len(m.Wednesday) > 0 {
		for _, e := range m.Wednesday {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if len(m.Thursday) > 0 {
		for _, e := range m.Thursday {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if len(m.Friday) > 0 {
		for _, e := range m.Friday {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if len(m.Saturday) > 0 {
		for _, e := range m.Saturday {
			l = e.Size()
			n += 1 + l + sovTimeWindow(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TimeWindowTimeRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Begin)
	if l > 0 {
		n += 1 + l + sovTimeWindow(uint64(l))
	}
	l = len(m.End)
	if l > 0 {
		n += 1 + l + sovTimeWindow(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovTimeWindow(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTimeWindow(x uint64) (n int) {
	return sovTimeWindow(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TimeWindowWhen) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeWindow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeWindowWhen: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeWindowWhen: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Days", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Days.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTimeWindow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeWindowDays) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeWindow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeWindowDays: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeWindowDays: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field All", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.All = append(m.All, &TimeWindowTimeRange{})
			if err := m.All[len(m.All)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sunday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sunday = append(m.Sunday, &TimeWindowTimeRange{})
			if err := m.Sunday[len(m.Sunday)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Monday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Monday = append(m.Monday, &TimeWindowTimeRange{})
			if err := m.Monday[len(m.Monday)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tuesday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tuesday = append(m.Tuesday, &TimeWindowTimeRange{})
			if err := m.Tuesday[len(m.Tuesday)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Wednesday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Wednesday = append(m.Wednesday, &TimeWindowTimeRange{})
			if err := m.Wednesday[len(m.Wednesday)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Thursday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Thursday = append(m.Thursday, &TimeWindowTimeRange{})
			if err := m.Thursday[len(m.Thursday)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Friday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Friday = append(m.Friday, &TimeWindowTimeRange{})
			if err := m.Friday[len(m.Friday)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Saturday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Saturday = append(m.Saturday, &TimeWindowTimeRange{})
			if err := m.Saturday[len(m.Saturday)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTimeWindow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TimeWindowTimeRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTimeWindow
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TimeWindowTimeRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TimeWindowTimeRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Begin", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Begin = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTimeWindow
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.End = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTimeWindow(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTimeWindow
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTimeWindow(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTimeWindow
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTimeWindow
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTimeWindow
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupTimeWindow
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthTimeWindow
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthTimeWindow        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTimeWindow          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupTimeWindow = fmt.Errorf("proto: unexpected end of group")
)
