// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/entity.proto

package v2

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	github_com_golang_protobuf_proto "github.com/golang/protobuf/proto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Entity is the Entity supplying the event. The default Entity for any
// Event is the running Agent process--if the Event is sent by an Agent.
type Entity struct {
	EntityClass    string         `protobuf:"bytes,1,opt,name=entity_class,json=entityClass,proto3" json:"entity_class"`
	System         System         `protobuf:"bytes,3,opt,name=system,proto3" json:"system"`
	Subscriptions  []string       `protobuf:"bytes,4,rep,name=subscriptions,proto3" json:"subscriptions"`
	LastSeen       int64          `protobuf:"varint,5,opt,name=last_seen,json=lastSeen,proto3" json:"last_seen"`
	Deregister     bool           `protobuf:"varint,6,opt,name=deregister,proto3" json:"deregister"`
	Deregistration Deregistration `protobuf:"bytes,7,opt,name=deregistration,proto3" json:"deregistration"`
	User           string         `protobuf:"bytes,11,opt,name=user,proto3" json:"user,omitempty"`
	// ExtendedAttributes store serialized arbitrary JSON-encoded data
	ExtendedAttributes []byte `protobuf:"bytes,12,opt,name=extended_attributes,json=extendedAttributes,proto3" json:"-"`
	// Redact contains the fields to redact on the agent
	Redact []string `protobuf:"bytes,13,rep,name=redact,proto3" json:"redact,omitempty"`
	// Metadata contains the name, namespace, labels and annotations of the
	// entity
	ObjectMeta `protobuf:"bytes,14,opt,name=metadata,proto3,embedded=metadata" json:"metadata,omitempty"`
	// SensuAgentVersion is the sensu-agent version.
	SensuAgentVersion string `protobuf:"bytes,15,opt,name=sensu_agent_version,json=sensuAgentVersion,proto3" json:"sensu_agent_version"`
	// KeepaliveHandlers contains a list of handlers to use for the entity's
	// keepalive events
	KeepaliveHandlers    []string `protobuf:"bytes,16,rep,name=keepalive_handlers,json=keepaliveHandlers,proto3" json:"keepalive_handlers,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_00cf9e6f3a2355f9, []int{0}
}
func (m *Entity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(m, src)
}
func (m *Entity) XXX_Size() int {
	return m.Size()
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

// System contains information about the system that the Agent process
// is running on, used for additional Entity context.
type System struct {
	Hostname        string  `protobuf:"bytes,1,opt,name=hostname,proto3" json:"hostname,omitempty"`
	OS              string  `protobuf:"bytes,2,opt,name=os,proto3" json:"os,omitempty"`
	Platform        string  `protobuf:"bytes,3,opt,name=platform,proto3" json:"platform,omitempty"`
	PlatformFamily  string  `protobuf:"bytes,4,opt,name=platform_family,json=platformFamily,proto3" json:"platform_family,omitempty"`
	PlatformVersion string  `protobuf:"bytes,5,opt,name=platform_version,json=platformVersion,proto3" json:"platform_version,omitempty"`
	Network         Network `protobuf:"bytes,6,opt,name=network,proto3" json:"network"`
	Arch            string  `protobuf:"bytes,7,opt,name=arch,proto3" json:"arch,omitempty"`
	ARMVersion      int32   `protobuf:"varint,8,opt,name=arm_version,json=armVersion,proto3" json:"arm_version,omitempty"`
	// LibCType indicates the type of libc the agent has access to (glibc, musl,
	// etc)
	LibCType string `protobuf:"bytes,9,opt,name=LibCType,proto3" json:"libc_type"`
	// VMSystem indicates the VM system of the agent (kvm, vbox, etc)
	VMSystem string `protobuf:"bytes,10,opt,name=VMSystem,proto3" json:"vm_system"`
	// VMRole indicates the VM role of the agent (host/guest)
	VMRole string `protobuf:"bytes,11,opt,name=VMRole,proto3" json:"vm_role"`
	// CloudProvider indicates the public cloud the agent is running on.
	CloudProvider string `protobuf:"bytes,12,opt,name=CloudProvider,proto3" json:"cloud_provider"`
	FloatType     string `protobuf:"bytes,13,opt,name=float_type,json=floatType,proto3" json:"float_type,omitempty"`
	// Processes contains information about the local processes on the agent.
	Processes            []*Process `protobuf:"bytes,14,rep,name=Processes,proto3" json:"processes"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *System) Reset()         { *m = System{} }
func (m *System) String() string { return proto.CompactTextString(m) }
func (*System) ProtoMessage()    {}
func (*System) Descriptor() ([]byte, []int) {
	return fileDescriptor_00cf9e6f3a2355f9, []int{1}
}
func (m *System) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *System) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_System.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *System) XXX_Merge(src proto.Message) {
	xxx_messageInfo_System.Merge(m, src)
}
func (m *System) XXX_Size() int {
	return m.Size()
}
func (m *System) XXX_DiscardUnknown() {
	xxx_messageInfo_System.DiscardUnknown(m)
}

var xxx_messageInfo_System proto.InternalMessageInfo

func (m *System) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

func (m *System) GetOS() string {
	if m != nil {
		return m.OS
	}
	return ""
}

func (m *System) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *System) GetPlatformFamily() string {
	if m != nil {
		return m.PlatformFamily
	}
	return ""
}

func (m *System) GetPlatformVersion() string {
	if m != nil {
		return m.PlatformVersion
	}
	return ""
}

func (m *System) GetNetwork() Network {
	if m != nil {
		return m.Network
	}
	return Network{}
}

func (m *System) GetArch() string {
	if m != nil {
		return m.Arch
	}
	return ""
}

func (m *System) GetARMVersion() int32 {
	if m != nil {
		return m.ARMVersion
	}
	return 0
}

func (m *System) GetLibCType() string {
	if m != nil {
		return m.LibCType
	}
	return ""
}

func (m *System) GetVMSystem() string {
	if m != nil {
		return m.VMSystem
	}
	return ""
}

func (m *System) GetVMRole() string {
	if m != nil {
		return m.VMRole
	}
	return ""
}

func (m *System) GetCloudProvider() string {
	if m != nil {
		return m.CloudProvider
	}
	return ""
}

func (m *System) GetFloatType() string {
	if m != nil {
		return m.FloatType
	}
	return ""
}

func (m *System) GetProcesses() []*Process {
	if m != nil {
		return m.Processes
	}
	return nil
}

// Process contains information about a local process.
type Process struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Process) Reset()         { *m = Process{} }
func (m *Process) String() string { return proto.CompactTextString(m) }
func (*Process) ProtoMessage()    {}
func (*Process) Descriptor() ([]byte, []int) {
	return fileDescriptor_00cf9e6f3a2355f9, []int{2}
}
func (m *Process) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Process) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Process.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Process) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Process.Merge(m, src)
}
func (m *Process) XXX_Size() int {
	return m.Size()
}
func (m *Process) XXX_DiscardUnknown() {
	xxx_messageInfo_Process.DiscardUnknown(m)
}

var xxx_messageInfo_Process proto.InternalMessageInfo

func (m *Process) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Network contains information about the system network interfaces
// that the Agent process is running on, used for additional Entity
// context.
type Network struct {
	Interfaces           []NetworkInterface `protobuf:"bytes,1,rep,name=interfaces,proto3" json:"interfaces"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Network) Reset()         { *m = Network{} }
func (m *Network) String() string { return proto.CompactTextString(m) }
func (*Network) ProtoMessage()    {}
func (*Network) Descriptor() ([]byte, []int) {
	return fileDescriptor_00cf9e6f3a2355f9, []int{3}
}
func (m *Network) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Network) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Network.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Network) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Network.Merge(m, src)
}
func (m *Network) XXX_Size() int {
	return m.Size()
}
func (m *Network) XXX_DiscardUnknown() {
	xxx_messageInfo_Network.DiscardUnknown(m)
}

var xxx_messageInfo_Network proto.InternalMessageInfo

func (m *Network) GetInterfaces() []NetworkInterface {
	if m != nil {
		return m.Interfaces
	}
	return nil
}

// NetworkInterface contains information about a system network
// interface.
type NetworkInterface struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	MAC                  string   `protobuf:"bytes,2,opt,name=mac,proto3" json:"mac,omitempty"`
	Addresses            []string `protobuf:"bytes,3,rep,name=addresses,proto3" json:"addresses"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NetworkInterface) Reset()         { *m = NetworkInterface{} }
func (m *NetworkInterface) String() string { return proto.CompactTextString(m) }
func (*NetworkInterface) ProtoMessage()    {}
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return fileDescriptor_00cf9e6f3a2355f9, []int{4}
}
func (m *NetworkInterface) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NetworkInterface) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_NetworkInterface.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *NetworkInterface) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkInterface.Merge(m, src)
}
func (m *NetworkInterface) XXX_Size() int {
	return m.Size()
}
func (m *NetworkInterface) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkInterface.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkInterface proto.InternalMessageInfo

func (m *NetworkInterface) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NetworkInterface) GetMAC() string {
	if m != nil {
		return m.MAC
	}
	return ""
}

func (m *NetworkInterface) GetAddresses() []string {
	if m != nil {
		return m.Addresses
	}
	return nil
}

// Deregistration contains configuration for Sensu entity de-registration.
type Deregistration struct {
	Handler              string   `protobuf:"bytes,1,opt,name=handler,proto3" json:"handler,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Deregistration) Reset()         { *m = Deregistration{} }
func (m *Deregistration) String() string { return proto.CompactTextString(m) }
func (*Deregistration) ProtoMessage()    {}
func (*Deregistration) Descriptor() ([]byte, []int) {
	return fileDescriptor_00cf9e6f3a2355f9, []int{5}
}
func (m *Deregistration) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Deregistration) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Deregistration.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Deregistration) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Deregistration.Merge(m, src)
}
func (m *Deregistration) XXX_Size() int {
	return m.Size()
}
func (m *Deregistration) XXX_DiscardUnknown() {
	xxx_messageInfo_Deregistration.DiscardUnknown(m)
}

var xxx_messageInfo_Deregistration proto.InternalMessageInfo

func (m *Deregistration) GetHandler() string {
	if m != nil {
		return m.Handler
	}
	return ""
}

func init() {
	proto.RegisterType((*Entity)(nil), "sensu.core.v2.Entity")
	proto.RegisterType((*System)(nil), "sensu.core.v2.System")
	proto.RegisterType((*Process)(nil), "sensu.core.v2.Process")
	proto.RegisterType((*Network)(nil), "sensu.core.v2.Network")
	proto.RegisterType((*NetworkInterface)(nil), "sensu.core.v2.NetworkInterface")
	proto.RegisterType((*Deregistration)(nil), "sensu.core.v2.Deregistration")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/entity.proto", fileDescriptor_00cf9e6f3a2355f9)
}

var fileDescriptor_00cf9e6f3a2355f9 = []byte{
	// 931 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0xcb, 0x72, 0x1b, 0x45,
	0x14, 0xf5, 0x58, 0xb2, 0x1e, 0x57, 0x96, 0x62, 0x77, 0x0a, 0x33, 0x71, 0x11, 0x8d, 0x4a, 0x2c,
	0xa2, 0x04, 0x2c, 0x11, 0x99, 0x0a, 0x14, 0x2b, 0x3c, 0xe6, 0x59, 0x60, 0x92, 0x6a, 0x83, 0x17,
	0x2c, 0x98, 0x6a, 0xcd, 0xb4, 0xe5, 0x21, 0x33, 0xd3, 0x53, 0xdd, 0x2d, 0x81, 0xfe, 0x80, 0x2d,
	0x3b, 0x96, 0x59, 0xe6, 0x13, 0x58, 0xb3, 0xca, 0x32, 0x5f, 0x30, 0x05, 0x62, 0x37, 0x5f, 0xc0,
	0x92, 0xea, 0x9e, 0x87, 0x1e, 0xe5, 0x45, 0x36, 0xaa, 0x7b, 0xef, 0x39, 0xb7, 0xef, 0xa3, 0xcf,
	0xb4, 0x60, 0x3c, 0xf5, 0xe5, 0xcd, 0x6c, 0x32, 0x74, 0x59, 0x38, 0x12, 0x34, 0x12, 0xb3, 0xec,
	0xf7, 0x64, 0xca, 0x46, 0x24, 0xf6, 0x47, 0x2e, 0xe3, 0x74, 0x34, 0x1f, 0x8f, 0x68, 0x24, 0x7d,
	0xb9, 0x18, 0xc6, 0x9c, 0x49, 0x86, 0xda, 0x9a, 0x32, 0x54, 0xd8, 0x70, 0x3e, 0x3e, 0xfe, 0x70,
	0xed, 0x88, 0x29, 0x9b, 0xb2, 0x91, 0x66, 0x4d, 0x66, 0xd7, 0x9f, 0xce, 0x1f, 0x0f, 0x4f, 0x87,
	0x8f, 0x75, 0x50, 0xc7, 0xb4, 0x95, 0x1d, 0x72, 0xfc, 0xc1, 0x9b, 0x15, 0x0e, 0xa9, 0x24, 0x59,
	0x46, 0xff, 0xf7, 0x3d, 0xa8, 0x7d, 0xae, 0xfb, 0x40, 0xa7, 0xb0, 0x9f, 0x75, 0xe4, 0xb8, 0x01,
	0x11, 0xc2, 0x34, 0x7a, 0xc6, 0xa0, 0x69, 0x1f, 0xa4, 0x89, 0xb5, 0x11, 0xc7, 0xad, 0xcc, 0x3b,
	0x57, 0x0e, 0x3a, 0x85, 0x9a, 0x58, 0x08, 0x49, 0x43, 0xb3, 0xd2, 0x33, 0x06, 0xad, 0xf1, 0x5b,
	0xc3, 0x8d, 0x39, 0x86, 0x97, 0x1a, 0xb4, 0xab, 0xaf, 0x12, 0x6b, 0x07, 0xe7, 0x54, 0xf4, 0x11,
	0xb4, 0xc5, 0x6c, 0x22, 0x5c, 0xee, 0xc7, 0xd2, 0x67, 0x91, 0x30, 0xab, 0xbd, 0xca, 0xa0, 0x69,
	0x1f, 0xa6, 0x89, 0xb5, 0x09, 0xe0, 0x4d, 0x17, 0x3d, 0x82, 0x66, 0x40, 0x84, 0x74, 0x04, 0xa5,
	0x91, 0xb9, 0xd7, 0x33, 0x06, 0x15, 0xbb, 0x9d, 0x26, 0xd6, 0x2a, 0x88, 0x1b, 0xca, 0xbc, 0xa4,
	0x34, 0x42, 0x43, 0x00, 0x8f, 0x72, 0x3a, 0xf5, 0x85, 0xa4, 0xdc, 0xac, 0xf5, 0x8c, 0x41, 0xc3,
	0xee, 0xa4, 0x89, 0xb5, 0x16, 0xc5, 0x6b, 0x36, 0xfa, 0x06, 0x3a, 0x85, 0xc7, 0x89, 0x2a, 0x67,
	0xd6, 0xf5, 0x44, 0xf7, 0xb7, 0x26, 0xfa, 0x6c, 0x83, 0x94, 0x4f, 0xb6, 0x95, 0x8a, 0x10, 0x54,
	0x67, 0x82, 0x72, 0xb3, 0xa5, 0x76, 0x88, 0xb5, 0x8d, 0x9e, 0xc0, 0x5d, 0xfa, 0xab, 0xa4, 0x91,
	0x47, 0x3d, 0x87, 0x48, 0xc9, 0xfd, 0xc9, 0x4c, 0x52, 0x61, 0xee, 0xf7, 0x8c, 0xc1, 0xbe, 0xbd,
	0x97, 0x26, 0x96, 0x71, 0x82, 0x51, 0xc1, 0x38, 0x2b, 0x09, 0xe8, 0x08, 0x6a, 0x9c, 0x7a, 0xc4,
	0x95, 0x66, 0x5b, 0xad, 0x09, 0xe7, 0x1e, 0xfa, 0x01, 0x1a, 0xea, 0x22, 0x3d, 0x22, 0x89, 0xd9,
	0xd1, 0xad, 0xde, 0xdb, 0x6a, 0xf5, 0xe9, 0xe4, 0x67, 0xea, 0xca, 0x0b, 0x2a, 0x89, 0xdd, 0x55,
	0x6d, 0xbe, 0x4e, 0x2c, 0x23, 0x4d, 0x2c, 0x54, 0xa4, 0xbd, 0xcf, 0x42, 0x5f, 0xd2, 0x30, 0x96,
	0x0b, 0x5c, 0x1e, 0x85, 0xbe, 0x84, 0xbb, 0xfa, 0x14, 0x87, 0x4c, 0x69, 0x24, 0x9d, 0x39, 0xe5,
	0x42, 0x2d, 0xe3, 0x8e, 0x56, 0xc3, 0xdb, 0x69, 0x62, 0xdd, 0x06, 0xe3, 0x43, 0x1d, 0x3c, 0x53,
	0xb1, 0xab, 0x2c, 0x84, 0x4e, 0x00, 0x3d, 0xa7, 0x34, 0x26, 0x81, 0x3f, 0xa7, 0xce, 0x0d, 0x89,
	0xbc, 0x80, 0x72, 0x61, 0x1e, 0xe8, 0x19, 0x0e, 0x4b, 0xe4, 0xab, 0x1c, 0xf8, 0xa4, 0xf1, 0xdb,
	0x0b, 0x6b, 0xe7, 0xe5, 0x0b, 0xcb, 0xe8, 0xff, 0x55, 0x85, 0x5a, 0xa6, 0x1b, 0x74, 0x0c, 0x8d,
	0x1b, 0x26, 0x64, 0x44, 0x42, 0x9a, 0xe9, 0x11, 0x97, 0x3e, 0x3a, 0x82, 0x5d, 0x26, 0xcc, 0x5d,
	0xdd, 0x57, 0x6d, 0x99, 0x58, 0xbb, 0x4f, 0x2f, 0xf1, 0x2e, 0x13, 0x2a, 0x27, 0x0e, 0x88, 0xbc,
	0x66, 0x3c, 0x13, 0x65, 0x13, 0x97, 0x3e, 0x7a, 0x00, 0x77, 0x0a, 0xdb, 0xb9, 0x26, 0xa1, 0x1f,
	0x2c, 0xcc, 0xaa, 0xa6, 0x74, 0x8a, 0xf0, 0x17, 0x3a, 0x8a, 0x1e, 0xc2, 0x41, 0x49, 0x2c, 0x56,
	0xb0, 0xa7, 0x99, 0xe5, 0x01, 0xc5, 0x9c, 0x4f, 0xa0, 0x1e, 0x51, 0xf9, 0x0b, 0xe3, 0xcf, 0xb5,
	0xca, 0x5a, 0xe3, 0xa3, 0xad, 0x6b, 0xf8, 0x2e, 0x43, 0x73, 0xa9, 0x14, 0x64, 0xa5, 0x11, 0xc2,
	0xdd, 0x1b, 0x2d, 0xb3, 0x26, 0xd6, 0x36, 0x1a, 0x41, 0x8b, 0xac, 0x55, 0x6c, 0xf4, 0x8c, 0xc1,
	0x9e, 0xdd, 0x59, 0x26, 0x16, 0x9c, 0xe1, 0x8b, 0xbc, 0x20, 0x06, 0xb2, 0x2a, 0xfe, 0x10, 0x1a,
	0xdf, 0xfa, 0x93, 0xf3, 0xef, 0x17, 0x31, 0x35, 0x9b, 0x7a, 0x15, 0xd9, 0x07, 0xe1, 0x4f, 0x5c,
	0x47, 0x2e, 0x62, 0x8a, 0x4b, 0x58, 0x51, 0xaf, 0x2e, 0xb2, 0xbd, 0x9a, 0xb0, 0xa2, 0xce, 0x43,
	0x27, 0xfb, 0x2c, 0x71, 0x09, 0xa3, 0x77, 0xa1, 0x76, 0x75, 0x81, 0x59, 0x40, 0x33, 0x01, 0xdb,
	0xad, 0x34, 0xb1, 0xea, 0xf3, 0xd0, 0xe1, 0x2c, 0xa0, 0x38, 0x87, 0xd0, 0xc7, 0xd0, 0x3e, 0x0f,
	0xd8, 0xcc, 0x7b, 0xc6, 0xd9, 0xdc, 0xf7, 0x28, 0xd7, 0x4a, 0x6e, 0xda, 0x28, 0x4d, 0xac, 0x8e,
	0xab, 0x00, 0x27, 0xce, 0x11, 0xbc, 0x49, 0x44, 0xf7, 0x01, 0xae, 0x03, 0x46, 0xa4, 0xee, 0xd0,
	0x6c, 0xeb, 0xf9, 0x9b, 0x3a, 0xa2, 0x1b, 0x3d, 0x87, 0xe6, 0x33, 0xce, 0x5c, 0x2a, 0x04, 0x15,
	0x66, 0xa7, 0x57, 0xb9, 0x65, 0xa5, 0x39, 0x9e, 0x4d, 0x10, 0x17, 0x64, 0xbc, 0xca, 0xeb, 0x3f,
	0x80, 0x7a, 0xee, 0xa0, 0x77, 0xa0, 0xba, 0x12, 0x90, 0xdd, 0x48, 0x13, 0x4b, 0xfb, 0x58, 0xff,
	0xf6, 0x7f, 0x82, 0x7a, 0x7e, 0x41, 0xe8, 0x12, 0xc0, 0x8f, 0x24, 0xe5, 0xd7, 0xc4, 0xa5, 0xea,
	0xfd, 0x53, 0x95, 0xad, 0xdb, 0x2f, 0xf3, 0xeb, 0x82, 0x67, 0x23, 0x75, 0xab, 0xea, 0x5d, 0x59,
	0xa5, 0xe2, 0x35, 0xbb, 0x1f, 0xc1, 0xc1, 0x76, 0x8e, 0xba, 0xfa, 0x35, 0x49, 0x6b, 0x1b, 0xdd,
	0x83, 0x4a, 0x48, 0xdc, 0x5c, 0xcf, 0xf5, 0x65, 0x62, 0x55, 0x2e, 0xce, 0xce, 0xb1, 0x8a, 0xa1,
	0xf7, 0xa0, 0x49, 0x3c, 0x8f, 0x67, 0x0b, 0xa9, 0xe8, 0xb7, 0x52, 0x0f, 0x5e, 0x06, 0xf1, 0xca,
	0xec, 0x3f, 0x82, 0xce, 0xe6, 0x13, 0x85, 0x4c, 0xa8, 0xe7, 0x9f, 0x5f, 0x5e, 0xb0, 0x70, 0xed,
	0xde, 0x7f, 0xff, 0x74, 0x8d, 0x97, 0xcb, 0xae, 0xf1, 0xe7, 0xb2, 0x6b, 0xbc, 0x5a, 0x76, 0x8d,
	0xd7, 0xcb, 0xae, 0xf1, 0xf7, 0xb2, 0x6b, 0xfc, 0xf1, 0x6f, 0x77, 0xe7, 0xc7, 0xdd, 0xf9, 0x78,
	0x52, 0xd3, 0x7f, 0x13, 0xa7, 0xff, 0x07, 0x00, 0x00, 0xff, 0xff, 0x26, 0x95, 0x6f, 0xf0, 0xd3,
	0x06, 0x00, 0x00,
}

func (this *Entity) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Entity)
	if !ok {
		that2, ok := that.(Entity)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.EntityClass != that1.EntityClass {
		return false
	}
	if !this.System.Equal(&that1.System) {
		return false
	}
	if len(this.Subscriptions) != len(that1.Subscriptions) {
		return false
	}
	for i := range this.Subscriptions {
		if this.Subscriptions[i] != that1.Subscriptions[i] {
			return false
		}
	}
	if this.LastSeen != that1.LastSeen {
		return false
	}
	if this.Deregister != that1.Deregister {
		return false
	}
	if !this.Deregistration.Equal(&that1.Deregistration) {
		return false
	}
	if this.User != that1.User {
		return false
	}
	if !bytes.Equal(this.ExtendedAttributes, that1.ExtendedAttributes) {
		return false
	}
	if len(this.Redact) != len(that1.Redact) {
		return false
	}
	for i := range this.Redact {
		if this.Redact[i] != that1.Redact[i] {
			return false
		}
	}
	if !this.ObjectMeta.Equal(&that1.ObjectMeta) {
		return false
	}
	if this.SensuAgentVersion != that1.SensuAgentVersion {
		return false
	}
	if len(this.KeepaliveHandlers) != len(that1.KeepaliveHandlers) {
		return false
	}
	for i := range this.KeepaliveHandlers {
		if this.KeepaliveHandlers[i] != that1.KeepaliveHandlers[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *System) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*System)
	if !ok {
		that2, ok := that.(System)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Hostname != that1.Hostname {
		return false
	}
	if this.OS != that1.OS {
		return false
	}
	if this.Platform != that1.Platform {
		return false
	}
	if this.PlatformFamily != that1.PlatformFamily {
		return false
	}
	if this.PlatformVersion != that1.PlatformVersion {
		return false
	}
	if !this.Network.Equal(&that1.Network) {
		return false
	}
	if this.Arch != that1.Arch {
		return false
	}
	if this.ARMVersion != that1.ARMVersion {
		return false
	}
	if this.LibCType != that1.LibCType {
		return false
	}
	if this.VMSystem != that1.VMSystem {
		return false
	}
	if this.VMRole != that1.VMRole {
		return false
	}
	if this.CloudProvider != that1.CloudProvider {
		return false
	}
	if this.FloatType != that1.FloatType {
		return false
	}
	if len(this.Processes) != len(that1.Processes) {
		return false
	}
	for i := range this.Processes {
		if !this.Processes[i].Equal(that1.Processes[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Process) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Process)
	if !ok {
		that2, ok := that.(Process)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Network) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Network)
	if !ok {
		that2, ok := that.(Network)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Interfaces) != len(that1.Interfaces) {
		return false
	}
	for i := range this.Interfaces {
		if !this.Interfaces[i].Equal(&that1.Interfaces[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *NetworkInterface) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*NetworkInterface)
	if !ok {
		that2, ok := that.(NetworkInterface)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.MAC != that1.MAC {
		return false
	}
	if len(this.Addresses) != len(that1.Addresses) {
		return false
	}
	for i := range this.Addresses {
		if this.Addresses[i] != that1.Addresses[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Deregistration) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Deregistration)
	if !ok {
		that2, ok := that.(Deregistration)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Handler != that1.Handler {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

type EntityFace interface {
	Proto() github_com_golang_protobuf_proto.Message
	GetEntityClass() string
	GetSystem() System
	GetSubscriptions() []string
	GetLastSeen() int64
	GetDeregister() bool
	GetDeregistration() Deregistration
	GetUser() string
	GetExtendedAttributes() []byte
	GetRedact() []string
	GetObjectMeta() ObjectMeta
	GetSensuAgentVersion() string
	GetKeepaliveHandlers() []string
}

func (this *Entity) Proto() github_com_golang_protobuf_proto.Message {
	return this
}

func (this *Entity) TestProto() github_com_golang_protobuf_proto.Message {
	return NewEntityFromFace(this)
}

func (this *Entity) GetEntityClass() string {
	return this.EntityClass
}

func (this *Entity) GetSystem() System {
	return this.System
}

func (this *Entity) GetSubscriptions() []string {
	return this.Subscriptions
}

func (this *Entity) GetLastSeen() int64 {
	return this.LastSeen
}

func (this *Entity) GetDeregister() bool {
	return this.Deregister
}

func (this *Entity) GetDeregistration() Deregistration {
	return this.Deregistration
}

func (this *Entity) GetUser() string {
	return this.User
}

func (this *Entity) GetExtendedAttributes() []byte {
	return this.ExtendedAttributes
}

func (this *Entity) GetRedact() []string {
	return this.Redact
}

func (this *Entity) GetObjectMeta() ObjectMeta {
	return this.ObjectMeta
}

func (this *Entity) GetSensuAgentVersion() string {
	return this.SensuAgentVersion
}

func (this *Entity) GetKeepaliveHandlers() []string {
	return this.KeepaliveHandlers
}

func NewEntityFromFace(that EntityFace) *Entity {
	this := &Entity{}
	this.EntityClass = that.GetEntityClass()
	this.System = that.GetSystem()
	this.Subscriptions = that.GetSubscriptions()
	this.LastSeen = that.GetLastSeen()
	this.Deregister = that.GetDeregister()
	this.Deregistration = that.GetDeregistration()
	this.User = that.GetUser()
	this.ExtendedAttributes = that.GetExtendedAttributes()
	this.Redact = that.GetRedact()
	this.ObjectMeta = that.GetObjectMeta()
	this.SensuAgentVersion = that.GetSensuAgentVersion()
	this.KeepaliveHandlers = that.GetKeepaliveHandlers()
	return this
}

func (m *Entity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Entity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Entity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.KeepaliveHandlers) > 0 {
		for iNdEx := len(m.KeepaliveHandlers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.KeepaliveHandlers[iNdEx])
			copy(dAtA[i:], m.KeepaliveHandlers[iNdEx])
			i = encodeVarintEntity(dAtA, i, uint64(len(m.KeepaliveHandlers[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0x82
		}
	}
	if len(m.SensuAgentVersion) > 0 {
		i -= len(m.SensuAgentVersion)
		copy(dAtA[i:], m.SensuAgentVersion)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.SensuAgentVersion)))
		i--
		dAtA[i] = 0x7a
	}
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEntity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x72
	if len(m.Redact) > 0 {
		for iNdEx := len(m.Redact) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Redact[iNdEx])
			copy(dAtA[i:], m.Redact[iNdEx])
			i = encodeVarintEntity(dAtA, i, uint64(len(m.Redact[iNdEx])))
			i--
			dAtA[i] = 0x6a
		}
	}
	if len(m.ExtendedAttributes) > 0 {
		i -= len(m.ExtendedAttributes)
		copy(dAtA[i:], m.ExtendedAttributes)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.ExtendedAttributes)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.User) > 0 {
		i -= len(m.User)
		copy(dAtA[i:], m.User)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.User)))
		i--
		dAtA[i] = 0x5a
	}
	{
		size, err := m.Deregistration.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEntity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x3a
	if m.Deregister {
		i--
		if m.Deregister {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.LastSeen != 0 {
		i = encodeVarintEntity(dAtA, i, uint64(m.LastSeen))
		i--
		dAtA[i] = 0x28
	}
	if len(m.Subscriptions) > 0 {
		for iNdEx := len(m.Subscriptions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Subscriptions[iNdEx])
			copy(dAtA[i:], m.Subscriptions[iNdEx])
			i = encodeVarintEntity(dAtA, i, uint64(len(m.Subscriptions[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	{
		size, err := m.System.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEntity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1a
	if len(m.EntityClass) > 0 {
		i -= len(m.EntityClass)
		copy(dAtA[i:], m.EntityClass)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.EntityClass)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *System) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *System) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *System) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Processes) > 0 {
		for iNdEx := len(m.Processes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Processes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEntity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.FloatType) > 0 {
		i -= len(m.FloatType)
		copy(dAtA[i:], m.FloatType)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.FloatType)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.CloudProvider) > 0 {
		i -= len(m.CloudProvider)
		copy(dAtA[i:], m.CloudProvider)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.CloudProvider)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.VMRole) > 0 {
		i -= len(m.VMRole)
		copy(dAtA[i:], m.VMRole)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.VMRole)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.VMSystem) > 0 {
		i -= len(m.VMSystem)
		copy(dAtA[i:], m.VMSystem)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.VMSystem)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.LibCType) > 0 {
		i -= len(m.LibCType)
		copy(dAtA[i:], m.LibCType)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.LibCType)))
		i--
		dAtA[i] = 0x4a
	}
	if m.ARMVersion != 0 {
		i = encodeVarintEntity(dAtA, i, uint64(m.ARMVersion))
		i--
		dAtA[i] = 0x40
	}
	if len(m.Arch) > 0 {
		i -= len(m.Arch)
		copy(dAtA[i:], m.Arch)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.Arch)))
		i--
		dAtA[i] = 0x3a
	}
	{
		size, err := m.Network.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintEntity(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x32
	if len(m.PlatformVersion) > 0 {
		i -= len(m.PlatformVersion)
		copy(dAtA[i:], m.PlatformVersion)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.PlatformVersion)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.PlatformFamily) > 0 {
		i -= len(m.PlatformFamily)
		copy(dAtA[i:], m.PlatformFamily)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.PlatformFamily)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Platform) > 0 {
		i -= len(m.Platform)
		copy(dAtA[i:], m.Platform)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.Platform)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.OS) > 0 {
		i -= len(m.OS)
		copy(dAtA[i:], m.OS)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.OS)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Hostname) > 0 {
		i -= len(m.Hostname)
		copy(dAtA[i:], m.Hostname)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.Hostname)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Process) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Process) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Process) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Network) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Network) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Network) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Interfaces) > 0 {
		for iNdEx := len(m.Interfaces) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Interfaces[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintEntity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *NetworkInterface) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NetworkInterface) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *NetworkInterface) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Addresses) > 0 {
		for iNdEx := len(m.Addresses) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Addresses[iNdEx])
			copy(dAtA[i:], m.Addresses[iNdEx])
			i = encodeVarintEntity(dAtA, i, uint64(len(m.Addresses[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.MAC) > 0 {
		i -= len(m.MAC)
		copy(dAtA[i:], m.MAC)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.MAC)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Deregistration) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Deregistration) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Deregistration) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Handler) > 0 {
		i -= len(m.Handler)
		copy(dAtA[i:], m.Handler)
		i = encodeVarintEntity(dAtA, i, uint64(len(m.Handler)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintEntity(dAtA []byte, offset int, v uint64) int {
	offset -= sovEntity(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedEntity(r randyEntity, easy bool) *Entity {
	this := &Entity{}
	this.EntityClass = string(randStringEntity(r))
	v1 := NewPopulatedSystem(r, easy)
	this.System = *v1
	v2 := r.Intn(10)
	this.Subscriptions = make([]string, v2)
	for i := 0; i < v2; i++ {
		this.Subscriptions[i] = string(randStringEntity(r))
	}
	this.LastSeen = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LastSeen *= -1
	}
	this.Deregister = bool(bool(r.Intn(2) == 0))
	v3 := NewPopulatedDeregistration(r, easy)
	this.Deregistration = *v3
	this.User = string(randStringEntity(r))
	v4 := r.Intn(100)
	this.ExtendedAttributes = make([]byte, v4)
	for i := 0; i < v4; i++ {
		this.ExtendedAttributes[i] = byte(r.Intn(256))
	}
	v5 := r.Intn(10)
	this.Redact = make([]string, v5)
	for i := 0; i < v5; i++ {
		this.Redact[i] = string(randStringEntity(r))
	}
	v6 := NewPopulatedObjectMeta(r, easy)
	this.ObjectMeta = *v6
	this.SensuAgentVersion = string(randStringEntity(r))
	v7 := r.Intn(10)
	this.KeepaliveHandlers = make([]string, v7)
	for i := 0; i < v7; i++ {
		this.KeepaliveHandlers[i] = string(randStringEntity(r))
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedEntity(r, 17)
	}
	return this
}

func NewPopulatedSystem(r randyEntity, easy bool) *System {
	this := &System{}
	this.Hostname = string(randStringEntity(r))
	this.OS = string(randStringEntity(r))
	this.Platform = string(randStringEntity(r))
	this.PlatformFamily = string(randStringEntity(r))
	this.PlatformVersion = string(randStringEntity(r))
	v8 := NewPopulatedNetwork(r, easy)
	this.Network = *v8
	this.Arch = string(randStringEntity(r))
	this.ARMVersion = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.ARMVersion *= -1
	}
	this.LibCType = string(randStringEntity(r))
	this.VMSystem = string(randStringEntity(r))
	this.VMRole = string(randStringEntity(r))
	this.CloudProvider = string(randStringEntity(r))
	this.FloatType = string(randStringEntity(r))
	if r.Intn(5) != 0 {
		v9 := r.Intn(5)
		this.Processes = make([]*Process, v9)
		for i := 0; i < v9; i++ {
			this.Processes[i] = NewPopulatedProcess(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedEntity(r, 15)
	}
	return this
}

func NewPopulatedProcess(r randyEntity, easy bool) *Process {
	this := &Process{}
	this.Name = string(randStringEntity(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedEntity(r, 2)
	}
	return this
}

func NewPopulatedNetwork(r randyEntity, easy bool) *Network {
	this := &Network{}
	if r.Intn(5) != 0 {
		v10 := r.Intn(5)
		this.Interfaces = make([]NetworkInterface, v10)
		for i := 0; i < v10; i++ {
			v11 := NewPopulatedNetworkInterface(r, easy)
			this.Interfaces[i] = *v11
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedEntity(r, 2)
	}
	return this
}

func NewPopulatedNetworkInterface(r randyEntity, easy bool) *NetworkInterface {
	this := &NetworkInterface{}
	this.Name = string(randStringEntity(r))
	this.MAC = string(randStringEntity(r))
	v12 := r.Intn(10)
	this.Addresses = make([]string, v12)
	for i := 0; i < v12; i++ {
		this.Addresses[i] = string(randStringEntity(r))
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedEntity(r, 4)
	}
	return this
}

func NewPopulatedDeregistration(r randyEntity, easy bool) *Deregistration {
	this := &Deregistration{}
	this.Handler = string(randStringEntity(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedEntity(r, 2)
	}
	return this
}

type randyEntity interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneEntity(r randyEntity) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringEntity(r randyEntity) string {
	v13 := r.Intn(100)
	tmps := make([]rune, v13)
	for i := 0; i < v13; i++ {
		tmps[i] = randUTF8RuneEntity(r)
	}
	return string(tmps)
}
func randUnrecognizedEntity(r randyEntity, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldEntity(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldEntity(dAtA []byte, r randyEntity, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateEntity(dAtA, uint64(key))
		v14 := r.Int63()
		if r.Intn(2) == 0 {
			v14 *= -1
		}
		dAtA = encodeVarintPopulateEntity(dAtA, uint64(v14))
	case 1:
		dAtA = encodeVarintPopulateEntity(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateEntity(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateEntity(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateEntity(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateEntity(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Entity) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.EntityClass)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = m.System.Size()
	n += 1 + l + sovEntity(uint64(l))
	if len(m.Subscriptions) > 0 {
		for _, s := range m.Subscriptions {
			l = len(s)
			n += 1 + l + sovEntity(uint64(l))
		}
	}
	if m.LastSeen != 0 {
		n += 1 + sovEntity(uint64(m.LastSeen))
	}
	if m.Deregister {
		n += 2
	}
	l = m.Deregistration.Size()
	n += 1 + l + sovEntity(uint64(l))
	l = len(m.User)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.ExtendedAttributes)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	if len(m.Redact) > 0 {
		for _, s := range m.Redact {
			l = len(s)
			n += 1 + l + sovEntity(uint64(l))
		}
	}
	l = m.ObjectMeta.Size()
	n += 1 + l + sovEntity(uint64(l))
	l = len(m.SensuAgentVersion)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	if len(m.KeepaliveHandlers) > 0 {
		for _, s := range m.KeepaliveHandlers {
			l = len(s)
			n += 2 + l + sovEntity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *System) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Hostname)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.OS)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.Platform)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.PlatformFamily)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.PlatformVersion)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = m.Network.Size()
	n += 1 + l + sovEntity(uint64(l))
	l = len(m.Arch)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	if m.ARMVersion != 0 {
		n += 1 + sovEntity(uint64(m.ARMVersion))
	}
	l = len(m.LibCType)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.VMSystem)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.VMRole)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.CloudProvider)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.FloatType)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	if len(m.Processes) > 0 {
		for _, e := range m.Processes {
			l = e.Size()
			n += 1 + l + sovEntity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Process) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Network) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Interfaces) > 0 {
		for _, e := range m.Interfaces {
			l = e.Size()
			n += 1 + l + sovEntity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *NetworkInterface) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	l = len(m.MAC)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	if len(m.Addresses) > 0 {
		for _, s := range m.Addresses {
			l = len(s)
			n += 1 + l + sovEntity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Deregistration) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Handler)
	if l > 0 {
		n += 1 + l + sovEntity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovEntity(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozEntity(x uint64) (n int) {
	return sovEntity(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Entity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEntity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Entity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Entity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntityClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EntityClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field System", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.System.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscriptions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subscriptions = append(m.Subscriptions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSeen", wireType)
			}
			m.LastSeen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastSeen |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deregister", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Deregister = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deregistration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Deregistration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtendedAttributes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtendedAttributes = append(m.ExtendedAttributes[:0], dAtA[iNdEx:postIndex]...)
			if m.ExtendedAttributes == nil {
				m.ExtendedAttributes = []byte{}
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Redact", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Redact = append(m.Redact, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SensuAgentVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SensuAgentVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepaliveHandlers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeepaliveHandlers = append(m.KeepaliveHandlers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEntity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *System) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEntity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: System: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: System: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hostname", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hostname = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OS", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OS = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platform = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlatformFamily", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PlatformFamily = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlatformVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PlatformVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Network.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Arch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Arch = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ARMVersion", wireType)
			}
			m.ARMVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ARMVersion |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LibCType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LibCType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VMSystem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VMSystem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VMRole", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VMRole = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CloudProvider", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CloudProvider = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FloatType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FloatType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Processes = append(m.Processes, &Process{})
			if err := m.Processes[len(m.Processes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEntity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Process) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEntity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Process: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Process: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEntity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Network) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEntity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Network: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Network: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interfaces", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Interfaces = append(m.Interfaces, NetworkInterface{})
			if err := m.Interfaces[len(m.Interfaces)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEntity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NetworkInterface) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEntity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NetworkInterface: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NetworkInterface: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MAC", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MAC = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEntity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Deregistration) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowEntity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Deregistration: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Deregistration: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthEntity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthEntity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Handler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipEntity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthEntity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipEntity(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowEntity
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowEntity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthEntity
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupEntity
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthEntity
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthEntity        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowEntity          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupEntity = fmt.Errorf("proto: unexpected end of group")
)
