# Contributing

First and foremost: **thank you very much** for your interest in this
project. Feel free to skip all this and open your issue / pull request
if reading contribution guidelines is too much for you at this point.
We value your contribution a lot more than we value your ability to
follow rules (and thankfully we can afford to take this approach given
this project's demand).

Any kind of contribution is welcome. We can always use better docs and
tests (and code, of course). If you think you can improve this project
in any dimension _let's talk_ :-)

## Guidelines

Be kind and respectful in all your interactions with people inside
(outside too!) this community; There is no excuse for not showing
basic decency. Sarcasm and generally unconstructive remarks are **not
welcome**.

### Issues

When opening and interacting with issues please:

- Be as clear as possible
- Provide examples if you can

### Pull Requests

We expect that pull requests:

- Have [good commit messages][commits]
- Contain tests for new features
- Target and can be cleanly merged with the  `master` branch
- Pass the tests (TravisCI will run them automatically but `go test` is
  your friend)

[commits]: https://www.git-scm.com/book/en/v2/Distributed-Git-Contributing-to-a-Project#_commit_guidelines

### Project Management

Don't bother with labels, milestones, assignments, etc. We don't make
use of those.
