/* (c) Magnus Auvinen. See licence.txt in the root of the distribution for more information. */
/* If you are missing that file, acquire a complete release at teeworlds.com.                */
#ifndef ENGINE_CLIENT_SERVERBROWSER_FILTER_H
#define ENGINE_CLIENT_SERVERBROWSER_FILTER_H

#include <base/tl/array.h>

class CServerBrowserFilter
{
public:
	enum
	{
		RESORT_FLAG_FORCE=1,
		RESORT_FLAG_FAV=2,
	};

	class CServerFilter
	{
	public:
		CServerBrowserFilter *m_pServerBrowserFilter;

		// filter settings
		int m_SortHash;
		int m_Ping;
		int m_Country;
		char m_aGametype[32];
		char m_aServerAddress[NETADDR_MAXSTRSIZE];
		
		// stats
		int m_NumSortedPlayers;
		int m_NumSortedServers;
		int *m_pSortedServerlist;
		int m_SortedServersCapacity;
		
		CServerFilter();
		~CServerFilter();

		void Filter();
		int GetSortHash() const;
		void Sort();

		// sorting criterions
		bool SortCompareName(int Index1, int Index2) const;
		bool SortCompareMap(int Index1, int Index2) const;
		bool SortComparePing(int Index1, int Index2) const;
		bool SortCompareGametype(int Index1, int Index2) const;
		bool SortCompareNumPlayers(int Index1, int Index2) const;
		bool SortCompareNumClients(int Index1, int Index2) const;
	};

	//
	void Init(class IFriends *pFriends, const char *pNetVersion);
	void Clear();
	void Sort(class CServerEntry **ppServerlist, int NumServers, int ResortFlags);

	// filter
	int AddFilter(const class CServerFilterInfo *pFilterInfo);
	void GetFilter(int Index, class CServerFilterInfo *pFilterInfo) const;
	void RemoveFilter(int Index);
	void SetFilter(int Index, const class CServerFilterInfo *pFilterInfo);
	
	// stats
	const void *GetID(int FilterIndex, int Index) const { return &m_lFilters[FilterIndex].m_pSortedServerlist[Index]; }
	int GetIndex(int FilterIndex, int Index) const { return m_lFilters[FilterIndex].m_pSortedServerlist[Index]; }
	int GetNumSortedServers(int Index) const { return m_lFilters[Index].m_NumSortedServers; }
	int GetNumSortedPlayers(int Index) const { return m_lFilters[Index].m_NumSortedPlayers; }

private:
	class IFriends *m_pFriends;
	char m_aNetVersion[128];
	array<CServerFilter> m_lFilters;

	// get updated on sort
	class CServerEntry **m_ppServerlist;
	int m_NumServers;
};

#endif
