/*
this code is Public Domain
*/


#include "gui_utils.h"
#include "utils.h"

void create_menu_from_list (QObject *handler,
                            QMenu *menu,
                            const QStringList &list,
                            const char *method
                           )
{
  menu->setTearOffEnabled (true);

  foreach (QString s, list)
          {
           if (! s.startsWith("#"))
              {
               QAction *act = new QAction (s, menu->parentWidget());
               handler->connect (act, SIGNAL(triggered()), handler, method);
               menu->addAction (act);
              }
          }
}


QString mod_to_string (Qt::KeyboardModifiers k)
{
  QString s;

  if (k & Qt::ShiftModifier)
     s += "Shift+";

  if (k & Qt::ControlModifier)
     s += "Ctrl+";

  if (k & Qt::AltModifier)
     s += "Alt+";

  if (k & Qt::MetaModifier)
     s+= "Meta+";

  return s;
}


QString keycode_to_string (int k)
{
 // return QKeySequence(k).toString();

  QString s;

  switch (k)
         {
          case Qt::Key_F1:
                          s = "F1";
                          break;

          case Qt::Key_F2:
                          s = "F2";
                          break;

          case Qt::Key_F3:
                          s = "F3";
                          break;

          case Qt::Key_F4:
                          s = "F4";
                          break;

          case Qt::Key_F5:
                          s = "F5";
                          break;

          case Qt::Key_F6:
                          s = "F6";
                          break;

          case Qt::Key_F7:
                          s = "F7";
                          break;

          case Qt::Key_F8:
                          s = "F8";
                          break;

          case Qt::Key_F9:
                          s = "F9";
                          break;

          case Qt::Key_F10:
                          s = "F10";
                          break;

          case Qt::Key_F11:
                          s = "F11";
                          break;

          case Qt::Key_F12:
                          s = "F12";
                          break;

          default:
                  s = QChar (k);
         }

  return s;
}


void create_menu_from_dir (QObject *handler,
                           QMenu *menu,
                           const QString &dir,
                           const char *method
                           )
{
  menu->setTearOffEnabled (true);
  QDir d (dir);
  QFileInfoList lst_fi = d.entryInfoList (QDir::NoDotAndDotDot | QDir::AllEntries,
                                          QDir::DirsFirst | QDir::IgnoreCase |
                                          QDir::LocaleAware | QDir::Name);

  foreach (QFileInfo fi, lst_fi)
         {
          if (fi.isDir())
             {
              QMenu *mni_temp = menu->addMenu (fi.fileName());
              create_menu_from_dir (handler, mni_temp,
                                    fi.filePath(), method);
             }
          else
              {
               QAction *act = new QAction (fi.fileName(), menu->parentWidget());
               act->setData (fi.filePath());
               handler->connect (act, SIGNAL(triggered()), handler, method);
               menu->addAction (act);
              }
         }
}


QImage image_scale_by (const QImage &source,
                       bool by_side,
                       int value,
                       Qt::TransformationMode mode)
{
  bool horisontal = (source.width() > source.height());

  int width;
  int height;

  if (by_side)
     {
      width = value;
      height = value;
     }
   else
       {
        width = get_value (source.width(), value);
        height = get_value (source.height(), value);
       }

  if (horisontal)
     return source.scaledToWidth (width, mode);
  else
      return source.scaledToHeight (height, mode);
}


QLineEdit* new_line_edit (QBoxLayout *layout, const QString &label, const QString &def_value)
{
  QHBoxLayout *lt_h = new QHBoxLayout;
  QLabel *l = new QLabel (label);

  QLineEdit *r = new QLineEdit;
  r->setText (def_value);

  lt_h->addWidget (l);
  lt_h ->addWidget (r);

  layout->addLayout (lt_h);

  return r;
}


QSpinBox* new_spin_box (QBoxLayout *layout, const QString &label, int min, int max, int value, int step)
{
  QHBoxLayout *lt_h = new QHBoxLayout;
  QLabel *l = new QLabel (label);

  QSpinBox *r = new QSpinBox;

  r->setSingleStep (step);
  r->setRange (min, max);
  r->setValue (value);

  lt_h->addWidget (l);
  lt_h ->addWidget (r);

  layout->addLayout (lt_h);

  return r;
}


QComboBox* new_combobox (QBoxLayout *layout,
                         const QString &label,
                         const QStringList &items,
                         const QString &def_value)
{
  QHBoxLayout *lt_h = new QHBoxLayout;
  QLabel *l = new QLabel (label);

  QComboBox *r = new QComboBox;

  r->addItems (items);
  r->setCurrentIndex (r->findText (def_value));

  lt_h->addWidget (l);
  lt_h->addWidget (r);

  layout->addLayout (lt_h);

  return r;
}
