/*
this code is Public Domain
*/

#include <QtCore>

#include "calc.h"
#include "utils.h"



class CMItem
{
public:

  QChar op;
  double val;

  CMItem (QChar a_op, double a_val);
};



CMItem::CMItem (QChar a_op, double a_val)
{
  op = a_op;
  val = a_val;
}


double qcalculate (QString expression)
{
  QList <CMItem*> items;

//parse expression to list:

  bool new_operator = false;

  QString t_operand;
  QChar t_operator = '0';

  int stop_size = expression.length() - 1;

  for (int i = 0; i < expression.length(); i++)
      {
       QChar t = expression[i];

       if (t.isDigit() || t == '.' || t == ',')
          t_operand += t;

       if (t == '+' || t == '-' ||
           t == '/' || t == '*' ||
           t == '^' || t == '%' ||
           i == stop_size)
          {
           new_operator = true;
           t_operator = t;

           if (i == stop_size)
              t_operator = '0';
          }

       if (new_operator)
          {
           //добавляем в items

           double f = t_operand.toDouble();

           items.push_back (new CMItem (t_operator, f));

           t_operand = "";
           t_operator = '0';
           new_operator = false;
          }
      }

  int i = 0;

  while (i < items.count())
        {
         if (i + 1 != items.count())
            {
             CMItem *current = items[i];
             CMItem *next = items[i + 1];

             if (current->op == '^')
                {
                 next->val = pow (current->val, next->val);
                 delete current;
                 items.removeAt (i);
                 continue;
                }

             if (current->op == '%')
                {
                 next->val = get_percent (current->val, next->val);
                 delete current;
                 items.removeAt (i);
                 continue;
                }
             }
         i++;
        }

  i = 0;

  while (i < items.count())
        {
         if (i + 1 != items.count())
            {
             CMItem *current = items[i];
             CMItem *next = items[i + 1];

             if (current->op == '/' || current->op == '*')
                {
                 if (current->op == '/')
                     next->val = current->val / next->val;
                 else
                     if (current->op == '*')
                        next->val = current->val * next->val;

                 delete current;
                 items.removeAt (i);
                 continue;
                }
             }
         i++;
        }

   i = 0;

   while (i < items.count())
         {
          if (i + 1 != items.count())
             {
              CMItem *current = items[i];
              CMItem *next = items[i + 1];

              if (current->op == '-' || current->op == '+')
                 {
                  if (current->op == '-')
                      next->val = current->val - next->val;
                  else
                      if (current->op == '+')
                         next->val = current->val + next->val;

                  delete current;
                  items.removeAt (i);
                  continue;
                 }
              }
          i++;
         }

  CMItem *item = items[0];

  double f = item->val;

  delete item;

  return f;
}
