/***************************************************************************
                          tea_text_document.h  -  description
                             -------------------
    begin                : Mon Dec 1 2003
    copyright            : (C) 2003, 2004, 2005 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef CHAI_MODE

#include <gtksourceview/gtksourcelanguagesmanager.h>
#include <gtksourceview/gtksourcetagtable.h>
#include <gtksourceview/gtksourcetag.h>
#include <gtksourceview/gtksourceview.h>

GtkSourceLanguagesManager *source_languages_manager;  
GtkSourceTagTable *main_tags_table;


#else

GtkTextTagTable *main_tags_table;

#endif

GtkTextTag *tag_paint;
GtkTextTag *tag_current_line;


GtkTextTag *tag_spell_err;
GtkTextTag *tag_comment;
GtkTextTag *tag_identifier;
GtkTextTag *tag_digit;
GtkTextTag *tag_string;
GtkTextTag *tag_html_tag;
GtkTextTag *tag_preprocessor;
GtkTextTag *tag_type;


GHashTable *c_t_keywords;
GHashTable *c_t_types;

GHashTable *pas_t_keywords;
GHashTable *pas_t_types;

GHashTable *py_t_keywords;

GHashTable *php_t_keywords;
GHashTable *bash_t_keywords;
GHashTable *po_t_keywords;


 
typedef struct
{
  gpointer um;

  gboolean autosave;
  gboolean toggle_images_visibility;

  gint position;
  gboolean *readonly;
  gchar *hl_mode;

  gint dclicked_y;
  gchar *current_path;
  GtkTextTag *basic_tag;
  gboolean b_saved;
  gchar *file_name_utf8;
  gchar *file_name_local;
  gchar *encoding;
  gboolean linenums;
  
  
#ifdef CHAI_MODE

  GtkSourceBuffer *text_buffer;
#else

  GtkTextBuffer *text_buffer;

#endif
  
  GtkWidget *tab_label;
  GtkWidget *but;

  GtkScrolledWindow *scrolledwindow;
  GtkTextView *text_view;

  gchar *last_searched_text;

} t_note_page;


typedef struct 
             {
              gchar *prefix;
              GtkTextIter itstart;
              GtkTextIter itend;
              t_note_page *page;

             } t_text_part;


t_text_part *temp_text_part;
GList *dox;
gchar *last_dir;


/////////////

void do_errors_hl (GtkTextView *text_view);
void set_lm_colors (void);
void hl_line_under_cursor (t_note_page *doc);
void hl_line_n (t_note_page *doc, gint line);


#ifdef CHAI_MODE

GList* get_supported_langs (void);
void langs_save (void);
GtkSourceTagStyle* string_to_tag_style (const gchar *string);
void langs_load (void);
GtkSourceLanguage* find_lang_by_name (gchar *name);
gchar* get_gconf_key (GtkSourceLanguage *language, const gchar *tag_id);
void done_hl (void);
void hl_init (void);
void save_tag (GtkSourceLanguage *language, GtkSourceTag *tag);

#endif


////////////

void do_backup (gchar *file_name, gboolean do_check);

t_note_page* doc_clear_new (void);
                                        
t_note_page* page_create_new (void);
void page_free (t_note_page *page);
void page_del_by_index (int i);
gpointer glist_find_by_index (GList *list, int i);
t_note_page* get_page_by_index (int i);

gboolean text_doc_save (t_note_page *doc ,char *a_filename);
t_note_page* doc_open_file (gchar *a_filename);

//cur_text_doc points to current text document (in any case)
t_note_page *cur_text_doc;


gboolean doc_is_sel (gpointer text_buffer);
gchar* doc_get_buf (gpointer text_buffer);
gboolean doc_save_buffer_to_file (gpointer text_buffer, gchar *filename);


void doc_select_line (t_note_page *doc, gint line);
void doc_rep_sel (t_note_page *page, const gchar *newstring);
t_note_page* get_page (void);
void doc_apply_settings (t_note_page *doc);
void doc_insert_at_cursor (t_note_page *doc, gchar *text);
void document_set_line_numbers(t_note_page* doc, gboolean value);
void doc_update_all (void);
gint editor_get_pos (t_note_page *doc);
void editor_set_pos (t_note_page *doc, guint pos);
//gchar* doc_get_word (t_note_page *doc);
void log_to_memo (gchar *m1, gchar* m2, gint mode);
void widget_apply_colors (GtkWidget *w);
gboolean doc_reload_text (t_note_page *doc, gchar *filename, gchar *enc);
gint get_n_page_by_filename (gchar *filename);
gboolean find_quote (gunichar ch, gpointer user_data);
gchar* get_c_url_pure (t_note_page *doc); 
t_note_page* doc_ins_to_new (const gchar *newstring);
t_note_page* get_page_text (void);
void set_title (t_note_page *t);
t_note_page* open_file_std (gchar *f);
gboolean doc_search_f_next_ncase (t_note_page *doc); 
gboolean doc_search_f_ncase (t_note_page *doc, const gchar *text); 
gchar* upcase_each_first_letter_ofw (t_note_page *doc);
gchar* doc_get_word_at_left (t_note_page *doc, GtkTextIter *itstart, GtkTextIter *itend); 
void doc_move_cursor_backw (t_note_page *doc, gint i); 
void doc_move_cursor_forw (t_note_page *doc, gint i); 
void doc_move_cursor_backw_middle_tags (t_note_page *doc); 

void indent_real(GtkWidget *text_view);
void doc_header_source_switch (t_note_page *doc);
gint cb_button_press_event (GtkWidget *widget, GdkEventButton *event, gpointer user_data);
void doc_close_all (void);
void doc_close_all_except_current (void);
GList* add_session_item_composed (GList *list, t_note_page *doc);
GList* add_recent_item_composed (GList *list, t_note_page *doc);
void current_tag_close (t_note_page *doc, gint mode);
void doc_goto_local_label (const gchar *l);
void set_last_dir (t_note_page *doc);
void swap_lines (t_note_page *doc, gboolean with_upper);
void doc_save_all (void);
void doc_search_and_paint (t_note_page *doc, gchar *str);
void doc_paint_lines_bigger_than (t_note_page *doc, gint val);
void session_save_to_file (gchar *filename);
void session_open_from_file (gchar *filename);
void doc_undo (t_note_page *doc);
void doc_redo (t_note_page *doc);
void doc_indent_selection (t_note_page *doc, gboolean unindent);
void doc_save_emergency (void);
gchar* get_c_url2 (t_note_page *doc); 
gchar* doc_get_cur_mispelled (t_note_page *doc, GtkTextIter *itstart, GtkTextIter *itend); 
void hide_error_marks (t_note_page *doc);





GtkTextTag *tag_paint;
GtkTextTag *tag_current_line;


GtkTextTag *tag_spell_err;
GtkTextTag *tag_comment;
GtkTextTag *tag_identifier;
GtkTextTag *tag_digit;
GtkTextTag *tag_string;
GtkTextTag *tag_html_tag;
GtkTextTag *tag_preprocessor;
GtkTextTag *tag_type;


GHashTable *c_t_keywords;
GHashTable *c_t_types;

GHashTable *pas_t_keywords;
GHashTable *pas_t_types;

GHashTable *py_t_keywords;

GHashTable *php_t_keywords;
GHashTable *bash_t_keywords;
GHashTable *po_t_keywords;


#ifdef CHAI_MODE

void document_apply_hl (t_note_page* doc); 

#endif