#include "mime_map.h"

#include <algorithm>
#include <map>

std::map<std::string, std::string> mime_map;

class PopulateMimeMap {
public:
	PopulateMimeMap();
};

static PopulateMimeMap populate_mime_map;

PopulateMimeMap::PopulateMimeMap() {
	/* Generated from an OSX-provided mime.types, massaged somewhat by hand */
	mime_map["application/andrew-inset"] = "ez";
	mime_map["application/applixware"] = "aw";
	mime_map["application/atom+xml"] = "atom";
	mime_map["application/atomcat+xml"] = "atomcat";
	mime_map["application/atomsvc+xml"] = "atomsvc";
	mime_map["application/ccxml+xml"] = "ccxml";
	mime_map["application/cdmi-capability"] = "cdmia";
	mime_map["application/cdmi-container"] = "cdmic";
	mime_map["application/cdmi-domain"] = "cdmid";
	mime_map["application/cdmi-object"] = "cdmio";
	mime_map["application/cdmi-queue"] = "cdmiq";
	mime_map["application/cu-seeme"] = "cu";
	mime_map["application/davmount+xml"] = "davmount";
	mime_map["application/dssc+der"] = "dssc";
	mime_map["application/dssc+xml"] = "xdssc";
	mime_map["application/ecmascript"] = "ecma";
	mime_map["application/emma+xml"] = "emma";
	mime_map["application/epub+zip"] = "epub";
	mime_map["application/exi"] = "exi";
	mime_map["application/font-tdpfr"] = "pfr";
	mime_map["application/hyperstudio"] = "stk";
	mime_map["application/ipfix"] = "ipfix";
	mime_map["application/java-archive"] = "jar";
	mime_map["application/java-serialized-object"] = "ser";
	mime_map["application/java-vm"] = "class";
	mime_map["application/javascript"] = "js";
	mime_map["application/json"] = "json";
	mime_map["application/lost+xml"] = "lostxml";
	mime_map["application/mac-binhex40"] = "hqx";
	mime_map["application/mac-compactpro"] = "cpt";
	mime_map["application/mads+xml"] = "mads";
	mime_map["application/marc"] = "mrc";
	mime_map["application/marcxml+xml"] = "mrcx";
	mime_map["application/mathematica"] = "mb";
	mime_map["application/mathml+xml"] = "mathml";
	mime_map["application/mbox"] = "mbox";
	mime_map["application/mediaservercontrol+xml"] = "mscml";
	mime_map["application/metalink4+xml"] = "meta4";
	mime_map["application/mets+xml"] = "mets";
	mime_map["application/mods+xml"] = "mods";
	mime_map["application/mp21"] = "mp21";
	mime_map["application/mp4"] = "mp4s";
	mime_map["application/msword"] = "doc";
	mime_map["application/mxf"] = "mxf";
	mime_map["application/oda"] = "oda";
	mime_map["application/oebps-package+xml"] = "opf";
	mime_map["application/ogg"] = "ogx";
	mime_map["application/onenote"] = "onetoc";
	mime_map["application/patch-ops-error+xml"] = "xer";
	mime_map["application/pdf"] = "pdf";
	mime_map["application/pgp-encrypted"] = "pgp";
	mime_map["application/pgp-signature"] = "asc";
	mime_map["application/pics-rules"] = "prf";
	mime_map["application/pkcs10"] = "p10";
	mime_map["application/pkcs7-mime"] = "p7m";
	mime_map["application/pkcs7-signature"] = "p7s";
	mime_map["application/pkcs8"] = "p8";
	mime_map["application/pkix-attr-cert"] = "ac";
	mime_map["application/pkix-cert"] = "cer";
	mime_map["application/pkix-crl"] = "crl";
	mime_map["application/pkix-pkipath"] = "pkipath";
	mime_map["application/pkixcmp"] = "pki";
	mime_map["application/pls+xml"] = "pls";
	mime_map["application/postscript"] = "ps";
	mime_map["application/prs.cww"] = "cww";
	mime_map["application/pskc+xml"] = "pskcxml";
	mime_map["application/rdf+xml"] = "rdf";
	mime_map["application/reginfo+xml"] = "rif";
	mime_map["application/relax-ng-compact-syntax"] = "rnc";
	mime_map["application/resource-lists+xml"] = "rl";
	mime_map["application/resource-lists-diff+xml"] = "rld";
	mime_map["application/rls-services+xml"] = "rs";
	mime_map["application/rsd+xml"] = "rsd";
	mime_map["application/rss+xml"] = "rss";
	mime_map["application/rtf"] = "rtf";
	mime_map["application/sbml+xml"] = "sbml";
	mime_map["application/scvp-cv-request"] = "scq";
	mime_map["application/scvp-cv-response"] = "scs";
	mime_map["application/scvp-vp-request"] = "spq";
	mime_map["application/scvp-vp-response"] = "spp";
	mime_map["application/sdp"] = "sdp";
	mime_map["application/set-payment-initiation"] = "setpay";
	mime_map["application/set-registration-initiation"] = "setreg";
	mime_map["application/shf+xml"] = "shf";
	mime_map["application/smil+xml"] = "smil";
	mime_map["application/sparql-query"] = "rq";
	mime_map["application/sparql-results+xml"] = "srx";
	mime_map["application/srgs"] = "gram";
	mime_map["application/srgs+xml"] = "grxml";
	mime_map["application/sru+xml"] = "sru";
	mime_map["application/ssml+xml"] = "ssml";
	mime_map["application/tei+xml"] = "teicorpus";
	mime_map["application/thraud+xml"] = "tfi";
	mime_map["application/timestamped-data"] = "tsd";
	mime_map["application/vnd.3gpp.pic-bw-large"] = "plb";
	mime_map["application/vnd.3gpp.pic-bw-small"] = "psb";
	mime_map["application/vnd.3gpp.pic-bw-var"] = "pvb";
	mime_map["application/vnd.3gpp2.tcap"] = "tcap";
	mime_map["application/vnd.3m.post-it-notes"] = "pwn";
	mime_map["application/vnd.accpac.simply.aso"] = "aso";
	mime_map["application/vnd.accpac.simply.imp"] = "imp";
	mime_map["application/vnd.acucobol"] = "acu";
	mime_map["application/vnd.acucorp"] = "atc";
	mime_map["application/vnd.adobe.air-application-installer-package+zip"] = "air";
	mime_map["application/vnd.adobe.fxp"] = "fxp";
	mime_map["application/vnd.adobe.xdp+xml"] = "xdp";
	mime_map["application/vnd.adobe.xfdf"] = "xfdf";
	mime_map["application/vnd.ahead.space"] = "ahead";
	mime_map["application/vnd.airzip.filesecure.azf"] = "azf";
	mime_map["application/vnd.airzip.filesecure.azs"] = "azs";
	mime_map["application/vnd.amazon.ebook"] = "azw";
	mime_map["application/vnd.americandynamics.acc"] = "acc";
	mime_map["application/vnd.amiga.ami"] = "ami";
	mime_map["application/vnd.android.package-archive"] = "apk";
	mime_map["application/vnd.anser-web-certificate-issue-initiation"] = "cii";
	mime_map["application/vnd.anser-web-funds-transfer-initiation"] = "fti";
	mime_map["application/vnd.antix.game-component"] = "atx";
	mime_map["application/vnd.apple.installer+xml"] = "mpkg";
	mime_map["application/vnd.apple.mpegurl"] = "m3u8";
	mime_map["application/vnd.aristanetworks.swi"] = "swi";
	mime_map["application/vnd.audiograph"] = "aep";
	mime_map["application/vnd.blueice.multipass"] = "mpm";
	mime_map["application/vnd.bmi"] = "bmi";
	mime_map["application/vnd.businessobjects"] = "rep";
	mime_map["application/vnd.chemdraw+xml"] = "cdxml";
	mime_map["application/vnd.chipnuts.karaoke-mmd"] = "mmd";
	mime_map["application/vnd.cinderella"] = "cdy";
	mime_map["application/vnd.claymore"] = "cla";
	mime_map["application/vnd.cloanto.rp9"] = "rp9";
	mime_map["application/vnd.clonk.c4group"] = "c4g";
	mime_map["application/vnd.cluetrust.cartomobile-config"] = "c11amc";
	mime_map["application/vnd.cluetrust.cartomobile-config-pkg"] = "c11amz";
	mime_map["application/vnd.commonspace"] = "csp";
	mime_map["application/vnd.contact.cmsg"] = "cdbcmsg";
	mime_map["application/vnd.cosmocaller"] = "cmc";
	mime_map["application/vnd.crick.clicker"] = "clkx";
	mime_map["application/vnd.crick.clicker.keyboard"] = "clkk";
	mime_map["application/vnd.crick.clicker.palette"] = "clkp";
	mime_map["application/vnd.crick.clicker.template"] = "clkt";
	mime_map["application/vnd.crick.clicker.wordbank"] = "clkw";
	mime_map["application/vnd.criticaltools.wbs+xml"] = "wbs";
	mime_map["application/vnd.ctc-posml"] = "pml";
	mime_map["application/vnd.cups-ppd"] = "ppd";
	mime_map["application/vnd.curl.car"] = "car";
	mime_map["application/vnd.curl.pcurl"] = "pcurl";
	mime_map["application/vnd.data-vision.rdz"] = "rdz";
	mime_map["application/vnd.denovo.fcselayout-link"] = "fe_launch";
	mime_map["application/vnd.dna"] = "dna";
	mime_map["application/vnd.dolby.mlp"] = "mlp";
	mime_map["application/vnd.dpgraph"] = "dpg";
	mime_map["application/vnd.dreamfactory"] = "dfac";
	mime_map["application/vnd.dvb.ait"] = "ait";
	mime_map["application/vnd.dvb.service"] = "svc";
	mime_map["application/vnd.dynageo"] = "geo";
	mime_map["application/vnd.ecowin.chart"] = "mag";
	mime_map["application/vnd.enliven"] = "nml";
	mime_map["application/vnd.epson.esf"] = "esf";
	mime_map["application/vnd.epson.msf"] = "msf";
	mime_map["application/vnd.epson.quickanime"] = "qam";
	mime_map["application/vnd.epson.salt"] = "slt";
	mime_map["application/vnd.epson.ssf"] = "ssf";
	mime_map["application/vnd.eszigno3+xml"] = "es3";
	mime_map["application/vnd.ezpix-album"] = "ez2";
	mime_map["application/vnd.ezpix-package"] = "ez3";
	mime_map["application/vnd.fdf"] = "fdf";
	mime_map["application/vnd.fdsn.mseed"] = "mseed";
	mime_map["application/vnd.fdsn.seed"] = "seed";
	mime_map["application/vnd.flographit"] = "gph";
	mime_map["application/vnd.fluxtime.clip"] = "ftc";
	mime_map["application/vnd.framemaker"] = "fm";
	mime_map["application/vnd.frogans.fnc"] = "fnc";
	mime_map["application/vnd.frogans.ltf"] = "ltf";
	mime_map["application/vnd.fsc.weblaunch"] = "fsc";
	mime_map["application/vnd.fujitsu.oasys"] = "oas";
	mime_map["application/vnd.fujitsu.oasys2"] = "oa2";
	mime_map["application/vnd.fujitsu.oasys3"] = "oa3";
	mime_map["application/vnd.fujitsu.oasysgp"] = "fg5";
	mime_map["application/vnd.fujitsu.oasysprs"] = "bh2";
	mime_map["application/vnd.fujixerox.ddd"] = "ddd";
	mime_map["application/vnd.fujixerox.docuworks"] = "xdw";
	mime_map["application/vnd.fujixerox.docuworks.binder"] = "xbd";
	mime_map["application/vnd.fuzzysheet"] = "fzs";
	mime_map["application/vnd.genomatix.tuxedo"] = "txd";
	mime_map["application/vnd.geogebra.file"] = "ggb";
	mime_map["application/vnd.geogebra.tool"] = "ggt";
	mime_map["application/vnd.geometry-explorer"] = "gex";
	mime_map["application/vnd.geonext"] = "gxt";
	mime_map["application/vnd.geoplan"] = "g2w";
	mime_map["application/vnd.geospace"] = "g3w";
	mime_map["application/vnd.gmx"] = "gmx";
	mime_map["application/vnd.google-earth.kml+xml"] = "kml";
	mime_map["application/vnd.google-earth.kmz"] = "kmz";
	mime_map["application/vnd.grafeq"] = "gqf";
	mime_map["application/vnd.groove-account"] = "gac";
	mime_map["application/vnd.groove-help"] = "ghf";
	mime_map["application/vnd.groove-identity-message"] = "gim";
	mime_map["application/vnd.groove-injector"] = "grv";
	mime_map["application/vnd.groove-tool-message"] = "gtm";
	mime_map["application/vnd.groove-tool-template"] = "tpl";
	mime_map["application/vnd.groove-vcard"] = "vcg";
	mime_map["application/vnd.hal+xml"] = "hal";
	mime_map["application/vnd.handheld-entertainment+xml"] = "zmm";
	mime_map["application/vnd.hbci"] = "hbci";
	mime_map["application/vnd.hhe.lesson-player"] = "les";
	mime_map["application/vnd.hp-hpgl"] = "hpgl";
	mime_map["application/vnd.hp-hpid"] = "hpid";
	mime_map["application/vnd.hp-hps"] = "hps";
	mime_map["application/vnd.hp-jlyt"] = "jlt";
	mime_map["application/vnd.hp-pcl"] = "pcl";
	mime_map["application/vnd.hp-pclxl"] = "pclxl";
	mime_map["application/vnd.hydrostatix.sof-data"] = "sfd-hdstx";
	mime_map["application/vnd.hzn-3d-crossword"] = "x3d";
	mime_map["application/vnd.ibm.minipay"] = "mpy";
	mime_map["application/vnd.ibm.modcap"] = "afp";
	mime_map["application/vnd.ibm.rights-management"] = "irm";
	mime_map["application/vnd.ibm.secure-container"] = "sc";
	mime_map["application/vnd.iccprofile"] = "icc";
	mime_map["application/vnd.igloader"] = "igl";
	mime_map["application/vnd.immervision-ivp"] = "ivp";
	mime_map["application/vnd.immervision-ivu"] = "ivu";
	mime_map["application/vnd.insors.igm"] = "igm";
	mime_map["application/vnd.intercon.formnet"] = "xpw";
	mime_map["application/vnd.intergeo"] = "i2g";
	mime_map["application/vnd.intu.qbo"] = "qbo";
	mime_map["application/vnd.intu.qfx"] = "qfx";
	mime_map["application/vnd.ipunplugged.rcprofile"] = "rcprofile";
	mime_map["application/vnd.irepository.package+xml"] = "irp";
	mime_map["application/vnd.is-xpr"] = "xpr";
	mime_map["application/vnd.isac.fcs"] = "fcs";
	mime_map["application/vnd.jam"] = "jam";
	mime_map["application/vnd.jcp.javame.midlet-rms"] = "rms";
	mime_map["application/vnd.jisp"] = "jisp";
	mime_map["application/vnd.joost.joda-archive"] = "joda";
	mime_map["application/vnd.kahootz"] = "ktz";
	mime_map["application/vnd.kde.karbon"] = "karbon";
	mime_map["application/vnd.kde.kchart"] = "chrt";
	mime_map["application/vnd.kde.kformula"] = "kfo";
	mime_map["application/vnd.kde.kivio"] = "flw";
	mime_map["application/vnd.kde.kontour"] = "kon";
	mime_map["application/vnd.kde.kpresenter"] = "kpr";
	mime_map["application/vnd.kde.kspread"] = "ksp";
	mime_map["application/vnd.kde.kword"] = "kwd";
	mime_map["application/vnd.kenameaapp"] = "htke";
	mime_map["application/vnd.kidspiration"] = "kia";
	mime_map["application/vnd.kinar"] = "knp";
	mime_map["application/vnd.koan"] = "skp";
	mime_map["application/vnd.kodak-descriptor"] = "sse";
	mime_map["application/vnd.las.las+xml"] = "lasxml";
	mime_map["application/vnd.llamagraphics.life-balance.desktop"] = "lbd";
	mime_map["application/vnd.llamagraphics.life-balance.exchange+xml"] = "lbe";
	mime_map["application/vnd.lotus-1-2-3"] = "123";
	mime_map["application/vnd.lotus-approach"] = "apr";
	mime_map["application/vnd.lotus-freelance"] = "pre";
	mime_map["application/vnd.lotus-notes"] = "nsf";
	mime_map["application/vnd.lotus-organizer"] = "org";
	mime_map["application/vnd.lotus-screencam"] = "scm";
	mime_map["application/vnd.lotus-wordpro"] = "lwp";
	mime_map["application/vnd.macports.portpkg"] = "portpkg";
	mime_map["application/vnd.mcd"] = "mcd";
	mime_map["application/vnd.medcalcdata"] = "mc1";
	mime_map["application/vnd.mediastation.cdkey"] = "cdkey";
	mime_map["application/vnd.mfer"] = "mwf";
	mime_map["application/vnd.mfmp"] = "mfm";
	mime_map["application/vnd.micrografx.flo"] = "flo";
	mime_map["application/vnd.micrografx.igx"] = "igx";
	mime_map["application/vnd.mif"] = "mif";
	mime_map["application/vnd.mobius.daf"] = "daf";
	mime_map["application/vnd.mobius.dis"] = "dis";
	mime_map["application/vnd.mobius.mbk"] = "mbk";
	mime_map["application/vnd.mobius.mqy"] = "mqy";
	mime_map["application/vnd.mobius.msl"] = "msl";
	mime_map["application/vnd.mobius.plc"] = "plc";
	mime_map["application/vnd.mobius.txf"] = "txf";
	mime_map["application/vnd.mophun.application"] = "mpn";
	mime_map["application/vnd.mophun.certificate"] = "mpc";
	mime_map["application/vnd.mozilla.xul+xml"] = "xul";
	mime_map["application/vnd.ms-artgalry"] = "cil";
	mime_map["application/vnd.ms-cab-compressed"] = "cab";
	mime_map["application/vnd.ms-excel"] = "xls";
	mime_map["application/vnd.ms-excel.addin.macroenabled.12"] = "xlam";
	mime_map["application/vnd.ms-excel.sheet.binary.macroenabled.12"] = "xlsb";
	mime_map["application/vnd.ms-excel.sheet.macroenabled.12"] = "xlsm";
	mime_map["application/vnd.ms-excel.template.macroenabled.12"] = "xltm";
	mime_map["application/vnd.ms-fontobject"] = "eot";
	mime_map["application/vnd.ms-htmlhelp"] = "chm";
	mime_map["application/vnd.ms-ims"] = "ims";
	mime_map["application/vnd.ms-lrm"] = "lrm";
	mime_map["application/vnd.ms-officetheme"] = "thmx";
	mime_map["application/vnd.ms-pki.seccat"] = "cat";
	mime_map["application/vnd.ms-pki.stl"] = "stl";
	mime_map["application/vnd.ms-powerpoint"] = "ppt";
	mime_map["application/vnd.ms-powerpoint.addin.macroenabled.12"] = "ppam";
	mime_map["application/vnd.ms-powerpoint.presentation.macroenabled.12"] = "pptm";
	mime_map["application/vnd.ms-powerpoint.slide.macroenabled.12"] = "sldm";
	mime_map["application/vnd.ms-powerpoint.slideshow.macroenabled.12"] = "ppsm";
	mime_map["application/vnd.ms-powerpoint.template.macroenabled.12"] = "potm";
	mime_map["application/vnd.ms-project"] = "mpp";
	mime_map["application/vnd.ms-word.document.macroenabled.12"] = "docm";
	mime_map["application/vnd.ms-word.template.macroenabled.12"] = "dotm";
	mime_map["application/vnd.ms-works"] = "wps";
	mime_map["application/vnd.ms-wpl"] = "wpl";
	mime_map["application/vnd.ms-xpsdocument"] = "xps";
	mime_map["application/vnd.mseq"] = "mseq";
	mime_map["application/vnd.musician"] = "mus";
	mime_map["application/vnd.muvee.style"] = "msty";
	mime_map["application/vnd.neurolanguage.nlu"] = "nlu";
	mime_map["application/vnd.noblenet-directory"] = "nnd";
	mime_map["application/vnd.noblenet-sealer"] = "nns";
	mime_map["application/vnd.noblenet-web"] = "nnw";
	mime_map["application/vnd.nokia.n-gage.data"] = "ngdat";
	mime_map["application/vnd.nokia.n-gage.symbian.install"] = "n-gage";
	mime_map["application/vnd.nokia.radio-preset"] = "rpst";
	mime_map["application/vnd.nokia.radio-presets"] = "rpss";
	mime_map["application/vnd.novadigm.edm"] = "edm";
	mime_map["application/vnd.novadigm.edx"] = "edx";
	mime_map["application/vnd.novadigm.ext"] = "ext";
	mime_map["application/vnd.oasis.opendocument.chart"] = "odc";
	mime_map["application/vnd.oasis.opendocument.chart-template"] = "otc";
	mime_map["application/vnd.oasis.opendocument.database"] = "odb";
	mime_map["application/vnd.oasis.opendocument.formula"] = "odf";
	mime_map["application/vnd.oasis.opendocument.formula-template"] = "odft";
	mime_map["application/vnd.oasis.opendocument.graphics"] = "odg";
	mime_map["application/vnd.oasis.opendocument.graphics-template"] = "otg";
	mime_map["application/vnd.oasis.opendocument.image"] = "odi";
	mime_map["application/vnd.oasis.opendocument.image-template"] = "oti";
	mime_map["application/vnd.oasis.opendocument.presentation"] = "odp";
	mime_map["application/vnd.oasis.opendocument.presentation-template"] = "otp";
	mime_map["application/vnd.oasis.opendocument.spreadsheet"] = "ods";
	mime_map["application/vnd.oasis.opendocument.spreadsheet-template"] = "ots";
	mime_map["application/vnd.oasis.opendocument.text"] = "odt";
	mime_map["application/vnd.oasis.opendocument.text-master"] = "odm";
	mime_map["application/vnd.oasis.opendocument.text-template"] = "ott";
	mime_map["application/vnd.oasis.opendocument.text-web"] = "oth";
	mime_map["application/vnd.olpc-sugar"] = "xo";
	mime_map["application/vnd.oma.dd2+xml"] = "dd2";
	mime_map["application/vnd.openofficeorg.extension"] = "oxt";
	mime_map["application/vnd.openxmlformats-officedocument.presentationml.presentation"] = "pptx";
	mime_map["application/vnd.openxmlformats-officedocument.presentationml.slide"] = "sldx";
	mime_map["application/vnd.openxmlformats-officedocument.presentationml.slideshow"] = "ppsx";
	mime_map["application/vnd.openxmlformats-officedocument.presentationml.template"] = "potx";
	mime_map["application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"] = "xlsx";
	mime_map["application/vnd.openxmlformats-officedocument.spreadsheetml.template"] = "xltx";
	mime_map["application/vnd.openxmlformats-officedocument.wordprocessingml.document"] = "docx";
	mime_map["application/vnd.openxmlformats-officedocument.wordprocessingml.template"] = "dotx";
	mime_map["application/vnd.osgeo.mapguide.package"] = "mgp";
	mime_map["application/vnd.osgi.dp"] = "dp";
	mime_map["application/vnd.palm"] = "pdb";
	mime_map["application/vnd.pawaafile"] = "paw";
	mime_map["application/vnd.pg.format"] = "str";
	mime_map["application/vnd.pg.osasli"] = "ei6";
	mime_map["application/vnd.picsel"] = "efif";
	mime_map["application/vnd.pmi.widget"] = "wg";
	mime_map["application/vnd.pocketlearn"] = "plf";
	mime_map["application/vnd.powerbuilder6"] = "pbd";
	mime_map["application/vnd.previewsystems.box"] = "box";
	mime_map["application/vnd.proteus.magazine"] = "mgz";
	mime_map["application/vnd.publishare-delta-tree"] = "qps";
	mime_map["application/vnd.pvi.ptid1"] = "ptid";
	mime_map["application/vnd.quark.quarkxpress"] = "qxd";
	mime_map["application/vnd.realvnc.bed"] = "bed";
	mime_map["application/vnd.recordare.musicxml"] = "mxl";
	mime_map["application/vnd.recordare.musicxml+xml"] = "musicxml";
	mime_map["application/vnd.rig.cryptonote"] = "cryptonote";
	mime_map["application/vnd.rim.cod"] = "cod";
	mime_map["application/vnd.rn-realmedia"] = "rm";
	mime_map["application/vnd.route66.link66+xml"] = "link66";
	mime_map["application/vnd.sailingtracker.track"] = "st";
	mime_map["application/vnd.seemail"] = "see";
	mime_map["application/vnd.sema"] = "sema";
	mime_map["application/vnd.semd"] = "semd";
	mime_map["application/vnd.semf"] = "semf";
	mime_map["application/vnd.shana.informed.formdata"] = "ifm";
	mime_map["application/vnd.shana.informed.formtemplate"] = "itp";
	mime_map["application/vnd.shana.informed.interchange"] = "iif";
	mime_map["application/vnd.shana.informed.package"] = "ipk";
	mime_map["application/vnd.simtech-mindmapper"] = "twd";
	mime_map["application/vnd.smaf"] = "mmf";
	mime_map["application/vnd.smart.teacher"] = "teacher";
	mime_map["application/vnd.solent.sdkm+xml"] = "sdkm";
	mime_map["application/vnd.spotfire.dxp"] = "dxp";
	mime_map["application/vnd.spotfire.sfs"] = "sfs";
	mime_map["application/vnd.stardivision.calc"] = "sdc";
	mime_map["application/vnd.stardivision.draw"] = "sda";
	mime_map["application/vnd.stardivision.impress"] = "sdd";
	mime_map["application/vnd.stardivision.math"] = "smf";
	mime_map["application/vnd.stardivision.writer"] = "sdw";
	mime_map["application/vnd.stardivision.writer-global"] = "sgl";
	mime_map["application/vnd.stepmania.stepchart"] = "sm";
	mime_map["application/vnd.sun.xml.calc"] = "sxc";
	mime_map["application/vnd.sun.xml.calc.template"] = "stc";
	mime_map["application/vnd.sun.xml.draw"] = "sxd";
	mime_map["application/vnd.sun.xml.draw.template"] = "std";
	mime_map["application/vnd.sun.xml.impress"] = "sxi";
	mime_map["application/vnd.sun.xml.impress.template"] = "sti";
	mime_map["application/vnd.sun.xml.math"] = "sxm";
	mime_map["application/vnd.sun.xml.writer"] = "sxw";
	mime_map["application/vnd.sun.xml.writer.global"] = "sxg";
	mime_map["application/vnd.sun.xml.writer.template"] = "stw";
	mime_map["application/vnd.sus-calendar"] = "sus";
	mime_map["application/vnd.svd"] = "svd";
	mime_map["application/vnd.symbian.install"] = "sis";
	mime_map["application/vnd.syncml+xml"] = "xsm";
	mime_map["application/vnd.syncml.dm+wbxml"] = "bdm";
	mime_map["application/vnd.syncml.dm+xml"] = "xdm";
	mime_map["application/vnd.tao.intent-module-archive"] = "tao";
	mime_map["application/vnd.tmobile-livetv"] = "tmo";
	mime_map["application/vnd.trid.tpt"] = "tpt";
	mime_map["application/vnd.triscape.mxs"] = "mxs";
	mime_map["application/vnd.trueapp"] = "tra";
	mime_map["application/vnd.ufdl"] = "ufdl";
	mime_map["application/vnd.uiq.theme"] = "utz";
	mime_map["application/vnd.umajin"] = "umj";
	mime_map["application/vnd.unity"] = "unityweb";
	mime_map["application/vnd.uoml+xml"] = "uoml";
	mime_map["application/vnd.vcx"] = "vcx";
	mime_map["application/vnd.visio"] = "vsd";
	mime_map["application/vnd.visionary"] = "vis";
	mime_map["application/vnd.vsf"] = "vsf";
	mime_map["application/vnd.wap.wbxml"] = "wbxml";
	mime_map["application/vnd.wap.wmlc"] = "wmlc";
	mime_map["application/vnd.wap.wmlscriptc"] = "wmlsc";
	mime_map["application/vnd.webturbo"] = "wtb";
	mime_map["application/vnd.wolfram.player"] = "nbp";
	mime_map["application/vnd.wordperfect"] = "wpd";
	mime_map["application/vnd.wqd"] = "wqd";
	mime_map["application/vnd.wt.stf"] = "stf";
	mime_map["application/vnd.xara"] = "xar";
	mime_map["application/vnd.xfdl"] = "xfdl";
	mime_map["application/vnd.yamaha.hv-dic"] = "hvd";
	mime_map["application/vnd.yamaha.hv-script"] = "hvs";
	mime_map["application/vnd.yamaha.hv-voice"] = "hvp";
	mime_map["application/vnd.yamaha.openscoreformat"] = "osf";
	mime_map["application/vnd.yamaha.openscoreformat.osfpvg+xml"] = "osfpvg";
	mime_map["application/vnd.yamaha.smaf-audio"] = "saf";
	mime_map["application/vnd.yamaha.smaf-phrase"] = "spf";
	mime_map["application/vnd.yellowriver-custom-menu"] = "cmp";
	mime_map["application/vnd.zul"] = "zir";
	mime_map["application/vnd.zzazz.deck+xml"] = "zaz";
	mime_map["application/voicexml+xml"] = "vxml";
	mime_map["application/widget"] = "wgt";
	mime_map["application/winhlp"] = "hlp";
	mime_map["application/wsdl+xml"] = "wsdl";
	mime_map["application/wspolicy+xml"] = "wspolicy";
	mime_map["application/x-7z-compressed"] = "7z";
	mime_map["application/x-abiword"] = "abw";
	mime_map["application/x-ace-compressed"] = "ace";
	mime_map["application/x-authorware-map"] = "aam";
	mime_map["application/x-authorware-seg"] = "aas";
	mime_map["application/x-bcpio"] = "bcpio";
	mime_map["application/x-bittorrent"] = "torrent";
	mime_map["application/x-bzip"] = "bz";
	mime_map["application/x-bzip2"] = "bz2";
	mime_map["application/x-cdlink"] = "vcd";
	mime_map["application/x-chat"] = "chat";
	mime_map["application/x-chess-pgn"] = "pgn";
	mime_map["application/x-cpio"] = "cpio";
	mime_map["application/x-csh"] = "csh";
	mime_map["application/x-debian-package"] = "deb";
	mime_map["application/x-director"] = "dir";
	mime_map["application/x-doom"] = "wad";
	mime_map["application/x-dtbncx+xml"] = "ncx";
	mime_map["application/x-dtbook+xml"] = "dtb";
	mime_map["application/x-dtbresource+xml"] = "res";
	mime_map["application/x-dvi"] = "dvi";
	mime_map["application/x-font-bdf"] = "bdf";
	mime_map["application/x-font-ghostscript"] = "gsf";
	mime_map["application/x-font-linux-psf"] = "psf";
	mime_map["application/x-font-otf"] = "otf";
	mime_map["application/x-font-pcf"] = "pcf";
	mime_map["application/x-font-snf"] = "snf";
	mime_map["application/x-font-ttf"] = "ttf";
	mime_map["application/x-font-type1"] = "afm";
	mime_map["application/x-font-woff"] = "woff";
	mime_map["application/x-futuresplash"] = "spl";
	mime_map["application/x-gnumeric"] = "gnumeric";
	mime_map["application/x-gtar"] = "gtar";
	mime_map["application/x-hdf"] = "hdf";
	mime_map["application/x-java-jnlp-file"] = "jnlp";
	mime_map["application/x-latex"] = "latex";
	mime_map["application/x-mobipocket-ebook"] = "mobi";
	mime_map["application/x-mpegurl"] = "m3u8";
	mime_map["application/x-ms-application"] = "application";
	mime_map["application/x-ms-wmd"] = "wmd";
	mime_map["application/x-ms-wmz"] = "wmz";
	mime_map["application/x-ms-xbap"] = "xbap";
	mime_map["application/x-msaccess"] = "mdb";
	mime_map["application/x-msbinder"] = "obd";
	mime_map["application/x-mscardfile"] = "crd";
	mime_map["application/x-msclip"] = "clp";
	mime_map["application/x-msmediaview"] = "mvb";
	mime_map["application/x-msmetafile"] = "wmf";
	mime_map["application/x-msmoney"] = "mny";
	mime_map["application/x-mspublisher"] = "pub";
	mime_map["application/x-msschedule"] = "scd";
	mime_map["application/x-msterminal"] = "trm";
	mime_map["application/x-mswrite"] = "wri";
	mime_map["application/x-netcdf"] = "nc";
	mime_map["application/x-pkcs12"] = "p12";
	mime_map["application/x-pkcs7-certificates"] = "p7b";
	mime_map["application/x-pkcs7-certreqresp"] = "p7r";
	mime_map["application/x-rar-compressed"] = "rar";
	mime_map["application/x-sh"] = "sh";
	mime_map["application/x-shar"] = "shar";
	mime_map["application/x-shockwave-flash"] = "swf";
	mime_map["application/x-silverlight-app"] = "xap";
	mime_map["application/x-stuffit"] = "sit";
	mime_map["application/x-stuffitx"] = "sitx";
	mime_map["application/x-sv4cpio"] = "sv4cpio";
	mime_map["application/x-sv4crc"] = "sv4crc";
	mime_map["application/x-tar"] = "tar";
	mime_map["application/x-tcl"] = "tcl";
	mime_map["application/x-tex"] = "tex";
	mime_map["application/x-tex-tfm"] = "tfm";
	mime_map["application/x-texinfo"] = "texi";
	mime_map["application/x-ustar"] = "ustar";
	mime_map["application/x-wais-source"] = "src";
	mime_map["application/x-x509-ca-cert"] = "crt";
	mime_map["application/x-xfig"] = "fig";
	mime_map["application/x-xpinstall"] = "xpi";
	mime_map["application/xcap-diff+xml"] = "xdf";
	mime_map["application/xenc+xml"] = "xenc";
	mime_map["application/xhtml+xml"] = "xhtml";
	mime_map["application/xml"] = "xml";
	mime_map["application/xml-dtd"] = "dtd";
	mime_map["application/xop+xml"] = "xop";
	mime_map["application/xslt+xml"] = "xslt";
	mime_map["application/xspf+xml"] = "xspf";
	mime_map["application/xv+xml"] = "xvml";
	mime_map["application/yang"] = "yang";
	mime_map["application/yin+xml"] = "yin";
	mime_map["application/zip"] = "zip";
	mime_map["audio/adpcm"] = "adp";
	mime_map["audio/basic"] = "au";
	mime_map["audio/midi"] = "mid";
	mime_map["audio/mp4"] = "mp4a";
	mime_map["audio/mp4a-latm"] = "m4a";
	mime_map["audio/mpeg"] = "mpga";
	mime_map["audio/ogg"] = "ogg";
	mime_map["audio/vnd.dece.audio"] = "uvva";
	mime_map["audio/vnd.digital-winds"] = "eol";
	mime_map["audio/vnd.dra"] = "dra";
	mime_map["audio/vnd.dts"] = "dts";
	mime_map["audio/vnd.dts.hd"] = "dtshd";
	mime_map["audio/vnd.lucent.voice"] = "lvp";
	mime_map["audio/vnd.ms-playready.media.pya"] = "pya";
	mime_map["audio/vnd.nuera.ecelp4800"] = "ecelp4800";
	mime_map["audio/vnd.nuera.ecelp7470"] = "ecelp7470";
	mime_map["audio/vnd.nuera.ecelp9600"] = "ecelp9600";
	mime_map["audio/vnd.rip"] = "rip";
	mime_map["audio/webm"] = "weba";
	mime_map["audio/x-aac"] = "aac";
	mime_map["audio/x-aiff"] = "aiff";
	mime_map["audio/x-mpegurl"] = "m3u";
	mime_map["audio/x-ms-wax"] = "wax";
	mime_map["audio/x-ms-wma"] = "wma";
	mime_map["audio/x-pn-realaudio"] = "ram";
	mime_map["audio/x-pn-realaudio-plugin"] = "rmp";
	mime_map["audio/x-wav"] = "wav";
	mime_map["chemical/x-cdx"] = "cdx";
	mime_map["chemical/x-cif"] = "cif";
	mime_map["chemical/x-cmdf"] = "cmdf";
	mime_map["chemical/x-cml"] = "cml";
	mime_map["chemical/x-csml"] = "csml";
	mime_map["chemical/x-xyz"] = "xyz";
	mime_map["image/bmp"] = "bmp";
	mime_map["image/cgm"] = "cgm";
	mime_map["image/g3fax"] = "g3";
	mime_map["image/gif"] = "gif";
	mime_map["image/ief"] = "ief";
	mime_map["image/jp2"] = "jp2";
	mime_map["image/jpeg"] = "jpg";
	mime_map["image/ktx"] = "ktx";
	mime_map["image/pict"] = "pict";
	mime_map["image/png"] = "png";
	mime_map["image/prs.btif"] = "btif";
	mime_map["image/svg+xml"] = "svg";
	mime_map["image/tiff"] = "tiff";
	mime_map["image/vnd.adobe.photoshop"] = "psd";
	mime_map["image/vnd.dece.graphic"] = "uvi";
	mime_map["image/vnd.djvu"] = "djvu";
	mime_map["image/vnd.dvb.subtitle"] = "sub";
	mime_map["image/vnd.dwg"] = "dwg";
	mime_map["image/vnd.dxf"] = "dxf";
	mime_map["image/vnd.fastbidsheet"] = "fbs";
	mime_map["image/vnd.fpx"] = "fpx";
	mime_map["image/vnd.fst"] = "fst";
	mime_map["image/vnd.fujixerox.edmics-mmr"] = "mmr";
	mime_map["image/vnd.fujixerox.edmics-rlc"] = "rlc";
	mime_map["image/vnd.ms-modi"] = "mdi";
	mime_map["image/vnd.net-fpx"] = "npx";
	mime_map["image/vnd.wap.wbmp"] = "wbmp";
	mime_map["image/vnd.xiff"] = "xif";
	mime_map["image/webp"] = "webp";
	mime_map["image/x-cmu-raster"] = "ras";
	mime_map["image/x-cmx"] = "cmx";
	mime_map["image/x-freehand"] = "fh";
	mime_map["image/x-icon"] = "ico";
	mime_map["image/x-macpaint"] = "pntg";
	mime_map["image/x-pcx"] = "pcx";
	mime_map["image/x-pict"] = "pict";
	mime_map["image/x-portable-anymap"] = "pnm";
	mime_map["image/x-portable-bitmap"] = "pbm";
	mime_map["image/x-portable-graymap"] = "pgm";
	mime_map["image/x-portable-pixmap"] = "ppm";
	mime_map["image/x-quicktime"] = "qtif";
	mime_map["image/x-rgb"] = "rgb";
	mime_map["image/x-xbitmap"] = "xbm";
	mime_map["image/x-xpixmap"] = "xpm";
	mime_map["image/x-xwindowdump"] = "xwd";
	mime_map["message/rfc822"] = "eml";
	mime_map["model/iges"] = "iges";
	mime_map["model/mesh"] = "mesh";
	mime_map["model/vnd.collada+xml"] = "dae";
	mime_map["model/vnd.dwf"] = "dwf";
	mime_map["model/vnd.gdl"] = "gdl";
	mime_map["model/vnd.gtw"] = "gtw";
	mime_map["model/vnd.mts"] = "mts";
	mime_map["model/vnd.vtu"] = "vtu";
	mime_map["model/vrml"] = "vrml";
	mime_map["text/cache-manifest"] = "manifest";
	mime_map["text/calendar"] = "ics";
	mime_map["text/css"] = "css";
	mime_map["text/csv"] = "csv";
	mime_map["text/html"] = "html";
	mime_map["text/n3"] = "n3";
	mime_map["text/plain"] = "txt";
	mime_map["text/prs.lines.tag"] = "dsc";
	mime_map["text/richtext"] = "rtx";
	mime_map["text/sgml"] = "sgml";
	mime_map["text/tab-separated-values"] = "tsv";
	mime_map["text/troff"] = "roff";
	mime_map["text/turtle"] = "ttl";
	mime_map["text/uri-list"] = "urls";
	mime_map["text/vnd.curl"] = "curl";
	mime_map["text/vnd.curl.dcurl"] = "dcurl";
	mime_map["text/vnd.curl.mcurl"] = "mcurl";
	mime_map["text/vnd.curl.scurl"] = "scurl";
	mime_map["text/vnd.fly"] = "fly";
	mime_map["text/vnd.fmi.flexstor"] = "flx";
	mime_map["text/vnd.graphviz"] = "gv";
	mime_map["text/vnd.in3d.3dml"] = "3dml";
	mime_map["text/vnd.in3d.spot"] = "spot";
	mime_map["text/vnd.sun.j2me.app-descriptor"] = "jad";
	mime_map["text/vnd.wap.wml"] = "wml";
	mime_map["text/vnd.wap.wmlscript"] = "wmls";
	mime_map["text/x-asm"] = "asm";
	mime_map["text/x-c"] = "c";
	mime_map["text/x-fortran"] = "f";
	mime_map["text/x-java-source"] = "java";
	mime_map["text/x-pascal"] = "pas";
	mime_map["text/x-setext"] = "etx";
	mime_map["text/x-uuencode"] = "uu";
	mime_map["text/x-vcalendar"] = "vcs";
	mime_map["text/x-vcard"] = "vcf";
	mime_map["video/3gpp"] = "3gp";
	mime_map["video/3gpp2"] = "3g2";
	mime_map["video/h261"] = "h261";
	mime_map["video/h263"] = "h263";
	mime_map["video/h264"] = "h264";
	mime_map["video/jpeg"] = "jpgv";
	mime_map["video/jpm"] = "jpm";
	mime_map["video/mj2"] = "mj2";
	mime_map["video/mp2t"] = "ts";
	mime_map["video/mp4"] = "m4v";
	mime_map["video/mpeg"] = "mpg";
	mime_map["video/ogg"] = "ogv";
	mime_map["video/quicktime"] = "mov";
	mime_map["video/vnd.dece.hd"] = "uvvh";
	mime_map["video/vnd.dece.mobile"] = "uvvm";
	mime_map["video/vnd.dece.pd"] = "uvvp";
	mime_map["video/vnd.dece.sd"] = "uvvs";
	mime_map["video/vnd.dece.video"] = "uvvv";
	mime_map["video/vnd.fvt"] = "fvt";
	mime_map["video/vnd.mpegurl"] = "m4u";
	mime_map["video/vnd.ms-playready.media.pyv"] = "pyv";
	mime_map["video/vnd.uvvu.mp4"] = "uvvu";
	mime_map["video/vnd.vivo"] = "viv";
	mime_map["video/webm"] = "webm";
	mime_map["video/x-dv"] = "dv";
	mime_map["video/x-f4v"] = "f4v";
	mime_map["video/x-fli"] = "fli";
	mime_map["video/x-flv"] = "flv";
	mime_map["video/x-m4v"] = "m4v";
	mime_map["video/x-ms-asf"] = "asf";
	mime_map["video/x-ms-wm"] = "wm";
	mime_map["video/x-ms-wmv"] = "wmv";
	mime_map["video/x-ms-wmx"] = "wmx";
	mime_map["video/x-ms-wvx"] = "wvx";
	mime_map["video/x-msvideo"] = "avi";
	mime_map["video/x-sgi-movie"] = "movie";
	mime_map["x-conference/x-cooltalk"] = "ice";
}

std::string get_extension_for_mime_type(const std::string& mime_type) {
	/* Strip anything after a semicolon (e.g. text/html; charset=utf-8) */
	std::string base_type(mime_type);
	size_t semicolon_pos = base_type.find_first_of(";");
	if (semicolon_pos != std::string::npos) {
		base_type = base_type.substr(0, semicolon_pos);
	}
	
	/* Downcase it for comparsion purposes */
	std::transform(base_type.begin(), base_type.end(), base_type.begin(), ::tolower);
	
	/* Look it up in the map */
	return mime_map[base_type];
}
