#!/bin/sh

# Source: https://github.com/tecnickcom/TCPDF/blob/6.4.2/tests/launch.sh
# Changes: removed coverage support as it is useless in Debian
# Added -u for set mode
# Changed root for searching for files
# Removed example_008 that depends on freeserif
# Removed pcov -d lines
# Fixed exit code strategy
# Added missing modules
# Backported as https://github.com/tecnickcom/TCPDF/pull/426

command -v pdfinfo > /dev/null
if [ $? -gt 0 ]; then
    echo "pdfinfo could not be found"
    echo "On Debian based systems you can run: apt install -y poppler-utils"
    exit 1
fi

# Only start here, the command checking can exit code > 0
set -eu

ROOT="/usr/share/doc/php-tcpdf/"
cd "${ROOT}"

EXAMPLE_FILES="$(find examples/ -type f -name 'example*.php' \
                -not -path '*/barcodes/*' \
                -not -wholename 'examples/example_006.php' \
                -not -wholename 'examples/example_008.php' \
                | sort -df)"

EXAMPLE_BARCODE_FILES="$(find examples/barcodes -type f -name 'example*.php' \
                | sort -df)"

TEMP_FOLDER="$(mktemp -d /tmp/TCPDF-tests.XXXXXXXXX)"
OUTPUT_FILE="${TEMP_FOLDER}/output.pdf"
OUTPUT_FILE_ERROR="${TEMP_FOLDER}/errors.txt"
ROOT_DIR="$(php -r 'echo realpath(__DIR__);')"

PHP_EXT_DIR="$(php -r 'echo ini_get("extension_dir");')"

echo "php extension dir: ${PHP_EXT_DIR}"

BCMATH_EXT="-d extension=$(find ${PHP_EXT_DIR} -type f -name 'bcmath.so')"
echo "bcmath found at: ${BCMATH_EXT}"

IMAGICK_OR_GD="-dextension=gd.so"
JSON_EXT="-dextension=json.so"
XML_EXT="-dextension=xml.so"
if [ "$(php -r 'echo PHP_MAJOR_VERSION;')" = "5" ];then

    # 5.5, 5.4, 5.3
    if [ "$(php -r 'echo (PHP_MINOR_VERSION < 6) ? "true" : "false";')" = "true" ];then
        # seems like there is no bcmath extension to be found
        BCMATH_EXT=""
        IMAGICK_OR_GD="-dextension=imagick.so"
        # Seems not to exist in 5.5, 5.4, 5.3
        JSON_EXT=""
        XML_EXT=""
    fi

fi

# PHP >= 8.x.x
if [ "$(php -r 'echo (PHP_MAJOR_VERSION >= 8) ? "true" : "false";')" = "true" ];then
    # The json ext is bundled into PHP 8.0
    JSON_EXT=""
fi

echo "Root folder: ${ROOT_DIR}"
echo "Temporary folder: ${TEMP_FOLDER}"

FAILED_FLAG=0

cd "${ROOT_DIR}/examples"

for file in $EXAMPLE_FILES; do
    echo "File: $file"
    php -l "${ROOT_DIR}/$file" > /dev/null
    if [ $? -eq 0 ]; then
        echo "File-lint-passed: $file"
    fi
    set +e
    # Some examples load a bit more into memory (this is why the limit is set to 512M)
    php -n \
        -d date.timezone=UTC \
        ${IMAGICK_OR_GD} \
        ${BCMATH_EXT} \
        ${JSON_EXT} \
        ${XML_EXT} \
        -d display_errors=on \
        -d error_reporting=-1 \
        -d memory_limit=512M \
        "${ROOT_DIR}/$file" 1> "${OUTPUT_FILE}" 2> "${OUTPUT_FILE_ERROR}"
    set -e
    if [ $? -eq 0 ]; then
        echo "File-run-passed: $file"
        ERROR_LOGS="$(cat "${OUTPUT_FILE_ERROR}")"
        if [ ! -z "${ERROR_LOGS}" ]; then
            FAILED_FLAG=1
            echo "Logs: $file"
            echo "---------------------------"
            echo "${ERROR_LOGS}"
            echo "---------------------------"
        fi
        if [ $(head -c 4 "${OUTPUT_FILE}") != "%PDF" ]; then
            FAILED_FLAG=1
            # cut before the PDF output starts and destroys the final logs
            OUT_LOGS="$(cat "${OUTPUT_FILE}" | sed '/%PDF/q')"
            echo "Generated-not-a-pdf: $file"
            echo "Logs (cut before PDF output eventually starts): $file"
            echo "---------------------------"
            echo "${OUT_LOGS}"
            echo "---------------------------"
            continue
        fi
        pdfinfo "${OUTPUT_FILE}" > /dev/null
        if [ $? -gt 0 ]; then
            FAILED_FLAG=1
            echo "Generated-invalid-file: $file"
        fi
    else
        FAILED_FLAG=1
        echo "File-run-failed: $file"
        ERROR_LOGS="$(cat "${OUTPUT_FILE_ERROR}")"
        if [ ! -z "${ERROR_LOGS}" ]; then
            echo "Logs: $file"
            echo "---------------------------"
            echo "${ERROR_LOGS}"
            echo "---------------------------"
        else
            # cut before the PDF output starts and destroys the final logs
            OUT_LOGS="$(cat "${OUTPUT_FILE}" | sed '/%PDF/q')"
            echo "Logs: $file"
            echo "---------------------------"
            echo "${OUT_LOGS}"
            echo "---------------------------"
        fi
    fi
done

for file in $EXAMPLE_BARCODE_FILES; do
    echo "File: $file"
    php -l "${ROOT_DIR}/$file" > /dev/null
    if [ $? -eq 0 ]; then
        echo "File-lint-passed: $file"
    fi
    set +e
    php -n \
        -d date.timezone=UTC \
        ${BCMATH_EXT} \
        -d display_errors=on \
        -d error_reporting=-1 \
        "${ROOT_DIR}/$file" 1> "${OUTPUT_FILE}" 2> "${OUTPUT_FILE_ERROR}"
    set -e
    if [ $? -eq 0 ]; then
        echo "File-run-passed: $file"
        ERROR_LOGS="$(cat "${OUTPUT_FILE_ERROR}")"
        if [ ! -z "${ERROR_LOGS}" ]; then
            FAILED_FLAG=1
            echo "Logs: $file"
            echo "---------------------------"
            echo "${ERROR_LOGS}"
            echo "---------------------------"
        fi
    else
        FAILED_FLAG=1
        echo "File-run-failed: $file"
        ERROR_LOGS="$(cat "${OUTPUT_FILE_ERROR}")"
        if [ ! -z "${ERROR_LOGS}" ]; then
            echo "Logs: $file"
            echo "---------------------------"
            echo "${ERROR_LOGS}"
            echo "---------------------------"
        fi
        # cut before the PDF output starts and destroys the final logs
        OUT_LOGS="$(cat "${OUTPUT_FILE}" | sed '/%PDF/q')"
        if [ ! -z "${OUT_LOGS}" ]; then
            echo "Logs (cut before PDF output eventually starts): $file"
            echo "---------------------------"
            echo "${OUT_LOGS}"
            echo "---------------------------"
        fi
    fi
done

cd - > /dev/null

rm -rf "${TEMP_FOLDER}"

echo "Exit code: ${FAILED_FLAG}"
exit "${FAILED_FLAG}"