[manpage_begin rc4 n 1.0.0]
[moddesc   {rc4}]
[copyright {2003, Pat Thoyts <patthoyts@users.sourceforge.net>}]
[titledesc {RC4 Stream Cipher}]
[require Tcl 8.2]
[require rc4 [opt 1.0.0]]
[description]
[para]

This package is an implementation in Tcl of the RC4 stream cipher 
developed by Ron Rivest of RSA Data Security Inc.

[section {COMMANDS}]

[list_begin definitions]

[call [cmd "::rc4::rc4"] \
        [opt "[arg -hex]"] \
        [arg "-key keyvalue" ] \
        [opt [arg "-out channel"]] \
        [lb] [arg "-in channel"] | \
        [arg "-infile filename"] | [arg "string"] [rb]]

Perform the RC4 algorithm on either the data provided by the argument
or on the data read from the [arg "-in"] channel. If an [arg "-out"]
channel is given then the result will be written to this channel.
Giving the [arg "-hex"] option will return a hexadecimal encoded
version of the result if not using an [arg -out] channel.

[nl]

The data to be processes can be specified either as a string argument to
the rc4 command, or as a filename or a pre-opened channel. If the 
[arg "-infile"] argument is given then the file is opened, the data read
and processed and the file is closed. If the [arg "-in"] argument is
given then data is read from the channel until the end of file. The
channel is not closed. If the [arg "-out"] argument is given then the
processing result is written to this channel.

[nl]

Only one of [arg "-infile"], [arg "-in"] or [arg "string"] should be given.

[list_end]

[comment { FIX ME: Talk about the Transfer method and do the API funcs. }]

[see_also des]

[keywords rc4 {stream cipher} security]
[manpage_end]
