[comment {-*- tcl -*- doctools manpage}]
[manpage_begin log n 1.2]
[copyright {2001-2002 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Logging facility}]
[titledesc {Procedures to log messages of libraries and applications.}]
[require Tcl 8]
[require log [opt 1.2]]
[description]

[para]

The [package log] package provides commands that allow libraries and
applications to selectively log information about their internal
operation and state.

[para]

To use the package just execute
[para]

[example {
    package require log
    log::log notice "Some message"
}]
[para]

As can be seen above, each message given to the log facility is
associated with a [emph level] determining the importance of the
message. The user can then select which levels to log, what commands
to use for the logging of each level and the channel to write the
message to. In the following example the logging of all message with
level [const debug] is deactivated.

[para]

[example {
    package require log
    log::lvSuppress debug
    log::log debug "Unseen message" ; # No output
}]
[para]

By default all messages associated with an error-level

([const emergency], [const alert], [const critical], and

[const error]) are written to [const stderr]. Messages with any
other level are written to [const stdout]. In the following example
the log module is reconfigured to write [const debug] messages to
[const stderr] too.

[para]

[example {
    package require log
    log::lvChannel debug stderr
    log::log debug "Written to stderr"
}]

[para]

Each message level is also associated with a command to use when
logging a message with that level. The behaviour above for example
relies on the fact that all message levels use by default the standard
command [cmd ::log::Puts] to log any message. In the following example
all messages of level [const notice] are given to the non-standard
command [cmd toText] for logging. This disables the channel setting
for such messages, assuming that [cmd toText] does not use it by
itself.

[para]

[example {
    package require log
    log::lvCmd notice toText
    log::log notice "Handled by \"toText\""
}]

[para]

Another database maintained by this facility is a map from message
levels to colors. The information in this database has [emph no]
influence on the behaviour of the module. It is merely provided as a
convenience and in anticipation of the usage of this facility in
[package tk]-based application which may want to colorize message
logs.

[section API]

[para]

The following commands are available:

[list_begin definitions]


[call [cmd ::log::levels]]

Returns the names of all known levels, in alphabetical order.

[call [cmd ::log::lv2longform] [arg level]]

Converts any unique abbreviation of a level name to the full level
name.

[call [cmd ::log::lv2color] [arg level]]

Converts any level name including unique abbreviations to the
corresponding color.

[call [cmd ::log::lv2priority] [arg level]]

Converts any level name including unique abbreviations to the
corresponding priority.

[call [cmd ::log::lv2cmd] [arg level]]

Converts any level name including unique abbreviations to the command
prefix used to write messages with that level.

[call [cmd ::log::lv2channel] [arg level]]

Converts any level name including unique abbreviations to the channel
used by [cmd ::log::Puts] to write messages with that level.

[call [cmd ::log::lvCompare] [arg level1] [arg level2]]

Compares two levels (including unique abbreviations) with respect to
their priority. This command can be used by the -command option of
lsort. The result is one of -1, 0 or 1 or an error. A result of -1
signals that level1 is of less priority than level2. 0 signals that
both levels have the same priority. 1 signals that level1 has higher
priority than level2.

[call [cmd ::log::lvSuppress] [arg level] "{[arg suppress] 1}"]]

(Un)suppresses the output of messages having the specified
level. Unique abbreviations for the level are allowed here too.

[call [cmd ::log::lvSuppressLE] [arg level] "{[arg suppress] 1}"]]

(Un)suppresses the output of messages having the specified level or
one of lesser priority. Unique abbreviations for the level are allowed
here too.

[call [cmd ::log::lvIsSuppressed] [arg level]]

Asks the package whether the specified level is currently
suppressed. Unique abbreviations of level names are allowed.

[call [cmd ::log::lvCmd] [arg level] [arg cmd]]

Defines for the specified level with which command to write the
messages having this level. Unique abbreviations of level names are
allowed. The command is actually a command prefix and this facility
will append 2 arguments before calling it, the level of the message
and the message itself, in this order.

[call [cmd ::log::lvCmdForall] [arg cmd]]

Defines for all known levels with which command to write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.

[call [cmd ::log::lvChannel] [arg level] [arg chan]]

Defines for the specified level into which channel [cmd ::log::Puts]
(the standard command) shall write the messages having this
level. Unique abbreviations of level names are allowed. The command is
actually a command prefix and this facility will append 2 arguments
before calling it, the level of the message and the message itself, in
this order.

[call [cmd ::log::lvChannelForall] [arg chan]]

Defines for all known levels with which which channel
[cmd ::log::Puts] (the standard command) shall write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.

[call [cmd ::log::lvColor] [arg level] [arg color]]

Defines for the specified level the color to return for it in a call
to [cmd ::log::lv2color]. Unique abbreviations of level names are
allowed.

[call [cmd ::log::lvColorForall] [arg color]]

Defines for all known levels the color to return for it in a call to
[cmd ::log::lv2color]. Unique abbreviations of level names are
allowed.

[call [cmd ::log::log] [arg level] [arg text]]

Log a message according to the specifications for commands, channels
and suppression. In other words: The command will do nothing if the
specified level is suppressed. If it is not suppressed the actual
logging is delegated to the specified command. If there is no command
specified for the level the message won't be logged. The standard
command [cmd ::log::Puts] will write the message to the channel
specified for the given level. If no channel is specified for the
level the message won't be logged. Unique abbreviations of level names
are allowed. Errors in the actual logging command are [emph not]
caught, but propagated to the caller, as they may indicate
misconfigurations of the log facility or errors in the callers code
itself.


[call [cmd ::log::logarray] [arg level] [arg arrayvar] [opt [arg pattern]]]

Like [cmd ::log::log], but logs the contents of the specified array
variable [arg arrayvar], possibly restricted to entries matching the
[arg pattern]. The pattern defaults to [const *] (i.e. all entries) if
none was specified.


[call [cmd ::log::loghex] [arg level] [arg text] [arg data]]

Like [cmd ::log::log], but assumes that [arg data] contains binary
data. It converts this into a mixed hex/ascii representation before
writing them to the log.


[call [cmd ::log::logMsg] [arg text]]

Convenience wrapper around [cmd ::log::log].
Equivalent to [cmd "::log::log info text"].

[call [cmd ::log::logError] [arg text]]

Convenience wrapper around [cmd ::log::log].
Equivalent to [cmd "::log::log error text"].

[call [cmd ::log::Puts] [arg level] [arg text]]

The standard log command, it writes messages and their levels to
user-specified channels. Assumes that the suppression checks were done
by the caller. Expects full level names, abbreviations are
[emph {not allowed}].

[list_end]

[section LEVELS]

The package currently defines the following log levels, the level of
highest importance listed first.

[list_begin bullet]
[bullet]
emergency
[bullet]
alert
[bullet]
critical
[bullet]
error
[bullet]
warning
[bullet]
notice
[bullet]
info
[bullet]
debug
[list_end]

[keywords log {log level} {message level} message]
[manpage_end]
