[comment {-*- tcl -*- doctools manpage}]
[manpage_begin fileutil n 1.7]
[moddesc   {file utilities}]
[titledesc {Procedures implementing some file utilities}]
[require Tcl 8]
[require fileutil [opt 1.7]]
[description]
[para]

This package provides implementations of standard unix utilities.

[list_begin definitions]


[call [cmd ::fileutil::cat] [arg files]]

A tcl implementation of the UNIX [syscmd cat] command.  Returns the
contents of the specified file(s). The arguments are files to read.
If there are problems reading any of the files, an error will occur,
and no data will be returned.

[call [cmd ::fileutil::fileType] [arg filename]]

An implementation of the UNIX [syscmd file] command, which uses
various heuristics to guess the type of a file.  Returns a list
specifying as much type information as can be determined about the
file, from most general (eg, "binary" or "text") to most specific (eg,
"gif").  For example, the return value for a GIF file would be "binary
graphic gif".  The command will detect the following types of files:
directory, empty, binary, text, script (with interpreter), executable
elf, executable dos, executable ne, executable pe, graphic gif,
graphic jpeg, graphic png, graphic tiff, graphic bitmap, html,
xml (with doctype if available), message pgp, binary pdf, text ps,
text eps, binary gravity_wave_data_frame, compressed bzip,
compressed gzip, compressed zip, compressed tar, audio wave,
audio mpeg, and link.


[call [cmd ::fileutil::find] [opt "[arg basedir] [opt [arg filtercmd]]"]]

An implementation of the unix command [syscmd find]. Adapted from the
Tcler's Wiki. Takes at most two arguments, the path to the directory
to start searching from and a command to use to evaluate interest in
each file. The path defaults to [file .], i.e. the current
directory. The command defaults to the empty string, which means that
all files are of interest. The command takes care [emph not] to
loose itself in infinite loops upon encountering circular link
structures.  The result of the command is a list containing the paths
to the interesting files.


[call [cmd ::fileutil::findByPattern] [arg basedir] [opt [option -regexp]|[option -glob]] [opt [option --]] [arg patterns]]

This command is based upon the [package TclX] command

[cmd recursive_glob], except that it doesn't allow recursion over more
than one directory at a time. It uses [cmd ::fileutil::find]
internally and is thus able to and does follow symbolic links,
something the [package TclX] command does not do. First argument is
the directory to start the search in, second argument is a list of
[arg patterns]. The command returns a list of all files reachable
through [arg basedir] whose names match at least one of the
patterns. The options before the pattern-list determine the style of
matching, either regexp or glob. glob-style matching is the default if
no options are given. Usage of the option [option --] stops option
processing. This allows the use of a leading '-' in the patterns.


[call [cmd ::fileutil::foreachLine] [arg {var filename cmd}]]

The command reads the file [arg filename] and executes the script

[arg cmd] for every line in the file. During the execution of the
script the variable [arg var] is set to the contents of the current
line. The return value of this command is the result of the last
invocation of the script [arg cmd] or the empty string if the file was
empty.


[call [cmd ::fileutil::grep] [arg pattern] [opt [arg files]]]

Implementation of [syscmd grep]. Adapted from the Tcler's Wiki. The
first argument defines the [arg pattern] to search for. This is
followed by a list of [arg files] to search through. The list is
optional and [const stdin] will be used if it is missing. The result
of the procedures is a list containing the matches. Each match is a
single element of the list and contains filename, number and contents
of the matching line, separated by a colons.

[call [cmd ::fileutil::install] [opt "[option -m] [arg "mode"]"] [arg source] [arg destination]]

The [cmd install] command is similar in functionality to the [syscmd install]
command found on many unix systems, or the shell script
distributed with many source distributions (unix/install-sh in the Tcl
sources, for example).  It copies [arg source], which can be either a
file or directory to [arg destination], which should be a directory,
unless [arg source] is also a single file.  The [opt -m] option lets
the user specify a unix-style mode (either octal or symbolic - see
[cmd {file attributes}].

[call [cmd ::fileutil::stripN] [arg path] [arg n]]

Removes the first [arg n] elements from the specified [arg path] and
returns the modified path. If [arg n] is greater than the number of
components in [arg path] an empty string is returned.

[call [cmd ::fileutil::stripPwd] [arg path]]

If the [arg path] is inside of the directory returned by

[lb][cmd pwd][rb] (or the current working directory itself) it is made
relative to that directory. In other words, the current working
directory is stripped from the [arg path].  The possibly modified path
is returned as the result of the command. If the current working
directory itself was specified for [arg path] the result is the string
"[const .]".


[call [cmd ::fileutil::touch] [opt [option -a]] [opt [option -c]] [opt [option -m]] [opt "[option -r] [arg ref_file]"] [opt "[option -t] [arg time]"] [arg filename] [opt [arg ...]]]

Implementation of [syscmd touch]. Alter the atime and mtime of the
specified files. If [option -c], do not create files if they do not
already exist. If [option -r], use the atime and mtime from

[arg ref_file]. If [option -t], use the integer clock value

[arg time]. It is illegal to specify both [option -r] and

[option -t]. If [option -a], only change the atime. If [option -m],
only change the mtime.

[nl]
[emph {This command is not available for Tcl versions less than 8.3.}]


[call [cmd ::fileutil::tempdir]]

The command returns the path of a directory where the caller can
place temporary files, such as [file /tmp] on Unix systems. The
algorithm we use to find the correct directory is as follows:

[list_begin enum]

[enum]
The directory named in the TMPDIR environment variable.

[enum]
The directory named in the TEMP environment variable.

[enum]
The directory named in the TMP environment variable.

[enum]
A platform specific location:

[list_begin definitions]
[lst_item {Windows}]

[file "C:\\TEMP"], [file "C:\\TMP"], [file "\\TEMP"],
and [file "\\TMP"] are tried in that order.

[lst_item {(classic) Macintosh}]

The TRASH_FOLDER environment variable is used.  This is most likely
not correct.

[lst_item {Unix}]

The directories [file /tmp], [file /var/tmp], and [file /usr/tmp] are
tried in that order.

[list_end]
[list_end]
[nl]

The algorithm utilized is that used in the Python standard library.


[call [cmd ::fileutil::tempfile] [opt [arg prefix]]]

The command generates a temporary file name suitable for writing to,
and the associated file.  The file name will be unique, and the file
will be writable and contained in the appropriate system specific temp
directory. The name of the file will be returned as the result of the
command.

[nl]

The code was taken from [uri http://wiki.tcl.tk/772], attributed to
Igor Volobouev and anon.



[list_end]


[keywords {file utilities} touch grep type {temp file}]
[manpage_end]
