'\"
'\" Generated from file 'csv\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2002-2013 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "csv" n 0\&.8 tcllib "CSV processing"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
csv \- Procedures to handle CSV data\&.
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBcsv  ?0\&.8?\fR
.sp
\fB::csv::iscomplete\fR \fIdata\fR
.sp
\fB::csv::join\fR \fIvalues\fR ?\fIsepChar\fR? ?\fIdelChar\fR? ?\fIdelMode\fR?
.sp
\fB::csv::joinlist\fR \fIvalues\fR ?\fIsepChar\fR? ?\fIdelChar\fR? ?\fIdelMode\fR?
.sp
\fB::csv::joinmatrix\fR \fImatrix\fR ?\fIsepChar\fR? ?\fIdelChar\fR? ?\fIdelMode\fR?
.sp
\fB::csv::read2matrix\fR ?\fB-alternate\fR? \fIchan m\fR {\fIsepChar\fR ,} {\fIexpand\fR none}
.sp
\fB::csv::read2queue\fR ?\fB-alternate\fR? \fIchan q\fR {\fIsepChar\fR ,}
.sp
\fB::csv::report\fR \fIcmd matrix\fR ?\fIchan\fR?
.sp
\fB::csv::split\fR ?\fB-alternate\fR? \fIline\fR ?\fIsepChar\fR? ?\fIdelChar\fR?
.sp
\fB::csv::split2matrix\fR ?\fB-alternate\fR? \fIm line\fR {\fIsepChar\fR ,} {\fIexpand\fR none}
.sp
\fB::csv::split2queue\fR ?\fB-alternate\fR? \fIq line\fR {\fIsepChar\fR ,}
.sp
\fB::csv::writematrix\fR \fIm chan\fR ?\fIsepChar\fR? ?\fIdelChar\fR?
.sp
\fB::csv::writequeue\fR \fIq chan\fR ?\fIsepChar\fR? ?\fIdelChar\fR?
.sp
.BE
.SH DESCRIPTION
.PP
The \fBcsv\fR package provides commands to manipulate information
in CSV \fBFORMAT\fR (CSV = Comma Separated Values)\&.
.SH COMMANDS
.PP
The following commands are available:
.TP
\fB::csv::iscomplete\fR \fIdata\fR
A predicate checking if the argument \fIdata\fR is a complete csv
record\&. The result is a boolean flag indicating the completeness of
the data\&. The result is true if the data is complete\&.
.TP
\fB::csv::join\fR \fIvalues\fR ?\fIsepChar\fR? ?\fIdelChar\fR? ?\fIdelMode\fR?
Takes a list of values and returns a string in CSV format containing
these values\&. The separator character can be defined by the caller,
but this is optional\&. The default is ","\&. The quoting aka delimiting character can
be defined by the caller, but this is optional\&. The default is '"'\&.
By default the quoting mode \fIdelMode\fR is "auto", surrounding
values with \fIdelChar\fR only when needed\&. When set to "always"
however, values are always surrounded by the \fIdelChar\fR instead\&.
.TP
\fB::csv::joinlist\fR \fIvalues\fR ?\fIsepChar\fR? ?\fIdelChar\fR? ?\fIdelMode\fR?
Takes a list of lists of values and returns a string in CSV format
containing these values\&. The separator character can be defined by the
caller, but this is optional\&. The default is ","\&. The quoting character
can be defined by the caller, but this is optional\&. The default is '"'\&.
By default the quoting mode \fIdelMode\fR is "auto", surrounding
values with \fIdelChar\fR only when needed\&. When set to "always"
however, values are always surrounded by the \fIdelChar\fR instead\&.
Each element of the outer list is considered a record, these are
separated by newlines in the result\&. The elements of each record are
formatted as usual (via \fB::csv::join\fR)\&.
.TP
\fB::csv::joinmatrix\fR \fImatrix\fR ?\fIsepChar\fR? ?\fIdelChar\fR? ?\fIdelMode\fR?
Takes a \fImatrix\fR object following the API specified for the
struct::matrix package and returns a string in CSV format containing
these values\&. The separator character can be defined by the caller,
but this is optional\&. The default is ","\&. The quoting character
can be defined by the caller, but this is optional\&. The default is
\'"'\&.
By default the quoting mode \fIdelMode\fR is "auto", surrounding
values with \fIdelChar\fR only when needed\&. When set to "always"
however, values are always surrounded by the \fIdelChar\fR instead\&.
Each row of the matrix is considered a record, these are
separated by newlines in the result\&. The elements of each record are
formatted as usual (via \fB::csv::join\fR)\&.
.TP
\fB::csv::read2matrix\fR ?\fB-alternate\fR? \fIchan m\fR {\fIsepChar\fR ,} {\fIexpand\fR none}
A wrapper around \fB::csv::split2matrix\fR (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given matrix\&. For an explanation of the \fIexpand\fR
argument see \fB::csv::split2matrix\fR\&.
.TP
\fB::csv::read2queue\fR ?\fB-alternate\fR? \fIchan q\fR {\fIsepChar\fR ,}
A wrapper around \fB::csv::split2queue\fR (see below) reading
CSV-formatted lines from the specified channel (until EOF) and adding
them to the given queue\&.
.TP
\fB::csv::report\fR \fIcmd matrix\fR ?\fIchan\fR?
A report command which can be used by the matrix methods
\fBformat 2string\fR and \fBformat 2chan\fR\&. For the latter this
command delegates the work to \fB::csv::writematrix\fR\&. \fIcmd\fR is
expected to be either \fBprintmatrix\fR or
\fBprintmatrix2channel\fR\&. The channel argument, \fIchan\fR, has
to be present for the latter and must not be present for the first\&.
.TP
\fB::csv::split\fR ?\fB-alternate\fR? \fIline\fR ?\fIsepChar\fR? ?\fIdelChar\fR?
converts a \fIline\fR in CSV format into a list of the values
contained in the line\&. The character used to separate the values from
each other can be defined by the caller, via \fIsepChar\fR, but this
is optional\&. The default is ","\&. The quoting character can be defined
by the caller, but this is optional\&. The default is '"'\&.
.sp
If the option \fB-alternate\fR is specified a slightly different
syntax is used to parse the input\&. This syntax is explained below, in
the section \fBFORMAT\fR\&.
.TP
\fB::csv::split2matrix\fR ?\fB-alternate\fR? \fIm line\fR {\fIsepChar\fR ,} {\fIexpand\fR none}
The same as \fB::csv::split\fR, but appends the resulting list as a
new row to the matrix \fIm\fR, using the method \fBadd row\fR\&. The
expansion mode specified via \fIexpand\fR determines how the command
handles a matrix with less columns than contained in \fIline\fR\&. The
allowed modes are:
.RS
.TP
\fBnone\fR
This is the default mode\&. In this mode it is the responsibility of the
caller to ensure that the matrix has enough columns to contain the
full line\&. If there are not enough columns the list of values is
silently truncated at the end to fit\&.
.TP
\fBempty\fR
In this mode the command expands an empty matrix to hold all columns
of the specified line, but goes no further\&. The overall effect is that
the first of a series of lines determines the number of columns in the
matrix and all following lines are truncated to that size, as if mode
\fBnone\fR was set\&.
.TP
\fBauto\fR
In this mode the command expands the matrix as needed to hold all
columns contained in \fIline\fR\&. The overall effect is that after
adding a series of lines the matrix will have enough columns to hold
all columns of the longest line encountered so far\&.
.RE
.TP
\fB::csv::split2queue\fR ?\fB-alternate\fR? \fIq line\fR {\fIsepChar\fR ,}
The same as \fB::csv::split\fR, but appending the resulting list as a
single item to the queue \fIq\fR, using the method \fBput\fR\&.
.TP
\fB::csv::writematrix\fR \fIm chan\fR ?\fIsepChar\fR? ?\fIdelChar\fR?
A wrapper around \fB::csv::join\fR taking all rows in the matrix
\fIm\fR and writing them CSV formatted into the channel \fIchan\fR\&.
.TP
\fB::csv::writequeue\fR \fIq chan\fR ?\fIsepChar\fR? ?\fIdelChar\fR?
A wrapper around \fB::csv::join\fR taking all items in the queue
\fIq\fR (assumes that they are lists) and writing them CSV formatted
into the channel \fIchan\fR\&.
.PP
.SH FORMAT
.PP
The format of regular CSV files is specified as
.IP [1]
Each record of a csv file (comma-separated values, as exported e\&.g\&. by
Excel) is a set of ASCII values separated by ","\&. For other languages
it may be ";" however, although this is not important for this case as
the functions provided here allow any separator character\&.
.IP [2]
If and only if a value contains itself the separator ",", then it (the
value) has to be put between ""\&. If the value does not contain the
separator character then quoting is optional\&.
.IP [3]
If a value contains the character ", that character is represented by ""\&.
.IP [4]
The output string "" represents the value "\&. In other words, it is
assumed that it was created through rule 3, and only this rule,
i\&.e\&. that the value was not quoted\&.
.PP
.PP
An alternate format definition mainly used by MS products specifies
that the output string "" is a representation of the empty
string\&. In other words, it is assumed that the output was generated
out of the empty string by quoting it (i\&.e\&. rule 2), and not through
rule 3\&. This is the only difference between the regular and the
alternate format\&.
.PP
The alternate format is activated through specification of the option
\fB-alternate\fR to the various split commands\&.
.SH EXAMPLE
Using the regular format the record
.PP
.CS


123,"123,521\&.2","Mary says ""Hello, I am Mary""",""

.CE
.PP
is parsed into the items
.PP
.CS


a) 123
b) 123,521\&.2
c) Mary says "Hello, I am Mary"
d) "

.CE
.PP
Using the alternate format the result is
.PP
.CS


a) 123
b) 123,521\&.2
c) Mary says "Hello, I am Mary"
d) (the empty string)

.CE
instead\&. As can be seen only item (d) is different, now the empty string
instead of a "\&.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIcsv\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH "SEE ALSO"
matrix, queue
.SH KEYWORDS
csv, matrix, package, queue, tcllib
.SH CATEGORY
Text processing
.SH COPYRIGHT
.nf
Copyright (c) 2002-2013 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi