/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.LineData;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class GprofDataSource
extends DataSource {
    private File[] files;
    private int indexStart = 0;
    private int percentStart = 0;
    private int selfStart = 0;
    private int descendantsStart = 0;
    private int calledStart = 0;
    private int nameStart = 0;
    private boolean fixNames = false;

    public GprofDataSource(File[] fileArray, boolean bl) {
        this.setMetrics(new Vector());
        this.fixNames = bl;
        this.files = fileArray;
    }

    public void cancelLoad() {
    }

    public int getProgress() {
        return 0;
    }

    public void load() throws FileNotFoundException, IOException {
        long l = System.currentTimeMillis();
        Function function = null;
        FunctionProfile functionProfile = null;
        Node node = null;
        Context context = null;
        Thread thread = null;
        int n = -1;
        String string = null;
        Object var10_9 = null;
        Object var11_10 = null;
        Function function2 = null;
        Object var15_12 = null;
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            node = this.addNode(++n);
            context = node.addContext(0);
            thread = context.addThread(0);
            this.addMetric("Time");
            boolean bl = false;
            boolean bl2 = true;
            Vector<LineData> vector = new Vector<LineData>();
            LineData lineData = null;
            Vector<LineData> vector2 = new Vector<LineData>();
            while ((string = bufferedReader.readLine()) != null) {
                int n2 = string.length();
                if (n2 != 0) {
                    int n3 = string.indexOf("granularity: ");
                    if (n3 == 0 || n3 == 1) {
                        bl = !bl;
                    }
                    if (bl) {
                        if (string.indexOf("index") == 0 && string.indexOf("time") >= 0 && string.indexOf("self") >= 0 && string.indexOf("called") >= 0 && string.indexOf("name") >= 0) {
                            this.getFieldLengths(string);
                        } else if (string.charAt(0) == '[') {
                            lineData = this.getSelfLineData(string);
                            bl2 = false;
                        } else if (string.charAt(0) == '-') {
                            String string2;
                            LineData lineData2;
                            int n4;
                            function = this.addFunction(lineData.s0, 1);
                            functionProfile = new FunctionProfile(function);
                            thread.addFunctionProfile(functionProfile);
                            functionProfile.setInclusive(0, lineData.d1 + lineData.d2);
                            functionProfile.setExclusive(0, lineData.d1);
                            functionProfile.setNumCalls(lineData.i0);
                            int n5 = 0;
                            for (n4 = 0; n4 < vector2.size(); ++n4) {
                                lineData2 = (LineData)vector2.get(n4);
                                n5 += lineData2.i0;
                            }
                            functionProfile.setNumSubr(n5);
                            for (n4 = 0; n4 < vector.size(); ++n4) {
                                lineData2 = (LineData)vector.elementAt(n4);
                                function = this.addFunction(lineData2.s0, 1);
                                string2 = lineData2.s0 + " => " + lineData.s0 + "  ";
                                function2 = this.addFunction(lineData2.s0 + " => " + lineData.s0 + "  ", 1);
                                function2.setCallPathFunction(true);
                                functionProfile = new FunctionProfile(function2);
                                thread.addFunctionProfile(functionProfile);
                                functionProfile.setInclusive(0, lineData2.d0 + lineData2.d1);
                                functionProfile.setExclusive(0, lineData2.d0);
                                functionProfile.setNumCalls(lineData2.i0);
                            }
                            vector.clear();
                            for (n4 = 0; n4 < vector2.size(); ++n4) {
                                lineData2 = (LineData)vector2.elementAt(n4);
                                function = this.addFunction(lineData2.s0, 1);
                                string2 = lineData.s0 + " => " + lineData2.s0 + "  ";
                                function2 = this.addFunction(lineData.s0 + " => " + lineData2.s0 + "  ", 1);
                                function2.setCallPathFunction(true);
                                functionProfile = new FunctionProfile(function2);
                                thread.addFunctionProfile(functionProfile);
                                functionProfile.setInclusive(0, lineData2.d0 + lineData2.d1);
                                functionProfile.setExclusive(0, lineData2.d0);
                                functionProfile.setNumCalls(lineData2.i0);
                            }
                            vector2.clear();
                            bl2 = true;
                        } else if (string.charAt(n2 - 1) == ']') {
                            if (string.indexOf("<cycle") >= 0) {
                                if (bl2) {
                                    vector.add(this.getParentChildLineData(string));
                                } else {
                                    vector2.add(this.getParentChildLineData(string));
                                }
                            } else if (bl2) {
                                vector.add(this.getParentChildLineData(string));
                            } else {
                                vector2.add(this.getParentChildLineData(string));
                            }
                        }
                    } else if (string.charAt(n2 - 1) == ']') {
                        // empty if block
                    }
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            }
        }
        this.generateDerivedData();
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
            this.setCallPathDataPresent(true);
        }
        l = System.currentTimeMillis() - l;
    }

    private void getFieldLengths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        if (string3.compareTo("%") == 0) {
            string3 = string3 + " " + stringTokenizer.nextToken();
        }
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        String string6 = stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        this.indexStart = string.indexOf(string2);
        this.percentStart = string.indexOf(string3);
        this.selfStart = string.indexOf(string3) + string3.length() + 1;
        this.descendantsStart = string.indexOf(string4) + string4.length() + 1;
        this.calledStart = string.indexOf(string5) + string5.length() + 1;
        this.nameStart = string.indexOf(string7);
    }

    private LineData getSelfLineData(String string) {
        String string2;
        LineData lineData = new LineData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        int n = stringTokenizer.countTokens();
        stringTokenizer.nextToken();
        lineData.d0 = Double.parseDouble(stringTokenizer.nextToken());
        lineData.d1 = 1000000.0 * Double.parseDouble(stringTokenizer.nextToken());
        lineData.d2 = 1000000.0 * Double.parseDouble(stringTokenizer.nextToken());
        if (n < 7) {
            lineData.i0 = 1;
        } else {
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf("+") < 0) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "+");
                lineData.i0 = Integer.parseInt(stringTokenizer2.nextToken());
            }
        }
        lineData.s0 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.indexOf("[") == 0 || string2.endsWith("]")) continue;
            lineData.s0 = lineData.s0 + " " + string2;
        }
        lineData.s0 = this.fix(lineData.s0);
        return lineData;
    }

    private LineData getParentChildLineData(String string) {
        LineData lineData = new LineData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        String string2 = string.substring(this.selfStart, this.descendantsStart).trim();
        lineData.d0 = string2.length() > 0 ? 1000000.0 * Double.parseDouble(string2) : 0.0;
        string2 = string.substring(this.descendantsStart, this.calledStart).trim();
        lineData.d1 = string2.length() > 0 ? 1000000.0 * Double.parseDouble(string2) : 0.0;
        String string3 = string.substring(this.calledStart, string.length()).trim();
        int n = string3.indexOf(" ");
        string2 = n > this.nameStart - this.calledStart ? string3.substring(0, n).trim() : string.substring(this.calledStart, this.nameStart).trim();
        if (string2.indexOf("/") >= 0) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
            lineData.i0 = Integer.parseInt(stringTokenizer2.nextToken());
            lineData.i1 = Integer.parseInt(stringTokenizer2.nextToken());
        } else {
            lineData.i1 = lineData.i0 = Integer.parseInt(string2);
        }
        if (n > this.nameStart - this.calledStart) {
            int n2 = string3.lastIndexOf("[") - 1;
            lineData.s0 = string3.substring(n, n2).trim();
        } else {
            int n3 = string.lastIndexOf("[") - 1;
            lineData.s0 = string.substring(this.nameStart, n3).trim();
        }
        lineData.s0 = this.fix(lineData.s0);
        return lineData;
    }

    private LineData getSummaryLineData(String string) {
        LineData lineData = new LineData();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
        lineData.d0 = Double.parseDouble(stringTokenizer.nextToken());
        lineData.d1 = 1000.0 * Double.parseDouble(stringTokenizer.nextToken());
        lineData.d2 = 1000.0 * Double.parseDouble(stringTokenizer.nextToken());
        if (stringTokenizer.countTokens() > 5) {
            lineData.i0 = Integer.parseInt(stringTokenizer.nextToken());
            lineData.d3 = Double.parseDouble(stringTokenizer.nextToken());
            lineData.d4 = Double.parseDouble(stringTokenizer.nextToken());
        } else {
            lineData.i0 = 1;
            lineData.d3 = lineData.d2;
            lineData.d4 = lineData.d2;
        }
        lineData.s0 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("[") == 0 || string2.endsWith("]")) continue;
            lineData.s0 = lineData.s0 + " " + string2;
        }
        lineData.s0 = this.fix(lineData.s0);
        return lineData;
    }

    private String fix(String string) {
        String string2 = string;
        if (this.fixNames) {
            if (string.indexOf(".") == 0) {
                string2 = string.substring(1, string.length());
            } else if (string.endsWith("_")) {
                string2 = string.substring(0, string.length() - 1);
            }
        }
        return string2;
    }
}

