/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.vis;

import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.vis.Axes;
import edu.uoregon.tau.paraprof.vis.ColorScale;
import edu.uoregon.tau.paraprof.vis.Plot;
import edu.uoregon.tau.paraprof.vis.Vec;
import edu.uoregon.tau.paraprof.vis.VisRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.util.GLUT;

public class BarPlot
implements Plot {
    private final GLUT glut = new GLUT();
    private float xSize;
    private float ySize;
    private float zSize;
    private float barSize = 0.9f;
    private ColorScale colorScale;
    private Axes axes;
    private int selectedRow = -1;
    private int selectedCol = -1;
    private boolean translucent = false;
    private float translucency = 0.5f;
    private static float threshold = 0.05f;
    private int nrows;
    private int ncols;
    private float[][] heightValues;
    private float[][] colorValues;
    private boolean dirty = true;
    private List displayLists = new ArrayList();
    private int translucentDisplayListsXplus;
    private int translucentDisplayListsXminus;
    private int translucentDisplayListsYplus;
    private int translucentDisplayListsYminus;
    private int translucentDisplayListsXsize;
    private int translucentDisplayListsYsize;
    protected GL gl;

    public void initialize(Axes axes, float f, float f2, float f3, float[][] fArray, float[][] fArray2, ColorScale colorScale) {
        this.setColorScale(colorScale);
        this.nrows = fArray.length;
        this.ncols = fArray[0].length;
        this.heightValues = fArray;
        this.colorValues = fArray2;
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        this.axes = axes;
        axes.setSize(f, f2, f3);
        this.processValues();
    }

    public String getName() {
        return "Bar Plot";
    }

    public void setValues(float f, float f2, float f3, float[][] fArray, float[][] fArray2) {
        this.nrows = fArray.length;
        this.ncols = fArray[0].length;
        this.heightValues = fArray;
        this.colorValues = fArray2;
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        this.axes.setSize(f, f2, f3);
        this.processValues();
        this.dirty = true;
    }

    public float getBarSize() {
        return this.barSize;
    }

    public void setBarSize(float f) {
        this.barSize = f;
        this.barSize = Math.min(this.barSize, 1.0f);
        this.barSize = Math.max(this.barSize, 0.01f);
        this.dirty = true;
    }

    private void processValues() {
        float f;
        float f2;
        int n;
        int n2;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        for (n2 = 0; n2 < this.nrows; ++n2) {
            for (n = 0; n < this.ncols; ++n) {
                f2 = this.heightValues[n2][n];
                f = this.colorValues[n2][n];
                f3 = Math.max(f3, f2);
                f4 = Math.max(f4, f);
            }
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            for (n = 0; n < this.ncols; ++n) {
                f2 = this.heightValues[n2][n];
                f = this.colorValues[n2][n];
                this.heightValues[n2][n] = f2 / f3 * this.zSize;
                this.colorValues[n2][n] = f / f4;
            }
        }
    }

    public void setSize(float f, float f2, float f3) {
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        this.axes.setSize(f, f2, f3);
        this.processValues();
        this.dirty = true;
    }

    private void doBox(Vec vec, Vec vec2, float f) {
        if (f >= threshold) {
            this.gl.glNormal3f(0.0f, 0.0f, 1.0f);
            this.gl.glVertex3f(vec.x(), vec.y(), vec2.z());
            this.gl.glVertex3f(vec2.x(), vec.y(), vec2.z());
            this.gl.glVertex3f(vec2.x(), vec2.y(), vec2.z());
            this.gl.glVertex3f(vec.x(), vec2.y(), vec2.z());
            this.gl.glNormal3f(-1.0f, 0.0f, 0.0f);
            this.gl.glVertex3f(vec.x(), vec.y(), vec.z());
            this.gl.glVertex3f(vec.x(), vec.y(), vec2.z());
            this.gl.glVertex3f(vec.x(), vec2.y(), vec2.z());
            this.gl.glVertex3f(vec.x(), vec2.y(), vec.z());
            this.gl.glNormal3f(1.0f, 0.0f, 0.0f);
            this.gl.glVertex3f(vec2.x(), vec.y(), vec.z());
            this.gl.glVertex3f(vec2.x(), vec2.y(), vec.z());
            this.gl.glVertex3f(vec2.x(), vec2.y(), vec2.z());
            this.gl.glVertex3f(vec2.x(), vec.y(), vec2.z());
            this.gl.glNormal3f(0.0f, 1.0f, 0.0f);
            this.gl.glVertex3f(vec.x(), vec2.y(), vec.z());
            this.gl.glVertex3f(vec.x(), vec2.y(), vec2.z());
            this.gl.glVertex3f(vec2.x(), vec2.y(), vec2.z());
            this.gl.glVertex3f(vec2.x(), vec2.y(), vec.z());
            this.gl.glNormal3f(0.0f, -1.0f, 0.0f);
            this.gl.glVertex3f(vec.x(), vec.y(), vec.z());
            this.gl.glVertex3f(vec2.x(), vec.y(), vec.z());
            this.gl.glVertex3f(vec2.x(), vec.y(), vec2.z());
            this.gl.glVertex3f(vec.x(), vec.y(), vec2.z());
        }
    }

    private void generateTranslucentDisplayLists(GL gL) {
        Vec vec;
        Vec vec2;
        Color color;
        float f;
        float f2;
        int n;
        int n2;
        this.translucentDisplayListsXplus = gL.glGenLists(this.ncols);
        this.translucentDisplayListsYplus = gL.glGenLists(this.nrows);
        this.translucentDisplayListsXminus = gL.glGenLists(this.ncols);
        this.translucentDisplayListsYminus = gL.glGenLists(this.nrows);
        this.translucentDisplayListsXsize = this.ncols;
        this.translucentDisplayListsYsize = this.nrows;
        float f3 = this.xSize / (float)(this.ncols + 1);
        float f4 = this.ySize / (float)(this.nrows + 1);
        for (n2 = 0; n2 < this.ncols; ++n2) {
            gL.glNewList(this.translucentDisplayListsXplus + n2, 4864);
            gL.glBegin(7);
            for (n = 0; n < this.nrows; ++n) {
                f2 = (float)n2 * f3;
                f = (float)n * f4;
                color = this.colorScale.getColor(this.colorValues[n][n2]);
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.translucency);
                vec2 = new Vec(f2, f, 0.0f);
                vec = new Vec(f2 + f3 * this.barSize, f + f4 * this.barSize, this.heightValues[n][n2]);
                this.doBox(vec2, vec, this.heightValues[n][n2]);
            }
            gL.glEnd();
            gL.glEndList();
            gL.glNewList(this.translucentDisplayListsXminus + n2, 4864);
            gL.glBegin(7);
            for (n = this.nrows - 1; n >= 0; --n) {
                f2 = (float)n2 * f3;
                f = (float)n * f4;
                color = this.colorScale.getColor(this.colorValues[n][n2]);
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.translucency);
                vec2 = new Vec(f2, f, 0.0f);
                vec = new Vec(f2 + f3 * this.barSize, f + f4 * this.barSize, this.heightValues[n][n2]);
                this.doBox(vec2, vec, this.heightValues[n][n2]);
            }
            gL.glEnd();
            gL.glEndList();
        }
        for (n2 = 0; n2 < this.nrows; ++n2) {
            gL.glNewList(this.translucentDisplayListsYplus + n2, 4864);
            gL.glBegin(7);
            for (n = 0; n < this.ncols; ++n) {
                f2 = (float)n * f3;
                f = (float)n2 * f4;
                color = this.colorScale.getColor(this.colorValues[n2][n]);
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.translucency);
                vec2 = new Vec(f2, f, 0.0f);
                vec = new Vec(f2 + f3 * this.barSize, f + f4 * this.barSize, this.heightValues[n2][n]);
                this.doBox(vec2, vec, this.heightValues[n2][n]);
            }
            gL.glEnd();
            gL.glEndList();
            gL.glNewList(this.translucentDisplayListsYminus + n2, 4864);
            gL.glBegin(7);
            for (n = this.ncols - 1; n >= 0; --n) {
                f2 = (float)n * f3;
                f = (float)n2 * f4;
                color = this.colorScale.getColor(this.colorValues[n2][n]);
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, this.translucency);
                vec2 = new Vec(f2, f, 0.0f);
                vec = new Vec(f2 + f3 * this.barSize, f + f4 * this.barSize, this.heightValues[n2][n]);
                this.doBox(vec2, vec, this.heightValues[n2][n]);
            }
            gL.glEnd();
            gL.glEndList();
        }
    }

    private void drawBoxesTranslucent(GL gL, Vec vec) {
        if (this.dirty) {
            gL.glDeleteLists(this.translucentDisplayListsXminus, this.translucentDisplayListsXsize);
            gL.glDeleteLists(this.translucentDisplayListsYminus, this.translucentDisplayListsYsize);
            gL.glDeleteLists(this.translucentDisplayListsXplus, this.translucentDisplayListsXsize);
            gL.glDeleteLists(this.translucentDisplayListsYplus, this.translucentDisplayListsYsize);
            this.generateTranslucentDisplayLists(gL);
        }
        vec.normalize();
        if (Math.abs(vec.x()) > Math.abs(vec.y())) {
            for (int i = 0; i < this.ncols; ++i) {
                if (vec.x() < 0.0f) {
                    if (vec.y() < 0.0f) {
                        gL.glCallList(this.translucentDisplayListsXplus + i);
                        continue;
                    }
                    gL.glCallList(this.translucentDisplayListsXminus + i);
                    continue;
                }
                if (vec.y() < 0.0f) {
                    gL.glCallList(this.translucentDisplayListsXplus + (this.ncols - 1) - i);
                    continue;
                }
                gL.glCallList(this.translucentDisplayListsXminus + (this.ncols - 1) - i);
            }
        } else {
            for (int i = 0; i < this.nrows; ++i) {
                if (vec.y() < 0.0f) {
                    if (vec.x() < 0.0f) {
                        gL.glCallList(this.translucentDisplayListsYplus + i);
                        continue;
                    }
                    gL.glCallList(this.translucentDisplayListsYminus + i);
                    continue;
                }
                if (vec.x() < 0.0f) {
                    gL.glCallList(this.translucentDisplayListsYplus + (this.nrows - 1) - i);
                    continue;
                }
                gL.glCallList(this.translucentDisplayListsYminus + (this.nrows - 1) - i);
            }
        }
    }

    public boolean isSufficientlyEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public boolean isSufficientlyEqual(double d, double d2) {
        return this.isSufficientlyEqual(d, d2, 0.01);
    }

    public void cleanUp() {
        ParaProfUtils.vout(this, "Cleaning up!");
        if (this.displayLists != null) {
            for (int i = 0; i < this.displayLists.size(); ++i) {
                this.gl.glDeleteLists(((Integer)this.displayLists.get(i)).intValue(), 1);
            }
            this.displayLists = new ArrayList();
        }
    }

    private void renderOpaque(GLDrawable gLDrawable) {
        GL gL = gLDrawable.getGL();
        if (this.dirty || this.displayLists == null) {
            if (this.displayLists != null) {
                for (int i = 0; i < this.displayLists.size(); ++i) {
                    gL.glDeleteLists(((Integer)this.displayLists.get(i)).intValue(), 1);
                }
                this.displayLists = new ArrayList();
            } else {
                this.displayLists = new ArrayList();
            }
            Integer n = new Integer(gL.glGenLists(1));
            this.displayLists.add(n);
            gL.glNewList(n.intValue(), 4864);
            gL.glEnable(2896);
            gL.glFrontFace(2305);
            gL.glEnable(2884);
            gL.glShadeModel(7424);
            gL.glEnable(2929);
            gL.glDisable(3042);
            gL.glBlendFunc(1, 0);
            float f = this.xSize / (float)(this.ncols + 1);
            float f2 = this.ySize / (float)(this.nrows + 1);
            gL.glPushMatrix();
            gL.glTranslatef(f - f * this.barSize / 2.0f, f2 - f2 * this.barSize / 2.0f, 0.05f);
            gL.glBegin(7);
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < this.nrows; ++i) {
                for (int j = 0; j < this.ncols; ++j) {
                    int n7 = i;
                    int n8 = j;
                    float f6 = (float)n8 * f;
                    float f7 = (float)n7 * f2;
                    Color color = this.colorScale.getColor(this.colorValues[n7][n8]);
                    float f8 = (float)color.getRed() / 255.0f;
                    float f9 = (float)color.getGreen() / 255.0f;
                    float f10 = (float)color.getBlue() / 255.0f;
                    if (this.isSufficientlyEqual(f8, f3) && this.isSufficientlyEqual(f9, f5) && this.isSufficientlyEqual(f10, f4)) {
                        ++n2;
                    } else {
                        gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                        f3 = f8;
                        f4 = f10;
                        f5 = f9;
                        ++n3;
                    }
                    Vec vec = new Vec(f6, f7, 0.0f);
                    Vec vec2 = new Vec(f6 + f * this.barSize, f7 + f2 * this.barSize, this.heightValues[n7][n8]);
                    if (this.heightValues[n7][n8] >= threshold) {
                        gL.glNormal3f(0.0f, 0.0f, 1.0f);
                        gL.glVertex3f(vec.x(), vec.y(), vec2.z());
                        gL.glVertex3f(vec2.x(), vec.y(), vec2.z());
                        gL.glVertex3f(vec2.x(), vec2.y(), vec2.z());
                        gL.glVertex3f(vec.x(), vec2.y(), vec2.z());
                        gL.glNormal3f(-1.0f, 0.0f, 0.0f);
                        gL.glVertex3f(vec.x(), vec.y(), vec.z());
                        gL.glVertex3f(vec.x(), vec.y(), vec2.z());
                        gL.glVertex3f(vec.x(), vec2.y(), vec2.z());
                        gL.glVertex3f(vec.x(), vec2.y(), vec.z());
                        gL.glNormal3f(1.0f, 0.0f, 0.0f);
                        gL.glVertex3f(vec2.x(), vec.y(), vec.z());
                        gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
                        gL.glVertex3f(vec2.x(), vec2.y(), vec2.z());
                        gL.glVertex3f(vec2.x(), vec.y(), vec2.z());
                        gL.glNormal3f(0.0f, 1.0f, 0.0f);
                        gL.glVertex3f(vec.x(), vec2.y(), vec.z());
                        gL.glVertex3f(vec.x(), vec2.y(), vec2.z());
                        gL.glVertex3f(vec2.x(), vec2.y(), vec2.z());
                        gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
                        gL.glNormal3f(0.0f, -1.0f, 0.0f);
                        gL.glVertex3f(vec.x(), vec.y(), vec.z());
                        gL.glVertex3f(vec2.x(), vec.y(), vec.z());
                        gL.glVertex3f(vec2.x(), vec.y(), vec2.z());
                        gL.glVertex3f(vec.x(), vec.y(), vec2.z());
                        ++n5;
                        n6 += 20;
                    } else {
                        ++n4;
                        n6 += 4;
                    }
                    if (n6 <= 10000) continue;
                    n6 = 0;
                    gL.glEnd();
                    gL.glEndList();
                    n = new Integer(gL.glGenLists(1));
                    this.displayLists.add(n);
                    gL.glNewList(n.intValue(), 4864);
                    gL.glBegin(7);
                }
            }
            ParaProfUtils.vout(this, "Saved " + n2 + " colors");
            ParaProfUtils.vout(this, "Used " + n3 + " colors");
            ParaProfUtils.vout(this, "Saved " + n4 + " boxes");
            ParaProfUtils.vout(this, "Used " + n5 + " boxes");
            gL.glEnd();
            gL.glPopMatrix();
            gL.glEndList();
            ParaProfUtils.vout(this, "Created " + this.displayLists.size() + " display lists");
        }
        for (int i = 0; i < this.displayLists.size(); ++i) {
            gL.glCallList(((Integer)this.displayLists.get(i)).intValue());
        }
        this.renderSelection(gL);
    }

    private void renderTranslucent(GLDrawable gLDrawable, Vec vec) {
        GL gL = gLDrawable.getGL();
        gL.glEnable(2929);
        this.renderSelectionForTranslucency(gL);
        gL.glEnable(2896);
        gL.glFrontFace(2305);
        gL.glEnable(2884);
        gL.glShadeModel(7424);
        gL.glBlendFunc(770, 771);
        gL.glEnable(3042);
        float f = this.xSize / (float)(this.ncols + 1);
        float f2 = this.ySize / (float)(this.nrows + 1);
        gL.glPushMatrix();
        gL.glTranslatef(f - f * this.barSize / 2.0f, f2 - f2 * this.barSize / 2.0f, 0.05f);
        this.drawBoxesTranslucent(gL, vec);
        gL.glPopMatrix();
    }

    public void render(VisRenderer visRenderer) {
        GLDrawable gLDrawable = visRenderer.getGLDrawable();
        Vec vec = visRenderer.getViewDirection();
        this.axes.render(visRenderer);
        GL gL = gLDrawable.getGL();
        if (gL == null) {
            return;
        }
        this.gl = gL;
        if (this.translucent) {
            this.renderTranslucent(gLDrawable, vec);
        } else {
            this.renderOpaque(gLDrawable);
        }
        this.dirty = false;
    }

    private void renderSelectionForTranslucency(GL gL) {
        Vec vec;
        Vec vec2;
        Color color;
        float f;
        float f2;
        int n;
        if (this.selectedRow < 0 || this.selectedCol < 0) {
            return;
        }
        float f3 = this.xSize / (float)(this.ncols + 1);
        float f4 = this.ySize / (float)(this.nrows + 1);
        gL.glPushMatrix();
        gL.glTranslatef(f3 - f3 * this.barSize / 2.0f, f4 - f4 * this.barSize / 2.0f, 0.05f);
        gL.glFrontFace(2305);
        gL.glEnable(2884);
        gL.glBlendFunc(1, 0);
        gL.glDisable(3042);
        gL.glBegin(7);
        int n2 = this.selectedCol;
        for (n = 0; n < this.nrows; ++n) {
            f2 = (float)n2 * f3;
            f = (float)n * f4;
            color = this.colorScale.getColor(this.colorValues[n][n2]);
            gL.glColor4f((float)color.getRed() / 255.0f + 0.25f, (float)color.getGreen() / 255.0f + 0.25f, (float)color.getBlue() / 255.0f + 0.25f, 1.0f);
            vec2 = new Vec(f2, f, 0.0f);
            vec = new Vec(f2 + f3 * this.barSize, f + f4 * this.barSize, this.heightValues[n][n2]);
            gL.glNormal3f(0.0f, 0.0f, 1.0f);
            gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec.x(), vec.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec.z());
            gL.glNormal3f(-1.0f, 0.0f, 0.0f);
            gL.glVertex3f(vec2.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec2.z());
            gL.glNormal3f(1.0f, 0.0f, 0.0f);
            gL.glVertex3f(vec.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec.y(), vec.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec.z());
            gL.glNormal3f(0.0f, 1.0f, 0.0f);
            gL.glVertex3f(vec2.x(), vec.y(), vec2.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec.z());
            gL.glVertex3f(vec.x(), vec.y(), vec.z());
            gL.glVertex3f(vec.x(), vec.y(), vec2.z());
            gL.glNormal3f(0.0f, -1.0f, 0.0f);
            gL.glVertex3f(vec2.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
        }
        n = this.selectedRow;
        for (n2 = 0; n2 < this.ncols; ++n2) {
            f2 = (float)n2 * f3;
            f = (float)n * f4;
            color = this.colorScale.getColor(this.colorValues[n][n2]);
            gL.glColor4f((float)color.getRed() / 255.0f + 0.25f, (float)color.getGreen() / 255.0f + 0.25f, (float)color.getBlue() / 255.0f + 0.25f, 1.0f);
            vec2 = new Vec(f2, f, 0.0f);
            vec = new Vec(f2 + f3 * this.barSize, f + f4 * this.barSize, this.heightValues[n][n2]);
            gL.glNormal3f(0.0f, 0.0f, 1.0f);
            gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec.x(), vec.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec.z());
            gL.glNormal3f(-1.0f, 0.0f, 0.0f);
            gL.glVertex3f(vec2.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec2.z());
            gL.glNormal3f(1.0f, 0.0f, 0.0f);
            gL.glVertex3f(vec.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec.y(), vec.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec.z());
            gL.glNormal3f(0.0f, 1.0f, 0.0f);
            gL.glVertex3f(vec2.x(), vec.y(), vec2.z());
            gL.glVertex3f(vec2.x(), vec.y(), vec.z());
            gL.glVertex3f(vec.x(), vec.y(), vec.z());
            gL.glVertex3f(vec.x(), vec.y(), vec2.z());
            gL.glNormal3f(0.0f, -1.0f, 0.0f);
            gL.glVertex3f(vec2.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec2.z());
            gL.glVertex3f(vec.x(), vec2.y(), vec.z());
            gL.glVertex3f(vec2.x(), vec2.y(), vec.z());
        }
        gL.glEnd();
        gL.glPopMatrix();
    }

    private void renderSelection(GL gL) {
        if (this.selectedRow < 0 || this.selectedCol < 0) {
            return;
        }
        gL.glPushMatrix();
        float f = this.xSize / (float)(this.ncols + 1);
        float f2 = this.ySize / (float)(this.nrows + 1);
        gL.glDisable(2896);
        gL.glEnable(2848);
        gL.glBlendFunc(770, 771);
        gL.glHint(3154, 4354);
        gL.glEnable(3042);
        gL.glLineWidth(4.0f);
        gL.glDepthFunc(515);
        gL.glDisable(2884);
        float f3 = this.heightValues[this.selectedRow][this.selectedCol];
        gL.glTranslatef(0.0f, 0.0f, 0.055f);
        gL.glBegin(7);
        float f4 = (float)(this.selectedCol + 1) * f - f * this.barSize / 2.0f;
        float f5 = (float)(this.selectedRow + 1) * f2 - f2 * this.barSize / 2.0f;
        gL.glColor4f(0.0f, 1.0f, 0.0f, 0.75f);
        gL.glVertex3f(f4, 0.0f, f3);
        gL.glVertex3f(f4 + f * this.barSize, 0.0f, f3);
        gL.glVertex3f(f4 + f * this.barSize, this.ySize, f3);
        gL.glVertex3f(f4, this.ySize, f3);
        gL.glEnd();
        gL.glTranslatef(0.0f, 0.0f, 0.005f);
        gL.glBegin(7);
        gL.glColor4f(1.0f, 1.0f, 0.0f, 0.75f);
        gL.glVertex3f(0.0f, f5, f3);
        gL.glVertex3f(0.0f, f5 + f2 * this.barSize, f3);
        gL.glVertex3f(this.xSize, f5 + f2 * this.barSize, f3);
        gL.glVertex3f(this.xSize, f5, f3);
        gL.glEnd();
        gL.glDisable(2848);
        gL.glDisable(3042);
        gL.glLineWidth(1.0f);
        gL.glPopMatrix();
    }

    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        final JSlider jSlider = new JSlider(1, 100, (int)(this.barSize * 100.0f));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    BarPlot.this.setBarSize((float)jSlider.getValue() / 100.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        final JSlider jSlider2 = new JSlider(0, 100, (int)(this.translucency * 100.0f));
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    BarPlot.this.setTranslucency((float)jSlider2.getValue() / 100.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        final JSlider jSlider3 = new JSlider(5, 300, (int)this.xSize);
        final JSlider jSlider4 = new JSlider(5, 300, (int)this.ySize);
        final JSlider jSlider5 = new JSlider(2, 50, (int)this.zSize);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    BarPlot.this.setSize(jSlider3.getValue(), jSlider4.getValue(), jSlider5.getValue());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        jSlider3.addChangeListener(changeListener);
        jSlider4.addChangeListener(changeListener);
        jSlider5.addChangeListener(changeListener);
        final JCheckBox jCheckBox = new JCheckBox("Transparency", this.translucent);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BarPlot.this.setTranslucent(jCheckBox.isSelected());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jPanel, new JLabel("Plot Width"), gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel, new JLabel("Plot Depth"), gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel, new JLabel("Plot Height"), gridBagConstraints, 0, 2, 1, 1);
        this.addCompItem(jPanel, new JLabel("Bar Size"), gridBagConstraints, 0, 3, 1, 1);
        this.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 4, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(jPanel, jSlider3, gridBagConstraints, 1, 0, 1, 1);
        this.addCompItem(jPanel, jSlider4, gridBagConstraints, 1, 1, 1, 1);
        this.addCompItem(jPanel, jSlider5, gridBagConstraints, 1, 2, 1, 1);
        this.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 3, 1, 1);
        this.addCompItem(jPanel, jSlider2, gridBagConstraints, 1, 4, 1, 1);
        return jPanel;
    }

    private void addCompItem(JPanel jPanel, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        jPanel.add(component, gridBagConstraints);
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ColorScale) {
            this.dirty = true;
        }
    }

    public float getWidth() {
        return this.xSize;
    }

    public float getDepth() {
        return this.ySize;
    }

    public float getHeight() {
        return this.zSize;
    }

    public Axes getAxes() {
        return this.axes;
    }

    public void setAxes(Axes axes) {
        this.axes = axes;
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int n) {
        this.selectedRow = n;
        this.axes.setSelectedRow(n);
    }

    public int getSelectedCol() {
        return this.selectedCol;
    }

    public void setSelectedCol(int n) {
        this.selectedCol = n;
        this.axes.setSelectedCol(n);
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale colorScale) {
        if (this.colorScale != null) {
            this.colorScale.deleteObserver(this);
        }
        this.colorScale = colorScale;
        if (colorScale != null) {
            colorScale.addObserver(this);
        }
    }

    public boolean getTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean bl) {
        this.translucent = bl;
        this.dirty = true;
    }

    public float getTranslucency() {
        return this.translucency;
    }

    public void setTranslucency(float f) {
        this.translucency = f;
        this.dirty = true;
    }
}

