/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.paraprof.treetable.TreeTableNode;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class CallPathModel
extends AbstractTreeTableModel {
    private List roots;
    private Thread thread;
    private DataSource dataSource;
    private ParaProfTrial ppTrial;
    private double[] maxValues;
    private int sortColumn;
    private boolean sortAscending;
    private TreeTableWindow window;
    static /* synthetic */ Class class$edu$uoregon$tau$paraprof$treetable$TreeTableModel;

    public CallPathModel(TreeTableWindow treeTableWindow, ParaProfTrial paraProfTrial, Thread thread) {
        super(null);
        this.root = new TreeTableNode(null, this, "root");
        this.window = treeTableWindow;
        this.dataSource = paraProfTrial.getDataSource();
        this.thread = thread;
        this.ppTrial = paraProfTrial;
        this.setupData();
    }

    private void setupData() {
        this.roots = new ArrayList();
        DataSorter dataSorter = new DataSorter(this.ppTrial);
        List list = dataSorter.getFunctionProfiles(this.thread);
        HashMap<FunctionProfile, String> hashMap = new HashMap<FunctionProfile, String>();
        if (this.window.getTreeMode()) {
            Object object;
            String string;
            Object object2;
            Object object3;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object3 = (PPFunctionProfile)iterator.next();
                object2 = ((PPFunctionProfile)object3).getFunctionProfile();
                if (object2 == null || !object2.isCallPathFunction()) continue;
                string = object2.getName();
                int n = string.indexOf("=>");
                object = string.substring(0, n).trim();
                if (hashMap.get(hashMap) != null) continue;
                hashMap.put((FunctionProfile)object, "1");
            }
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                TreeTableNode treeTableNode;
                object2 = (String)object3.next();
                string = this.dataSource.getFunction((String)object2);
                if (string == null) {
                    treeTableNode = new TreeTableNode(null, this, (String)object2);
                } else {
                    object = this.thread.getFunctionProfile((Function)string);
                    treeTableNode = new TreeTableNode((FunctionProfile)object, this, null);
                }
                this.roots.add(treeTableNode);
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)iterator.next();
                FunctionProfile functionProfile = pPFunctionProfile.getFunctionProfile();
                if (functionProfile == null) continue;
                String string = functionProfile.getName();
                TreeTableNode treeTableNode = new TreeTableNode(functionProfile, this, null);
                this.roots.add(treeTableNode);
            }
        }
        Collections.sort(this.roots);
        this.computeMaximum();
    }

    public void computeMaximum() {
        int n = this.window.getPPTrial().getNumberOfMetrics();
        this.maxValues = new double[n];
        Iterator iterator = this.roots.iterator();
        while (iterator.hasNext()) {
            TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
            if (treeTableNode.getFunctionProfile() == null) continue;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                this.maxValues[n3] = this.maxValues[n3] + treeTableNode.getFunctionProfile().getInclusive(n2);
                ++n2;
            }
        }
    }

    public int getColumnCount() {
        return 1 + this.window.getColumns().size();
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Name";
        }
        return this.window.getColumns().get(n - 1).toString();
    }

    public Object getValueAt(Object object, int n) {
        if (object == this.root) {
            return null;
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        return treeTableNode;
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$edu$uoregon$tau$paraprof$treetable$TreeTableModel == null ? (class$edu$uoregon$tau$paraprof$treetable$TreeTableModel = CallPathModel.class$("edu.uoregon.tau.paraprof.treetable.TreeTableModel")) : class$edu$uoregon$tau$paraprof$treetable$TreeTableModel;
        }
        return this.window.getColumns().get(n - 1).getClass();
    }

    public int getChildCount(Object object) {
        if (object == this.root) {
            return this.roots.size();
        }
        if (this.window.getTreeMode()) {
            TreeTableNode treeTableNode = (TreeTableNode)object;
            return treeTableNode.getNumChildren();
        }
        return 0;
    }

    public Object getChild(Object object, int n) {
        if (object == this.root) {
            return this.roots.get(n);
        }
        TreeTableNode treeTableNode = (TreeTableNode)object;
        return treeTableNode.getChildren().get(n);
    }

    public Thread getThread() {
        return this.thread;
    }

    public double[] getMaxValues() {
        return this.maxValues;
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public boolean getSortAscending() {
        return this.sortAscending;
    }

    public void sortColumn(int n, boolean bl) {
        super.sortColumn(n, bl);
        this.sortColumn = n;
        this.sortAscending = bl;
        Collections.sort(this.roots);
        Iterator iterator = this.roots.iterator();
        while (iterator.hasNext()) {
            TreeTableNode treeTableNode = (TreeTableNode)iterator.next();
            treeTableNode.sortChildren();
        }
    }

    public TreeTableWindow getWindow() {
        return this.window;
    }

    public ParaProfTrial getPPTrial() {
        return this.ppTrial;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

