/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import edu.uoregon.tau.paraprof.CallGraphWindow;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.FunctionSelectorDialog;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageFormatFileFilter;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import edu.uoregon.tau.paraprof.ThreeDeeWindow;
import edu.uoregon.tau.paraprof.interfaces.ImageExport;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class ParaProfUtils {
    static boolean verbose;
    static boolean verboseSet;

    private ParaProfUtils() {
    }

    private static void checkVerbose() {
        if (!verboseSet) {
            if (System.getProperty("paraprof.verbose") != null) {
                verbose = true;
            }
            verboseSet = true;
        }
    }

    public static void verr(String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            System.err.println(string);
        }
    }

    public static void vout(String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            System.out.println(string);
        }
    }

    public static void vout(Object object, String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.out.println(string2 + ": " + string);
        }
    }

    public static void verr(Object object, String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.println(string2 + ": " + string);
        }
    }

    public static void helperAddRadioMenuItem(String string, String string2, boolean bl, ButtonGroup buttonGroup, JMenu jMenu, ActionListener actionListener) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand(string2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
    }

    public static void addCompItem(Container container, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        container.add(component, gridBagConstraints);
    }

    public static void print(Printable printable) {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.defaultPage();
        if (pageFormat2 != (pageFormat = printerJob.pageDialog(pageFormat2))) {
            printerJob.setPrintable(printable, pageFormat);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    ParaProfUtils.handleException(printerException);
                }
            }
        }
    }

    public static JMenu createHelpMenu(final JFrame jFrame, final ParaProfWindow paraProfWindow) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object instanceof JMenuItem) {
                        String string = actionEvent.getActionCommand();
                        if (string.equals("About ParaProf")) {
                            JOptionPane.showMessageDialog(jFrame, ParaProf.getInfoString());
                        } else if (string.equals("Show Help Window")) {
                            paraProfWindow.help(true);
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createFileMenu(final ParaProfWindow paraProfWindow, final Printable printable, final Object object) {
        if (printable == null) {
            throw new ParaProfException("File menu created with null panel!");
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object3 = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Print")) {
                        ParaProfUtils.print(printable);
                    } else if (string.equals("Preferences...")) {
                        ParaProf.preferencesWindow.showPreferencesWindow();
                    } else if (string.equals("Save Image")) {
                        Object object2;
                        if (object instanceof ImageExport) {
                            object2 = (ImageExport)object;
                            ParaProfImageOutput.saveImage((ImageExport)object2);
                        }
                        if (object instanceof ThreeDeeWindow) {
                            object2 = (ThreeDeeWindow)object;
                            ParaProfImageOutput.save3dImage((ThreeDeeWindow)object2);
                        }
                    } else if (string.equals("Close This Window")) {
                        paraProfWindow.closeThisWindow();
                    } else if (string.equals("Exit ParaProf!")) {
                        ParaProf.exitParaProf(0);
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Save ...");
        JMenuItem jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createThreadMenu(ParaProfTrial paraProfTrial, JFrame jFrame, Thread thread) {
        JMenu jMenu = new JMenu("Thread");
        JMenuItem jMenuItem = new JMenuItem("Function Graph");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Callpath Relations");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Call Graph");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Function Statistics");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("User Event Statistics");
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createFunctionMenu(ParaProfTrial paraProfTrial, JFrame jFrame, Thread thread) {
        JMenu jMenu = new JMenu("Function");
        JMenuItem jMenuItem = new JMenuItem("Thread Graph");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Histogram");
        jMenu.add(jMenuItem);
        return jMenu;
    }

    private static JMenuItem createMenuItem(String string, ActionListener actionListener, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setEnabled(bl);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JMenu createWindowsMenu(final ParaProfTrial paraProfTrial, final JFrame jFrame) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("ParaProf Manager")) {
                        new ParaProfManagerWindow().show();
                    } else if (string.equals("Function Ledger")) {
                        new LedgerWindow(paraProfTrial, 0).show();
                    } else if (string.equals("Group Ledger")) {
                        new LedgerWindow(paraProfTrial, 1).show();
                    } else if (string.equals("User Event Ledger")) {
                        new LedgerWindow(paraProfTrial, 2).show();
                    } else if (string.equals("3D Visualization")) {
                        if ("1.3".equals("1.3")) {
                            JOptionPane.showMessageDialog(jFrame, "3D Visualization requires Java 1.4 or above\nPlease make sure Java 1.4 is in your path, then reconfigure TAU and re-run ParaProf");
                            return;
                        }
                        try {
                            new ThreeDeeWindow(paraProfTrial).show();
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            JOptionPane.showMessageDialog(jFrame, "Unable to load jogl library.  Possible reasons:\nlibjogl.so is not in your LD_LIBRARY_PATH.\nJogl is not built for this platform.\nOpenGL is not installed\n\nJogl is available at jogl.dev.java.net");
                        }
                        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                            JOptionPane.showMessageDialog(jFrame, "Unsupported class version.  Are you using Java 1.4 or above?");
                        }
                    } else if (string.equals("Call Path Relations")) {
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(paraProfTrial, paraProfTrial.getDataSource().getMeanData(), 1);
                        callPathTextWindow.show();
                    } else if (string.equals("Close All Sub-Windows")) {
                        paraProfTrial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Windows");
        JMenuItem jMenuItem = new JMenuItem("ParaProf Manager");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("3D Visualization");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(jFrame, true, paraProfTrial.getDataSource().getFunctions(), null, false);
                if (functionSelectorDialog.choose()) {
                    Function function = (Function)functionSelectorDialog.getSelectedObject();
                    Object object = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Bar Chart")) {
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(paraProfTrial, function);
                        functionDataWindow.show();
                    } else if (string.equals("Histogram")) {
                        HistogramWindow histogramWindow = new HistogramWindow(paraProfTrial, function);
                        histogramWindow.show();
                    }
                }
            }
        };
        JMenu jMenu2 = new JMenu("Function");
        jMenu2.add(ParaProfUtils.createMenuItem("Bar Chart", actionListener2, true));
        jMenu2.add(ParaProfUtils.createMenuItem("Histogram", actionListener2, true));
        jMenu.add(jMenu2);
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                ArrayList<Thread> arrayList = new ArrayList<Thread>(paraProfTrial.getDataSource().getAllThreads());
                if (paraProfTrial.getDataSource().getAllThreads().size() > 1 && !string.equals("User Event Statistics")) {
                    arrayList.add(0, paraProfTrial.getDataSource().getStdDevData());
                    arrayList.add(1, paraProfTrial.getDataSource().getMeanData());
                }
                FunctionSelectorDialog functionSelectorDialog = new FunctionSelectorDialog(jFrame, true, arrayList.iterator(), null, false);
                functionSelectorDialog.setTitle("Select a Thread");
                if (functionSelectorDialog.choose()) {
                    Thread thread = (Thread)functionSelectorDialog.getSelectedObject();
                    if (string.equals("Bar Chart")) {
                        ThreadDataWindow threadDataWindow = new ThreadDataWindow(paraProfTrial, thread);
                        ((Component)threadDataWindow).setVisible(true);
                    } else if (string.equals("Statistics Text")) {
                        ((Component)new StatWindow(paraProfTrial, thread, false)).setVisible(true);
                    } else if (string.equals("Statistics Table")) {
                        ((Component)new TreeTableWindow(paraProfTrial, thread)).setVisible(true);
                    } else if (string.equals("Call Graph")) {
                        ((Component)new CallGraphWindow(paraProfTrial, thread)).setVisible(true);
                    } else if (string.equals("Call Path Relations")) {
                        ((Component)new CallPathTextWindow(paraProfTrial, thread, 0)).setVisible(true);
                    } else if (string.equals("User Event Statistics")) {
                        ((Component)new StatWindow(paraProfTrial, thread, true)).setVisible(true);
                    }
                }
            }
        };
        JMenu jMenu3 = new JMenu("Thread");
        jMenu3.add(ParaProfUtils.createMenuItem("Bar Chart", actionListener3, true));
        jMenu3.add(ParaProfUtils.createMenuItem("Statistics Text", actionListener3, true));
        jMenu3.add(ParaProfUtils.createMenuItem("Statistics Table", actionListener3, true));
        jMenu3.add(ParaProfUtils.createMenuItem("Call Graph", actionListener3, paraProfTrial.callPathDataPresent()));
        jMenu3.add(ParaProfUtils.createMenuItem("Call Path Relations", actionListener3, paraProfTrial.callPathDataPresent()));
        jMenu3.add(ParaProfUtils.createMenuItem("User Event Statistics", actionListener3, paraProfTrial.userEventsPresent()));
        jMenu.add(jMenu3);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Function Ledger");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem("Group Ledger");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem("User Event Ledger");
        jMenuItem3.addActionListener(actionListener);
        jMenu.add(jMenuItem3);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        MenuListener menuListener = new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                try {
                    jMenuItem2.setEnabled(paraProfTrial.groupNamesPresent());
                    jMenuItem3.setEnabled(paraProfTrial.userEventsPresent());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        };
        jMenu.addMenuListener(menuListener);
        return jMenu;
    }

    public static void scaleForPrint(Graphics graphics, PageFormat pageFormat, int n, int n2) {
        double d = pageFormat.getImageableWidth();
        double d2 = pageFormat.getImageableHeight();
        int n3 = (int)((double)n / d) + 1;
        int n4 = (int)((double)n2 / d2) + 1;
        double d3 = d / (double)n;
        double d4 = d2 / (double)n2;
        double d5 = Math.min(d3, d4);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d3 > d5) {
            d6 = 0.5 * (d3 - d5) * (double)n;
        } else {
            d7 = 0.5 * (d4 - d5) * (double)n2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.translate(d6, d7);
        graphics2D.scale(d5, d5);
    }

    public static JPopupMenu createFunctionClickPopUp(final ParaProfTrial paraProfTrial, final Function function, final JComponent jComponent) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Show Function Bar Chart")) {
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(paraProfTrial, function);
                        functionDataWindow.show();
                    } else if (string.equals("Show Function Histogram")) {
                        HistogramWindow histogramWindow = new HistogramWindow(paraProfTrial, function);
                        histogramWindow.show();
                    } else if (string.equals("Assign Function Color")) {
                        ParaProf.colorMap.assignColor(jComponent, function);
                    } else if (string.equals("Reset to Default Color")) {
                        ParaProf.colorMap.removeColor(function);
                        ParaProf.colorMap.reassignColors();
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show Function Bar Chart");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Show Function Histogram");
        jMenuItem2.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Assign Function Color");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        jMenuItem3 = new JMenuItem("Reset to Default Color");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    public static JMenuItem createStatisticsMenuItem(String string, final ParaProfTrial paraProfTrial, final Thread thread, final boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatWindow statWindow = new StatWindow(paraProfTrial, thread, bl);
                statWindow.show();
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createStatisticsTableMenuItem(String string, final ParaProfTrial paraProfTrial, final Thread thread) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableWindow treeTableWindow = new TreeTableWindow(paraProfTrial, thread);
                treeTableWindow.show();
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createCallGraphMenuItem(String string, final ParaProfTrial paraProfTrial, final Thread thread) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow callGraphWindow = new CallGraphWindow(paraProfTrial, thread);
                callGraphWindow.show();
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createCallPathThreadRelationMenuItem(String string, final ParaProfTrial paraProfTrial, final Thread thread) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallPathTextWindow callPathTextWindow = new CallPathTextWindow(paraProfTrial, thread, 0);
                callPathTextWindow.show();
            }
        });
        return jMenuItem;
    }

    public static JMenuItem createThreadDataMenuItem(String string, final ParaProfTrial paraProfTrial, final Thread thread) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThreadDataWindow threadDataWindow = new ThreadDataWindow(paraProfTrial, thread);
                threadDataWindow.show();
            }
        });
        return jMenuItem;
    }

    public static void handleThreadClick(ParaProfTrial paraProfTrial, Thread thread, JPanel jPanel, MouseEvent mouseEvent) {
        if (thread.getNodeID() == -1) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(ParaProfUtils.createThreadDataMenuItem("Show Mean Bar Chart", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createStatisticsMenuItem("Show Mean Statistics Text Window", paraProfTrial, thread, false));
            jPopupMenu.add(ParaProfUtils.createStatisticsTableMenuItem("Show Mean Statistics Table", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createCallGraphMenuItem("Show Mean Call Graph", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createCallPathThreadRelationMenuItem("Show Mean Call Path Relations", paraProfTrial, thread));
            jPopupMenu.show(jPanel, mouseEvent.getX(), mouseEvent.getY());
        } else if (thread.getNodeID() == -3) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(ParaProfUtils.createThreadDataMenuItem("Show Standard Deviation Bar Chart", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createStatisticsMenuItem("Show Standard Deviation Statistics Text Window", paraProfTrial, thread, false));
            jPopupMenu.add(ParaProfUtils.createStatisticsTableMenuItem("Show Standard Deviation Statistics Table", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createCallGraphMenuItem("Show Standard Deviation Call Graph", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createCallPathThreadRelationMenuItem("Show Standard Deviation Call Path Thread Relations", paraProfTrial, thread));
            jPopupMenu.show(jPanel, mouseEvent.getX(), mouseEvent.getY());
        } else {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(ParaProfUtils.createThreadDataMenuItem("Show Thread Bar Chart", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createStatisticsMenuItem("Show Thread Statistics Text Window", paraProfTrial, thread, false));
            jPopupMenu.add(ParaProfUtils.createStatisticsTableMenuItem("Show Thread Statistics Table", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createCallGraphMenuItem("Show Thread Call Graph", paraProfTrial, thread));
            jPopupMenu.add(ParaProfUtils.createCallPathThreadRelationMenuItem("Show Thread Call Path Relations", paraProfTrial, thread));
            if (paraProfTrial.userEventsPresent()) {
                jPopupMenu.add(ParaProfUtils.createStatisticsMenuItem("Show User Event Statistics Window", paraProfTrial, thread, true));
            }
            jPopupMenu.show(jPanel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static int[] computeClipping(Rectangle rectangle, Rectangle rectangle2, boolean bl, boolean bl2, int n, int n2, int n3) {
        int n4;
        int n5;
        if (!bl2) {
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                n6 = (int)rectangle.getY();
                n7 = (int)((double)n6 + rectangle.getHeight());
            } else {
                n6 = (int)rectangle2.getY();
                n7 = (int)((double)n6 + rectangle2.getHeight());
            }
            n5 = (n6 - n3) / n2 - 1;
            n4 = (n7 - n3) / n2 + 1;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 > n - 1) {
                n5 = n - 1;
            }
            if (n4 > n - 1) {
                n4 = n - 1;
            }
            if (bl) {
                n3 += n5 * n2;
            }
        } else {
            n5 = 0;
            n4 = n - 1;
        }
        int[] nArray = new int[]{n5, n4, n3};
        return nArray;
    }

    public static JMenu createUnitsMenu(final UnitListener unitListener, int n, boolean bl) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Microseconds")) {
                        unitListener.setUnits(0);
                    } else if (string.equals("Milliseconds")) {
                        unitListener.setUnits(1);
                    } else if (string.equals("Seconds")) {
                        unitListener.setUnits(2);
                    } else if (string.equals("hr:min:sec")) {
                        unitListener.setUnits(3);
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Select Units");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", n == 0);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", n == 1);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", n == 2);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", n == 3);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    private static int findGroupID(Group[] groupArray, Group group) {
        int n = 0;
        while (n < groupArray.length) {
            if (groupArray[n] == group) {
                return n;
            }
            ++n;
        }
        throw new ParaProfException("Couldn't find group: " + group.getName());
    }

    public static void writePacked(DataSource dataSource, File file) throws FileNotFoundException, IOException {
        Thread thread;
        Object object;
        Function function;
        Object object2;
        Group group;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gZIPOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        int n = dataSource.getNumFunctions();
        int n2 = dataSource.getNumberOfMetrics();
        int n3 = dataSource.getNumUserEvents();
        int n4 = dataSource.getNumGroups();
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(75);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(n2);
        int n5 = 0;
        while (n5 < n2) {
            String string = dataSource.getMetricName(n5);
            dataOutputStream.writeUTF(string);
            ++n5;
        }
        int n6 = 0;
        dataOutputStream.writeInt(n4);
        Group[] groupArray = new Group[n4];
        Iterator iterator = dataSource.getGroups();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            object2 = group.getName();
            dataOutputStream.writeUTF((String)object2);
            groupArray[n6++] = group;
        }
        group = new Function[n];
        n6 = 0;
        dataOutputStream.writeInt(n);
        object2 = dataSource.getFunctions();
        while (object2.hasNext()) {
            function = (Function)object2.next();
            group[n6++] = function;
            dataOutputStream.writeUTF(function.getName());
            object = function.getGroups();
            if (object == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(object.size());
            int n7 = 0;
            while (n7 < object.size()) {
                thread = (Group)object.get(n7);
                dataOutputStream.writeInt(ParaProfUtils.findGroupID(groupArray, (Group)thread));
                ++n7;
            }
        }
        function = new UserEvent[n3];
        n6 = 0;
        dataOutputStream.writeInt(n3);
        object = dataSource.getUserEvents();
        while (object.hasNext()) {
            UserEvent userEvent = (UserEvent)object.next();
            function[n6++] = userEvent;
            dataOutputStream.writeUTF(userEvent.getName());
        }
        dataOutputStream.writeInt(dataSource.getAllThreads().size());
        Iterator iterator2 = dataSource.getAllThreads().iterator();
        while (iterator2.hasNext()) {
            int n8;
            thread = (Thread)iterator2.next();
            dataOutputStream.writeInt(thread.getNodeID());
            dataOutputStream.writeInt(thread.getContextID());
            dataOutputStream.writeInt(thread.getThreadID());
            int n9 = 0;
            int n10 = 0;
            while (n10 < n) {
                FunctionProfile functionProfile = thread.getFunctionProfile((Function)group[n10]);
                if (functionProfile != null) {
                    ++n9;
                }
                ++n10;
            }
            dataOutputStream.writeInt(n9);
            int n11 = 0;
            while (n11 < n) {
                FunctionProfile functionProfile = thread.getFunctionProfile((Function)group[n11]);
                if (functionProfile != null) {
                    dataOutputStream.writeInt(n11);
                    dataOutputStream.writeDouble(functionProfile.getNumCalls());
                    dataOutputStream.writeDouble(functionProfile.getNumSubr());
                    n8 = 0;
                    while (n8 < n2) {
                        dataOutputStream.writeDouble(functionProfile.getExclusive(n8));
                        dataOutputStream.writeDouble(functionProfile.getInclusive(n8));
                        ++n8;
                    }
                }
                ++n11;
            }
            n9 = 0;
            int n12 = 0;
            while (n12 < n3) {
                UserEventProfile userEventProfile = thread.getUserEventProfile((UserEvent)function[n12]);
                if (userEventProfile != null) {
                    ++n9;
                }
                ++n12;
            }
            dataOutputStream.writeInt(n9);
            n8 = 0;
            while (n8 < n3) {
                UserEventProfile userEventProfile = thread.getUserEventProfile((UserEvent)function[n8]);
                if (userEventProfile != null) {
                    dataOutputStream.writeInt(n8);
                    dataOutputStream.writeInt(userEventProfile.getUserEventNumberValue());
                    dataOutputStream.writeDouble(userEventProfile.getUserEventMinValue());
                    dataOutputStream.writeDouble(userEventProfile.getUserEventMaxValue());
                    dataOutputStream.writeDouble(userEventProfile.getUserEventMeanValue());
                    dataOutputStream.writeDouble(userEventProfile.getUserEventSumSquared());
                }
                ++n8;
            }
        }
        dataOutputStream.close();
        gZIPOutputStream.close();
        fileOutputStream.close();
    }

    public static void exportTrial(ParaProfTrial paraProfTrial, Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Export Trial");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        jFileChooser.setFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.PPK));
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showSaveDialog(component);
        if (n != 0) {
            return;
        }
        try {
            int n2;
            File file = jFileChooser.getSelectedFile();
            String string = file.getCanonicalPath();
            String string2 = ParaProfImageFormatFileFilter.getExtension(file);
            if (string2 == null) {
                string = string + ".ppk";
                file = new File(string);
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(component, file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                return;
            }
            ParaProfUtils.writePacked(paraProfTrial.getDataSource(), file);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private static void writeMetric(String string, DataSource dataSource, int n, Function[] functionArray, String[] stringArray, UserEvent[] userEventArray) throws IOException {
        int n2 = dataSource.getNumFunctions();
        int n3 = dataSource.getNumberOfMetrics();
        int n4 = dataSource.getNumUserEvents();
        int n5 = dataSource.getNumGroups();
        Iterator iterator = dataSource.getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            File file = new File(string + "/profile." + thread.getNodeID() + "." + thread.getContextID() + "." + thread.getThreadID());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                FunctionProfile functionProfile = thread.getFunctionProfile(functionArray[n7]);
                if (functionProfile != null) {
                    ++n6;
                }
                ++n7;
            }
            if (dataSource.getNumberOfMetrics() == 1 && dataSource.getMetricName(n).equals("Time")) {
                bufferedWriter.write(n6 + " templated_functions\n");
            } else {
                bufferedWriter.write(n6 + " templated_functions_MULTI_" + dataSource.getMetricName(n) + "\n");
            }
            bufferedWriter.write("# Name Calls Subrs Excl Incl ProfileCalls\n");
            int n8 = 0;
            while (n8 < n2) {
                FunctionProfile functionProfile = thread.getFunctionProfile(functionArray[n8]);
                if (functionProfile != null) {
                    bufferedWriter.write('\"' + functionArray[n8].getName() + "\" ");
                    bufferedWriter.write((int)functionProfile.getNumCalls() + " ");
                    bufferedWriter.write((int)functionProfile.getNumSubr() + " ");
                    bufferedWriter.write(functionProfile.getExclusive(n) + " ");
                    bufferedWriter.write(functionProfile.getInclusive(n) + " ");
                    bufferedWriter.write("0 GROUP=\"" + stringArray[n8] + "\"\n");
                }
                ++n8;
            }
            bufferedWriter.write("0 aggregates\n");
            n6 = 0;
            int n9 = 0;
            while (n9 < n4) {
                UserEventProfile userEventProfile = thread.getUserEventProfile(userEventArray[n9]);
                if (userEventProfile != null) {
                    ++n6;
                }
                ++n9;
            }
            if (n6 > 0) {
                bufferedWriter.write(n6 + " userevents\n");
                bufferedWriter.write("# eventname numevents max min mean sumsqr\n");
                int n10 = 0;
                while (n10 < n4) {
                    UserEventProfile userEventProfile = thread.getUserEventProfile(userEventArray[n10]);
                    if (userEventProfile != null) {
                        bufferedWriter.write('\"' + userEventArray[n10].getName() + "\" ");
                        bufferedWriter.write(userEventProfile.getUserEventNumberValue() + " ");
                        bufferedWriter.write(userEventProfile.getUserEventMaxValue() + " ");
                        bufferedWriter.write(userEventProfile.getUserEventMinValue() + " ");
                        bufferedWriter.write(userEventProfile.getUserEventMeanValue() + " ");
                        bufferedWriter.write(userEventProfile.getUserEventSumSquared() + "\n");
                    }
                    ++n10;
                }
            }
            bufferedWriter.close();
            outputStreamWriter.close();
            fileOutputStream.close();
        }
    }

    public static String createSafeMetricName(String string) {
        String string2 = string.replace('/', '\\');
        return string2;
    }

    public static void writeProfiles(DataSource dataSource, File file) throws IOException {
        Object object;
        Object object2;
        Function function;
        String[] stringArray;
        Group group;
        int n = dataSource.getNumFunctions();
        int n2 = dataSource.getNumberOfMetrics();
        int n3 = dataSource.getNumUserEvents();
        int n4 = dataSource.getNumGroups();
        int n5 = 0;
        Group[] groupArray = new Group[n4];
        Iterator iterator = dataSource.getGroups();
        while (iterator.hasNext()) {
            group = (Group)iterator.next();
            stringArray = group.getName();
            groupArray[n5++] = group;
        }
        group = new Function[n];
        stringArray = new String[n];
        n5 = 0;
        Iterator iterator2 = dataSource.getFunctions();
        while (iterator2.hasNext()) {
            function = (Function)iterator2.next();
            group[n5] = function;
            object2 = function.getGroups();
            if (object2 == null) {
                stringArray[n5] = "";
            } else {
                stringArray[n5] = "";
                int n6 = 0;
                while (n6 < object2.size()) {
                    object = (Group)object2.get(n6);
                    stringArray[n5] = stringArray[n5] + " | " + object.getName();
                    ++n6;
                }
                stringArray[n5] = stringArray[n5].trim();
            }
            ++n5;
        }
        function = new UserEvent[n3];
        n5 = 0;
        object2 = dataSource.getUserEvents();
        while (object2.hasNext()) {
            UserEvent userEvent = (UserEvent)object2.next();
            function[n5++] = userEvent;
        }
        if (n2 == 1) {
            ParaProfUtils.writeMetric(".", dataSource, 0, (Function[])group, stringArray, (UserEvent[])function);
        } else {
            int n7 = 0;
            while (n7 < n2) {
                object = "MULTI__" + ParaProfUtils.createSafeMetricName(dataSource.getMetricName(n7));
                boolean bl = new File((String)object).mkdir();
                if (!bl) {
                    System.err.println("Failed to create directory: " + (String)object);
                } else {
                    ParaProfUtils.writeMetric((String)object, dataSource, n7, (Function[])group, stringArray, (UserEvent[])function);
                }
                ++n7;
            }
        }
    }

    public static boolean rightClick(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & 4) != 0;
    }

    public static String getFunctionName(Function function) {
        if (ParaProf.preferences.getReversedCallPaths()) {
            return function.getReversedName();
        }
        return function.getName();
    }

    public static void handleException(Exception exception) {
        new ParaProfErrorDialog(exception);
    }
}

