/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.enums;

import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfMetric;

public abstract class ValueType {
    private final String name;
    public static final ValueType EXCLUSIVE = new ValueType("Exclusive"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getExclusive(n);
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxExclusive(n);
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            if (!paraProfMetric.isTimeMetric()) {
                return " counts";
            }
            return ValueType.timeUnits(n);
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            if (paraProfMetric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static final ValueType EXCLUSIVE_PERCENT = new ValueType("Exclusive percent"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getExclusivePercent(n);
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxExclusivePercent(n);
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            return " %";
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            return 0;
        }
    };
    public static final ValueType INCLUSIVE = new ValueType("Inclusive"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getInclusive(n);
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxInclusive(n);
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            if (!paraProfMetric.isTimeMetric()) {
                return " counts";
            }
            return ValueType.timeUnits(n);
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            if (paraProfMetric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static final ValueType INCLUSIVE_PERCENT = new ValueType("Inclusive percent"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getInclusivePercent(n);
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxInclusivePercent(n);
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            return " %";
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            return 0;
        }
    };
    public static final ValueType NUMCALLS = new ValueType("Number of Calls"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getNumCalls();
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxNumCalls();
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            return " calls";
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            return 0;
        }
    };
    public static final ValueType NUMSUBR = new ValueType("Number of Child Calls"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getNumSubr();
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxNumSubr();
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            return " calls";
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            return 0;
        }
    };
    public static final ValueType INCLUSIVE_PER_CALL = new ValueType("Inclusive per Call"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getInclusivePerCall(n);
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxInclusivePerCall(n);
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            if (!paraProfMetric.isTimeMetric()) {
                return " counts per call";
            }
            return ValueType.timeUnits(n) + " per call";
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            if (paraProfMetric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static final ValueType EXCLUSIVE_PER_CALL = new ValueType("Exclusive per Call"){

        public double getValue(FunctionProfile functionProfile, int n) {
            return functionProfile.getExclusivePerCall(n);
        }

        public double getThreadMaxValue(Thread thread, int n) {
            return thread.getMaxExclusivePerCall(n);
        }

        public String getSuffix(int n, ParaProfMetric paraProfMetric) {
            if (!paraProfMetric.isTimeMetric()) {
                return " counts per call";
            }
            return ValueType.timeUnits(n) + " per call";
        }

        public int getUnits(int n, ParaProfMetric paraProfMetric) {
            if (paraProfMetric.isTimeMetric()) {
                return n;
            }
            return 0;
        }
    };
    public static ValueType[] VALUES = new ValueType[]{EXCLUSIVE, INCLUSIVE, EXCLUSIVE_PERCENT, INCLUSIVE_PERCENT, NUMCALLS, NUMSUBR, INCLUSIVE_PER_CALL, EXCLUSIVE_PER_CALL};

    private ValueType(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    private static String timeUnits(int n) {
        String string;
        switch (n) {
            case 0: {
                string = " microseconds";
                break;
            }
            case 1: {
                string = " milliseconds";
                break;
            }
            case 2: {
                string = " seconds";
                break;
            }
            case 3: {
                string = " hh:mm:ss";
                break;
            }
            default: {
                throw new ParaProfException("Unexpected unit type: " + n);
            }
        }
        return string;
    }

    public abstract double getValue(FunctionProfile var1, int var2);

    public abstract double getThreadMaxValue(Thread var1, int var2);

    public abstract String getSuffix(int var1, ParaProfMetric var2);

    public abstract int getUnits(int var1, ParaProfMetric var2);
}

