/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.paraprof.ColorChooser;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Color;

public class LedgerDataElement {
    private int xBeg;
    private int xEnd;
    private int yBeg;
    private int yEnd;
    private Function function;
    private UserEvent userEvent;
    private Group group;
    private static final int FUNCTION = 0;
    private static final int GROUP = 1;
    private static final int USEREVENT = 2;
    int elementType;

    public LedgerDataElement(Function function) {
        this.function = function;
        this.elementType = 0;
    }

    public LedgerDataElement(Group group) {
        this.group = group;
        this.elementType = 1;
    }

    public LedgerDataElement(UserEvent userEvent) {
        this.userEvent = userEvent;
        this.elementType = 2;
    }

    public Function getFunction() {
        return this.function;
    }

    public Group getGroup() {
        return this.group;
    }

    public UserEvent getUserEvent() {
        return this.userEvent;
    }

    public String getName() {
        if (this.elementType == 0) {
            return ParaProfUtils.getFunctionName(this.function);
        }
        if (this.elementType == 1) {
            return this.group.getName();
        }
        if (this.elementType == 2) {
            return this.userEvent.getName();
        }
        return null;
    }

    public boolean isHighlighted(ParaProfTrial paraProfTrial) {
        if (this.elementType == 0) {
            return paraProfTrial.getHighlightedFunction() == this.function;
        }
        if (this.elementType == 1) {
            return paraProfTrial.getHighlightedGroup() == this.group;
        }
        if (this.elementType == 2) {
            return paraProfTrial.getHighlightedUserEvent() == this.userEvent;
        }
        return false;
    }

    public Color getHighlightColor(ColorChooser colorChooser) {
        if (this.elementType == 0) {
            return colorChooser.getHighlightColor();
        }
        if (this.elementType == 1) {
            return colorChooser.getGroupHighlightColor();
        }
        if (this.elementType == 2) {
            return colorChooser.getUserEventHighlightColor();
        }
        return Color.black;
    }

    public void setDrawCoords(int n, int n2, int n3, int n4) {
        this.xBeg = n;
        this.xEnd = n2;
        this.yBeg = n3;
        this.yEnd = n4;
    }

    public int getXBeg() {
        return this.xBeg;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getYBeg() {
        return this.yBeg;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public Color getColor() {
        if (this.elementType == 0) {
            return this.function.getColor();
        }
        if (this.elementType == 1) {
            return this.group.getColor();
        }
        if (this.elementType == 2) {
            return this.userEvent.getColor();
        }
        return new Color(0, 0, 0);
    }

    public void setColorFlag(boolean bl) {
        if (this.elementType == 0) {
            this.function.setColorFlag(bl);
        } else if (this.elementType == 1) {
            this.group.setColorFlag(bl);
        } else if (this.elementType == 2) {
            this.userEvent.setColorFlag(bl);
        }
    }

    public boolean isColorFlagSet() {
        if (this.elementType == 0) {
            return this.function.isColorFlagSet();
        }
        if (this.elementType == 1) {
            return this.group.isColorFlagSet();
        }
        if (this.elementType == 2) {
            return this.userEvent.isColorFlagSet();
        }
        return false;
    }

    public void setSpecificColor(Color color) {
        if (this.elementType == 0) {
            this.function.setSpecificColor(color);
        } else if (this.elementType == 1) {
            this.group.setSpecificColor(color);
        } else if (this.elementType == 2) {
            this.userEvent.setSpecificColor(color);
        }
    }
}

