/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataSorter {
    private ParaProfTrial ppTrial = null;
    private double maxExclusiveSum = 0.0;
    private double[] maxExclusives;
    private int selectedMetricID;
    private boolean descendingOrder;
    private boolean showAsPercent;
    private SortType sortType = SortType.MEAN_VALUE;
    private ValueType valueType = ValueType.EXCLUSIVE;
    private UserEventValueType userEventValueType = UserEventValueType.NUMSAMPLES;

    public DataSorter(ParaProfTrial paraProfTrial) {
        this.ppTrial = paraProfTrial;
        this.selectedMetricID = paraProfTrial.getDefaultMetricID();
    }

    public UserEventValueType getUserEventValueType() {
        return this.userEventValueType;
    }

    public void setUserEventValueType(UserEventValueType userEventValueType) {
        this.userEventValueType = userEventValueType;
    }

    public boolean isTimeMetric() {
        String string = this.ppTrial.getMetricName(this.getSelectedMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.ppTrial.getMetric(this.getSelectedMetricID()).getDerivedMetric();
    }

    public void setSelectedMetricID(int n) {
        this.selectedMetricID = n;
    }

    public int getSelectedMetricID() {
        return this.selectedMetricID;
    }

    public void setDescendingOrder(boolean bl) {
        this.descendingOrder = bl;
    }

    public boolean getDescendingOrder() {
        return this.descendingOrder;
    }

    public void setShowAsPercent(boolean bl) {
        this.showAsPercent = bl;
    }

    public boolean getShowAsPercent() {
        return this.showAsPercent;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public List getUserEventProfiles(Thread thread) {
        UserEventProfile userEventProfile = null;
        List list = thread.getUserEventProfiles();
        ArrayList<PPUserEventProfile> arrayList = new ArrayList<PPUserEventProfile>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            userEventProfile = (UserEventProfile)iterator.next();
            if (userEventProfile == null) continue;
            PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this, thread, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getFunctionProfiles(Thread thread) {
        ArrayList<PPFunctionProfile> arrayList = null;
        List list = thread.getFunctionProfiles();
        arrayList = new ArrayList<PPFunctionProfile>();
        for (int i = 0; i < list.size(); ++i) {
            FunctionProfile functionProfile = (FunctionProfile)list.get(i);
            if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction())) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getAllFunctionProfiles() {
        Iterator iterator;
        PPThread pPThread;
        Thread thread;
        ArrayList<PPThread> arrayList = new ArrayList<PPThread>();
        if (this.ppTrial.getDataSource().getAllThreads().size() > 1) {
            PPFunctionProfile pPFunctionProfile;
            FunctionProfile functionProfile;
            thread = this.ppTrial.getDataSource().getStdDevData();
            pPThread = new PPThread(thread, this.ppTrial);
            iterator = thread.getFunctionProfiles().iterator();
            while (iterator.hasNext()) {
                functionProfile = (FunctionProfile)iterator.next();
                if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction())) continue;
                pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
                pPThread.addFunction(pPFunctionProfile);
            }
            Collections.sort(pPThread.getFunctionList());
            arrayList.add(pPThread);
            thread = this.ppTrial.getDataSource().getMeanData();
            pPThread = new PPThread(thread, this.ppTrial);
            iterator = thread.getFunctionProfiles().iterator();
            while (iterator.hasNext()) {
                functionProfile = (FunctionProfile)iterator.next();
                if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction())) continue;
                pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
                pPThread.addFunction(pPFunctionProfile);
            }
            Collections.sort(pPThread.getFunctionList());
            arrayList.add(pPThread);
        }
        this.maxExclusiveSum = 0.0;
        this.maxExclusives = new double[this.ppTrial.getDataSource().getNumFunctions()];
        iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            thread = (Thread)iterator.next();
            int n = 0;
            pPThread = new PPThread(thread, this.ppTrial);
            double d = 0.0;
            Iterator iterator2 = thread.getFunctionProfiles().iterator();
            while (iterator2.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator2.next();
                if (functionProfile == null || !this.ppTrial.displayFunction(functionProfile.getFunction())) continue;
                PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
                pPThread.addFunction(pPFunctionProfile);
                ++n;
                d += pPFunctionProfile.getExclusiveValue();
                this.maxExclusives[functionProfile.getFunction().getID()] = Math.max(this.maxExclusives[functionProfile.getFunction().getID()], pPFunctionProfile.getExclusiveValue());
            }
            if (d > this.maxExclusiveSum) {
                this.maxExclusiveSum = d;
            }
            if (n == 0) continue;
            Collections.sort(pPThread.getFunctionList());
            arrayList.add(pPThread);
        }
        return arrayList;
    }

    public List getFunctionData(Function function, boolean bl, boolean bl2) {
        Object object;
        Thread thread;
        FunctionProfile functionProfile;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.ppTrial.getDataSource().getAllThreads().size() > 1) {
            if (bl && (functionProfile = (thread = this.ppTrial.getDataSource().getMeanData()).getFunctionProfile(function)) != null) {
                object = new PPFunctionProfile(this, thread, functionProfile);
                arrayList.add(object);
            }
            if (bl2 && (functionProfile = (thread = this.ppTrial.getDataSource().getStdDevData()).getFunctionProfile(function)) != null) {
                object = new PPFunctionProfile(this, thread, functionProfile);
                arrayList.add(object);
            }
        }
        functionProfile = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (functionProfile.hasNext()) {
            thread = (Thread)functionProfile.next();
            object = thread.getFunctionProfile(function);
            if (object == null) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, (FunctionProfile)object);
            arrayList.add(pPFunctionProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List getUserEventData(UserEvent userEvent) {
        ArrayList<PPUserEventProfile> arrayList = new ArrayList<PPUserEventProfile>();
        Iterator iterator = this.ppTrial.getDataSource().getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent);
            if (userEventProfile == null) continue;
            PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this, thread, userEventProfile);
            arrayList.add(pPUserEventProfile);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public double getMaxExclusiveSum() {
        return this.maxExclusiveSum;
    }

    public double[] getMaxExclusives() {
        return this.maxExclusives;
    }
}

