echo off

rem    NOTE: All command line parameters will be passed on to nosetests
rem
rem    This script runs nosetests on all test subfolders;
rem    "coverage" is used to generate coverage data used by pycoverage.
rem    pycoverage generates a report in console window, then generates
rem    for each file tested an annotated version that shows which lines
rem    were missed; by diffing this across subversion commits, it is easy
rem    to determine what coverage has changed since last commit.
rem
rem    Oliver Schoenborn


set exepath=c:\python%1\scripts
echo Using %exepath% for Python interpreter
shift


echo.
echo.
echo 1. ######################## PUBSUB config #########################
echo.

pushd config_no_auto
%exepath%\nosetests --with-isolation --verbose
popd

echo.
echo.
echo 2. ######################## PUBSUB auto-v1 #########################
echo.

pushd config_autov1
%exepath%\nosetests --with-isolation --verbose
popd

echo.
echo.
echo 3. ######################## PUBSUB kwargs #########################
echo.

set tests=%1 %2 %3 %4 %5 %6 %7 %8 %9

pushd pubsub3_kwargs
%exepath%\nosetests --with-coverage %tests%
rem report on the coverage results
rem coverage -r -i -o test,raising
rem generate HTML report
%exepath%\coverage -b -i -d cover_html

popd


echo.
echo.
echo 4. ######################## PUBSUB arg1 #########################
echo.

pushd pubsub_arg1
%exepath%\nosetests  --with-coverage
%exepath%\coverage -b -i -d cover_html
popd

echo.
echo.
echo 4b. ##################### PUBSUB trans 1 to 3#######################
echo.

pushd trans1to3
%exepath%\nosetests --with-isolation
popd


echo.
echo.
echo 5. ######################## PUBSUB v1 (ie wx) ########################
echo.

pushd pubsub1
%exepath%\nosetests
popd

echo.
echo.
echo 6. ######################## PUBSUB v2 (kwargs 0) #########################
echo.

pushd pubsub2
%exepath%\nosetests
popd


