from pubsub import setupv2
from pubsub import pub as ps


def testAll():
    #ps.logToStdOut()

    # setup a static tree:
    class A(ps.Message):
        class B1(ps.Message):
            class C1(ps.Message):
                pass
        class B2(ps.Message):
            class C2(ps.Message):
                pass
    # parts (or all) can also be dynamic
    class D2(ps.Message):
        pass
    A.B2.C2.D2 = D2
    # setup chaining so messages go from most to least specific
    #save = set(locals().keys())
    ps.setupMsgTree(A, locals())
    #print set(locals().keys()) - save
    assert A.getType() == 'A'
    assert A.B1.C1.getType() == 'A.B1.C1'
    assert not A.B1.C1.hasListeners()
    assert not A.B1.C1.hasListenersAny()

    global callbackCalled
    callbackCalled = []
    def callback(msg):
        global callbackCalled
        if hasattr(msg, 'sender'):
            callbackCalled.append((msg.sender, msg.subTopic))
        else:
            callbackCalled.append((None, msg.subTopic))
        #print 'Msg type received:', MsgType.getType()

    # subscribe:
    assert not A.hasListeners()
    assert not A.B2.C2.hasListeners()
    ps.subscribe(callback, A,       id='callbacker2')
    assert not A.B2.C2.hasListeners()
    assert A.B2.C2.hasListenersAny()
    ps.subscribe(callback, A.B2.C2, id='callbacker1')
    assert A.B2.C2.hasListeners()
    assert A.hasListeners()
    assert not A.B2.hasListeners()
    # subscribe multiple times, change id last time:
    ps.subscribe(callback, A,       id='callbacker2')
    ps.subscribe(callback, A,       id='callbacker3')
    listeners = A.getListeners()
    assert len(listeners) == 1
    assert listeners[0].id == 'callbacker3'

    # send:
    callbackCalled = []
    A.B2.C2().send('sender1')
    assert callbackCalled == [(None, None), (None, A.B2.C2)]

    # subscribe on another branch:
    ps.subscribe(callback, A.B1.C1)
    assert not A.B1.hasListeners()

    # send another:
    callbackCalled = []
    ps.sendMessage(A.B1.C1(sender='sender'))
    assert callbackCalled == [('sender',None), ('sender', A.B1.C1)]

    # callbacks that generate exception:
    def callbackBad(MsgType, data=None):
        raise RuntimeError('test')

    ps.subscribe(callbackBad, A.B2, id='callbacker4')
    try:
        assert ps.sendMessage(A.B2.C2.D2(), id='bad'), "Didn't raise exception!"
    except ps.ListenerError, exc:
        assert len(exc.exceptions) == 1
        assert exc.exceptions[0].type is RuntimeError

    class Wrapper:
        def __init__(self, fn):
            self.fn = fn
        def __call__(self):
            pass

    ps.subscribe(Wrapper(callback), A, id='callbacker5')
    try:
        assert ps.sendMessage(A(), id='doa'), "Didn't raise exception!"
    except ps.ListenerError, exc:
        assert str(exc.exceptions[0].arg) \
            == 'Callback callbacker5 no longer exists (maybe it was wrapped?)'

    assert A.B1.C1.countListeners() == 1
    assert A.B1.C1.countAllListeners() == 3
    assert A.B1.C1.getListeners() == [ps.Listener(callback)]
    assert A.B1.C1.getAllListeners() == {
            'A':       [ps.Listener(callback), ps.Listener(Wrapper(callback))],
            'A.B1.C1': [ps.Listener(callback)]
        }
    A.B1.C1.unsubscribe(callback)
    A.B1.C1.clearSubscriptions()
