# pubsub has to load pub even if not asked by user
# because Publisher must NOT be a module but a singleton

def test_import():
    # this pretends to do what auto-load-v1 will do: first do setupv1,
    # which will import pub and publisher; then user says they want
    # version 3 in arg1 mode so unload v1 and prepare for when user
    # imports pub to load version 3.

    # "autoload"
    from pubsub import setupv1
    import pubsub
    assert  hasattr(pubsub, 'Publisher')

    # override
    from pubsub import setuparg1
    from pubsub import pub       # pubsub1 module OR
    assert not hasattr(pubsub, 'Publisher')

    assert pub.PUBSUB_VERSION == 3
