#!/bin/sh
set -e -u -x
version="$1"
uscan --no-conf --force-download --download-current-version --rename --verbose --destdir="$PWD" "${0%/*}"/../
tmpdir=$(mktemp -d -t task.get-orig-source.XXXXXX)
git clone -b "v$version" git://tasktools.org/task.git "$tmpdir/task"
tarfile="task_${version}.orig-test.tar"
git -c tar.umask=022 --git-dir="$tmpdir/task/.git/" archive "v$version" --prefix="task-$version-" test/ -o "$tarfile"
gzip -9 -n -f "$tarfile"
rm -rf "$tmpdir"

# vim:ts=4 sw=4 et
