//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2002, 2003, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_INPUT_REMOV_PREFI_H
#define COMMON_TAR_INPUT_REMOV_PREFI_H

#include <libtardy/rcstring.h>
#include <libtardy/tar/input/filter.h>

/**
  * The tar_input_filter_remove_prefix class is used to represent a
  * filter which removes a directory prefix from the file names in tar
  * archive file header.  If the filter isn't present, the file names
  * are unchanged.
  */
class tar_input_filter_remove_prefix:
    public tar_input_filter
{
public:
    /**
      * The destructor.
      */
    virtual ~tar_input_filter_remove_prefix();

    /**
      * The constructor.
      *
      * \param deeper
      *     The input stream the filter is to be applied to.
      * \param prefix
      *     The directory prefix to be removed from file names, if present.
      */
    tar_input_filter_remove_prefix(tar_input *deeper, const rcstring &prefix);

    // See base class for documentation.
    virtual int read_header(tar_header &);

private:
    /**
      * The prefix instance variable is used to remember the directory
      * prefix to be removed from file names in the tar arcive.
      */
    rcstring prefix;

    /**
      * The default constructor.  Do not use.
      */
    tar_input_filter_remove_prefix();

    /**
      * The copy constructor.  Do not use.
      */
    tar_input_filter_remove_prefix(const tar_input_filter_remove_prefix &);

    /**
      * The assignment operator.  Do not use.
      */
    tar_input_filter_remove_prefix &operator = (
        const tar_input_filter_remove_prefix &);
};

#endif // COMMON_TAR_INPUT_REMOV_PREFI_H
