//
// tardy - a tar post-processor
// Copyright (C) 2002, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/tar/input/filename.h>
#include <libtardy/tar/input/filenamelist.h>


tar_input_filenamelist::~tar_input_filenamelist()
{
    delete source;
    delete singleton;
}


tar_input_filenamelist::tar_input_filenamelist(filenamelist *arg) :
    source(arg),
    singleton(0)
{
}


tar_input *
tar_input_filenamelist::get_singleton()
    const
{
    if (!singleton)
    {
        rcstring line;
        if (!source->read_one_line(line))
            return 0;
        singleton = new tar_input_filename(line);
    }
    return singleton;
}


int
tar_input_filenamelist::read_header(tar_header &result)
{
    if (singleton)
    {
        delete singleton;
        singleton = 0;
    }
    tar_input *fp = get_singleton();
    return (fp ? fp->read_header(result) : 0);
}


int
tar_input_filenamelist::read_data(void *buffer, int buflen)
{
    tar_input *fp = get_singleton();
    if (!fp)
        return 0;
    return fp->read_data(buffer, buflen);
}


const char *
tar_input_filenamelist::filename()
    const
{
    return source->filename();
}
