//
//      srecord - manipulate eprom load files
//      Copyright (C) 2002, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#ifndef COMMON_TAR_INPUT_FILENAME_H
#define COMMON_TAR_INPUT_FILENAME_H

#include <libtardy/file/input.h>
#include <libtardy/tar/input.h>

/**
  * The tar_input_filename class is used to represent tar input from a
  * single file.
  */
class tar_input_filename:
        public tar_input
{
public:
        /**
          * The destructor.
          */
        virtual ~tar_input_filename();

        /**
          * The constructor.
          */
        tar_input_filename(const rcstring &);

        // see base class for documentation
        int read_data(void *, int);

        // see base class for documentation
        int read_header(tar_header &);

        // see base class for documentation
        const char *filename() const;

private:
        /**
          * The `name' instance variable is used to remember the name
          * of the file being read.
          */
        rcstring name;

        /**
          * The `length' instance variable is used to remember how many
          * bytes of input are to be read from the file.
          */
        int length;

        /**
          * The `source' instance variable is used to remember the input
          * file state (position, file descriptor, etc).
          */
        file_input *source;

        /**
          * The default constructor.
          */
        tar_input_filename();

        /**
          * The copy constructor.
          */
        tar_input_filename(const tar_input_filename &);

        /**
          * The assignment operator.
          */
        tar_input_filename &operator=(const tar_input_filename &);
};

#endif // COMMON_TAR_INPUT_FILENAME_H
