//
//      tardy - a tar post-processor
//      Copyright (C) 1998, 1999, 2003, 2008, 2009 Peter Miller
//
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 3 of the License, or
//      (at your option) any later version.
//
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//
//      You should have received a copy of the GNU General Public License
//      along with this program. If not, see
//      <http://www.gnu.org/licenses/>.
//

#include <libtardy/ac/unistd.h>
#include <libtardy/file/output/stdout.h>


file_output_stdout::~file_output_stdout()
{
    // nothing to do
}


file_output_stdout::file_output_stdout()
{
    // nothing to do
}


void
file_output_stdout::write(const void *buffer, int nbytes)
{
    int count = ::write(1, buffer, nbytes);
    if (count < 0)
        nfatal("write");
    if (count != nbytes)
        fatal("short write (gave %d, got %d)", nbytes, count);
}


const char *
file_output_stdout::filename()
    const
{
    return "standard output";
}
