/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999, 2001-2004 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate tar output tars
 */

#include <ac/assert.h>
#include <ac/string.h>

#include <error.h>
#include <tar/format.h>
#include <tar/output/tar_base.h>


tar_output_tar_base::~tar_output_tar_base()
{
    delete fp;
}


tar_output_tar_base::tar_output_tar_base(file_output *arg) :
    fp(arg),
    pos(0),
    block_size(TBLOCK * 20)
{
    assert(fp);
}


void
tar_output_tar_base::write_data(const void *buffer, int nbytes)
{
    fp->write(buffer, nbytes);
    pos += nbytes;
}


void
tar_output_tar_base::write_data_padding()
{
    static char padding[TBLOCK];
    int n = pos % TBLOCK;
    if (n)
	write_data(padding, TBLOCK - n);
}


const char *
tar_output_tar_base::filename()
    const
{
    return fp->filename();
}


void
tar_output_tar_base::write_archive_end()
{
    if ((pos % block_size) == 0)
	return;
    char buffer[TBLOCK];
    memset(buffer, 0, TBLOCK);
    for (;;)
    {
	write_data(buffer, TBLOCK);
	if ((pos % block_size) == 0)
	    break;
    }
}


void
tar_output_tar_base::set_block_size(long nbytes)
{
    if (nbytes <= 0 || (nbytes % TBLOCK != 0))
	block_size = TBLOCK * 20;
    else
	block_size = nbytes;
}
