#include <errno.h>
#include <limits.h>
#include <inttypes.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

/*
 * Autogenerated file, do not edit it!
 */


#include "cfg/warning.h"
#include "cfg/tarantool_box_cfg.h"
static int
cmpNameAtoms(NameAtom *a, NameAtom *b) {
	while(a && b) {
		if (strcasecmp(a->name, b->name) != 0)
			return 0;
		a = a->next;
		b = b->next;
	}
	return (a == NULL && b == NULL) ? 1 : 0;
}

void
init_tarantool_cfg(tarantool_cfg *c) {
	c->__confetti_flags = 0;

	c->username = NULL;
	c->local_hot_standby = false;
	c->bind_ipaddr = NULL;
	c->coredump = false;
	c->admin_port = 0;
	c->replication_port = 0;
	c->log_level = 0;
	c->slab_alloc_arena = 0;
	c->slab_alloc_minimal = 0;
	c->slab_alloc_factor = 0;
	c->work_dir = NULL;
	c->snap_dir = NULL;
	c->wal_dir = NULL;
	c->script_dir = NULL;
	c->pid_file = NULL;
	c->logger = NULL;
	c->logger_nonblock = false;
	c->io_collect_interval = 0;
	c->backlog = 0;
	c->readahead = 0;
	c->snap_io_rate_limit = 0;
	c->rows_per_wal = 0;
	c->wal_writer_inbox_size = 0;
	c->wal_mode = NULL;
	c->wal_fsync_delay = 0;
	c->wal_dir_rescan_delay = 0;
	c->panic_on_snap_error = false;
	c->panic_on_wal_error = false;
	c->primary_port = 0;
	c->secondary_port = 0;
	c->too_long_threshold = 0;
	c->custom_proc_title = NULL;
	c->memcached_port = 0;
	c->memcached_space = 0;
	c->memcached_expire = false;
	c->memcached_expire_per_loop = 0;
	c->memcached_expire_full_sweep = 0;
	c->replication_source = NULL;
	c->space = NULL;
}

int
fill_default_tarantool_cfg(tarantool_cfg *c) {
	c->__confetti_flags = 0;

	c->username = NULL;
	c->local_hot_standby = false;
	c->bind_ipaddr = strdup("INADDR_ANY");
	if (c->bind_ipaddr == NULL) return CNF_NOMEMORY;
	c->coredump = false;
	c->admin_port = 0;
	c->replication_port = 0;
	c->log_level = 5;
	c->slab_alloc_arena = 1;
	c->slab_alloc_minimal = 64;
	c->slab_alloc_factor = 2;
	c->work_dir = NULL;
	c->snap_dir = strdup(".");
	if (c->snap_dir == NULL) return CNF_NOMEMORY;
	c->wal_dir = strdup(".");
	if (c->wal_dir == NULL) return CNF_NOMEMORY;
	c->script_dir = strdup(".");
	if (c->script_dir == NULL) return CNF_NOMEMORY;
	c->pid_file = strdup("tarantool.pid");
	if (c->pid_file == NULL) return CNF_NOMEMORY;
	c->logger = NULL;
	c->logger_nonblock = true;
	c->io_collect_interval = 0;
	c->backlog = 1024;
	c->readahead = 16320;
	c->snap_io_rate_limit = 0;
	c->rows_per_wal = 500000;
	c->wal_writer_inbox_size = 16384;
	c->wal_mode = strdup("fsync_delay");
	if (c->wal_mode == NULL) return CNF_NOMEMORY;
	c->wal_fsync_delay = 0;
	c->wal_dir_rescan_delay = 0.1;
	c->panic_on_snap_error = true;
	c->panic_on_wal_error = false;
	c->primary_port = 0;
	c->secondary_port = 0;
	c->too_long_threshold = 0.5;
	c->custom_proc_title = NULL;
	c->memcached_port = 0;
	c->memcached_space = 23;
	c->memcached_expire = false;
	c->memcached_expire_per_loop = 1024;
	c->memcached_expire_full_sweep = 3600;
	c->replication_source = NULL;
	c->space = NULL;
	return 0;
}

void
swap_tarantool_cfg(struct tarantool_cfg *c1, struct tarantool_cfg *c2) {
	struct tarantool_cfg tmpcfg = *c1;
	*c1 = *c2;
	*c2 = tmpcfg;
}

static int
acceptDefault_name__space(tarantool_cfg_space *c) {
	c->enabled = -1;
	c->cardinality = -1;
	c->estimated_rows = 0;
	c->index = NULL;
	return 0;
}

static int
acceptDefault_name__space__index(tarantool_cfg_space_index *c) {
	c->type = strdup("");
	if (c->type == NULL) return CNF_NOMEMORY;
	c->unique = -1;
	c->key_field = NULL;
	return 0;
}

static int
acceptDefault_name__space__index__key_field(tarantool_cfg_space_index_key_field *c) {
	c->fieldno = -1;
	c->type = strdup("");
	if (c->type == NULL) return CNF_NOMEMORY;
	return 0;
}

static NameAtom _name__username[] = {
	{ "username", -1, NULL }
};
static NameAtom _name__local_hot_standby[] = {
	{ "local_hot_standby", -1, NULL }
};
static NameAtom _name__bind_ipaddr[] = {
	{ "bind_ipaddr", -1, NULL }
};
static NameAtom _name__coredump[] = {
	{ "coredump", -1, NULL }
};
static NameAtom _name__admin_port[] = {
	{ "admin_port", -1, NULL }
};
static NameAtom _name__replication_port[] = {
	{ "replication_port", -1, NULL }
};
static NameAtom _name__log_level[] = {
	{ "log_level", -1, NULL }
};
static NameAtom _name__slab_alloc_arena[] = {
	{ "slab_alloc_arena", -1, NULL }
};
static NameAtom _name__slab_alloc_minimal[] = {
	{ "slab_alloc_minimal", -1, NULL }
};
static NameAtom _name__slab_alloc_factor[] = {
	{ "slab_alloc_factor", -1, NULL }
};
static NameAtom _name__work_dir[] = {
	{ "work_dir", -1, NULL }
};
static NameAtom _name__snap_dir[] = {
	{ "snap_dir", -1, NULL }
};
static NameAtom _name__wal_dir[] = {
	{ "wal_dir", -1, NULL }
};
static NameAtom _name__script_dir[] = {
	{ "script_dir", -1, NULL }
};
static NameAtom _name__pid_file[] = {
	{ "pid_file", -1, NULL }
};
static NameAtom _name__logger[] = {
	{ "logger", -1, NULL }
};
static NameAtom _name__logger_nonblock[] = {
	{ "logger_nonblock", -1, NULL }
};
static NameAtom _name__io_collect_interval[] = {
	{ "io_collect_interval", -1, NULL }
};
static NameAtom _name__backlog[] = {
	{ "backlog", -1, NULL }
};
static NameAtom _name__readahead[] = {
	{ "readahead", -1, NULL }
};
static NameAtom _name__snap_io_rate_limit[] = {
	{ "snap_io_rate_limit", -1, NULL }
};
static NameAtom _name__rows_per_wal[] = {
	{ "rows_per_wal", -1, NULL }
};
static NameAtom _name__wal_writer_inbox_size[] = {
	{ "wal_writer_inbox_size", -1, NULL }
};
static NameAtom _name__wal_mode[] = {
	{ "wal_mode", -1, NULL }
};
static NameAtom _name__wal_fsync_delay[] = {
	{ "wal_fsync_delay", -1, NULL }
};
static NameAtom _name__wal_dir_rescan_delay[] = {
	{ "wal_dir_rescan_delay", -1, NULL }
};
static NameAtom _name__panic_on_snap_error[] = {
	{ "panic_on_snap_error", -1, NULL }
};
static NameAtom _name__panic_on_wal_error[] = {
	{ "panic_on_wal_error", -1, NULL }
};
static NameAtom _name__primary_port[] = {
	{ "primary_port", -1, NULL }
};
static NameAtom _name__secondary_port[] = {
	{ "secondary_port", -1, NULL }
};
static NameAtom _name__too_long_threshold[] = {
	{ "too_long_threshold", -1, NULL }
};
static NameAtom _name__custom_proc_title[] = {
	{ "custom_proc_title", -1, NULL }
};
static NameAtom _name__memcached_port[] = {
	{ "memcached_port", -1, NULL }
};
static NameAtom _name__memcached_space[] = {
	{ "memcached_space", -1, NULL }
};
static NameAtom _name__memcached_expire[] = {
	{ "memcached_expire", -1, NULL }
};
static NameAtom _name__memcached_expire_per_loop[] = {
	{ "memcached_expire_per_loop", -1, NULL }
};
static NameAtom _name__memcached_expire_full_sweep[] = {
	{ "memcached_expire_full_sweep", -1, NULL }
};
static NameAtom _name__replication_source[] = {
	{ "replication_source", -1, NULL }
};
static NameAtom _name__space[] = {
	{ "space", -1, NULL }
};
static NameAtom _name__space__enabled[] = {
	{ "space", -1, _name__space__enabled + 1 },
	{ "enabled", -1, NULL }
};
static NameAtom _name__space__cardinality[] = {
	{ "space", -1, _name__space__cardinality + 1 },
	{ "cardinality", -1, NULL }
};
static NameAtom _name__space__estimated_rows[] = {
	{ "space", -1, _name__space__estimated_rows + 1 },
	{ "estimated_rows", -1, NULL }
};
static NameAtom _name__space__index[] = {
	{ "space", -1, _name__space__index + 1 },
	{ "index", -1, NULL }
};
static NameAtom _name__space__index__type[] = {
	{ "space", -1, _name__space__index__type + 1 },
	{ "index", -1, _name__space__index__type + 2 },
	{ "type", -1, NULL }
};
static NameAtom _name__space__index__unique[] = {
	{ "space", -1, _name__space__index__unique + 1 },
	{ "index", -1, _name__space__index__unique + 2 },
	{ "unique", -1, NULL }
};
static NameAtom _name__space__index__key_field[] = {
	{ "space", -1, _name__space__index__key_field + 1 },
	{ "index", -1, _name__space__index__key_field + 2 },
	{ "key_field", -1, NULL }
};
static NameAtom _name__space__index__key_field__fieldno[] = {
	{ "space", -1, _name__space__index__key_field__fieldno + 1 },
	{ "index", -1, _name__space__index__key_field__fieldno + 2 },
	{ "key_field", -1, _name__space__index__key_field__fieldno + 3 },
	{ "fieldno", -1, NULL }
};
static NameAtom _name__space__index__key_field__type[] = {
	{ "space", -1, _name__space__index__key_field__type + 1 },
	{ "index", -1, _name__space__index__key_field__type + 2 },
	{ "key_field", -1, _name__space__index__key_field__type + 3 },
	{ "type", -1, NULL }
};

#define ARRAYALLOC(x,n,t,_chk_ro, __flags)  do {                    \
   int l = 0, ar;                                                   \
   __typeof__(x) y = (x), t;                                        \
   if ( (n) <= 0 ) return CNF_WRONGINDEX; /* wrong index */         \
   while(y && *y) {                                                 \
       l++; y++;                                                    \
   }                                                                \
   if ( (n) >= (l + 1) ) {                                          \
      if (_chk_ro)  return CNF_RDONLY;                              \
      if ( (x) == NULL )                                            \
          t = y = malloc( ((n)+1) * sizeof( __typeof__(*(x))) );    \
      else {                                                        \
          t = realloc((x), ((n)+1) * sizeof( __typeof__(*(x))) );   \
          y = t + l;                                                \
      }                                                             \
      if (t == NULL)  return CNF_NOMEMORY;                          \
      (x) = t;                                                      \
      memset(y, 0, (((n)+1) - l) * sizeof( __typeof__(*(x))) );     \
      while ( y - (x) < (n) ) {                                     \
          *y = malloc( sizeof( __typeof__(**(x))) );                \
          if (*y == NULL)  return CNF_NOMEMORY;                     \
          if ( (ar = acceptDefault##t(*y)) != 0 ) return ar;        \
          (*y)->__confetti_flags = __flags;                         \
          y++;                                                      \
      }                                                             \
   }                                                                \
} while(0)

int
confetti_strcmp(char *s1, char *s2);

static ConfettyError
acceptValue(tarantool_cfg* c, OptDef* opt, int check_rdonly) {

	if ( cmpNameAtoms( opt->name, _name__username) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->username == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->username) != 0))
			return CNF_RDONLY;
		if (c->username) free(c->username);
		c->username = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->username == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__local_hot_standby) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->local_hot_standby != bln)
			return CNF_RDONLY;
		c->local_hot_standby = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__bind_ipaddr) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->bind_ipaddr == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->bind_ipaddr) != 0))
			return CNF_RDONLY;
		if (c->bind_ipaddr) free(c->bind_ipaddr);
		c->bind_ipaddr = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->bind_ipaddr == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__coredump) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->coredump != bln)
			return CNF_RDONLY;
		c->coredump = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__admin_port) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->admin_port != i32)
			return CNF_RDONLY;
		c->admin_port = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__replication_port) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->replication_port != i32)
			return CNF_RDONLY;
		c->replication_port = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__log_level) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->log_level = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__slab_alloc_arena) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->slab_alloc_arena != dbl)
			return CNF_RDONLY;
		c->slab_alloc_arena = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__slab_alloc_minimal) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->slab_alloc_minimal != i32)
			return CNF_RDONLY;
		c->slab_alloc_minimal = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__slab_alloc_factor) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->slab_alloc_factor != dbl)
			return CNF_RDONLY;
		c->slab_alloc_factor = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__work_dir) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->work_dir == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->work_dir) != 0))
			return CNF_RDONLY;
		if (c->work_dir) free(c->work_dir);
		c->work_dir = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->work_dir == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__snap_dir) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->snap_dir == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->snap_dir) != 0))
			return CNF_RDONLY;
		if (c->snap_dir) free(c->snap_dir);
		c->snap_dir = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->snap_dir == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__wal_dir) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->wal_dir == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->wal_dir) != 0))
			return CNF_RDONLY;
		if (c->wal_dir) free(c->wal_dir);
		c->wal_dir = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->wal_dir == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__script_dir) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->script_dir == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->script_dir) != 0))
			return CNF_RDONLY;
		if (c->script_dir) free(c->script_dir);
		c->script_dir = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->script_dir == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__pid_file) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->pid_file == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->pid_file) != 0))
			return CNF_RDONLY;
		if (c->pid_file) free(c->pid_file);
		c->pid_file = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->pid_file == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__logger) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->logger == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->logger) != 0))
			return CNF_RDONLY;
		if (c->logger) free(c->logger);
		c->logger = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->logger == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__logger_nonblock) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->logger_nonblock != bln)
			return CNF_RDONLY;
		c->logger_nonblock = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__io_collect_interval) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->io_collect_interval = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__backlog) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->backlog != i32)
			return CNF_RDONLY;
		c->backlog = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__readahead) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->readahead = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__snap_io_rate_limit) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->snap_io_rate_limit = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__rows_per_wal) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->rows_per_wal != i32)
			return CNF_RDONLY;
		c->rows_per_wal = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__wal_writer_inbox_size) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->wal_writer_inbox_size != i32)
			return CNF_RDONLY;
		c->wal_writer_inbox_size = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__wal_mode) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (c->wal_mode) free(c->wal_mode);
		c->wal_mode = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->wal_mode == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__wal_fsync_delay) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->wal_fsync_delay = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__wal_dir_rescan_delay) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->wal_dir_rescan_delay != dbl)
			return CNF_RDONLY;
		c->wal_dir_rescan_delay = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__panic_on_snap_error) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->panic_on_snap_error != bln)
			return CNF_RDONLY;
		c->panic_on_snap_error = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__panic_on_wal_error) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->panic_on_wal_error != bln)
			return CNF_RDONLY;
		c->panic_on_wal_error = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__primary_port) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->primary_port != i32)
			return CNF_RDONLY;
		c->primary_port = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__secondary_port) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->secondary_port != i32)
			return CNF_RDONLY;
		c->secondary_port = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__too_long_threshold) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->too_long_threshold = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__custom_proc_title) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->custom_proc_title == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->custom_proc_title) != 0))
			return CNF_RDONLY;
		if (c->custom_proc_title) free(c->custom_proc_title);
		c->custom_proc_title = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->custom_proc_title == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__memcached_port) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->memcached_port != i32)
			return CNF_RDONLY;
		c->memcached_port = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__memcached_space) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->memcached_space != i32)
			return CNF_RDONLY;
		c->memcached_space = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__memcached_expire) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->memcached_expire != bln)
			return CNF_RDONLY;
		c->memcached_expire = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__memcached_expire_per_loop) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->memcached_expire_per_loop = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__memcached_expire_full_sweep) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		double dbl = strtod(opt->paramValue.scalarval, NULL);
		if ( (dbl == 0 || dbl == -HUGE_VAL || dbl == HUGE_VAL) && errno == ERANGE)
			return CNF_WRONGRANGE;
		c->memcached_expire_full_sweep = dbl;
	}
	else if ( cmpNameAtoms( opt->name, _name__replication_source) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		c->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (c->replication_source) free(c->replication_source);
		c->replication_source = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->replication_source == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__space) ) {
		if (opt->paramType != arrayType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
	}
	else if ( cmpNameAtoms( opt->name, _name__space__enabled) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->space[opt->name->index]->enabled != bln)
			return CNF_RDONLY;
		c->space[opt->name->index]->enabled = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__space__cardinality) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->space[opt->name->index]->cardinality != i32)
			return CNF_RDONLY;
		c->space[opt->name->index]->cardinality = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__space__estimated_rows) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->space[opt->name->index]->estimated_rows != i32)
			return CNF_RDONLY;
		c->space[opt->name->index]->estimated_rows = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__space__index) ) {
		if (opt->paramType != arrayType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index, 1, _name__space__index, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
	}
	else if ( cmpNameAtoms( opt->name, _name__space__index__type) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index, opt->name->next->index + 1, _name__space__index, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->space[opt->name->index]->index[opt->name->next->index]->type == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->space[opt->name->index]->index[opt->name->next->index]->type) != 0))
			return CNF_RDONLY;
		if (c->space[opt->name->index]->index[opt->name->next->index]->type) free(c->space[opt->name->index]->index[opt->name->next->index]->type);
		c->space[opt->name->index]->index[opt->name->next->index]->type = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->space[opt->name->index]->index[opt->name->next->index]->type == NULL)
			return CNF_NOMEMORY;
	}
	else if ( cmpNameAtoms( opt->name, _name__space__index__unique) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index, opt->name->next->index + 1, _name__space__index, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		bool bln;

		if (strcasecmp(opt->paramValue.scalarval, "true") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "yes") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "enable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "on") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "1") == 0 )
			bln = true;
		else if (strcasecmp(opt->paramValue.scalarval, "false") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "no") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "disable") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "off") == 0 ||
				strcasecmp(opt->paramValue.scalarval, "0") == 0 )
			bln = false;
		else
			return CNF_WRONGRANGE;
		if (check_rdonly && c->space[opt->name->index]->index[opt->name->next->index]->unique != bln)
			return CNF_RDONLY;
		c->space[opt->name->index]->index[opt->name->next->index]->unique = bln;
	}
	else if ( cmpNameAtoms( opt->name, _name__space__index__key_field) ) {
		if (opt->paramType != arrayType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index, opt->name->next->index + 1, _name__space__index, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index[opt->name->next->index]->key_field, 1, _name__space__index__key_field, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
	}
	else if ( cmpNameAtoms( opt->name, _name__space__index__key_field__fieldno) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index, opt->name->next->index + 1, _name__space__index, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index[opt->name->next->index]->key_field, opt->name->next->next->index + 1, _name__space__index__key_field, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		long int i32 = strtol(opt->paramValue.scalarval, NULL, 10);
		if (i32 == 0 && errno == EINVAL)
			return CNF_WRONGINT;
		if ( (i32 == LONG_MIN || i32 == LONG_MAX) && errno == ERANGE)
			return CNF_WRONGRANGE;
		if (check_rdonly && c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->fieldno != i32)
			return CNF_RDONLY;
		c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->fieldno = i32;
	}
	else if ( cmpNameAtoms( opt->name, _name__space__index__key_field__type) ) {
		if (opt->paramType != scalarType )
			return CNF_WRONGTYPE;
		ARRAYALLOC(c->space, opt->name->index + 1, _name__space, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index, opt->name->next->index + 1, _name__space__index, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->index[opt->name->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		ARRAYALLOC(c->space[opt->name->index]->index[opt->name->next->index]->key_field, opt->name->next->next->index + 1, _name__space__index__key_field, check_rdonly, CNF_FLAG_STRUCT_NEW | CNF_FLAG_STRUCT_NOTSET);
		if (c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->__confetti_flags & CNF_FLAG_STRUCT_NEW)
			check_rdonly = 0;
		c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NOTSET;
		errno = 0;
		if (check_rdonly && ( (opt->paramValue.scalarval == NULL && c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->type == NULL) || confetti_strcmp(opt->paramValue.scalarval, c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->type) != 0))
			return CNF_RDONLY;
		if (c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->type) free(c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->type);
		c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->type = (opt->paramValue.scalarval) ? strdup(opt->paramValue.scalarval) : NULL;
		if (opt->paramValue.scalarval && c->space[opt->name->index]->index[opt->name->next->index]->key_field[opt->name->next->next->index]->type == NULL)
			return CNF_NOMEMORY;
	}
	else {
		return opt->optional ? CNF_OPTIONAL : CNF_MISSED;
	}
	return CNF_OK;
}

static void cleanFlags(tarantool_cfg* c, OptDef* opt);

#define PRINTBUFLEN	8192
static char*
dumpOptDef(NameAtom *atom) {
	static char	buf[PRINTBUFLEN], *ptr;
	int  i = 0;

	ptr = buf;
	while(atom) {
		if (i) ptr += snprintf(ptr, PRINTBUFLEN - 1 - (ptr - buf), ".");
		ptr += snprintf(ptr, PRINTBUFLEN - 1 - (ptr - buf), "%s", atom->name);
		if (atom->index >= 0)
			ptr += snprintf(ptr, PRINTBUFLEN - 1 - (ptr - buf), "[%d]", atom->index);
		i = 1;
		atom = atom->next;
	}
	return buf;
}

static void
acceptCfgDef(tarantool_cfg *c, OptDef *opt, int check_rdonly, int *n_accepted, int *n_skipped, int *n_optional) {
	ConfettyError	r;
	OptDef		*orig_opt = opt;

	while(opt) {
		r = acceptValue(c, opt, check_rdonly);
		switch(r) {
			case CNF_OK:
				if (n_accepted) (*n_accepted)++;
				break;
			case CNF_OPTIONAL:
				out_warning(r, "Option '%s' is not supported", dumpOptDef(opt->name));
				if (n_optional) (*n_optional)++;
				break;
			case CNF_MISSED:
				out_warning(r, "Could not find '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			case CNF_WRONGTYPE:
				out_warning(r, "Wrong value type for '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			case CNF_WRONGINDEX:
				out_warning(r, "Wrong array index in '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			case CNF_RDONLY:
				out_warning(r, "Could not accept read only '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			case CNF_WRONGINT:
				out_warning(r, "Could not parse integer value for '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			case CNF_WRONGRANGE:
				out_warning(r, "Wrong range for '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			case CNF_NOMEMORY:
				out_warning(r, "Not enough memory to accept '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			case CNF_NOTSET:
				out_warning(r, "Option '%s' is not set (or has a default value)", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
			default:
				out_warning(r, "Unknown error for '%s' option", dumpOptDef(opt->name));
				if (n_skipped) (*n_skipped)++;
				break;
		}

		opt = opt->next;
	}

	cleanFlags(c, orig_opt);
}

int
parse_cfg_file_tarantool_cfg(tarantool_cfg *c, FILE *fh, int check_rdonly, int *n_accepted, int *n_skipped, int *n_optional) {
	int error;
	OptDef *option = parseCfgDef(fh, &error);
	if (n_accepted) *n_accepted=0;
	if (n_skipped) *n_skipped=0;
	if (n_optional) *n_optional=0;
	if (option == NULL)
		return error ? -1 : 0;
	acceptCfgDef(c, option, check_rdonly, n_accepted, n_skipped, n_optional);
	freeCfgDef(option);
	return 0;
}

int
parse_cfg_buffer_tarantool_cfg(tarantool_cfg *c, char *buffer, int check_rdonly, int *n_accepted, int *n_skipped, int *n_optional) {
	int error;
	OptDef *option = parseCfgDefBuffer(buffer, &error);
	if (n_accepted) *n_accepted=0;
	if (n_skipped) *n_skipped=0;
	if (n_optional) *n_optional=0;
	if (option == NULL)
		return error ? -1 : 0;
	acceptCfgDef(c, option, check_rdonly, n_accepted, n_skipped, n_optional);
	freeCfgDef(option);
	return 0;
}

/************** Iterator **************/
typedef enum IteratorState {
	_S_Initial = 0,
	S_name__username,
	S_name__local_hot_standby,
	S_name__bind_ipaddr,
	S_name__coredump,
	S_name__admin_port,
	S_name__replication_port,
	S_name__log_level,
	S_name__slab_alloc_arena,
	S_name__slab_alloc_minimal,
	S_name__slab_alloc_factor,
	S_name__work_dir,
	S_name__snap_dir,
	S_name__wal_dir,
	S_name__script_dir,
	S_name__pid_file,
	S_name__logger,
	S_name__logger_nonblock,
	S_name__io_collect_interval,
	S_name__backlog,
	S_name__readahead,
	S_name__snap_io_rate_limit,
	S_name__rows_per_wal,
	S_name__wal_writer_inbox_size,
	S_name__wal_mode,
	S_name__wal_fsync_delay,
	S_name__wal_dir_rescan_delay,
	S_name__panic_on_snap_error,
	S_name__panic_on_wal_error,
	S_name__primary_port,
	S_name__secondary_port,
	S_name__too_long_threshold,
	S_name__custom_proc_title,
	S_name__memcached_port,
	S_name__memcached_space,
	S_name__memcached_expire,
	S_name__memcached_expire_per_loop,
	S_name__memcached_expire_full_sweep,
	S_name__replication_source,
	S_name__space,
	S_name__space__enabled,
	S_name__space__cardinality,
	S_name__space__estimated_rows,
	S_name__space__index,
	S_name__space__index__type,
	S_name__space__index__unique,
	S_name__space__index__key_field,
	S_name__space__index__key_field__fieldno,
	S_name__space__index__key_field__type,
	_S_Finished
} IteratorState;

struct tarantool_cfg_iterator_t {
	IteratorState	state;
	int	idx_name__space;
	int	idx_name__space__index;
	int	idx_name__space__index__key_field;
};

tarantool_cfg_iterator_t*
tarantool_cfg_iterator_init() {
	tarantool_cfg_iterator_t *i = malloc(sizeof(*i));
	if (i == NULL) return NULL;
	memset(i, 0, sizeof(*i));
	return i;
}

char*
tarantool_cfg_iterator_next(tarantool_cfg_iterator_t* i, tarantool_cfg *c, char **v) {
	static char	buf[PRINTBUFLEN];

	*v = NULL;
	goto again; /* keep compiler quiet */
again:
	switch(i->state) {
		case _S_Initial:
		case S_name__username:
			*v = (c->username) ? strdup(c->username) : NULL;
			if (*v == NULL && c->username) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "username");
			i->state = S_name__local_hot_standby;
			return buf;
		case S_name__local_hot_standby:
			*v = malloc(8);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%s", c->local_hot_standby ? "true" : "false");
			snprintf(buf, PRINTBUFLEN-1, "local_hot_standby");
			i->state = S_name__bind_ipaddr;
			return buf;
		case S_name__bind_ipaddr:
			*v = (c->bind_ipaddr) ? strdup(c->bind_ipaddr) : NULL;
			if (*v == NULL && c->bind_ipaddr) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "bind_ipaddr");
			i->state = S_name__coredump;
			return buf;
		case S_name__coredump:
			*v = malloc(8);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%s", c->coredump ? "true" : "false");
			snprintf(buf, PRINTBUFLEN-1, "coredump");
			i->state = S_name__admin_port;
			return buf;
		case S_name__admin_port:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->admin_port);
			snprintf(buf, PRINTBUFLEN-1, "admin_port");
			i->state = S_name__replication_port;
			return buf;
		case S_name__replication_port:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->replication_port);
			snprintf(buf, PRINTBUFLEN-1, "replication_port");
			i->state = S_name__log_level;
			return buf;
		case S_name__log_level:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->log_level);
			snprintf(buf, PRINTBUFLEN-1, "log_level");
			i->state = S_name__slab_alloc_arena;
			return buf;
		case S_name__slab_alloc_arena:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->slab_alloc_arena);
			snprintf(buf, PRINTBUFLEN-1, "slab_alloc_arena");
			i->state = S_name__slab_alloc_minimal;
			return buf;
		case S_name__slab_alloc_minimal:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->slab_alloc_minimal);
			snprintf(buf, PRINTBUFLEN-1, "slab_alloc_minimal");
			i->state = S_name__slab_alloc_factor;
			return buf;
		case S_name__slab_alloc_factor:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->slab_alloc_factor);
			snprintf(buf, PRINTBUFLEN-1, "slab_alloc_factor");
			i->state = S_name__work_dir;
			return buf;
		case S_name__work_dir:
			*v = (c->work_dir) ? strdup(c->work_dir) : NULL;
			if (*v == NULL && c->work_dir) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "work_dir");
			i->state = S_name__snap_dir;
			return buf;
		case S_name__snap_dir:
			*v = (c->snap_dir) ? strdup(c->snap_dir) : NULL;
			if (*v == NULL && c->snap_dir) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "snap_dir");
			i->state = S_name__wal_dir;
			return buf;
		case S_name__wal_dir:
			*v = (c->wal_dir) ? strdup(c->wal_dir) : NULL;
			if (*v == NULL && c->wal_dir) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "wal_dir");
			i->state = S_name__script_dir;
			return buf;
		case S_name__script_dir:
			*v = (c->script_dir) ? strdup(c->script_dir) : NULL;
			if (*v == NULL && c->script_dir) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "script_dir");
			i->state = S_name__pid_file;
			return buf;
		case S_name__pid_file:
			*v = (c->pid_file) ? strdup(c->pid_file) : NULL;
			if (*v == NULL && c->pid_file) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "pid_file");
			i->state = S_name__logger;
			return buf;
		case S_name__logger:
			*v = (c->logger) ? strdup(c->logger) : NULL;
			if (*v == NULL && c->logger) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "logger");
			i->state = S_name__logger_nonblock;
			return buf;
		case S_name__logger_nonblock:
			*v = malloc(8);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%s", c->logger_nonblock ? "true" : "false");
			snprintf(buf, PRINTBUFLEN-1, "logger_nonblock");
			i->state = S_name__io_collect_interval;
			return buf;
		case S_name__io_collect_interval:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->io_collect_interval);
			snprintf(buf, PRINTBUFLEN-1, "io_collect_interval");
			i->state = S_name__backlog;
			return buf;
		case S_name__backlog:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->backlog);
			snprintf(buf, PRINTBUFLEN-1, "backlog");
			i->state = S_name__readahead;
			return buf;
		case S_name__readahead:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->readahead);
			snprintf(buf, PRINTBUFLEN-1, "readahead");
			i->state = S_name__snap_io_rate_limit;
			return buf;
		case S_name__snap_io_rate_limit:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->snap_io_rate_limit);
			snprintf(buf, PRINTBUFLEN-1, "snap_io_rate_limit");
			i->state = S_name__rows_per_wal;
			return buf;
		case S_name__rows_per_wal:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->rows_per_wal);
			snprintf(buf, PRINTBUFLEN-1, "rows_per_wal");
			i->state = S_name__wal_writer_inbox_size;
			return buf;
		case S_name__wal_writer_inbox_size:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->wal_writer_inbox_size);
			snprintf(buf, PRINTBUFLEN-1, "wal_writer_inbox_size");
			i->state = S_name__wal_mode;
			return buf;
		case S_name__wal_mode:
			*v = (c->wal_mode) ? strdup(c->wal_mode) : NULL;
			if (*v == NULL && c->wal_mode) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "wal_mode");
			i->state = S_name__wal_fsync_delay;
			return buf;
		case S_name__wal_fsync_delay:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->wal_fsync_delay);
			snprintf(buf, PRINTBUFLEN-1, "wal_fsync_delay");
			i->state = S_name__wal_dir_rescan_delay;
			return buf;
		case S_name__wal_dir_rescan_delay:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->wal_dir_rescan_delay);
			snprintf(buf, PRINTBUFLEN-1, "wal_dir_rescan_delay");
			i->state = S_name__panic_on_snap_error;
			return buf;
		case S_name__panic_on_snap_error:
			*v = malloc(8);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%s", c->panic_on_snap_error ? "true" : "false");
			snprintf(buf, PRINTBUFLEN-1, "panic_on_snap_error");
			i->state = S_name__panic_on_wal_error;
			return buf;
		case S_name__panic_on_wal_error:
			*v = malloc(8);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%s", c->panic_on_wal_error ? "true" : "false");
			snprintf(buf, PRINTBUFLEN-1, "panic_on_wal_error");
			i->state = S_name__primary_port;
			return buf;
		case S_name__primary_port:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->primary_port);
			snprintf(buf, PRINTBUFLEN-1, "primary_port");
			i->state = S_name__secondary_port;
			return buf;
		case S_name__secondary_port:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->secondary_port);
			snprintf(buf, PRINTBUFLEN-1, "secondary_port");
			i->state = S_name__too_long_threshold;
			return buf;
		case S_name__too_long_threshold:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->too_long_threshold);
			snprintf(buf, PRINTBUFLEN-1, "too_long_threshold");
			i->state = S_name__custom_proc_title;
			return buf;
		case S_name__custom_proc_title:
			*v = (c->custom_proc_title) ? strdup(c->custom_proc_title) : NULL;
			if (*v == NULL && c->custom_proc_title) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "custom_proc_title");
			i->state = S_name__memcached_port;
			return buf;
		case S_name__memcached_port:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->memcached_port);
			snprintf(buf, PRINTBUFLEN-1, "memcached_port");
			i->state = S_name__memcached_space;
			return buf;
		case S_name__memcached_space:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->memcached_space);
			snprintf(buf, PRINTBUFLEN-1, "memcached_space");
			i->state = S_name__memcached_expire;
			return buf;
		case S_name__memcached_expire:
			*v = malloc(8);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%s", c->memcached_expire ? "true" : "false");
			snprintf(buf, PRINTBUFLEN-1, "memcached_expire");
			i->state = S_name__memcached_expire_per_loop;
			return buf;
		case S_name__memcached_expire_per_loop:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%"PRId32, c->memcached_expire_per_loop);
			snprintf(buf, PRINTBUFLEN-1, "memcached_expire_per_loop");
			i->state = S_name__memcached_expire_full_sweep;
			return buf;
		case S_name__memcached_expire_full_sweep:
			*v = malloc(32);
			if (*v == NULL) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			sprintf(*v, "%g", c->memcached_expire_full_sweep);
			snprintf(buf, PRINTBUFLEN-1, "memcached_expire_full_sweep");
			i->state = S_name__replication_source;
			return buf;
		case S_name__replication_source:
			*v = (c->replication_source) ? strdup(c->replication_source) : NULL;
			if (*v == NULL && c->replication_source) {
				free(i);
				out_warning(CNF_NOMEMORY, "No memory to output value");
				return NULL;
			}
			snprintf(buf, PRINTBUFLEN-1, "replication_source");
			i->state = S_name__space;
			return buf;
		case S_name__space:
			i->state = S_name__space;
		case S_name__space__enabled:
		case S_name__space__cardinality:
		case S_name__space__estimated_rows:
		case S_name__space__index:
		case S_name__space__index__type:
		case S_name__space__index__unique:
		case S_name__space__index__key_field:
		case S_name__space__index__key_field__fieldno:
		case S_name__space__index__key_field__type:
			if (c->space && c->space[i->idx_name__space]) {
				switch(i->state) {
					case S_name__space:
					case S_name__space__enabled:
						*v = malloc(8);
						if (*v == NULL) {
							free(i);
							out_warning(CNF_NOMEMORY, "No memory to output value");
							return NULL;
						}
						sprintf(*v, "%s", c->space[i->idx_name__space]->enabled == -1 ? "false" : c->space[i->idx_name__space]->enabled ? "true" : "false");
						snprintf(buf, PRINTBUFLEN-1, "space[%d].enabled", i->idx_name__space);
						i->state = S_name__space__cardinality;
						return buf;
					case S_name__space__cardinality:
						*v = malloc(32);
						if (*v == NULL) {
							free(i);
							out_warning(CNF_NOMEMORY, "No memory to output value");
							return NULL;
						}
						sprintf(*v, "%"PRId32, c->space[i->idx_name__space]->cardinality);
						snprintf(buf, PRINTBUFLEN-1, "space[%d].cardinality", i->idx_name__space);
						i->state = S_name__space__estimated_rows;
						return buf;
					case S_name__space__estimated_rows:
						*v = malloc(32);
						if (*v == NULL) {
							free(i);
							out_warning(CNF_NOMEMORY, "No memory to output value");
							return NULL;
						}
						sprintf(*v, "%"PRId32, c->space[i->idx_name__space]->estimated_rows);
						snprintf(buf, PRINTBUFLEN-1, "space[%d].estimated_rows", i->idx_name__space);
						i->state = S_name__space__index;
						return buf;
					case S_name__space__index:
						i->state = S_name__space__index;
					case S_name__space__index__type:
					case S_name__space__index__unique:
					case S_name__space__index__key_field:
					case S_name__space__index__key_field__fieldno:
					case S_name__space__index__key_field__type:
						if (c->space[i->idx_name__space]->index && c->space[i->idx_name__space]->index[i->idx_name__space__index]) {
							switch(i->state) {
								case S_name__space__index:
								case S_name__space__index__type:
									*v = (c->space[i->idx_name__space]->index[i->idx_name__space__index]->type) ? strdup(c->space[i->idx_name__space]->index[i->idx_name__space__index]->type) : NULL;
									if (*v == NULL && c->space[i->idx_name__space]->index[i->idx_name__space__index]->type) {
										free(i);
										out_warning(CNF_NOMEMORY, "No memory to output value");
										return NULL;
									}
									snprintf(buf, PRINTBUFLEN-1, "space[%d].index[%d].type", i->idx_name__space, i->idx_name__space__index);
									i->state = S_name__space__index__unique;
									return buf;
								case S_name__space__index__unique:
									*v = malloc(8);
									if (*v == NULL) {
										free(i);
										out_warning(CNF_NOMEMORY, "No memory to output value");
										return NULL;
									}
									sprintf(*v, "%s", c->space[i->idx_name__space]->index[i->idx_name__space__index]->unique == -1 ? "false" : c->space[i->idx_name__space]->index[i->idx_name__space__index]->unique ? "true" : "false");
									snprintf(buf, PRINTBUFLEN-1, "space[%d].index[%d].unique", i->idx_name__space, i->idx_name__space__index);
									i->state = S_name__space__index__key_field;
									return buf;
								case S_name__space__index__key_field:
									i->state = S_name__space__index__key_field;
								case S_name__space__index__key_field__fieldno:
								case S_name__space__index__key_field__type:
									if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field && c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]) {
										switch(i->state) {
											case S_name__space__index__key_field:
											case S_name__space__index__key_field__fieldno:
												*v = malloc(32);
												if (*v == NULL) {
													free(i);
													out_warning(CNF_NOMEMORY, "No memory to output value");
													return NULL;
												}
												sprintf(*v, "%"PRId32, c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->fieldno);
												snprintf(buf, PRINTBUFLEN-1, "space[%d].index[%d].key_field[%d].fieldno", i->idx_name__space, i->idx_name__space__index, i->idx_name__space__index__key_field);
												i->state = S_name__space__index__key_field__type;
												return buf;
											case S_name__space__index__key_field__type:
												*v = (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type) ? strdup(c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type) : NULL;
												if (*v == NULL && c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type) {
													free(i);
													out_warning(CNF_NOMEMORY, "No memory to output value");
													return NULL;
												}
												snprintf(buf, PRINTBUFLEN-1, "space[%d].index[%d].key_field[%d].type", i->idx_name__space, i->idx_name__space__index, i->idx_name__space__index__key_field);
												i->state = S_name__space__index__key_field;
												i->idx_name__space__index__key_field++;
												return buf;
											default:
												break;
										}
									}
									else {
										i->state = S_name__space__index;
										i->idx_name__space__index++;
										i->idx_name__space__index__key_field = 0;
										goto again;
									}
								default:
									break;
							}
						}
						else {
							i->state = S_name__space;
							i->idx_name__space++;
							i->idx_name__space__index = 0;
							i->idx_name__space__index__key_field = 0;
							goto again;
						}
					default:
						break;
				}
			}
		case _S_Finished:
			free(i);
			break;
		default:
			out_warning(CNF_INTERNALERROR, "Unknown state for tarantool_cfg_iterator_t: %d", i->state);
			free(i);
	}
	return NULL;
}

/************** Checking of required fields  **************/
int
check_cfg_tarantool_cfg(tarantool_cfg *c) {
	tarantool_cfg_iterator_t iterator, *i = &iterator;
	int	res = 0;

	if (c->primary_port == 0) {
		res++;
		out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__primary_port));
	}
	i->idx_name__space = 0;
	while (c->space && c->space[i->idx_name__space]) {
		if (c->space[i->idx_name__space]->__confetti_flags & CNF_FLAG_STRUCT_NOTSET) {
			(void)0;
		} else {
			if (c->space[i->idx_name__space]->enabled == -1) {
				res++;
				_name__space__enabled->index = i->idx_name__space;
				out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__space__enabled));
			}
			if (c->space[i->idx_name__space]->index == NULL) {
				res++;
				_name__space__index->index = i->idx_name__space;
				out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__space__index));
			}
			i->idx_name__space__index = 0;
			while (c->space[i->idx_name__space]->index && c->space[i->idx_name__space]->index[i->idx_name__space__index]) {
				if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->__confetti_flags & CNF_FLAG_STRUCT_NOTSET) {
					res++;
					_name__space__index->next->index = i->idx_name__space__index;
					_name__space__index->index = i->idx_name__space;
					out_warning(CNF_NOTSET, "Option '%s' is not set", dumpOptDef(_name__space__index));
				} else {
					if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->type != NULL && strcmp(c->space[i->idx_name__space]->index[i->idx_name__space__index]->type, "") == 0) {
						res++;
						_name__space__index__type->next->index = i->idx_name__space__index;
						_name__space__index__type->index = i->idx_name__space;
						out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__space__index__type));
					}
					if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->unique == -1) {
						res++;
						_name__space__index__unique->next->index = i->idx_name__space__index;
						_name__space__index__unique->index = i->idx_name__space;
						out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__space__index__unique));
					}
					if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field == NULL) {
						res++;
						_name__space__index__key_field->next->index = i->idx_name__space__index;
						_name__space__index__key_field->index = i->idx_name__space;
						out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__space__index__key_field));
					}
					i->idx_name__space__index__key_field = 0;
					while (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field && c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]) {
						if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->__confetti_flags & CNF_FLAG_STRUCT_NOTSET) {
							res++;
							_name__space__index__key_field->next->next->index = i->idx_name__space__index__key_field;
							_name__space__index__key_field->next->index = i->idx_name__space__index;
							_name__space__index__key_field->index = i->idx_name__space;
							out_warning(CNF_NOTSET, "Option '%s' is not set", dumpOptDef(_name__space__index__key_field));
						} else {
							if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->fieldno == -1) {
								res++;
								_name__space__index__key_field__fieldno->next->next->index = i->idx_name__space__index__key_field;
								_name__space__index__key_field__fieldno->next->index = i->idx_name__space__index;
								_name__space__index__key_field__fieldno->index = i->idx_name__space;
								out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__space__index__key_field__fieldno));
							}
							if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type != NULL && strcmp(c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type, "") == 0) {
								res++;
								_name__space__index__key_field__type->next->next->index = i->idx_name__space__index__key_field;
								_name__space__index__key_field__type->next->index = i->idx_name__space__index;
								_name__space__index__key_field__type->index = i->idx_name__space;
								out_warning(CNF_NOTSET, "Option '%s' is not set (or has a default value)", dumpOptDef(_name__space__index__key_field__type));
							}
						}

						i->idx_name__space__index__key_field++;
					}

				}

				i->idx_name__space__index++;
			}

		}

		i->idx_name__space++;
	}

	return res;
}

static void
cleanFlags(tarantool_cfg* c, OptDef* opt) {
	tarantool_cfg_iterator_t iterator, *i = &iterator;


	if (c->space != NULL) {
		i->idx_name__space = 0;
		while (c->space[i->idx_name__space] != NULL) {
			c->space[i->idx_name__space]->__confetti_flags &= ~CNF_FLAG_STRUCT_NEW;


			if (c->space[i->idx_name__space]->index != NULL) {
				i->idx_name__space__index = 0;
				while (c->space[i->idx_name__space]->index[i->idx_name__space__index] != NULL) {
					c->space[i->idx_name__space]->index[i->idx_name__space__index]->__confetti_flags &= ~CNF_FLAG_STRUCT_NEW;


					if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field != NULL) {
						i->idx_name__space__index__key_field = 0;
						while (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field] != NULL) {
							c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->__confetti_flags &= ~CNF_FLAG_STRUCT_NEW;


							i->idx_name__space__index__key_field++;
						}
					}

					i->idx_name__space__index++;
				}
			}

			i->idx_name__space++;
		}
	}
}

/************** Duplicate config  **************/

int
dup_tarantool_cfg(tarantool_cfg* dst, tarantool_cfg* src) {
	tarantool_cfg_iterator_t iterator, *i = &iterator;

	if (dst->username) free(dst->username);dst->username = src->username == NULL ? NULL : strdup(src->username);
	if (src->username != NULL && dst->username == NULL)
		return CNF_NOMEMORY;
	dst->local_hot_standby = src->local_hot_standby;
	if (dst->bind_ipaddr) free(dst->bind_ipaddr);dst->bind_ipaddr = src->bind_ipaddr == NULL ? NULL : strdup(src->bind_ipaddr);
	if (src->bind_ipaddr != NULL && dst->bind_ipaddr == NULL)
		return CNF_NOMEMORY;
	dst->coredump = src->coredump;
	dst->admin_port = src->admin_port;
	dst->replication_port = src->replication_port;
	dst->log_level = src->log_level;
	dst->slab_alloc_arena = src->slab_alloc_arena;
	dst->slab_alloc_minimal = src->slab_alloc_minimal;
	dst->slab_alloc_factor = src->slab_alloc_factor;
	if (dst->work_dir) free(dst->work_dir);dst->work_dir = src->work_dir == NULL ? NULL : strdup(src->work_dir);
	if (src->work_dir != NULL && dst->work_dir == NULL)
		return CNF_NOMEMORY;
	if (dst->snap_dir) free(dst->snap_dir);dst->snap_dir = src->snap_dir == NULL ? NULL : strdup(src->snap_dir);
	if (src->snap_dir != NULL && dst->snap_dir == NULL)
		return CNF_NOMEMORY;
	if (dst->wal_dir) free(dst->wal_dir);dst->wal_dir = src->wal_dir == NULL ? NULL : strdup(src->wal_dir);
	if (src->wal_dir != NULL && dst->wal_dir == NULL)
		return CNF_NOMEMORY;
	if (dst->script_dir) free(dst->script_dir);dst->script_dir = src->script_dir == NULL ? NULL : strdup(src->script_dir);
	if (src->script_dir != NULL && dst->script_dir == NULL)
		return CNF_NOMEMORY;
	if (dst->pid_file) free(dst->pid_file);dst->pid_file = src->pid_file == NULL ? NULL : strdup(src->pid_file);
	if (src->pid_file != NULL && dst->pid_file == NULL)
		return CNF_NOMEMORY;
	if (dst->logger) free(dst->logger);dst->logger = src->logger == NULL ? NULL : strdup(src->logger);
	if (src->logger != NULL && dst->logger == NULL)
		return CNF_NOMEMORY;
	dst->logger_nonblock = src->logger_nonblock;
	dst->io_collect_interval = src->io_collect_interval;
	dst->backlog = src->backlog;
	dst->readahead = src->readahead;
	dst->snap_io_rate_limit = src->snap_io_rate_limit;
	dst->rows_per_wal = src->rows_per_wal;
	dst->wal_writer_inbox_size = src->wal_writer_inbox_size;
	if (dst->wal_mode) free(dst->wal_mode);dst->wal_mode = src->wal_mode == NULL ? NULL : strdup(src->wal_mode);
	if (src->wal_mode != NULL && dst->wal_mode == NULL)
		return CNF_NOMEMORY;
	dst->wal_fsync_delay = src->wal_fsync_delay;
	dst->wal_dir_rescan_delay = src->wal_dir_rescan_delay;
	dst->panic_on_snap_error = src->panic_on_snap_error;
	dst->panic_on_wal_error = src->panic_on_wal_error;
	dst->primary_port = src->primary_port;
	dst->secondary_port = src->secondary_port;
	dst->too_long_threshold = src->too_long_threshold;
	if (dst->custom_proc_title) free(dst->custom_proc_title);dst->custom_proc_title = src->custom_proc_title == NULL ? NULL : strdup(src->custom_proc_title);
	if (src->custom_proc_title != NULL && dst->custom_proc_title == NULL)
		return CNF_NOMEMORY;
	dst->memcached_port = src->memcached_port;
	dst->memcached_space = src->memcached_space;
	dst->memcached_expire = src->memcached_expire;
	dst->memcached_expire_per_loop = src->memcached_expire_per_loop;
	dst->memcached_expire_full_sweep = src->memcached_expire_full_sweep;
	if (dst->replication_source) free(dst->replication_source);dst->replication_source = src->replication_source == NULL ? NULL : strdup(src->replication_source);
	if (src->replication_source != NULL && dst->replication_source == NULL)
		return CNF_NOMEMORY;

	dst->space = NULL;
	if (src->space != NULL) {
		i->idx_name__space = 0;
		ARRAYALLOC(dst->space, 1, _name__space, 0, 0);

		while (src->space[i->idx_name__space] != NULL) {
			ARRAYALLOC(dst->space, i->idx_name__space + 1, _name__space, 0, 0);

			dst->space[i->idx_name__space]->__confetti_flags = src->space[i->idx_name__space]->__confetti_flags;
			dst->space[i->idx_name__space]->enabled = src->space[i->idx_name__space]->enabled;
			dst->space[i->idx_name__space]->cardinality = src->space[i->idx_name__space]->cardinality;
			dst->space[i->idx_name__space]->estimated_rows = src->space[i->idx_name__space]->estimated_rows;

			dst->space[i->idx_name__space]->index = NULL;
			if (src->space[i->idx_name__space]->index != NULL) {
				i->idx_name__space__index = 0;
				ARRAYALLOC(dst->space[i->idx_name__space]->index, 1, _name__space__index, 0, 0);

				while (src->space[i->idx_name__space]->index[i->idx_name__space__index] != NULL) {
					ARRAYALLOC(dst->space[i->idx_name__space]->index, i->idx_name__space__index + 1, _name__space__index, 0, 0);

					dst->space[i->idx_name__space]->index[i->idx_name__space__index]->__confetti_flags = src->space[i->idx_name__space]->index[i->idx_name__space__index]->__confetti_flags;
					if (dst->space[i->idx_name__space]->index[i->idx_name__space__index]->type) free(dst->space[i->idx_name__space]->index[i->idx_name__space__index]->type);dst->space[i->idx_name__space]->index[i->idx_name__space__index]->type = src->space[i->idx_name__space]->index[i->idx_name__space__index]->type == NULL ? NULL : strdup(src->space[i->idx_name__space]->index[i->idx_name__space__index]->type);
					if (src->space[i->idx_name__space]->index[i->idx_name__space__index]->type != NULL && dst->space[i->idx_name__space]->index[i->idx_name__space__index]->type == NULL)
						return CNF_NOMEMORY;
					dst->space[i->idx_name__space]->index[i->idx_name__space__index]->unique = src->space[i->idx_name__space]->index[i->idx_name__space__index]->unique;

					dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field = NULL;
					if (src->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field != NULL) {
						i->idx_name__space__index__key_field = 0;
						ARRAYALLOC(dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field, 1, _name__space__index__key_field, 0, 0);

						while (src->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field] != NULL) {
							ARRAYALLOC(dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field, i->idx_name__space__index__key_field + 1, _name__space__index__key_field, 0, 0);

							dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->__confetti_flags = src->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->__confetti_flags;
							dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->fieldno = src->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->fieldno;
							if (dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type) free(dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type);dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type = src->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type == NULL ? NULL : strdup(src->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type);
							if (src->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type != NULL && dst->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type == NULL)
								return CNF_NOMEMORY;

							i->idx_name__space__index__key_field++;
						}
					}

					i->idx_name__space__index++;
				}
			}

			i->idx_name__space++;
		}
	}

	return CNF_OK;
}

/************** Destroy config  **************/

void
destroy_tarantool_cfg(tarantool_cfg* c) {
	tarantool_cfg_iterator_t iterator, *i = &iterator;

	if (c->username != NULL)
		free(c->username);
	if (c->bind_ipaddr != NULL)
		free(c->bind_ipaddr);
	if (c->work_dir != NULL)
		free(c->work_dir);
	if (c->snap_dir != NULL)
		free(c->snap_dir);
	if (c->wal_dir != NULL)
		free(c->wal_dir);
	if (c->script_dir != NULL)
		free(c->script_dir);
	if (c->pid_file != NULL)
		free(c->pid_file);
	if (c->logger != NULL)
		free(c->logger);
	if (c->wal_mode != NULL)
		free(c->wal_mode);
	if (c->custom_proc_title != NULL)
		free(c->custom_proc_title);
	if (c->replication_source != NULL)
		free(c->replication_source);

	if (c->space != NULL) {
		i->idx_name__space = 0;
		while (c->space[i->idx_name__space] != NULL) {

			if (c->space[i->idx_name__space]->index != NULL) {
				i->idx_name__space__index = 0;
				while (c->space[i->idx_name__space]->index[i->idx_name__space__index] != NULL) {
					if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->type != NULL)
						free(c->space[i->idx_name__space]->index[i->idx_name__space__index]->type);

					if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field != NULL) {
						i->idx_name__space__index__key_field = 0;
						while (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field] != NULL) {
							if (c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type != NULL)
								free(c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]->type);

							free(c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field[i->idx_name__space__index__key_field]);

							i->idx_name__space__index__key_field++;
						}

						free(c->space[i->idx_name__space]->index[i->idx_name__space__index]->key_field);
					}

					free(c->space[i->idx_name__space]->index[i->idx_name__space__index]);

					i->idx_name__space__index++;
				}

				free(c->space[i->idx_name__space]->index);
			}

			free(c->space[i->idx_name__space]);

			i->idx_name__space++;
		}

		free(c->space);
	}
}

/************** Compare config  **************/

int
confetti_strcmp(char *s1, char *s2) {
	if (s1 == NULL || s2 == NULL) {
		if (s1 != s2)
			return s1 == NULL ? -1 : 1;
		else
			return 0;
	}

	return strcmp(s1, s2);
}

char *
cmp_tarantool_cfg(tarantool_cfg* c1, tarantool_cfg* c2, int only_check_rdonly) {
	tarantool_cfg_iterator_t iterator1, iterator2, *i1 = &iterator1, *i2 = &iterator2;
	static char diff[PRINTBUFLEN];

	if (confetti_strcmp(c1->username, c2->username) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->username");

		return diff;
}
	if (c1->local_hot_standby != c2->local_hot_standby) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->local_hot_standby");

		return diff;
	}
	if (confetti_strcmp(c1->bind_ipaddr, c2->bind_ipaddr) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->bind_ipaddr");

		return diff;
}
	if (c1->coredump != c2->coredump) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->coredump");

		return diff;
	}
	if (c1->admin_port != c2->admin_port) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->admin_port");

		return diff;
	}
	if (c1->replication_port != c2->replication_port) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->replication_port");

		return diff;
	}
	if (!only_check_rdonly) {
		if (c1->log_level != c2->log_level) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->log_level");

			return diff;
		}
	}
	if (c1->slab_alloc_arena != c2->slab_alloc_arena) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->slab_alloc_arena");

		return diff;
	}
	if (c1->slab_alloc_minimal != c2->slab_alloc_minimal) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->slab_alloc_minimal");

		return diff;
	}
	if (c1->slab_alloc_factor != c2->slab_alloc_factor) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->slab_alloc_factor");

		return diff;
	}
	if (confetti_strcmp(c1->work_dir, c2->work_dir) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->work_dir");

		return diff;
}
	if (confetti_strcmp(c1->snap_dir, c2->snap_dir) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->snap_dir");

		return diff;
}
	if (confetti_strcmp(c1->wal_dir, c2->wal_dir) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->wal_dir");

		return diff;
}
	if (confetti_strcmp(c1->script_dir, c2->script_dir) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->script_dir");

		return diff;
}
	if (confetti_strcmp(c1->pid_file, c2->pid_file) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->pid_file");

		return diff;
}
	if (confetti_strcmp(c1->logger, c2->logger) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->logger");

		return diff;
}
	if (c1->logger_nonblock != c2->logger_nonblock) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->logger_nonblock");

		return diff;
	}
	if (!only_check_rdonly) {
		if (c1->io_collect_interval != c2->io_collect_interval) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->io_collect_interval");

			return diff;
		}
	}
	if (c1->backlog != c2->backlog) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->backlog");

		return diff;
	}
	if (!only_check_rdonly) {
		if (c1->readahead != c2->readahead) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->readahead");

			return diff;
		}
	}
	if (!only_check_rdonly) {
		if (c1->snap_io_rate_limit != c2->snap_io_rate_limit) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->snap_io_rate_limit");

			return diff;
		}
	}
	if (c1->rows_per_wal != c2->rows_per_wal) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->rows_per_wal");

		return diff;
	}
	if (c1->wal_writer_inbox_size != c2->wal_writer_inbox_size) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->wal_writer_inbox_size");

		return diff;
	}
	if (!only_check_rdonly) {
		if (confetti_strcmp(c1->wal_mode, c2->wal_mode) != 0) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->wal_mode");

			return diff;
}
	}
	if (!only_check_rdonly) {
		if (c1->wal_fsync_delay != c2->wal_fsync_delay) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->wal_fsync_delay");

			return diff;
		}
	}
	if (c1->wal_dir_rescan_delay != c2->wal_dir_rescan_delay) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->wal_dir_rescan_delay");

		return diff;
	}
	if (c1->panic_on_snap_error != c2->panic_on_snap_error) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->panic_on_snap_error");

		return diff;
	}
	if (c1->panic_on_wal_error != c2->panic_on_wal_error) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->panic_on_wal_error");

		return diff;
	}
	if (c1->primary_port != c2->primary_port) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->primary_port");

		return diff;
	}
	if (c1->secondary_port != c2->secondary_port) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->secondary_port");

		return diff;
	}
	if (!only_check_rdonly) {
		if (c1->too_long_threshold != c2->too_long_threshold) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->too_long_threshold");

			return diff;
		}
	}
	if (confetti_strcmp(c1->custom_proc_title, c2->custom_proc_title) != 0) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->custom_proc_title");

		return diff;
}
	if (c1->memcached_port != c2->memcached_port) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->memcached_port");

		return diff;
	}
	if (c1->memcached_space != c2->memcached_space) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->memcached_space");

		return diff;
	}
	if (c1->memcached_expire != c2->memcached_expire) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->memcached_expire");

		return diff;
	}
	if (!only_check_rdonly) {
		if (c1->memcached_expire_per_loop != c2->memcached_expire_per_loop) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->memcached_expire_per_loop");

			return diff;
		}
	}
	if (!only_check_rdonly) {
		if (c1->memcached_expire_full_sweep != c2->memcached_expire_full_sweep) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->memcached_expire_full_sweep");

			return diff;
		}
	}
	if (!only_check_rdonly) {
		if (confetti_strcmp(c1->replication_source, c2->replication_source) != 0) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->replication_source");

			return diff;
}
	}

	i1->idx_name__space = 0;
	i2->idx_name__space = 0;
	while (c1->space != NULL && c1->space[i1->idx_name__space] != NULL && c2->space != NULL && c2->space[i2->idx_name__space] != NULL) {
		if (c1->space[i1->idx_name__space]->enabled != c2->space[i2->idx_name__space]->enabled) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->enabled");

			return diff;
		}
		if (c1->space[i1->idx_name__space]->cardinality != c2->space[i2->idx_name__space]->cardinality) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->cardinality");

			return diff;
		}
		if (c1->space[i1->idx_name__space]->estimated_rows != c2->space[i2->idx_name__space]->estimated_rows) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->estimated_rows");

			return diff;
		}

		i1->idx_name__space__index = 0;
		i2->idx_name__space__index = 0;
		while (c1->space[i1->idx_name__space]->index != NULL && c1->space[i1->idx_name__space]->index[i1->idx_name__space__index] != NULL && c2->space[i2->idx_name__space]->index != NULL && c2->space[i2->idx_name__space]->index[i2->idx_name__space__index] != NULL) {
			if (confetti_strcmp(c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->type, c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->type) != 0) {
				snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->index[]->type");

				return diff;
}
			if (c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->unique != c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->unique) {
				snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->index[]->unique");

				return diff;
			}

			i1->idx_name__space__index__key_field = 0;
			i2->idx_name__space__index__key_field = 0;
			while (c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field != NULL && c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field[i1->idx_name__space__index__key_field] != NULL && c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->key_field != NULL && c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->key_field[i2->idx_name__space__index__key_field] != NULL) {
				if (c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field[i1->idx_name__space__index__key_field]->fieldno != c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->key_field[i2->idx_name__space__index__key_field]->fieldno) {
					snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->index[]->key_field[]->fieldno");

					return diff;
				}
				if (confetti_strcmp(c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field[i1->idx_name__space__index__key_field]->type, c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->key_field[i2->idx_name__space__index__key_field]->type) != 0) {
					snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->index[]->key_field[]->type");

					return diff;
}

				i1->idx_name__space__index__key_field++;
				i2->idx_name__space__index__key_field++;
			}
			if (!(c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field == c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->key_field && c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field == NULL) && (c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field == NULL || c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->key_field == NULL || c1->space[i1->idx_name__space]->index[i1->idx_name__space__index]->key_field[i1->idx_name__space__index__key_field] != NULL || c2->space[i2->idx_name__space]->index[i2->idx_name__space__index]->key_field[i2->idx_name__space__index__key_field] != NULL)) {
				snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->index[]->key_field[]");

				return diff;
			}

			i1->idx_name__space__index++;
			i2->idx_name__space__index++;
		}
		if (!(c1->space[i1->idx_name__space]->index == c2->space[i2->idx_name__space]->index && c1->space[i1->idx_name__space]->index == NULL) && (c1->space[i1->idx_name__space]->index == NULL || c2->space[i2->idx_name__space]->index == NULL || c1->space[i1->idx_name__space]->index[i1->idx_name__space__index] != NULL || c2->space[i2->idx_name__space]->index[i2->idx_name__space__index] != NULL)) {
			snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]->index[]");

			return diff;
		}

		i1->idx_name__space++;
		i2->idx_name__space++;
	}
	if (!(c1->space == c2->space && c1->space == NULL) && (c1->space == NULL || c2->space == NULL || c1->space[i1->idx_name__space] != NULL || c2->space[i2->idx_name__space] != NULL)) {
		snprintf(diff, PRINTBUFLEN - 1, "%s", "c->space[]");

		return diff;
	}

	return 0;
}

