/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_AVATARS_H__
#define __TPA_AVATARS_H__

#include <tapioca/base/tpa-errors.h>

typedef struct _TpaIAvatars TpaIAvatars;
typedef struct _TpaIAvatarsPrivate TpaIAvatarsPrivate;

struct _TpaIAvatars {
    GTypeInterface parent;

    TpaError    (* get_avatar_requirements) (GObject *obj,
                                             gchar ***ret,
                                             guint *ret1,
                                             guint *ret2,
                                             guint *ret3,
                                             guint *ret4,
                                             guint *ret5);
    TpaError    (* get_avatar_tokens)       (GObject *obj,
                                             const GArray *contacts,
                                             DBusGMethodInvocation *context);
    TpaError    (* request_avatar)          (GObject *obj,
                                             guint contact,
                                             DBusGMethodInvocation *context);
    TpaError    (* set_avatar)              (GObject *obj,
                                             const GArray *avatar,
                                             const gchar *mime_type,
                                             DBusGMethodInvocation *context);
    TpaIAvatarsPrivate *priv;
};

/* TYPE MACROS */
#define TPA_TYPE_IAVATARS \
    (tpa_avatars_get_type ())
#define TPA_IS_IAVATARS(obj) \
    (g_type_is_a (G_OBJECT_TYPE(obj), TPA_TYPE_IAVATARS))
#define TPA_IAVATARS(obj) \
    (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TPA_TYPE_IAVATARS, TpaIAvatars))

GType       tpa_avatars_get_type                (void);
void        tpa_avatars_init                    (TpaIAvatars *iface,
                                                 gpointer data);
void        tpa_avatars_finalize                (GObject *obj);
void        tpa_avatars_signal_avatar_updated   (GObject *obj,
                                                 guint handle,
                                                 const gchar *new_avatar_token);

#endif /* #ifndef __TPA_AVATARS_H__*/
