/*
 * Tapioca library
 * Copyright (C) 2007 INdT.
 * @author  Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_VIDEO_STREAM_H__
#define __TPA_VIDEO_STREAM_H__

#include <glib.h>
#include <glib-object.h>

#include <tapioca/client/tpa-stream.h>

G_BEGIN_DECLS

/* TYPE MACROS */
#define TPA_TYPE_VIDEO_STREAM \
    (tpa_video_stream_get_type())
#define TPA_VIDEO_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_CAST((obj), TPA_TYPE_VIDEO_STREAM, TpaVideoStream))
#define TPA_VIDEO_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_CAST((klass), TPA_TYPE_VIDEO_STREAM, TpaVideoStreamClass))
#define TPA_IS_VIDEO_STREAM(obj) \
    (G_TYPE_CHECK_INSTANCE_TYPE((obj), TPA_TYPE_VIDEO_STREAM))
#define TPA_IS_VIDEO_STREAM_CLASS(klass) \
    (G_TYPE_CHECK_CLASS_TYPE((klass), TPA_TYPE_VIDEO_STREAM))
#define TPA_VIDEO_STREAM_GET_CLASS(obj) \
    (G_TYPE_INSTANCE_GET_CLASS ((obj), TPA_TYPE_VIDEO_STREAM, TpaVideoStreamClass))
#define TPA_VIDEO_STREAM_GET_PRIVATE(obj) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((obj), TPA_TYPE_VIDEO_STREAM, TpaVideoStreamPrivate))


typedef struct _TpaVideoStream TpaVideoStream;
typedef struct _TpaVideoStreamClass TpaVideoStreamClass;
typedef struct _TpaVideoStreamPrivate TpaVideoStreamPrivate;

struct _TpaVideoStreamClass {
    TpaStreamClass parent_class;
};

struct _TpaVideoStream {
    TpaStream parent;
    TpaVideoStreamPrivate *priv;
};

GType tpa_video_stream_get_type                   (void);
void  tpa_video_stream_set_window_id              (TpaVideoStream *self,
                                                   guint id);
guint tpa_video_stream_get_window_id              (TpaVideoStream *self);
void  tpa_video_stream_add_preview_window_id      (TpaVideoStream *self,
                                                   guint id);
void  tpa_video_stream_remove_preview_window_id   (TpaVideoStream *self,
                                                   guint id);
G_END_DECLS

#endif /* #ifndef __TPA_VIDEO_STREAM_H__*/

