/*
 * Tapioca library
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_CONTACT_PRIV_H__
#define __TPA_CONTACT_PRIV_H__

#include "tpa-contact.h"
#include "tpa-contact-list.h"
#include "tpa-handle.h"

G_BEGIN_DECLS

TpaContact *        tpa_contact_new                     (TpaHandle *handle,
                                                         TpaObject *list);
void                tpa_contact_set_subscription_status (TpaContact *self,
                                                         TpaSubscriptionStatus status);
void                tpa_contact_set_authorization_status(TpaContact *self,
                                                         TpaAuthorizationStatus status);
void                tpa_contact_set_hide                (TpaContact *self,
                                                         gboolean value);
void                tpa_contact_set_block               (TpaContact *self,
                                                         gboolean value);

G_END_DECLS

#endif /* #ifndef __TPA_CONTACT_PRIV_H__*/
