/*
 * Copyright (C) 2006 INdT.
 * @author  Luiz Augusto von Dentz <luiz.dentz@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __TPA_DEBUG_H__
#define __TPA_DEBUG_H__

#include "config.h"

#include <glib.h>

G_BEGIN_DECLS

typedef enum {
    TPA_DOMAIN_CONNECTION_MANAGER   = 1 << 0,
    TPA_DOMAIN_CONNECTION           = 1 << 1,
    TPA_DOMAIN_ALIASING             = 1 << 2,
    TPA_DOMAIN_AVATARS              = 1 << 3,
    TPA_DOMAIN_CAPABILITIES         = 1 << 4,
    TPA_DOMAIN_CONTACT_INFO         = 1 << 5,
    TPA_DOMAIN_FORWARDING           = 1 << 6,
    TPA_DOMAIN_PRESENCE             = 1 << 7,
    TPA_DOMAIN_PROPERTIES           = 1 << 8,
    TPA_DOMAIN_CONNECTION_IFACES    =
        TPA_DOMAIN_CONNECTION |
        TPA_DOMAIN_ALIASING |
        TPA_DOMAIN_AVATARS |
        TPA_DOMAIN_CAPABILITIES |
        TPA_DOMAIN_CONTACT_INFO |
        TPA_DOMAIN_FORWARDING |
        TPA_DOMAIN_PRESENCE |
        TPA_DOMAIN_PROPERTIES,
    TPA_DOMAIN_CHANNEL              = 1 << 9,
    TPA_DOMAIN_NONE                 = 1 << 10
} TpaDomainFlags;

typedef enum {
    TPA_LEVEL_VERBOSE = 1 << 0,
    TPA_LEVEL_INFO  = 1 << 2,
    TPA_LEVEL_ERROR = 1 << 3,
} TpaDebugLevelFlags;

void        tpa_debug_set_flags_from_env        (void);
void        tpa_debug_set_flags                 (TpaDomainFlags flags);
gboolean    tpa_debug_flag_is_set               (TpaDomainFlags flag);
void        tpa_debug_level_set_flags           (TpaDebugLevelFlags flags);
gboolean    tpa_debug_level_flag_is_set         (TpaDebugLevelFlags flag);
void        tpa_debug                           (TpaDomainFlags domain_flag,
                                                 TpaDebugLevelFlags level_flag,
                                                 const gchar *format,
                                                 ...) G_GNUC_PRINTF (3, 4);
#ifdef ENABLE_DEBUG

#define VERBOSE(format, ...) \
    g_printerr ("\033[00;36m"), \
    tpa_debug(DEBUG_DOMAIN, TPA_LEVEL_VERBOSE, "(%s)%s " format, G_STRLOC, G_STRFUNC, ##__VA_ARGS__); \
    g_printerr ("\033[00m");

#ifdef DEBUG_DOMAIN

#define DEBUGGING tpa_debug_flag_is_set(DEBUG_DOMAIN)

#else

#define DEBUGGING tpa_debug_flag_is_set(TPA_DOMAIN_NONE)

#endif /* DEBUG_DOMAIN */

#else

#define VERBOSE(format, ...)

#define DEBUGGING 0

#endif /* ENABLE_DEBUG */

#define INFO(format, ...) \
    g_printerr ("\033[00;32m"), \
    tpa_debug(DEBUG_DOMAIN, TPA_LEVEL_INFO, format, ##__VA_ARGS__); \
    g_printerr ("\033[00m");

#define ERROR(format, ...) \
    g_printerr ("\033[00;31m"), \
    tpa_debug(DEBUG_DOMAIN, TPA_LEVEL_ERROR, "(%s)%s " format, G_STRLOC, G_STRFUNC, ##__VA_ARGS__); \
    g_printerr ("\033[00m");

G_END_DECLS

#endif
