static const char *RcsId = "$Header$";
//+=============================================================================
//
// file :         TangoTestStateMachine.cpp
//
// description :  C++ source for the TangoTest and its alowed. 
//                method for commands and attributes
//
// project :      TANGO Device Server
//
// $Author: taurel $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010
//						Synchrotron SOLEIL
//                		L'Orme des Merisiers
//                		Saint-Aubin - BP 48 - France
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 19209 $
//
// $Log$
// Revision 1.9  2010/09/10 17:21:30  nleclercq
// Added support for crash report  (i.e. google breakpad)
// Added ClassID to the cvs repository
//
// Revision 1.8  2010/03/01 16:57:18  nleclercq
// Added 64bits attributes (scalars, spectra & images)
// Tested from a 64bits Matlab session (seems to work :-)
//
// Revision 1.7  2007/12/11 19:07:52  nleclercq
// added a "no_value" and a "throw_exception" attribute
//
// Revision 1.6  2007/12/04 11:30:40  nleclercq
// Added string spectrum and image attributes
//
// Revision 1.5  2006/03/20 15:21:51  jensmeyer
// Added some castings for porting to VC8
//
// Revision 1.4  2006/02/08 16:14:28  nleclercq
// Minor modifs in RW spectrum and image attributes
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#include <tango.h>
#include <TangoTest.h>
#include <TangoTestClass.h>

/*====================================================================
 *	This file contains the methods to allow commands and attributes
 * read or write execution.
 *
 * If you wand to add your own code, add it between 
 * the "End/Re-Start of Generated Code" comments.
 *
 * If you want, you can also add your own methods.
 *====================================================================
 */

namespace TangoTest_ns
{

//=================================================
//		Attributes Allowed Methods
//=================================================

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_scalar_ro_allowed
// 
// description : 	Read/Write allowed for short_scalar_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_scalar_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_scalar_allowed
// 
// description : 	Read/Write allowed for short_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long_scalar_allowed
// 
// description : 	Read/Write allowed for long_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_double_scalar_allowed
// 
// description : 	Read/Write allowed for double_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_double_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_string_scalar_allowed
// 
// description : 	Read/Write allowed for string_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_string_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_scalar_w_allowed
// 
// description : 	Read/Write allowed for short_scalar_w attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_scalar_w_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_scalar_rww_allowed
// 
// description : 	Read/Write allowed for short_scalar_rww attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_scalar_rww_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long_scalar_w_allowed
// 
// description : 	Read/Write allowed for long_scalar_w attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long_scalar_w_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long_scalar_rww_allowed
// 
// description : 	Read/Write allowed for long_scalar_rww attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long_scalar_rww_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_double_scalar_w_allowed
// 
// description : 	Read/Write allowed for double_scalar_w attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_double_scalar_w_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_double_scalar_rww_allowed
// 
// description : 	Read/Write allowed for double_scalar_rww attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_double_scalar_rww_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ampli_allowed
// 
// description : 	Read/Write allowed for ampli attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ampli_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_wave_allowed
// 
// description : 	Read/Write allowed for wave attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_wave_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_boolean_scalar_allowed
// 
// description : 	Read/Write allowed for boolean_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_boolean_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_float_scalar_allowed
// 
// description : 	Read/Write allowed for float_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_float_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_uchar_scalar_allowed
// 
// description : 	Read/Write allowed for uchar_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_uchar_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ushort_scalar_allowed
// 
// description : 	Read/Write allowed for ushort_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ushort_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}


//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_spectrum_allowed
// 
// description : 	Read/Write allowed for short_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long_spectrum_allowed
// 
// description : 	Read/Write allowed for long_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_double_spectrum_allowed
// 
// description : 	Read/Write allowed for double_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_double_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_boolean_spectrum_allowed
// 
// description : 	Read/Write allowed for boolean_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_boolean_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_uchar_spectrum_allowed
// 
// description : 	Read/Write allowed for uchar_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_uchar_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ushort_spectrum_allowed
// 
// description : 	Read/Write allowed for ushort_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ushort_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_float_spectrum_allowed
// 
// description : 	Read/Write allowed for float_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_float_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for short_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_float_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for float_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_float_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for long_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_double_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for double_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_double_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_boolean_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for boolean_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_boolean_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_uchar_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for uchar_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_uchar_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ushort_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for ushort_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ushort_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_uchar_image_ro_allowed
// 
// description : 	Read/Write allowed for uchar_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_uchar_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ushort_image_ro_allowed
// 
// description : 	Read/Write allowed for ushort_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ushort_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_float_image_ro_allowed
// 
// description : 	Read/Write allowed for float_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_float_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_image_ro_allowed
// 
// description : 	Read/Write allowed for short_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long_image_ro_allowed
// 
// description : 	Read/Write allowed for long_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_double_image_ro_allowed
// 
// description : 	Read/Write allowed for double_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_double_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_boolean_image_ro_allowed
// 
// description : 	Read/Write allowed for boolean_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_boolean_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_boolean_image_allowed
// 
// description : 	Read/Write allowed for boolean_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_boolean_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_uchar_image_allowed
// 
// description : 	Read/Write allowed for uchar_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_uchar_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_short_image_allowed
// 
// description : 	Read/Write allowed for short_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_short_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ushort_image_allowed
// 
// description : 	Read/Write allowed for ushort_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ushort_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long_image_allowed
// 
// description : 	Read/Write allowed for long_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_float_image_allowed
// 
// description : 	Read/Write allowed for float_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_float_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_double_image_allowed
// 
// description : 	Read/Write allowed for double_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_double_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_string_spectrum_allowed
// 
// description : 	Read/Write allowed for string_spectrum attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_string_spectrum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_string_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for string_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_string_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_string_image_allowed
// 
// description : 	Read/Write allowed for string_image attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_string_image_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_string_image_ro_allowed
// 
// description : 	Read/Write allowed for string_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_string_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_no_value_allowed
// 
// description : 	Read/Write allowed for no_value attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_no_value_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_throw_exception_allowed
// 
// description : 	Read/Write allowed for throw_exception attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_throw_exception_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long64_scalar_allowed
// 
// description : 	Read/Write allowed for long64_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long64_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ulong64_scalar_allowed
// 
// description : 	Read/Write allowed for ulong64_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ulong64_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long64_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for long64_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long64_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ulong64_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for ulong64_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ulong64_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ulong_spectrum_ro_allowed
// 
// description : 	Read/Write allowed for ulong_spectrum_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ulong_spectrum_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_long64_image_ro_allowed
// 
// description : 	Read/Write allowed for long64_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_long64_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ulong64_image_ro_allowed
// 
// description : 	Read/Write allowed for ulong64_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ulong64_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ulong_image_ro_allowed
// 
// description : 	Read/Write allowed for ulong_image_ro attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ulong_image_ro_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_ulong_scalar_allowed
// 
// description : 	Read/Write allowed for ulong_scalar attribute.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_ulong_scalar_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}

//=================================================
//		Commands Allowed Methods
//=================================================

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVoid_allowed
// 
// description : 	Execution allowed for DevVoid command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVoid_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevString_allowed
// 
// description : 	Execution allowed for DevString command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevString_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarCharArray_allowed
// 
// description : 	Execution allowed for DevVarCharArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarCharArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarShortArray_allowed
// 
// description : 	Execution allowed for DevVarShortArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarShortArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarUShortArray_allowed
// 
// description : 	Execution allowed for DevVarUShortArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarUShortArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarLongArray_allowed
// 
// description : 	Execution allowed for DevVarLongArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarLongArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarULongArray_allowed
// 
// description : 	Execution allowed for DevVarULongArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarULongArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarFloatArray_allowed
// 
// description : 	Execution allowed for DevVarFloatArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarFloatArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarDoubleArray_allowed
// 
// description : 	Execution allowed for DevVarDoubleArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarDoubleArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarStringArray_allowed
// 
// description : 	Execution allowed for DevVarStringArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarStringArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarLongStringArray_allowed
// 
// description : 	Execution allowed for DevVarLongStringArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarLongStringArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarDoubleStringArray_allowed
// 
// description : 	Execution allowed for DevVarDoubleStringArray command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarDoubleStringArray_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_SwitchStates_allowed
// 
// description : 	Execution allowed for SwitchStates command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_SwitchStates_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevBoolean_allowed
// 
// description : 	Execution allowed for DevBoolean command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevBoolean_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevShort_allowed
// 
// description : 	Execution allowed for DevShort command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevShort_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevUShort_allowed
// 
// description : 	Execution allowed for DevUShort command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevUShort_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevULong_allowed
// 
// description : 	Execution allowed for DevULong command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevULong_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevFloat_allowed
// 
// description : 	Execution allowed for DevFloat command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevFloat_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevDouble_allowed
// 
// description : 	Execution allowed for DevDouble command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevDouble_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarLong64Array_allowed
// 
// description : 	Execution allowed for DevVarLong64Array command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarLong64Array_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevVarULong64Array_allowed
// 
// description : 	Execution allowed for DevVarULong64Array command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevVarULong64Array_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	if (get_state() == Tango::FAULT)
	{
		//	End of Generated Code

		//	Re-Start of Generated Code
		return false;
	}
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevLong64_allowed
// 
// description : 	Execution allowed for DevLong64 command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevLong64_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevULong64_allowed
// 
// description : 	Execution allowed for DevULong64 command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevULong64_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DevLong_allowed
// 
// description : 	Execution allowed for DevLong command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DevLong_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_CrashFromDevelopperThread_allowed
// 
// description : 	Execution allowed for CrashFromDevelopperThread command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_CrashFromDevelopperThread_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_CrashFromOmniThread_allowed
// 
// description : 	Execution allowed for CrashFromOmniThread command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_CrashFromOmniThread_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTest::is_DumpExecutionState_allowed
// 
// description : 	Execution allowed for DumpExecutionState command.
//
//-----------------------------------------------------------------------------
bool TangoTest::is_DumpExecutionState_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
		//	End of Generated Code

		//	Re-Start of Generated Code
	return true;
}

}	// namespace TangoTest
