/*----- PROTECTED REGION ID(DataBaseStateMachine.cpp) ENABLED START -----*/
static const char *RcsId = "$Id: DataBaseStateMachine.cpp 20190 2012-05-11 11:57:18Z taurel $";
//=============================================================================
//
// file :        DataBaseStateMachine.cpp
//
// description : C++ source for the name and its alowed
//               methods for commands and attributes
//
// project :     TANGO.
//
// $Author: taurel $
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Revision: 20190 $
// $Date: 2012-05-11 13:57:18 +0200 (Fri, 11 May 2012) $
//
// $HeadURL:$
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================



#include <DataBase.h>
#include <DataBaseClass.h>

/*----- PROTECTED REGION END -----*/


/*
 * DataBase states description:
 *
 */

namespace DataBase_ns
{
//=================================================
//		Attributes Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_StoredProcedureReleaseState_allowed()
 *	Description : Execution allowed for StoredProcedureRelease attribute.
 */
//--------------------------------------------------------

bool DataBase::is_StoredProcedureRelease_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	Not any excluded states for StoredProcedureRelease attribute in READ access.
	
	/*----- PROTECTED REGION ID(DataBase::read_StoredProcedureReleaseStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::read_StoredProcedureReleaseStateAllowed_READ

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_Timing_averageState_allowed()
 *	Description : Execution allowed for Timing_average attribute.
 */
//--------------------------------------------------------

bool DataBase::is_Timing_average_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	Not any excluded states for Timing_average attribute in READ access.
	
	/*----- PROTECTED REGION ID(DataBase::read_Timing_averageStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::read_Timing_averageStateAllowed_READ

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_Timing_minimumState_allowed()
 *	Description : Execution allowed for Timing_minimum attribute.
 */
//--------------------------------------------------------

bool DataBase::is_Timing_minimum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	Not any excluded states for Timing_minimum attribute in READ access.
	
	/*----- PROTECTED REGION ID(DataBase::read_Timing_minimumStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::read_Timing_minimumStateAllowed_READ

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_Timing_maximumState_allowed()
 *	Description : Execution allowed for Timing_maximum attribute.
 */
//--------------------------------------------------------

bool DataBase::is_Timing_maximum_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	Not any excluded states for Timing_maximum attribute in READ access.
	
	/*----- PROTECTED REGION ID(DataBase::read_Timing_maximumStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::read_Timing_maximumStateAllowed_READ

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_Timing_callsState_allowed()
 *	Description : Execution allowed for Timing_calls attribute.
 */
//--------------------------------------------------------

bool DataBase::is_Timing_calls_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	Not any excluded states for Timing_calls attribute in READ access.
	
	/*----- PROTECTED REGION ID(DataBase::read_Timing_callsStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::read_Timing_callsStateAllowed_READ

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_Timing_indexState_allowed()
 *	Description : Execution allowed for Timing_index attribute.
 */
//--------------------------------------------------------

bool DataBase::is_Timing_index_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	Not any excluded states for Timing_index attribute in READ access.
	
	/*----- PROTECTED REGION ID(DataBase::read_Timing_indexStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::read_Timing_indexStateAllowed_READ

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_Timing_infoState_allowed()
 *	Description : Execution allowed for Timing_info attribute.
 */
//--------------------------------------------------------

bool DataBase::is_Timing_info_allowed(TANGO_UNUSED(Tango::AttReqType type))
{
		//	Not any excluded states for Timing_info attribute in READ access.
	
	/*----- PROTECTED REGION ID(DataBase::read_Timing_infoStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::read_Timing_infoStateAllowed_READ

	return true;
}


//=================================================
//	Dynamic Attributes Allowed Methods
//=================================================


	/*----- PROTECTED REGION ID(DataBase::are_dynamic_attributes_allowed) ENABLED START -----*/

	//	Add your code to check if dynamic attributes are alowed

	/*----- PROTECTED REGION END -----*/	//	DataBase::are_dynamic_attributes_allowed


//=================================================
//		Commands Allowed Methods
//=================================================


//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbAddDeviceState_allowed()
 *	Description : Execution allowed for DbAddDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbAddDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbAddDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbAddDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbAddDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbAddServerState_allowed()
 *	Description : Execution allowed for DbAddServer command.
 */
//--------------------------------------------------------

bool DataBase::is_DbAddServer_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbAddServer command.

	/*----- PROTECTED REGION ID(DataBase::DbAddServerStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbAddServerStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteAttributeAliasState_allowed()
 *	Description : Execution allowed for DbDeleteAttributeAlias command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteAttributeAlias_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteAttributeAlias command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteAttributeAliasStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteAttributeAliasStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteClassAttributeState_allowed()
 *	Description : Execution allowed for DbDeleteClassAttribute command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteClassAttribute_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteClassAttribute command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteClassAttributeStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteClassAttributeStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteClassAttributePropertyState_allowed()
 *	Description : Execution allowed for DbDeleteClassAttributeProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteClassAttributeProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteClassAttributeProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteClassAttributePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteClassAttributePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteClassPropertyState_allowed()
 *	Description : Execution allowed for DbDeleteClassProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteClassProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteClassProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteClassPropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteClassPropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteDeviceState_allowed()
 *	Description : Execution allowed for DbDeleteDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteDeviceAliasState_allowed()
 *	Description : Execution allowed for DbDeleteDeviceAlias command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteDeviceAlias_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteDeviceAlias command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteDeviceAliasStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteDeviceAliasStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteDeviceAttributeState_allowed()
 *	Description : Execution allowed for DbDeleteDeviceAttribute command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteDeviceAttribute_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteDeviceAttribute command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteDeviceAttributeStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteDeviceAttributeStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteDeviceAttributePropertyState_allowed()
 *	Description : Execution allowed for DbDeleteDeviceAttributeProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteDeviceAttributeProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteDeviceAttributeProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteDeviceAttributePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteDeviceAttributePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteDevicePropertyState_allowed()
 *	Description : Execution allowed for DbDeleteDeviceProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteDeviceProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteDeviceProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteDevicePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteDevicePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeletePropertyState_allowed()
 *	Description : Execution allowed for DbDeleteProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbDeletePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeletePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteServerState_allowed()
 *	Description : Execution allowed for DbDeleteServer command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteServer_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteServer command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteServerStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteServerStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteServerInfoState_allowed()
 *	Description : Execution allowed for DbDeleteServerInfo command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteServerInfo_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteServerInfo command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteServerInfoStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteServerInfoStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbExportDeviceState_allowed()
 *	Description : Execution allowed for DbExportDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbExportDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbExportDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbExportDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbExportDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbExportEventState_allowed()
 *	Description : Execution allowed for DbExportEvent command.
 */
//--------------------------------------------------------

bool DataBase::is_DbExportEvent_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbExportEvent command.

	/*----- PROTECTED REGION ID(DataBase::DbExportEventStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbExportEventStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetAliasDeviceState_allowed()
 *	Description : Execution allowed for DbGetAliasDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetAliasDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetAliasDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbGetAliasDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetAliasDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetAttributeAliasState_allowed()
 *	Description : Execution allowed for DbGetAttributeAlias command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetAttributeAlias_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetAttributeAlias command.

	/*----- PROTECTED REGION ID(DataBase::DbGetAttributeAliasStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetAttributeAliasStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetAttributeAliasListState_allowed()
 *	Description : Execution allowed for DbGetAttributeAliasList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetAttributeAliasList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetAttributeAliasList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetAttributeAliasListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetAttributeAliasListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassAttributeListState_allowed()
 *	Description : Execution allowed for DbGetClassAttributeList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassAttributeList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassAttributeList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassAttributeListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassAttributeListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassAttributePropertyState_allowed()
 *	Description : Execution allowed for DbGetClassAttributeProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassAttributeProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassAttributeProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassAttributePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassAttributePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassAttributeProperty2State_allowed()
 *	Description : Execution allowed for DbGetClassAttributeProperty2 command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassAttributeProperty2_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassAttributeProperty2 command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassAttributeProperty2StateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassAttributeProperty2StateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassAttributePropertyHistState_allowed()
 *	Description : Execution allowed for DbGetClassAttributePropertyHist command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassAttributePropertyHist_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassAttributePropertyHist command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassAttributePropertyHistStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassAttributePropertyHistStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassForDeviceState_allowed()
 *	Description : Execution allowed for DbGetClassForDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassForDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassForDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassForDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassForDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassInheritanceForDeviceState_allowed()
 *	Description : Execution allowed for DbGetClassInheritanceForDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassInheritanceForDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassInheritanceForDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassInheritanceForDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassInheritanceForDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassListState_allowed()
 *	Description : Execution allowed for DbGetClassList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassPropertyState_allowed()
 *	Description : Execution allowed for DbGetClassProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassPropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassPropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassPropertyHistState_allowed()
 *	Description : Execution allowed for DbGetClassPropertyHist command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassPropertyHist_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassPropertyHist command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassPropertyHistStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassPropertyHistStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetClassPropertyListState_allowed()
 *	Description : Execution allowed for DbGetClassPropertyList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetClassPropertyList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetClassPropertyList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetClassPropertyListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetClassPropertyListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceAliasState_allowed()
 *	Description : Execution allowed for DbGetDeviceAlias command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceAlias_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceAlias command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceAliasStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceAliasStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceAliasListState_allowed()
 *	Description : Execution allowed for DbGetDeviceAliasList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceAliasList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceAliasList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceAliasListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceAliasListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceAttributeListState_allowed()
 *	Description : Execution allowed for DbGetDeviceAttributeList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceAttributeList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceAttributeList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceAttributeListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceAttributeListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceAttributePropertyState_allowed()
 *	Description : Execution allowed for DbGetDeviceAttributeProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceAttributeProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceAttributeProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceAttributePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceAttributePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceAttributeProperty2State_allowed()
 *	Description : Execution allowed for DbGetDeviceAttributeProperty2 command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceAttributeProperty2_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceAttributeProperty2 command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceAttributeProperty2StateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceAttributeProperty2StateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceAttributePropertyHistState_allowed()
 *	Description : Execution allowed for DbGetDeviceAttributePropertyHist command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceAttributePropertyHist_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceAttributePropertyHist command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceAttributePropertyHistStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceAttributePropertyHistStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceClassListState_allowed()
 *	Description : Execution allowed for DbGetDeviceClassList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceClassList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceClassList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceClassListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceClassListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceDomainListState_allowed()
 *	Description : Execution allowed for DbGetDeviceDomainList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceDomainList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceDomainList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceDomainListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceDomainListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceExportedListState_allowed()
 *	Description : Execution allowed for DbGetDeviceExportedList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceExportedList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceExportedList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceExportedListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceExportedListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceFamilyListState_allowed()
 *	Description : Execution allowed for DbGetDeviceFamilyList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceFamilyList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceFamilyList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceFamilyListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceFamilyListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceInfoState_allowed()
 *	Description : Execution allowed for DbGetDeviceInfo command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceInfo_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceInfo command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceInfoStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceInfoStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceListState_allowed()
 *	Description : Execution allowed for DbGetDeviceList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceWideListState_allowed()
 *	Description : Execution allowed for DbGetDeviceWideList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceWideList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceWideList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceWideListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceWideListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceMemberListState_allowed()
 *	Description : Execution allowed for DbGetDeviceMemberList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceMemberList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceMemberList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceMemberListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceMemberListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDevicePropertyState_allowed()
 *	Description : Execution allowed for DbGetDeviceProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDevicePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDevicePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDevicePropertyHistState_allowed()
 *	Description : Execution allowed for DbGetDevicePropertyHist command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDevicePropertyHist_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDevicePropertyHist command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDevicePropertyHistStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDevicePropertyHistStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDevicePropertyListState_allowed()
 *	Description : Execution allowed for DbGetDevicePropertyList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDevicePropertyList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDevicePropertyList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDevicePropertyListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDevicePropertyListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDeviceServerClassListState_allowed()
 *	Description : Execution allowed for DbGetDeviceServerClassList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDeviceServerClassList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDeviceServerClassList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDeviceServerClassListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDeviceServerClassListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetExportdDeviceListForClassState_allowed()
 *	Description : Execution allowed for DbGetExportdDeviceListForClass command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetExportdDeviceListForClass_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetExportdDeviceListForClass command.

	/*----- PROTECTED REGION ID(DataBase::DbGetExportdDeviceListForClassStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetExportdDeviceListForClassStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetHostListState_allowed()
 *	Description : Execution allowed for DbGetHostList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetHostList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetHostList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetHostListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetHostListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetHostServerListState_allowed()
 *	Description : Execution allowed for DbGetHostServerList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetHostServerList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetHostServerList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetHostServerListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetHostServerListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetHostServersInfoState_allowed()
 *	Description : Execution allowed for DbGetHostServersInfo command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetHostServersInfo_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetHostServersInfo command.

	/*----- PROTECTED REGION ID(DataBase::DbGetHostServersInfoStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetHostServersInfoStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetInstanceNameListState_allowed()
 *	Description : Execution allowed for DbGetInstanceNameList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetInstanceNameList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetInstanceNameList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetInstanceNameListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetInstanceNameListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetObjectListState_allowed()
 *	Description : Execution allowed for DbGetObjectList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetObjectList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetObjectList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetObjectListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetObjectListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetPropertyState_allowed()
 *	Description : Execution allowed for DbGetProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbGetPropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetPropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetPropertyHistState_allowed()
 *	Description : Execution allowed for DbGetPropertyHist command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetPropertyHist_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetPropertyHist command.

	/*----- PROTECTED REGION ID(DataBase::DbGetPropertyHistStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetPropertyHistStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetPropertyListState_allowed()
 *	Description : Execution allowed for DbGetPropertyList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetPropertyList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetPropertyList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetPropertyListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetPropertyListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetServerInfoState_allowed()
 *	Description : Execution allowed for DbGetServerInfo command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetServerInfo_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetServerInfo command.

	/*----- PROTECTED REGION ID(DataBase::DbGetServerInfoStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetServerInfoStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetServerListState_allowed()
 *	Description : Execution allowed for DbGetServerList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetServerList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetServerList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetServerListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetServerListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetServerNameListState_allowed()
 *	Description : Execution allowed for DbGetServerNameList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetServerNameList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetServerNameList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetServerNameListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetServerNameListStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbImportDeviceState_allowed()
 *	Description : Execution allowed for DbImportDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbImportDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbImportDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbImportDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbImportDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbImportEventState_allowed()
 *	Description : Execution allowed for DbImportEvent command.
 */
//--------------------------------------------------------

bool DataBase::is_DbImportEvent_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbImportEvent command.

	/*----- PROTECTED REGION ID(DataBase::DbImportEventStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbImportEventStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbInfoState_allowed()
 *	Description : Execution allowed for DbInfo command.
 */
//--------------------------------------------------------

bool DataBase::is_DbInfo_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbInfo command.

	/*----- PROTECTED REGION ID(DataBase::DbInfoStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbInfoStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutAttributeAliasState_allowed()
 *	Description : Execution allowed for DbPutAttributeAlias command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutAttributeAlias_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutAttributeAlias command.

	/*----- PROTECTED REGION ID(DataBase::DbPutAttributeAliasStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutAttributeAliasStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutClassAttributePropertyState_allowed()
 *	Description : Execution allowed for DbPutClassAttributeProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutClassAttributeProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutClassAttributeProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbPutClassAttributePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutClassAttributePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutClassAttributeProperty2State_allowed()
 *	Description : Execution allowed for DbPutClassAttributeProperty2 command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutClassAttributeProperty2_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutClassAttributeProperty2 command.

	/*----- PROTECTED REGION ID(DataBase::DbPutClassAttributeProperty2StateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutClassAttributeProperty2StateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutClassPropertyState_allowed()
 *	Description : Execution allowed for DbPutClassProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutClassProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutClassProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbPutClassPropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutClassPropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutDeviceAliasState_allowed()
 *	Description : Execution allowed for DbPutDeviceAlias command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutDeviceAlias_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutDeviceAlias command.

	/*----- PROTECTED REGION ID(DataBase::DbPutDeviceAliasStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutDeviceAliasStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutDeviceAttributePropertyState_allowed()
 *	Description : Execution allowed for DbPutDeviceAttributeProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutDeviceAttributeProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutDeviceAttributeProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbPutDeviceAttributePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutDeviceAttributePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutDeviceAttributeProperty2State_allowed()
 *	Description : Execution allowed for DbPutDeviceAttributeProperty2 command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutDeviceAttributeProperty2_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutDeviceAttributeProperty2 command.

	/*----- PROTECTED REGION ID(DataBase::DbPutDeviceAttributeProperty2StateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutDeviceAttributeProperty2StateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutDevicePropertyState_allowed()
 *	Description : Execution allowed for DbPutDeviceProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutDeviceProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutDeviceProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbPutDevicePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutDevicePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutPropertyState_allowed()
 *	Description : Execution allowed for DbPutProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbPutPropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutPropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbPutServerInfoState_allowed()
 *	Description : Execution allowed for DbPutServerInfo command.
 */
//--------------------------------------------------------

bool DataBase::is_DbPutServerInfo_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbPutServerInfo command.

	/*----- PROTECTED REGION ID(DataBase::DbPutServerInfoStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbPutServerInfoStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbUnExportDeviceState_allowed()
 *	Description : Execution allowed for DbUnExportDevice command.
 */
//--------------------------------------------------------

bool DataBase::is_DbUnExportDevice_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbUnExportDevice command.

	/*----- PROTECTED REGION ID(DataBase::DbUnExportDeviceStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbUnExportDeviceStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbUnExportEventState_allowed()
 *	Description : Execution allowed for DbUnExportEvent command.
 */
//--------------------------------------------------------

bool DataBase::is_DbUnExportEvent_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbUnExportEvent command.

	/*----- PROTECTED REGION ID(DataBase::DbUnExportEventStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbUnExportEventStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbUnExportServerState_allowed()
 *	Description : Execution allowed for DbUnExportServer command.
 */
//--------------------------------------------------------

bool DataBase::is_DbUnExportServer_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbUnExportServer command.

	/*----- PROTECTED REGION ID(DataBase::DbUnExportServerStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbUnExportServerStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_ResetTimingValuesState_allowed()
 *	Description : Execution allowed for ResetTimingValues command.
 */
//--------------------------------------------------------

bool DataBase::is_ResetTimingValues_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for ResetTimingValues command.

	/*----- PROTECTED REGION ID(DataBase::ResetTimingValuesStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::ResetTimingValuesStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetDataForServerCacheState_allowed()
 *	Description : Execution allowed for DbGetDataForServerCache command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetDataForServerCache_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetDataForServerCache command.

	/*----- PROTECTED REGION ID(DataBase::DbGetDataForServerCacheStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetDataForServerCacheStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbDeleteAllDeviceAttributePropertyState_allowed()
 *	Description : Execution allowed for DbDeleteAllDeviceAttributeProperty command.
 */
//--------------------------------------------------------

bool DataBase::is_DbDeleteAllDeviceAttributeProperty_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbDeleteAllDeviceAttributeProperty command.

	/*----- PROTECTED REGION ID(DataBase::DbDeleteAllDeviceAttributePropertyStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbDeleteAllDeviceAttributePropertyStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbMySqlSelectState_allowed()
 *	Description : Execution allowed for DbMySqlSelect command.
 */
//--------------------------------------------------------

bool DataBase::is_DbMySqlSelect_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbMySqlSelect command.

	/*----- PROTECTED REGION ID(DataBase::DbMySqlSelectStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbMySqlSelectStateAllowed

	return true;
}

//--------------------------------------------------------
/**
 *	Method      : DataBase::is_DbGetCSDbServerListState_allowed()
 *	Description : Execution allowed for DbGetCSDbServerList command.
 */
//--------------------------------------------------------

bool DataBase::is_DbGetCSDbServerList_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for DbGetCSDbServerList command.

	/*----- PROTECTED REGION ID(DataBase::DbGetCSDbServerListStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	DataBase::DbGetCSDbServerListStateAllowed

	return true;
}


	/*----- PROTECTED REGION ID(DataBase::are_dynamic_commands_allowed) ENABLED START -----*/

	//	Add your code to check if dynamic commands are alowed

	/*----- PROTECTED REGION END -----*/	//	DataBase::are_dynamic_commands_allowed

}	// namespace DataBase_ns
