.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "TAKTUK 1"
.TH TAKTUK 1 "2007-11-27" "perl v5.8.6" "TakTuk Deployment Engine"
.SH "NAME"
\&\fBTakTuk\fR \- a tool for large scale remote execution deployment
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBtaktuk\fR [\fB\-hinsvP\fR] [\fB\-c\fR connector] [\fB\-d\fR limit] [\fB\-f\fR filename]
[\fB\-g\fR duration] [\fB\-l\fR login] [\fB\-m\fR hostname [\fB\-[\fR args ... \fB\-]\fR]]
[\fB\-o\fR stream=template] [\fB\-t\fR timeout] [\fB\-w\fR size] [\fB\-C\fR separators]
[\fB\-E\fR character] [\fB\-F\fR filename] [\fB\-L\fR hostname] [\fB\-O\fR separators]
[\fB\-R\fR stream=descriptor] [\fB\-S\fR files] [\fB\-T\fR command] [\fB\-W\fR scheme]
[commands ... ]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBTakTuk\fR is a tool for broadcasting the remote execution of one ore more
commands to a set of one or more distant machines. \fBTakTuk\fR combines local
parallelization (using concurrent deployment processes) and work distribution
(using an adaptive work-stealing algorithm) to achieve both
\&\fBscalability\fR and \fBefficiency\fR.
.PP
\&\fBTakTuk\fR is especially suited to interactive tasks involving several distant 
machines and parallel remote executions. This is the case of clusters 
administration and parallel program debugging.
.PP
\&\fBTakTuk\fR also provides a basic communication layer to programs it executes.
This communication layer uses the communication infrastructure set up by
\&\fBTakTuk\fR during its deployment. It is available both for the Perl and the C
langages and is described in \f(CWtaktukcomm(3)\fR.
.SH "OPTIONS"
.IX Header "OPTIONS"
Caution, in \fBTakTuk\fR options are parsed in the order given on the comand line.
This means that \fBTakTuk\fR is not \s-1POSIX\s0 compliant regarding options order.  This
is important as some of the options change the behavior of following ones (and
only these ones \- e.g. \fB\-l\fR applies to following \fB\-m\fR options). The defaults
settings of \fBTakTuk\fR can be obtained by using the \f(CW\*(C`\-\-print\-defaults\*(C'\fR option.
The following options are given by category in alphabetical order.
.SH "DEPLOYMENT OPTIONS"
.IX Header "DEPLOYMENT OPTIONS"
.IP "\fB\-c\fR connector" 4
.IX Item "-c connector"
.PD 0
.IP "\fB\-\-connector\fR connector" 4
.IX Item "--connector connector"
.PD
defines the connector command used to contact the following remote machines.
.IP "\fB\-d\fR limit" 4
.IX Item "-d limit"
.PD 0
.IP "\fB\-\-dynamic\fR limit" 4
.IX Item "--dynamic limit"
.PD
turns dynamic mode (work stealing) on or off for the deployment of all the
following remote machines specifications. If \f(CW\*(C`limit\*(C'\fR is positive or null,
\&\fBTakTuk\fR uses the dynamic mode with its value as a maximal arity (0 =
no maximal arity).
A negative value for \f(CW\*(C`limit\*(C'\fR turns dynamic mode off.
\&\fBWarning\fR,
currently it is a bad idea to use several \-d options on the same command line.
.IP "\fB\-f\fR filename" 4
.IX Item "-f filename"
.PD 0
.IP "\fB\-\-machines\-file\fR filename" 4
.IX Item "--machines-file filename"
.PD
\&\f(CW\*(C`filename\*(C'\fR is the name of a file that contains remote machines names
(equivalent to several \f(CW\*(C`\-m\*(C'\fR opions). In each line of this file, the first word
is considered as a machine name and the remaining as comments.
.IP "\fB\-l\fR login" 4
.IX Item "-l login"
.PD 0
.IP "\fB\-\-login\fR login" 4
.IX Item "--login login"
.PD
sets the login name for the following hosts. This assumes that the connector
command accepts \f(CW\*(C`\-l\*(C'\fR option (this is the case for ssh, the default).
.IP "\fB\-m\fR hostname" 4
.IX Item "-m hostname"
.PD 0
.IP "\fB\-\-machine\fR hostname" 4
.IX Item "--machine hostname"
.PD
\&\f(CW\*(C`hostname\*(C'\fR is the name of a remote machine on which \fBTakTuk\fR has to be
deployed. \f(CW\*(C`hostname\*(C'\fR might contain list of values specified inside brackets
and exclusion lists (see \*(L"\s-1HOSTNAMES\s0 \s-1SPECIFICATION\s0\*(R"). In such case, the
depolyment will be performed on all the matching hosts.
This option can be followed by any number of arguments enclosed
between \f(CW\*(C`\-[\*(C'\fR and \f(CW\*(C`\-]\*(C'\fR which will be transmitted as arguments of the remote
\&\fBTakTuk\fR that will execute on all the target hosts.
.IP "\fB\-s\fR" 4
.IX Item "-s"
.PD 0
.IP "\fB\-\-self\-propagate\fR" 4
.IX Item "--self-propagate"
.PD
propagates the \fBTakTuk\fR executable through the following connectors and thus
eliminates the need for a \fBTakTuk\fR installation on remote machines.
.IP "\fB\-z\fR" 4
.IX Item "-z"
.PD 0
.IP "\fB\-\-dont\-self\-propagate\fR" 4
.IX Item "--dont-self-propagate"
.PD
cancels a preceding \fB\-s\fR option.
.IP "\fB\-F\fR filename" 4
.IX Item "-F filename"
.PD 0
.IP "\fB\-\-args\-file\fR filename" 4
.IX Item "--args-file filename"
.PD
\&\f(CW\*(C`filename\*(C'\fR is the name of a file that contains additional options for \fBTakTuk\fR. The parsing of the file is done when encountering this option.
.IP "\fB\-L\fR hostname" 4
.IX Item "-L hostname"
.PD 0
.IP "\fB\-\-localhost\fR hostname" 4
.IX Item "--localhost hostname"
.PD
changes the name of localhost as viewed by \fBTakTuk\fR.
.IP "\fB\-S\fR files" 4
.IX Item "-S files"
.PD 0
.IP "\fB\-\-send\-files\fR files" 4
.IX Item "--send-files files"
.PD
gives to \fBTakTuk\fR a list of files to be sent upon successfull remote
connection. Use with caution as it will slow down deployment (the files are
transfered before the end of the deployment). The intended use is \s-1NOT\s0 to
transfer application data files but rather files that are necessary to perform
further connections from the remote node.  \f(CW\*(C`files\*(C'\fR is a comma separated list
of pairs \f(CW\*(C`local_file:remote_file\*(C'\fR. It behaves as the \f(CW\*(C`put\*(C'\fR command.
.IP "\fB\-T\fR command" 4
.IX Item "-T command"
.PD 0
.IP "\fB\-\-taktuk\-command\fR command" 4
.IX Item "--taktuk-command command"
.PD
\&\f(CW\*(C`command\*(C'\fR is the name of the \fBTakTuk\fR command (default is \f(CW$0\fR, the name used to
launch \fBTakTuk\fR). This is the command used once connected to initiate the
remote \fBTakTuk\fR engine. Note that
the effect of this switch is void when using the \f(CW\*(C`\-s\*(C'\fR option.
.SH "COMMAND LINE PARSING OPTIONS"
.IX Header "COMMAND LINE PARSING OPTIONS"
.IP "\fB\-C\fR separators set" 4
.IX Item "-C separators set"
.PD 0
.IP "\fB\-\-command\-separator\fR separators set" 4
.IX Item "--command-separator separators set"
.PD
replaces the default set of characters that separates successive \fBTakTuk\fR
commands.
.IP "\fB\-E\fR character" 4
.IX Item "-E character"
.PD 0
.IP "\fB\-\-escape\-character\fR character" 4
.IX Item "--escape-character character"
.PD
defines an escape character that can be used to protect any following character
from \fBTakTuk\fR interpretation. This protection applies nearly to the whole
\&\fBTakTuk\fR command line.
.IP "\fB\-O\fR separators set" 4
.IX Item "-O separators set"
.PD 0
.IP "\fB\-\-option\-separator\fR separators set" 4
.IX Item "--option-separator separators set"
.PD
replaces the default set of characters that separates successive words when
reading options and commands from a file (using the \f(CW\*(C`\-F\*(C'\fR switch).
.SH "I/O OPTIONS"
.IX Header "I/O OPTIONS"
.IP "\fB\-o\fR stream=template" 4
.IX Item "-o stream=template"
.PD 0
.IP "\fB\-\-output\-template\fR stream=template" 4
.IX Item "--output-template stream=template"
.PD
sets an output template specification for one of output streams designed by the
given name. When giving only a stream name (without template) this disables the
stream. Available streams include :
.RS 4
.ie n .IP """connector"" (errors from the connector command)" 4
.el .IP "\f(CWconnector\fR (errors from the connector command)" 4
.IX Item "connector (errors from the connector command)"
this stream contains in \f(CW$line\fR informations outputed to stderr by a connector
command. Relevant fields include \f(CW$host\fR, \f(CW$peer\fR and others listed below.
.ie n .IP """error""\fR, \f(CW""output"" (error and output of remotely executed commands)" 4
.el .IP "\f(CWerror\fR, \f(CWoutput\fR (error and output of remotely executed commands)" 4
.IX Item "error, output (error and output of remotely executed commands)"
these streams contain in \f(CW$line\fR informations outputed by executed command to
stdout or stderr (respectively). Relevant fields include \f(CW$host\fR,
\&\f(CW$command\fR, \f(CW$pid\fR and others listed below.
.ie n .IP """info"" (general informations such as help summary or version)" 4
.el .IP "\f(CWinfo\fR (general informations such as help summary or version)" 4
.IX Item "info (general informations such as help summary or version)"
this stream contains in \f(CW$line\fR informations outputed by taktuk in response to
commands such as \f(CW\*(C`help\*(C'\fR or \f(CW\*(C`version\*(C'\fR.
.ie n .IP """state"" (internal state of TakTuk instance)" 4
.el .IP "\f(CWstate\fR (internal state of TakTuk instance)" 4
.IX Item "state (internal state of TakTuk instance)"
this stream contains in \f(CW$line\fR the state change code matching some \fBTakTuk\fR
events. Codes are the following:
.Sp
.Vb 16
\&  0 - TakTuk is ready
\&  1 - TakTuk is numbered
\&  2 - TakTuk terminated
\&  3 - connection failed
\&  4 - connection initialized
\&  5 - connection lost
\&  6 - command started
\&  7 - command failed
\&  8 - command terminated
\&  9 - numbering update failed
\& 10 - pipe input started
\& 11 - pipe input failed
\& 12 - pipe input terminated
\& 13 - file reception started
\& 14 - file reception failed
\& 15 - file reception terminated
.Ve
.Sp
The function \f(CWevent_msg($)\fR can be used in the template to translate this code
into a string that describes the event.  Relevant fields include \f(CW$host\fR,
\&\f(CW$position\fR, \f(CW$rank\fR, \f(CW$count\fR and others listed below.
.ie n .IP """status"" (commands exit status)" 4
.el .IP "\f(CWstatus\fR (commands exit status)" 4
.IX Item "status (commands exit status)"
this stream contains in \f(CW$line\fR the return code of executed commands. Relevant
fields include \f(CW$host\fR, \f(CW$pid\fR and others listed below.
.ie n .IP """taktuk"" (internal messages, warnings and errors)" 4
.el .IP "\f(CWtaktuk\fR (internal messages, warnings and errors)" 4
.IX Item "taktuk (internal messages, warnings and errors)"
this stream contains in \f(CW$line\fR error, warning and debug messages outputed by
\&\fBTakTuk\fR itself. Relevant fields include \f(CW$line_number\fR, \f(CW$package\fR and
others listed below.
.RE
.RS 4
.Sp
a template is a Perl expression that should evaluate to the string
eventually displayed. Within a
specification, some variables might be used depending on the concerned stream
(notice that \f(CW$father_position\fR and \f(CW$depth\fR that appeared in 3.2.4 are not
supported anymore and that \f(CW$position\fR evolved since 3.2.5):
.ie n .IP "$command\fR (not for \f(CW""taktuk""\fR nor \f(CW""info"")" 4
.el .IP "\f(CW$command\fR (not for \f(CWtaktuk\fR nor \f(CWinfo\fR)" 4
.IX Item "$command (not for taktuk nor info)"
the command line execution that generated output.
.ie n .IP "$count" 4
.el .IP "\f(CW$count\fR" 4
.IX Item "$count"
the total number of \fBTakTuk\fR instances.
.ie n .IP "$eof" 4
.el .IP "\f(CW$eof\fR" 4
.IX Item "$eof"
an empty string or a newline depending on what character ended command output.
.ie n .IP "$filename\fR (\f(CW""taktuk"" only)" 4
.el .IP "\f(CW$filename\fR (\f(CWtaktuk\fR only)" 4
.IX Item "$filename (taktuk only)"
the file in which a \fBTakTuk\fR diagnostic function has been called.
.ie n .IP "$host" 4
.el .IP "\f(CW$host\fR" 4
.IX Item "$host"
the name of the host executing the current \fBTakTuk\fR instance
.ie n .IP "$init_date\fR (\f(CW""connector""\fR and \f(CW""state"" only)" 4
.el .IP "\f(CW$init_date\fR (\f(CWconnector\fR and \f(CWstate\fR only)" 4
.IX Item "$init_date (connector and state only)"
the time in seconds since Jan. 1, 1970 at which the remote \fBTakTuk\fR instance
completed its initialization (including ssh connection time and self
propagation if any).
.ie n .IP "$level\fR (\f(CW""taktuk"" only)" 4
.el .IP "\f(CW$level\fR (\f(CWtaktuk\fR only)" 4
.IX Item "$level (taktuk only)"
the level of the diagnostic function called.
.ie n .IP "$level_name\fR (\f(CW""taktuk"" only)" 4
.el .IP "\f(CW$level_name\fR (\f(CWtaktuk\fR only)" 4
.IX Item "$level_name (taktuk only)"
the name associated with the level of the diagnostic function called.
.ie n .IP "$line" 4
.el .IP "\f(CW$line\fR" 4
.IX Item "$line"
the raw data outputed by a command or passed to a diagnostic function, any
trailing newline removed (see \f(CW$eof\fR).
.ie n .IP "$line_number\fR (\f(CW""taktuk"" only)" 4
.el .IP "\f(CW$line_number\fR (\f(CWtaktuk\fR only)" 4
.IX Item "$line_number (taktuk only)"
the line number at which a \fBTakTuk\fR diagnostic function has been called.
.ie n .IP "$package\fR (\f(CW""taktuk"" only)" 4
.el .IP "\f(CW$package\fR (\f(CWtaktuk\fR only)" 4
.IX Item "$package (taktuk only)"
the package in which a \fBTakTuk\fR diagnostic function has been called.
.ie n .IP "$peer\fR (\f(CW""connector""\fR and \f(CW""state"" only)" 4
.el .IP "\f(CW$peer\fR (\f(CWconnector\fR and \f(CWstate\fR only)" 4
.IX Item "$peer (connector and state only)"
the remote machine for which a connector command outputed information.
.ie n .IP "$peer_position\fR (\f(CW""connector""\fR and \f(CW""state"" only)" 4
.el .IP "\f(CW$peer_position\fR (\f(CWconnector\fR and \f(CWstate\fR only)" 4
.IX Item "$peer_position (connector and state only)"
position on the command line of the remote host. This position is expressed as
a path in the hierarchy of hosts expressed on the command line (dot separated
position number at each level of imbrication).
.ie n .IP "$pid\fR (not for \f(CW""taktuk""\fR nor \f(CW""info"")" 4
.el .IP "\f(CW$pid\fR (not for \f(CWtaktuk\fR nor \f(CWinfo\fR)" 4
.IX Item "$pid (not for taktuk nor info)"
the pid of the command line executed (that produced output).
.ie n .IP "$position" 4
.el .IP "\f(CW$position\fR" 4
.IX Item "$position"
position on the command line of the current host. This position is expressed as
a path in the hierarchy of hosts expressed on the command line (dot separated
position number at each level of imbrication).
.ie n .IP "$rank" 4
.el .IP "\f(CW$rank\fR" 4
.IX Item "$rank"
the logical number of \fBTakTuk\fR instance in which output is collected.
.ie n .IP "$reply_date\fR (\f(CW""connector""\fR and \f(CW""state"" only)" 4
.el .IP "\f(CW$reply_date\fR (\f(CWconnector\fR and \f(CWstate\fR only)" 4
.IX Item "$reply_date (connector and state only)"
the time in seconds since Jan. 1, 1970 at which the connector command replied
to the local \fBTakTuk\fR instance (note that this does not include the
initialization exange occuring before the remote \fBTakTuk\fR is considered as
functional).
.ie n .IP "$start_date\fR (\f(CW""output""\fR, \f(CW""error""\fR, \f(CW""connector""\fR and \f(CW""status"")" 4
.el .IP "\f(CW$start_date\fR (\f(CWoutput\fR, \f(CWerror\fR, \f(CWconnector\fR and \f(CWstatus\fR)" 4
.IX Item "$start_date (output, error, connector and status)"
the time in seconds since Jan. 1, 1970 at which the command started (taken just
after the call to \fIfork()\fR).
.ie n .IP "$stop_date\fR (\f(CW""connector""\fR and \f(CW""status"" only)" 4
.el .IP "\f(CW$stop_date\fR (\f(CWconnector\fR and \f(CWstatus\fR only)" 4
.IX Item "$stop_date (connector and status only)"
the time in seconds since Jan. 1, 1970 at which the command terminated (after
the closing of its stdout).
.ie n .IP "$type" 4
.el .IP "\f(CW$type\fR" 4
.IX Item "$type"
the name of the output stream (connector, error, output, ...).
.ie n .IP "$user_scalar" 4
.el .IP "\f(CW$user_scalar\fR" 4
.IX Item "$user_scalar"
a scalar, global to the package, initially initialized to undef, that the user
is free to use for any purpose.
.RE
.RS 4
.Sp
at the end of the day, the specification is evaluated for each line of the
concerned stream and the result printed on the root node.
Note that the newline has to be added explicitely as \f(CW\*(C`\en\*(C'\fR in the template if
needed.
.Sp
\&\s-1WARNING:\s0 take care of your specification, if the Perl syntax is not correct
lots of awfull compilation error messages will be displayed and \fBTakTuk\fR
execution will fail.
.RE
.IP "\fB\-R\fR stream=descriptor" 4
.IX Item "-R stream=descriptor"
.PD 0
.IP "\fB\-\-output\-redirect\fR stream=descriptor" 4
.IX Item "--output-redirect stream=descriptor"
.PD
redirect a given stream output to a given file descriptor number (located at
the root node). See \f(CW\*(C`\-o\*(C'\fR option for more details about streams output.
.SH "PERFORMANCE TUNING OPTIONS"
.IX Header "PERFORMANCE TUNING OPTIONS"
.IP "\fB\-g\fR duration" 4
.IX Item "-g duration"
.PD 0
.IP "\fB\-\-time\-granularity\fR duration" 4
.IX Item "--time-granularity duration"
.PD
sets to \f(CW\*(C`duration\*(C'\fR the maximal interval between timeouts checks (usually checks are made more often: at each message received a timeouts check is made).
.IP "\fB\-n\fR" 4
.IX Item "-n"
.PD 0
.IP "\fB\-\-no\-numbering\fR" 4
.IX Item "--no-numbering"
.PD
disables \fBTakTuk\fR logical numbering and the variables \f(CW\*(C`TAKTUK_COUNT\*(C'\fR and
\&\f(CW\*(C`TAKTUK_RANK\*(C'\fR are not defined in executed commands. This has the advantage of
removing the global synchronization occuring at the end of the deployment and
making the deployment more efficient.
.Sp
\&\s-1WARNING:\s0 use this option only before any remote node specification (\f(CW\*(C`\-m\*(C'\fR or
\&\f(CW\*(C`\-f\*(C'\fR) otherwise you might get serious synchronization issues in \fBTakTuk\fR.
Using \fBTakTuk\fR point-to-point communication along with this option will
fail and produce \fBTakTuk\fR warnings.
.IP "\fB\-t\fR timeout" 4
.IX Item "-t timeout"
.PD 0
.IP "\fB\-\-timeout\fR timeout" 4
.IX Item "--timeout timeout"
.PD
sets the timeout for following connectors (0 = no timeout). Notice that this
option override the timeout of the connector command (\f(CW\*(C`ssh\*(C'\fR for instance).
When the delay expires, the connector command is simply killed.
.IP "\fB\-w\fR size" 4
.IX Item "-w size"
.PD 0
.IP "\fB\-\-window\fR size" 4
.IX Item "--window size"
.PD
sets initial window to the given size (= pipeline width).
.IP "\fB\-W\fR scheme" 4
.IX Item "-W scheme"
.PD 0
.IP "\fB\-\-window\-adaptation\fR scheme" 4
.IX Item "--window-adaptation scheme"
.PD
sets the windows adaptation scheme to number (default is 0, 0: no adaptation,
1: implementation in progress).
.SH "MISCELLANEOUS OPTIONS"
.IX Header "MISCELLANEOUS OPTIONS"
.IP "\fB\-M\fR" 4
.IX Item "-M"
.PD 0
.IP "\fB\-\-my\fR" 4
.IX Item "--my"
.PD
makes the next option local (not inherited). This means that the next option is
set only for the local host and not propagated to children \fBTakTuk\fR instances.
Has no effect if the next option is already a local one.
.IP "\fB\-h\fR" 4
.IX Item "-h"
.PD 0
.IP "\fB\-\-help\fR" 4
.IX Item "--help"
.PD
prints a short description of \fBTakTuk\fR on the screen.
.IP "\fB\-i\fR" 4
.IX Item "-i"
.PD 0
.IP "\fB\-\-interactive\fR" 4
.IX Item "--interactive"
.PD
forces \fBTakTuk\fR interactive mode even after some batch commands given on the
command line.
.IP "\fB\-v\fR" 4
.IX Item "-v"
.PD 0
.IP "\fB\-\-version\fR" 4
.IX Item "--version"
.PD
prints the \fBTakTuk\fR version.
.IP "\fB\-P\fR" 4
.IX Item "-P"
.PD 0
.IP "\fB\-\-print\-defaults\fR" 4
.IX Item "--print-defaults"
.PD
prints the defaults settings used by \fBTakTuk\fR (environment variables taken
into account).
.SH "INTERNAL OPTIONS"
.IX Header "INTERNAL OPTIONS"
These option are not useful for most users. They are used either internally by
\&\fBTakTuk\fR itself or for development purposes.
.IP "\fB\-p\fR packagename" 4
.IX Item "-p packagename"
.PD 0
.IP "\fB\-\-print\-package\fR packagename" 4
.IX Item "--print-package packagename"
.PD
prints the content of package \f(CW\*(C`packagename\*(C'\fR extracted from the taktuk code in
execution.
.IP "\fB\-r\fR" 4
.IX Item "-r"
.PD 0
.IP "\fB\-\-not\-root\fR" 4
.IX Item "--not-root"
.PD
current \fBTakTuk\fR instance is not the root node. This is an internal switch
used by spawned \fBTakTuk\fR instances. This is usually not useful for most users.
.IP "\fB\-D\fR scope=level" 4
.IX Item "-D scope=level"
.PD 0
.IP "\fB\-\-debug\fR scope=level" 4
.IX Item "--debug scope=level"
.PD
sets debugging level (1..4) for \f(CW\*(C`scope\*(C'\fR. The \f(CW\*(C`scope\*(C'\fR might be a \fBTakTuk\fR package name or \f(CW\*(C`default\*(C'\fR and the lowest the level the more verbose the output.
.SH "COMMANDS"
.IX Header "COMMANDS"
After the options parsing, \fBTakTuk\fR expects some commands either on the
remaining of the command line (batch mode) or on the standard input
(interactive mode). These commands are actions to be performed by \fBTakTuk\fR
using the logical network infrastructure set up during the deployment. By
default, commands might be separated by ; or newlines. For all the commands,
any non ambiguous prefix can be used instead of their full name.
In interactive mode, \fBTakTuk\fR has support for \f(CW\*(C`readline\*(C'\fR (history, command
line editing) if installed on your system.
.PP
When \fBTakTuk\fR commands accept arguments, they should be enclosed into matching
delimiters (indicated by * below). In other words, * might be replaced either
by any non alphanumeric character or by a pair of matching braces, brackets or
parenthesis.
These delimiters must be separated from their content (using the options
separator). If the argument contains a closing delimiter preceded by a
separator, then it is probably a good idea to escape it (see \fB\-E\fR option) or
to protect the whole arguments string if given on the command line.
.PP
Taktuk understands the following commands:
.IP "\fB[ set specification ]\fR command" 4
.IX Item "[ set specification ] command"
Sends the execution of command to all the peers belonging to the given set. For
more details about the set specification, see section \*(L"\s-1SET\s0 \s-1SPECIFICATION\s0\*(R".
.IP "\fBbroadcast\fR command" 4
.IX Item "broadcast command"
Broadcasts the execution of command on all the remote peers (not including the
node initiating the broadcast).
.IP "\fBdowncast\fR command" 4
.IX Item "downcast command"
Spreads the execution of command on all the children of the node initiating
the downcast (not including itself).
.IP "\fBexec\fR parameters * command line *" 4
.IX Item "exec parameters * command line *"
Executes the \f(CW\*(C`command line\*(C'\fR on the local machine but has no effect on the root
node. Inputs/outputs of the execution are multiplexed and fowarded to the
\&\fBTakTuk\fR root.
.Sp
This command accepts optional parameters that enable the attachment of
callbacks triggered by timeouts to the execution of the command. See section
\&\*(L"\s-1EXEC\s0 \s-1PARAMETERS\s0\*(R" for more details.
.IP "\fBget\fR * src * * dest *" 4
.IX Item "get * src * * dest *"
Copies (a) remote source\&(s) (present on the remote node\&(s)) to a 
destination on the node executing this command.
The type of source and destination is quite similar to those accepted by the
\&\f(CW\*(C`cp \-r\*(C'\fR command (that is file or directories). This command also performs some
kind of magic with its parameters: shell environment variables present in the
source or destination names are replaced by their respective value on the
remote and local nodes.
In addition, the variables \f(CW$host\fR, \f(CW$rank\fR and \f(CW$position\fR of the remote
node (which are the same as in \fB\-o\fR option) can also be used in both names.
.IP "\fBhelp\fR" 4
.IX Item "help"
Prints a very concise \fBTakTuk\fR help.
.IP "\fBinput\fR * data *" 4
.IX Item "input * data *"
.PD 0
.IP "\fBinput data\fR * data *" 4
.IX Item "input data * data *"
.PD
Sends the parameters as input to each command in execution on the
local machine.
.IP "\fBinput close\fR" 4
.IX Item "input close"
Closes the inputs descriptor of all executing commands on the local machine.
.IP "\fBinput file\fR * filename *" 4
.IX Item "input file * filename *"
Sends the content of a file (which must be local to the node executing the
input file) as input to each command in execution on the local machine.
.Sp
\&\s-1WARNING:\s0 this command is not atomic. If you manage somehow to initiate a
input file command from two different \fBTakTuk\fR instances, data will probably
be interleaved. In this case you should synchronize the two instances. This is
not required when spreading files only from the root node.
.IP "\fBinput line\fR * data *" 4
.IX Item "input line * data *"
Sends the parameters with an additional newline as input to each
command in execution on the local machine.
.IP "\fBinput pipe\fR * data *" 4
.IX Item "input pipe * data *"
Treat the parameter as a filename (which must be local to the node executing
the input pipe) which behavior is the same as a pipe: data
can arrive continuously. \fBTakTuk\fR add it as one of its input channels and send
data as input to commands when available.
.IP "\fBkill\fR <signal>" 4
.IX Item "kill <signal>"
Sends the given signal to local commands processes groups. If no signal is
given, sends a \s-1TERM\s0 signal (signal 15).
.IP "\fBnetwork\fR" 4
.IX Item "network"
.PD 0
.IP "\fBnetwork state\fR" 4
.IX Item "network state"
.PD
Prints the current \fBTakTuk\fR deployment tree. Numbers in parenthesis match the
peer rank in the logical \fBTakTuk\fR numbering and the peer ready state. If the
deployment is not complete, the printed tree will display \f(CW\*(C`connecting ...\*(C'\fR
leaves.
.IP "\fBnetwork cancel\fR" 4
.IX Item "network cancel"
Cancels all ongoing connections. Consequently, this causes immediate starting
of the possible numbering of \fBTakTuk\fR instances and the execution of \fBTakTuk\fR
commands.
.IP "\fBnetwork renumber\fR" 4
.IX Item "network renumber"
Completely recomputes the logical numbering of \fBTakTuk\fR instances. This is
especially useful when adding new nodes to the deployed network after initial
numbering.
.IP "\fBnetwork update\fR" 4
.IX Item "network update"
Updates the logical numbering of \fBTakTuk\fR instances without changing already
existing numbers. Does not always succeed as \fBTakTuk\fR uses a depth first
scheme for numbering. Sends an event 9 in the stream 'state' for each node of
the tree that cannot be updated while keeping \fBTakTuk\fR numbering scheme.
This is especially useful when adding new nodes to the deployed network after
initial numbering.
.IP "\fBoption\fR name * value *" 4
.IX Item "option name * value *"
.PD 0
.IP "\fBoption\fR * line *" 4
.IX Item "option * line *"
.PD
Either changes a single option which name is given (first form) or parses an
additional options line (second form) on the node\&(s) executing this command.
See \fBTakTuk\fR options for more details, name can be either short or long in the
first form.
.Sp
\&\s-1WARNING:\s0 new nodes added to \fBTakTuk\fR network using this command are not
numbered. Further use of network renumbering or update is necessary to get
\&\fBTakTuk\fR logical numbering.
.IP "\fBput\fR * src * * dest *" 4
.IX Item "put * src * * dest *"
Copies a local source (present on the node executing this command) to a
destination on all the remote nodes given as prefix of the command.
The type of source and destination is quite similar to those accepted by the
\&\f(CW\*(C`cp \-r\*(C'\fR command (that is file or directories). This command also performs some
kind of magic with its parameters: shell environment variables present in the
source or destination names are replaced by their respective value on the
local and remote nodes.
In addition, the variables \f(CW$host\fR, \f(CW$rank\fR and \f(CW$position\fR of the local
node (which are the same as in \fB\-o\fR option) can also be used in both names.
.IP "\fBsynchronize\fR" 4
.IX Item "synchronize"
Forces the given command to wait for the completion of deployment, nodes
numbering and previous commands before executing. This is usefull for commands
like \f(CW\*(C`broadcast\*(C'\fR which does not wait for nodes numbering.
.IP "\fBtaktuk_perl\fR * arguments *" 4
.IX Item "taktuk_perl * arguments *"
Forks a perl interpreter on the local node just as if the command \f(CW\*(C`exec perl
arguments\*(C'\fR have been used. The difference is that this interpreter is
previously fetched with the \f(CW\*(C`taktuk\*(C'\fR package that contains point-to-point
communication routines (\f(CW\*(C`taktuk::send\*(C'\fR and \f(CW\*(C`taktuk::recv\*(C'\fR, see
\&\f(CWtaktukcomm(3)\fR).
\&\s-1WARNING:\s0 due to the limitations of the parser that analyses the arguments of
this command, you have to give arguments (even if empty) and to use '\-\-' if you
give any option to the perl interpreter (and even if you give it only options).
.IP "\fBversion\fR" 4
.IX Item "version"
prints \fBTakTuk\fR version.
.IP "\fBquit\fR" 4
.IX Item "quit"
Quit the \fBTakTuk\fR engine and shut down the logical communication network
established during the deployment.
.SH "EXEC PARAMETERS"
.IX Header "EXEC PARAMETERS"
The \fBTakTuk\fR command \f(CW\*(C`exec\*(C'\fR accepts optional parameters. These parameters are
used to attach actions triggered by timeouts to commands execution. An \f(CW\*(C`exec\*(C'\fR
command accepts any number of parameters. These parameters are
interpreted from left to right using the following syntax:
.IP "\fBtimeout\fR value" 4
.IX Item "timeout value"
Creates a new timeout specification. At the end of the duration expressed by
the given value, it will trigger its attached callbacks. If it has no attached
callback, it will send a \s-1TERM\s0 signal to the command. If the command
execution terminates before the end of the timeout duration, the timeout is
canceled.
.IP "\fBkill\fR value" 4
.IX Item "kill value"
Attach a callback to the last defined timeout. This callback send a signal,
which number is the given value, to the timeouted command.
.IP "\fBaction\fR command" 4
.IX Item "action command"
Attach a callback to the last defined timeout. This callback executes the given
\&\fBTakTuk\fR command. If it executes some other command, it can use the
environment variable \f(CW\*(C`TAKTUK_PID\*(C'\fR that contains the pid of the timeouted
command. The given \fBTakTuk\fR command can be any valid \fBTakTuk\fR command
(without command separator).
.PP
Notice that each timeout can have any number of attached callbacks. They will
be processed in the order they are given as parameters.
.SH "ENVIRONMENT"
.IX Header "ENVIRONMENT"
.IP "\fBVariables that change TakTuk default behavior\fR" 4
.IX Item "Variables that change TakTuk default behavior"
Some of \fBTakTuk\fR defaults settings can be changed on some host using
environment variables. These settings are propagated as are other options.
They are overridden by propagated settings and command line options.
.Sp
To change some default setting use the variable \fB\s-1TAKTUK_NAME\s0\fR where \fB\s-1NAME\s0\fR is
the name of the according long option in upper case and with dashes replaced by
underscores. For option taking complex value (such as \f(CW\*(C`\-\-debug\*(C'\fR) just add an
underscore and the field you want to change in upper case at the end of the
name.
Using \f(CW\*(C`taktuk \-\-print\-defaults\*(C'\fR will give you examples of names used to change
default settings.
Note that defining in the environment a default setting not used by \fBTakTuk\fR
has no effect.
.Sp
You can also change some \fBTakTuk\fR default settings locally without propagating
the change in the deployment tree. To do this, use the variable
\&\fB\s-1TAKTUK_MY_NAME\s0\fR where name is defined as above. As before, these local
settings are overridden by propagated settings and command line options.
.IP "\fBVariables set by TakTuk in remotely executed commands\fR" 4
.IX Item "Variables set by TakTuk in remotely executed commands"
Taktuk sets the following environment variables for all the commands it
executes :
.RS 4
.IP "\s-1TAKTUK_CONTROL_READ\s0, \s-1TAKTUK_CONTROL_WRITE\s0" 4
.IX Item "TAKTUK_CONTROL_READ, TAKTUK_CONTROL_WRITE"
File descriptors, used internally by \fBTakTuk\fR.
.IP "\s-1TAKTUK_COUNT\s0" 4
.IX Item "TAKTUK_COUNT"
The total number of successfully deployed \fBTakTuk\fR instances
.IP "\s-1TAKTUK_HOSTNAME\s0" 4
.IX Item "TAKTUK_HOSTNAME"
Local node hostname as given to \fBTakTuk\fR (on the command line)
.IP "\s-1TAKTUK_PIDS\s0" 4
.IX Item "TAKTUK_PIDS"
List of pids (separated by spaces) of commands executed by the local \fBTakTuk\fR
instance.
.IP "\s-1TAKTUK_POSITION\s0" 4
.IX Item "TAKTUK_POSITION"
Host position on the command line.
.IP "\s-1TAKTUK_RANK\s0" 4
.IX Item "TAKTUK_RANK"
The logical rank of the local instance
.RE
.RS 4
.RE
.SH "HOSTNAMES SPECIFICATION"
.IX Header "HOSTNAMES SPECIFICATION"
Hostnames given to \fBTakTuk\fR might be simple machine name or complex hosts
lists specifications. In its general form, an hostname is made of an host set
and an optional exclusion set separated by a slash.  Each of those sets is a
comma separated list of host templates.  Each of these templates is made of
constant part (characters outside brackets) and optional range parts
(characters inside brackets). Each range part is a comma separated list of
intervals or single values. Each interval is made of two single values
separated by a dash. This is true for all hostnames given to \fBTakTuk\fR (both
with \fB\-m\fR or \fB\-f\fR options).
.PP
In other words, the following expressions are valid host specifications:
    node1
    node[19]
    node[1\-3]
    node[1\-3],otherhost/node2
    node[1\-3,5]part[a\-b]/node[3\-5]parta,node1partb
.PP
they respectively expand to:
    node1
    node19
    node1 node2 node3
    node1 node3 otherhost
    node1parta node2parta node2partb node3partb node5partb
.PP
Notice that these list of values are not regular expressions (\f(CW\*(C`node[19]\*(C'\fR is
\&\f(CW\*(C`node19\*(C'\fR and not \f(CW\*(C`node1, node2, ...., node9\*(C'\fR). Intervals are implemented
using the perl magical auto increment feature, thus you can use alphanumeric
values as interval bounds (see perl documentation, operator ++ for limitations
of this auto increment).
.SH "SET SPECIFICATION"
.IX Header "SET SPECIFICATION"
The \fBTakTuk\fR command line and the \f(CW\*(C`taktuk::send\*(C'\fR routine accept a set
specification as destination host\&(s). A set specification is made of interval
specifications separated by slashes. An interval specification is made of a
single number or two numbers separated by a dash. Of course the two numbers
specifying an interval must be given in increasing order.
.PP
The remote peers included in a set specification are all the peer which logical
number belong to at least one interval of the set. Here are some exemples of
set specifications :
.PP
.Vb 2
\&    1
\&the peer numbered 1
.Ve
.PP
.Vb 2
\&    2-7
\&the peers numbered 2,3,4,5,6 and 7
.Ve
.PP
.Vb 2
\&    2-4/1/10
\&the peers numbered 1,2,3,4 an 10
.Ve
.SH "EXAMPLES"
.IX Header "EXAMPLES"
The following examples illustrate the basic use of \fBTakTuk\fR on a few machines and the use of developper options. Notice that \fBTakTuk\fR is designed to scale to much more peers than the number involved in these examples.
.Sh "Basic usage"
.IX Subsection "Basic usage"
.IP "\fBsimple deployment\fR" 4
.IX Item "simple deployment"
the simplest way to use \fBTakTuk\fR is to make it selfpropagate with option
\&\f(CW\*(C`\-s\*(C'\fR. In this case, the basic remote execution of \f(CW\*(C`hostname\*(C'\fR on the host
\&\f(CW\*(C`toto.nowhere.com\*(C'\fR can be written :
.Sp
.Vb 1
\&    taktuk -s -m toto.nowhere.com broadcast exec [ hostname ]
.Ve
.Sp
In this example, \f(CW\*(C`\-s\*(C'\fR asks \fBTakTuk\fR to propagate its own code on remote
hosts. It can be removed by installing the \f(CW\*(C`taktuk\*(C'\fR executable on
\&\f(CW\*(C`toto.nowhere.com\*(C'\fR. By the following we will assume that \fBTakTuk\fR is
installed on all the remote hosts.
.Sp
The \f(CW\*(C`\-m toto.nowhere.com\*(C'\fR describe the set of remote hosts to be contacted by
\&\fBTakTuk\fR and \f(CW\*(C`broadcast exec [hostname]\*(C'\fR is a command that will be executed
by the \fBTakTuk\fR interpreter.
.Sp
This example can be written in many other ways. In interactive mode, the
same execution might become:
.Sp
.Vb 1
\&    taktuk -m toto.nowhere.com
.Ve
.Sp
here \fBTakTuk\fR is blocked waiting for commands from stdin. Thus, we just have
to type:
.Sp
.Vb 2
\&    broadcast exec { hostname }
\&    Ctrl-D
.Ve
.Sp
here you can notice that parameters to the \f(CW\*(C`exec\*(C'\fR \fBTakTuk\fR command (as all
commands parameters) can be enclosed in any reasonable pair of delimiters.
We might also write the list of hosts involved in the command in
a file \f(CW\*(C`machine\*(C'\fR that contains:
.Sp
.Vb 1
\&    toto.nowhere.com
.Ve
.Sp
and the \fBTakTuk\fR command becomes:
.Sp
.Vb 1
\&    taktuk -f machine broadcast exec - hostname -
.Ve
.Sp
We could also use another file \f(CW\*(C`options\*(C'\fR that contains:
.Sp
.Vb 1
\&    -f machine
.Ve
.Sp
and use it as the options line given to \fBTakTuk\fR:
.Sp
.Vb 1
\&    taktuk -F options broadcast exec \e( hostname \e)
.Ve
.Sp
Finally, everything could be stored in a last file \f(CW\*(C`command_line\*(C'\fR that
contains:
.Sp
.Vb 1
\&    -f machine broadcast exec = hostname =
.Ve
.Sp
and the following command achieve the same result:
.Sp
.Vb 1
\&    taktuk -F command_line
.Ve
.Sp
All of these variants have the same effect: they execute \f(CW\*(C`hostname\*(C'\fR on \f(CW\*(C`toto.nowhere.com\*(C'\fR and the output of the program is forwarded to the localhost. In this case:
.Sp
.Vb 1
\&    toto.nowhere.com: hostname: somepid: output > toto.nowhere.com
.Ve
.IP "\fBparameters braces\fR" 4
.IX Item "parameters braces"
notice that braces for command parameters must be separated from their content.
Thus, they can contain other braces as long as no single closing brace is part
of the content:
.Sp
.Vb 1
\&    taktuk -m localhost broadcast exec [ 'if [ $RANDOM -gt 10000 ];then echo greater;else echo lower;fi' ]
.Ve
.Sp
In this example, quotes are necessary to prevent the shell from interpreting
the \f(CW\*(C`$\*(C'\fR and \f(CW\*(C`;\*(C'\fR characters and to prevent the closing brace for \f(CW\*(C`if\*(C'\fR toe be
considered as closing the \f(CW\*(C`exec\*(C'\fR command.
In this case the variable will be interpolated
only on remote hosts. This same example can also be expressed using shortcuts
and intercative mode:
.Sp
.Vb 1
\&    taktuk -m localhost -E%
.Ve
.Sp
then type:
.Sp
.Vb 2
\&    b e [ if [ $RANDOM -gt 10000 %];then echo greater;else echo lower;fi ]
\&    Ctrl-D
.Ve
.Sp
Notice the closing bracket used in the test that should not be
interpreted as the closing bracket for \f(CW\*(C`exec\*(C'\fR arguments. In such case, a
simpler solution is probably to use another kind of braces
.Sp
.Vb 1
\&    taktuk -m localhost
.Ve
.Sp
and then:
    b e { if [ \f(CW$RANDOM\fR \-gt 10000 ];then echo greater;else echo lower;fi }
    Ctrl-D
.Sp
Usually, if you want to be safe, you can quote all commands parameters.
Nevertheless, notice that parameters should not be quoted in interactive mode
as input lines are not interpreted by the shell.
.IP "\fBexec parameters\fR" 4
.IX Item "exec parameters"
commands executed by \fBTakTuk\fR can be timeouted using \f(CW\*(C`exec\*(C'\fR parameters.
For instance if you want to execute some command and send it a \s-1TERM\s0 signal
after two seconds, just type:
.Sp
.Vb 1
\&    taktuk -m localhost broadcast exec timeout 2 [ sleep 10 ]
.Ve
.Sp
the callback executed when a timeout occurs can also be something else than a
\&\s-1TERM\s0 signal. This can be another signal (\s-1KILL\s0 for instance):
.Sp
.Vb 1
\&    taktuk -m localhost broadcast exec timeout 2 kill 9 [ sleep 10 ]
.Ve
.Sp
or any valid \fBTakTuk\fR command:
.Sp
.Vb 1
\&    taktuk -m localhost broadcast exec timeout 2 action broadcast exec [ echo hello ] [ sleep 10 ]
.Ve
.Sp
or even several timeouts and several callbacks:
.Sp
.Vb 1
\&    taktuk -m localhost b e t 2 a e [ echo hello ] k 30 t 10 k 9 [ sleep 5 ]
.Ve
.Sp
in this last example, the command \f(CW\*(C`sleep 5\*(C'\fR is executed by \fBTakTuk\fR. After 2
seconds, the first timeout will be triggered, it will execute the command
\&\f(CW\*(C`echo hello\*(C'\fR and send a \s-1USR1\s0 signal to the first command (\f(CW\*(C`sleep 5\*(C'\fR). The
second timeout is set to 10 seconds. Thus, it will never occur as the
\&\f(CW\*(C`sleep 5\*(C'\fR command will be terminated before its expiration.
.IP "\fBtopology\fR" 4
.IX Item "topology"
Usually, \fBTakTuk\fR deploys itself using a relatively flat tree because its
default window size is quite large (10 simultaneous ongoing connections).
Using a smaller window size will result in a deeper tree although it also
depends on the local load of the deployment nodes.  You can use the
\&\fBTakTuk\fR \f(CW\*(C`network state\*(C'\fR command to print the tree constructed by \fBTakTuk\fR.
.Sp
Notice that it is usually a bad idea to use a too large window as it results in
too much local load and bad distribution of work (something like 10 is often sufficient).
.Sp
You can also force \fBTakTuk\fR to use more specific topologies. For instance, to
execute \f(CW\*(C`echo $$\*(C'\fR using a flat-tree as deployment topology, just disable
work-stealing in \fBTakTuk\fR:
.Sp
.Vb 1
\&    taktuk -d -1 -m host1 -m host2 -m host3 broadcast exec [ 'echo $$' ]
.Ve
.Sp
and to use a chain-like topology, either encode the topology in arguments
structure:
.Sp
.Vb 1
\&    taktuk -m host1 -[ -m host2 -[ -m host3 -] -] broadcast exec [ 'echo $$' ]
.Ve
.Sp
or limits the arity of the dynamic tree to 1:
.Sp
.Vb 1
\&    taktuk -d 1 -m host1 -m host2 -m host3 broadcast exec [ 'echo $$' ]
.Ve
.Sp
Finally, the default will use a dynamicly constructed topology:
.Sp
.Vb 1
\&    taktuk -d 0 -m host1 -m host2 -m host3 broadcast exec [ 'echo $$' ]
.Ve
.IP "\fBlightweight grid deployment\fR" 4
.IX Item "lightweight grid deployment"
On a lightweight grid, because of locality issues (ldap cache, network
topology, ...) it seems interesting to separate the deployment of each
subcluster. To do this, it is possible to choose one node in each subcluster
that will be deployed first and from which the rest of the cluster will be
deployed:
.Sp
.Vb 1
\&    taktuk -m node1.cluster1 -[ -m node2.cluster1 -m node3.cluster1 -m node4.cluster1 -] -m node1.cluster2 -[ -m node2.cluster2 -m node3.cluster2 -m node4.cluster2 -] broadcast exec [ hostname ]
.Ve
.Sp
This command has the effect of deploying \fBTakTuk\fR on two clusters (cluster 1
and 2) made of four nodes (node 1 to 4) using node1 of each cluster to deploy
the other nodes in the same cluster. Finally, once the deployment is complete,
it executes the command \f(CW\*(C`hostname\*(C'\fR on all these nodes.
.IP "\fBexecuting a distinct command on each host\fR" 4
.IX Item "executing a distinct command on each host"
each distinct host can be given its own command using arguments:
.Sp
.Vb 1
\&    ./taktuk -m host1 -[ exec [ hostname ] -] -m host2 -[ exec [ id ] -] -m host3 -[ exec [ 'echo $TAKTUK_RANK; ls' ] -] quit
.Ve
.Sp
but this could also be given using set specification (in this case logical
number are used for hosts):
.Sp
.Vb 1
\&    ./taktuk -m host1 -m host3 -m host8 1 exec [ hostname ], 2 exec [ id ], 3 exec [ 'echo $TAKTUK_RANK; ls' ]
.Ve
.Sp
or in interactive mode:
.Sp
.Vb 5
\&    ./taktuk -m host1 -m host3 -m host8
\&    1 exec [ hostname ]
\&    2 exec [ id ]
\&    3 exec [ echo $TAKTUK_RANK; ls ]
\&    Ctrl-D
.Ve
.IP "\fBscript diffusion\fR" 4
.IX Item "script diffusion"
spreading and executing a perl script named \f(CW\*(C`essai.pl\*(C'\fR on three hosts, knowing
that \f(CW\*(C`taktuk\*(C'\fR and \f(CW\*(C`essai.pl\*(C'\fR are only present on the root node:
.Sp
.Vb 5
\&    taktuk -s -m host1 -m host2 -m host3
\&    broadcast exec [ perl -- - ]
\&    broadcast input file [ essai.pl ]
\&    broadcast input close
\&    Ctrl-D
.Ve
.IP "\fBfiles diffusion and collection\fR" 4
.IX Item "files diffusion and collection"
since version 3.4, files transfer is supported directly by TakTuk. Notice that
this transfer uses the \fBTakTuk\fR network (usually a tree composed of ssh
connections by default). This network is not efficient for the tranfer of large
files (both topologically and from a protocol point of view), so keep this in
mind when using this feature.
.Sp
copying a file named \f(CW\*(C`message.txt\*(C'\fR to the \f(CW\*(C`/tmp\*(C'\fR directory of each remote
host is thus as easy as:
.Sp
.Vb 3
\&    taktuk -s -m host1 -m host2 -m host3
\&    broadcast put [ message.txt ] [ /tmp ]
\&    Ctrl-D
.Ve
.Sp
but the older method still works (and does almost the same as the previous
command):
.Sp
.Vb 5
\&    taktuk -s -m host1 -m host2 -m host3
\&    broadcast exec [ cat - >/tmp/message.txt ]
\&    broadcast input file [ message.txt ]
\&    broadcast input close
\&    Ctrl-D
.Ve
.Sp
although it reuqires to be more careful about shell interpretation when typing
everything directly on the command line:
.Sp
.Vb 1
\&    taktuk -s -m host1 -m host2 -m host3  broadcast exec [ 'cat - >/tmp/message.txt' ]\e;broadcast input file [ message.txt ]
.Ve
.Sp
notice in this latter command that the \f(CW\*(C`input close\*(C'\fR is not necessary as
\&\fBTakTuk\fR closes inputs of all spawned commands when quiting.
.Sp
the \f(CW\*(C`get\*(C'\fR command also makes possible things that were previously very
difficult in \fBTakTuk\fR, files collecting. The following command gets the file
\&\f(CW\*(C`/tmp/message.txt\*(C'\fR from each remote host and copies it locally to
\&\f(CW\*(C`message\-number.txt\*(C'\fR where \f(CW\*(C`number\*(C'\fR is the logical rank of the source node:
.Sp
.Vb 3
\&    taktuk -s -m host1 -m host2 -m host3
\&    broadcast get [ /tmp/message.txt ] [ message-$rank.txt ]
\&    Ctrl-D
.Ve
.Sp
finally, it seems important to mention that \f(CW\*(C`put/get\*(C'\fR commands can copy
directories and keep files permissions unchanged.
.IP "\fBcommunication\fR" 4
.IX Item "communication"
establishing a point-to-point communication. Assume the file
\&\f(CW\*(C`communication.pl\*(C'\fR contains the following Perl script:
.Sp
.Vb 16
\&    my $rank = taktuk::get('rank');
\&    my $count = taktuk::get('count');
\&    if ($rank == 1)
\&      {
\&        print "I'm process 1\en";
\&        if ($count > 1)
\&          {
\&            taktuk::send(to=>2, body=>"Hello world");
\&          }
\&      }
\&    elsif ($rank == 2)
\&      {
\&        print "I'm process 2\en";
\&        my ($to, $from, $message) = taktuk::recv();
\&        print "Process $to received $message from $from\en";
\&      }
.Ve
.Sp
then the execution of the following command:
.Sp
.Vb 1
\&    taktuk -m localhost -m localhost broadcast taktuk_perl [ - ]\e;broadcast input file [ communication.pl ]
.Ve
.Sp
would produce an output similar to:
.Sp
.Vb 5
\&    Astaroth.local: taktuk_perl: 3523: output > I'm process 2
\&    Astaroth.local: taktuk_perl: 3523: output > Process 2 received Hello world from 1
\&    Astaroth.local: taktuk_perl: 3523: status > 0
\&    Astaroth.local: taktuk_perl: 3524: output > I'm process 1
\&    Astaroth.local: taktuk_perl: 3524: status > 0
.Ve
.Sp
if the file \f(CW\*(C`communication.pl\*(C'\fR was placed in the login directory of the user,
this could have also been executed by the more simple:
.Sp
.Vb 1
\&    taktuk -m localhost -m localhost broadcast taktuk_perl [ communication.pl ]
.Ve
.IP "\fBoutput templates and redirections\fR" 4
.IX Item "output templates and redirections"
making each site echo its rank without command status information:
.Sp
.Vb 1
\&    taktuk -o status -m host1 -m host2 broadcast exec [ 'echo $TAKTUK_RANK' ]
.Ve
.Sp
or removing the prompt before each line of output from commands:
.Sp
.Vb 1
\&    taktuk -o output='"$line\en"' -m host1 -m host2 broadcast exec [ 'echo $TAKTUK_RANK' ]
.Ve
.Sp
or even changing the prompt to make it display only the stream type:
.Sp
.Vb 1
\&    taktuk -o default='"$type > $line\en"' -m host1 -m host2 broadcast exec [ 'echo $TAKTUK_RANK' ]
.Ve
.Sp
and it also possible to redirect the status to file descriptor 2 only for the
second host:
.Sp
.Vb 1
\&    taktuk -m host1 -R status=2 -m host2 broadcast exec [ 'echo $TAKTUK_RANK' ]
.Ve
.Sp
and so on...
.Sh "Developer usage"
.IX Subsection "Developer usage"
.IP "\fBdebugging TakTuk\fR" 4
.IX Item "debugging TakTuk"
debugging in \fBTakTuk\fR is made using \f(CW\*(C`debug\*(C'\fR, \f(CW\*(C`warning\*(C'\fR and \f(CW\*(C`error\*(C'\fR functions of the package \f(CW\*(C`diagnostic\*(C'\fR. These routines, depending on the debugging level of the package in which they are called, produce an output that is propagated up to the root node and printed on screen.
.Sp
By default the debugging level of packages is set to 2 (everything is printed out except \f(CW\*(C`debug\*(C'\fR messages). It might be changed for each package using the \fB\-D\fR option. For instance the following code executes \f(CW\*(C`true\*(C'\fR on \f(CW\*(C`toto.nowhere.com\*(C'\fR and prints out every bit of internal messaging:
.Sp
.Vb 1
\&    taktuk -D default=1 -m toto.nowhere.com broadcast exec [ true ]
.Ve
.Sp
but one could have executed the same command keeping only messages from the \f(CW\*(C`scheduler\*(C'\fR package:
.Sp
.Vb 1
\&    taktuk -D scheduler=1 -m toto.nowhere.com broadcast exec [ true ]
.Ve
.Sp
or ensuring an  execution exempted of any warning or error messages:
.Sp
.Vb 1
\&    taktuk -D default=4 -m toto.nowhere.com broadcast exec [ true ]
.Ve
.IP "\fBinternal messages server\fR" 4
.IX Item "internal messages server"
the internal message server used in \fBTakTuk\fR for the management of logical
network construction, commands execution and I/O forwarding can be exposed
using the \fB\-r\fR option:
.Sp
.Vb 1
\&    taktuk -r
.Ve
.Sp
Notice that in this mode the behavior of \fBTakTuk\fR can seem very cryptic. This is not intended for ordinary users.
.SH "BUGS"
.IX Header "BUGS"
The development of \fBTakTuk\fR is still in progress, so there are propably
numbers of bugs. For now, the following characteristics (some of them are not
really bugs) have been identified :
.IP "hanged commands" 4
.IX Item "hanged commands"
currently \fBTakTuk\fR do not quit (even if asked to do so) if some local commands
do not terminate upon the closing of their standard input. Interrupting
\&\fBTakTuk\fR actually terminate the engine but do not kill these commands. We
still have to decide if this is the appropriate behavior.
.IP "command order" 4
.IX Item "command order"
broadcasts and multicast (set specifications) are not synchronized the same way
in \fBTakTuk\fR. Thus, broadcast commands given after multicast commands might be
executed before these last ones. Use the \f(CW\*(C`synchronize\*(C'\fR command to avoid this.
.IP "synchronized network state" 4
.IX Item "synchronized network state"
implementation of the \f(CW\*(C`synchronize\*(C'\fR command do not allow a proper
synchronization of the \f(CW\*(C`network state\*(C'\fR command. This might change in the
future but is not in the priority list.
.IP "slow connections" 4
.IX Item "slow connections"
this is not really a bug : on some clusters, the connections are \s-1VERY\s0
slow when doing a large deployment (over 50 nodes) with self propagation.
This result in a total time for the deployment of 50 nodes that can take
several minutes (up to half an hours in some cases).
I don't know what's the exact cause (ldap ? local load ? writes block ?) but it
can be fixed by adding connection timeouts to connectors.
.IP "fork failures" 4
.IX Item "fork failures"
this is not really a bug : when a machine is highly loaded, fork may fail.
If this happen to a local command, a distributed application may deadlock,
because the taktuk instances numbering is correct but some instance didn't
fork the local command.
The simplest fix is to use timeouts on taktuk::recv\&().
.PP
You might also want to have a look at:
.PP
.Vb 1
\&    http://taktuk.gforge.inria.fr/Bugs.txt
.Ve
.PP
where all the temporary bugs are listed version by version.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\f(CWtaktukcomm(3)\fR
.SH "AUTHOR"
.IX Header "AUTHOR"
The original concept of \fBTakTuk\fR has been proposed by Cyrille Martin in his PhD thesis. People involved in this work include Jacques Briat, Olivier Richard, Thierry Gautier and Guillaume Huard.
.PP
The author of the version 3 (perl version) and current maintainer of the package is Guillaume Huard.
.SH "COPYRIGHT"
.IX Header "COPYRIGHT"
\&\fBTakTuk\fR is provided under the terms of the \s-1GNU\s0 General Public License version
2 or later.
