//Filename: system_info.h
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#ifndef SYSTEM_INFO_H
#define SYSTEM_INFO_H

#include <iostream>
#include <fstream>

//global variables
Glib::ustring ostype = "unknown";
Glib::ustring release = "unknown";
Glib::ustring kerv = "unknown";
Glib::ustring kerd = "unknown";
Glib::ustring hostname = "unknown";
Glib::ustring domainname = "unknown";
Glib::ustring gversion = "unknown";
Glib::ustring gccv = "unknown";
Glib::ustring xorgv = "unknown";
Glib::ustring uptime = "unknown";
Glib::ustring timedate = "unknown";


//operating system type
void Ostype() {
	
	std::ifstream text("/proc/sys/kernel/ostype");
	char line[30];
	text.getline(line,30,'\n');
	
	ostype = line;

	text.close();
}

//release redhat-release
void Release()
{
	//redhat (fedora)
	std::ifstream redhat("/etc/redhat-release");
	if (!redhat.good()) {}
		else {
			char line[80];
			redhat.getline(line,80,'\n');
			release = line;
		}
	redhat.close();
	
	//suse
	std::ifstream suse("/etc/SuSE-release");
	if (!suse.good()) {}
		else {
			char line[80];
			suse.getline(line,80,'\n');
			release = line;
		}
	suse.close();
		
	//slackware
	std::ifstream slack("/etc/slackware-release");
	if (!slack.good()) {}
		else {
			char line[80];
			slack.getline(line,80,'\n');
			release = line;
		}
	slack.close();
		
	//debian
	std::ifstream debian("/etc/debian_version");
	if (!debian.good()) {}
		else {
			char line[80];
			debian.getline(line,80,'\n');
			release = line;
		}
	debian.close();
		
	//mandrake
	std::ifstream mdk("/etc/mandrake-release");
	if (!mdk.good()) {}
		else {
			char line[80];
			mdk.getline(line,80,'\n');
			release = line;
		}
	mdk.close();
		
	//yellow dog
	std::ifstream yd("/etc/yellowdog-release");
	if (!yd.good()) {}
		else {
			char line[80];
			yd.getline(line,80,'\n');
			release = line;
		}
	yd.close();
		
	//sun JDK
	std::ifstream sun("/etc/sun-release");
	if (!sun.good()) {}
		else {
			char line[80];
			sun.getline(line,80,'\n');
			release = line;
		}
	sun.close();
		
	//gentoo
	std::ifstream gentoo("/etc/gentoo-release");
	if (!gentoo.good()) {}
		else {
			char line[80];
			gentoo.getline(line,80,'\n');
			release = line;
		}
	gentoo.close();
		
	//solaris sparc
	std::ifstream ss("/etc/release");
	if (!ss.good()) {}
		else {
			char line[80];
			ss.getline(line,80,'\n');
			release = line;
		}
	ss.close();
}

//kernel version
void KernelVersion() {
	
	std::ifstream text1("/proc/sys/kernel/osrelease");
	char line1[50];
	text1.getline(line1,50,'\n');
	
	kerv = line1;
	
	std::ifstream text2("/proc/sys/kernel/version");
	char line2[50];
	text2.getline(line2,50,'\n');
	
	kerd = line2;
  
	text1.close();
	text2.close();
}

//hostname
void Hostname() {
	
	std::ifstream text("/proc/sys/kernel/hostname");
	char line[30];
	text.getline(line,30,'\n');

	hostname = line;

	text.close();
}

//domainname
void Domainname() {
	
	std::ifstream text("/proc/sys/kernel/domainname");
	char line[50];
	text.getline(line,100,'\n');

	domainname = line;

	text.close();
}

//gnome version
void Gversion() {
	Glib::ustring gv1, gv2, gv3, gv4, gv5;
  
	std::ifstream text("/usr/share/gnome-about/gnome-version.xml");
	char line[150];
	int x = 0;
	while (!text.eof() && x < 9) {
		
		text.getline(line,150,'\n');
		if(strstr(line, "<platform>")) {
			gv1 = line;
			gv1.erase(0,12);
			gv1.erase(gv1.find("</platform>"), 11);
		}
		
		if(strstr(line, "<minor>")) {
			gv2 = line;
			gv2.erase(0,9);
			gv2.erase(gv2.find("</minor>"), 8);
		}
		
		if(strstr(line, "<micro>")) {
			gv3 = line;
			gv3.erase(0,9);
			gv3.erase(gv3.find("</micro>"), 8);
		}
		
		if(strstr(line, "<distributor>")) {
			gv4 = line;
			gv4.erase(0,15);
			gv4.erase(gv4.find("</distributor>"), 14);
		}
		
		if(strstr(line, "<date>")) {
			gv5 = line;
			gv5.erase(0,8);
			gv5.erase(gv5.find("</date>"), 7);
		}
		x++;
	}
	text.close();
	
	gversion = gv1 + "." + gv2 + "." + gv3 + " - " + gv4 + " (" + gv5 + ")";
}

//gcc version
void Gccv() {
	
	FILE *file;
	Glib::ustring temp1, temp2;
	char gcc1[50];
	file = popen("gcc -dumpversion", "r");
	fgets(gcc1, 50, file);
	gcc1[strlen(gcc1)-1] = ' ';
	pclose(file);
	
	char gcc2[50];
	file = popen("gcc -dumpmachine", "r");
	fgets(gcc2, 50, file);
	gcc2[strlen(gcc2)-1] = ' ';
	pclose(file);
	
	temp1 = gcc1; temp2 = gcc2;
	gccv = temp1 + "- " + temp2;
}

//Xorg version
void Xorgv() {
	
	std::ifstream text("/var/log/Xorg.0.log");
	char line[150];
	int a = 0;
	while (!text.eof() && a < 9) {
		text.getline(line,150,'\n');
		if(strstr(line, "X Window System Version")) {
			xorgv = line;
			xorgv.erase(0, 24);
		}
		a++;
	}
	text.close();
}

//uptime
void Uptime()
{
  Glib::ustring uptime1, uptime2, uptime3;
  
	std::ifstream text("/proc/uptime");
	char line[80];
	text.getline(line,80,' ');
	
	//days
	int numbers3 = atoi(line);
	numbers3 = (numbers3/86400);
	
	char chars3[50];
	sprintf(chars3, "%d", numbers3);
	
	uptime3 = chars3;
	
	//hours
	int numbers1 = atoi(line);
	numbers1 = (numbers1/3600) - (numbers3 * 24);
	
	char chars1[50];
	sprintf(chars1, "%d", numbers1);
	
	uptime1 = chars1;
	
	//seconds
	int numbers2 = atoi(line);
	numbers2 = (numbers2/60) - ((numbers3 * 1440) + (numbers1 * 60));

	char chars2[50];
	sprintf(chars2, "%d", numbers2);
	
	uptime2 = chars2;

	text.close();
	
	uptime = uptime3 + " days " + uptime1 + " h " + uptime2 + " min";
}

//time & date
void Timedate()
{
	FILE *file;
	
	char td[50];
	file = popen("date", "r");
	fgets(td, 50, file);
	td[strlen(td)-1] = ' ';
	
	timedate = td;
	
	pclose(file);
}

#endif //SYSTEM_INFO_H

//ghaefb
