//Filename: sysinfo.cc
/*
 * Sysinfo
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#include <iostream>
#include "sysinfo.h"
#include "system_info.h"
#include "cpu_info.h"
#include "memory_info.h"
#include "ide_info.h"
#include "filesystem_info.h"
#include "hardware_info.h"
#include "usb_info.h"
#include "other_info.h"
#include "savetofile.h"
#include "nvidia_info.h"

//sysinfo version
Glib::ustring sysinfo_version = "0.6.1";

//sysinfo class
Sysinfo::Sysinfo(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
: Gtk::Window(cobject),
  m_refGlade(refGlade),
  m_TreeView(0)
{
	//functions calls
	Ostype(); Release(); KernelVersion(); Hostname(); Domainname(); Gversion(); Gccv(); Xorgv(); Uptime(); Timedate();
	Cpuinfo1(); Cpuinfo2(); Cpuinfo3(); Cpuinfo4(); Cpuinfo5(); Cpuinfo6(); Cpuinfo7(); Cpuinfo8();
	Meminfo1(); Meminfo2(); Meminfo3(); Meminfo4(); Meminfo5(); Meminfo6(); Meminfo7(); Meminfo_progress();
	Hda(); Hdb(); Hdc(); Hdd(); Df();
	Motherboard(); Idec(); Vgac(); Soundc(); Eth();
	Usb(); Sound(); Nvidia(); Inputdev(); Screen(); Nvidia();
	
	//menuitems connect
	m_refGlade->get_widget("quit1", menuitem_quit);
	menuitem_quit->signal_activate().connect( sigc::mem_fun(*this, &Sysinfo::on_menuitem_quit) );
	m_refGlade->get_widget("save1", menuitem_save);
    menuitem_save->signal_activate().connect( sigc::mem_fun(*this, &Sysinfo::on_menuitem_save) );
	m_refGlade->get_widget("refresh1", menuitem_refresh);
    menuitem_refresh->signal_activate().connect( sigc::mem_fun(*this, &Sysinfo::on_menuitem_refresh) );
	m_refGlade->get_widget("about1", menuitem_about);
	menuitem_about->signal_activate().connect( sigc::mem_fun(*this, &Sysinfo::on_menuitem_about) );
	
	//treeview
	m_refGlade->get_widget("treeview1", m_TreeView);
    if(m_TreeView) {
		m_refTreeModel = Gtk::ListStore::create(m_Columns);
		m_TreeView->set_model(m_refTreeModel);
		
		Gtk::TreeModel::Row row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_sys = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_sys.png");
		row[m_Columns.pix1] = pix_sys;
		row[m_Columns.m_col1] = "System";
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_cpu = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_cpu.png");
		row[m_Columns.pix1] = pix_cpu;
		row[m_Columns.m_col1] = "CPU";
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_mem = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_mem.png");
		row[m_Columns.pix1] = pix_mem;
		row[m_Columns.m_col1] = "Memory";
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_ide = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_ide.png");
		row[m_Columns.pix1] = pix_ide;
		row[m_Columns.m_col1] = "IDE";
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_filesys = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_filesys.png");
		row[m_Columns.pix1] = pix_filesys;
		row[m_Columns.m_col1] = "Filesystem";
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_hard = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_hard.png");
		row[m_Columns.pix1] = pix_hard;
		row[m_Columns.m_col1] = "Hardware";
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_usb = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_usb.png");
		row[m_Columns.pix1] = pix_usb;
		row[m_Columns.m_col1] = "USB";
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_other = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_other.png");
		row[m_Columns.pix1] = pix_other;
		row[m_Columns.m_col1] = "Other";
		if (nvi_mod != "unknown") {
		row = *(m_refTreeModel->append());
		Glib::RefPtr<Gdk::Pixbuf> pix_nvi = Gdk::Pixbuf::create_from_file("/usr/share/pixmaps/sysinfo/sysinfo_nvi.png");
		row[m_Columns.pix1] = pix_nvi;
		row[m_Columns.m_col1] = "NVIDIA"; }
		
		m_TreeView->append_column("Pix", m_Columns.pix1);
		m_TreeView->append_column("Navigation", m_Columns.m_col1);
		
		m_refTreeSelection = m_TreeView->get_selection();
        m_refTreeSelection->set_mode(Gtk::SELECTION_SINGLE);
        m_refTreeSelection->signal_changed().connect( sigc::mem_fun(*this, &Sysinfo::on_selection_changed) );
		

    }
	
	//system info
	m_refGlade->get_widget("entry_ostype", entry_ostype);
	entry_ostype->set_text(ostype);
	m_refGlade->get_widget("entry_release", entry_release);
	entry_release->set_text(release);
	m_refGlade->get_widget("entry_kernel", entry_kernel);
	entry_kernel->set_text(kerv);
	m_refGlade->get_widget("entry_buildtime", entry_buildtime);
	entry_buildtime->set_text(kerd);
	m_refGlade->get_widget("entry_hostname", entry_hostname);
	entry_hostname->set_text(hostname);
	m_refGlade->get_widget("entry_domainname", entry_domainname);
	entry_domainname->set_text(domainname);
	m_refGlade->get_widget("entry_gnomeversion", entry_gnomeversion);
	entry_gnomeversion->set_text(gversion);
	m_refGlade->get_widget("entry_gccversion", entry_gccversion);
	entry_gccversion->set_text(gccv);
	m_refGlade->get_widget("entry_xorgversion", entry_xorgversion);
	entry_xorgversion->set_text(xorgv);
	m_refGlade->get_widget("entry_uptime", entry_uptime);
	entry_uptime->set_alignment(0.5);
	entry_uptime->set_text(uptime);
	
	//cpu info
	m_refGlade->get_widget("entry_cpu_name", entry_cpu_name);
	entry_cpu_name->set_text(cpuinfo2);
	m_refGlade->get_widget("entry_cpu_vendor", entry_cpu_vendor);
	entry_cpu_vendor->set_text(cpuinfo1);
	m_refGlade->get_widget("entry_cpu_frequency", entry_cpu_frequency);
	entry_cpu_frequency->set_text(cpuinfo3);
	m_refGlade->get_widget("entry_cpu_cache", entry_cpu_cache);
	entry_cpu_cache->set_text(cpuinfo4);
	m_refGlade->get_widget("entry_cpu_bogomips", entry_cpu_bogomips);
	entry_cpu_bogomips->set_text(cpuinfo8);
	m_refGlade->get_widget("entry_cpu_model", entry_cpu_model);
	entry_cpu_model->set_text(cpuinfo5);
	m_refGlade->get_widget("entry_cpu_family", entry_cpu_family);
	entry_cpu_family->set_text(cpuinfo6);
	m_refGlade->get_widget("entry_cpu_stepping", entry_cpu_stepping);
	entry_cpu_stepping->set_text(cpuinfo7);
	
	//memory info
	m_refGlade->get_widget("entry_mem_total", entry_mem_total);
	entry_mem_total->set_text(meminfo1);
	m_refGlade->get_widget("progressbar1", progressbar_mem);
	progressbar_mem->set_text(meminfo2);
	progressbar_mem->set_fraction(mem);
	m_refGlade->get_widget("entry_mem_cached", entry_mem_cached);
	entry_mem_cached->set_text(meminfo3);
	m_refGlade->get_widget("entry_mem_active", entry_mem_active);
	entry_mem_active->set_text(meminfo4);
	m_refGlade->get_widget("entry_mem_inactive", entry_mem_inactive);
	entry_mem_inactive->set_text(meminfo5);
	m_refGlade->get_widget("entry_mem_swaptotal", entry_mem_swaptotal);
	entry_mem_swaptotal->set_text(meminfo6);
	m_refGlade->get_widget("entry_mem_swapfree", entry_mem_swapfree);
	entry_mem_swapfree->set_text(meminfo7);
	
	//ide info
	m_refGlade->get_widget("label_ide_pm", label_ide_pm);
	label_ide_pm->set_text("Primary Master /dev/hda - " + hdamedia);
	m_refGlade->get_widget("entry_idepm_model", entry_idepm_model);
	entry_idepm_model->set_text(hdamodel);
	m_refGlade->get_widget("entry_idepm_capa", entry_idepm_capa);
	entry_idepm_capa->set_text(hdacapa);
	m_refGlade->get_widget("entry_idepm_cache", entry_idepm_cache);
	entry_idepm_cache->set_text(hdacache);
	m_refGlade->get_widget("label_ide_ps", label_ide_ps);
	label_ide_ps->set_text("Primary Slave /dev/hdb - " + hdbmedia);
	m_refGlade->get_widget("entry_ideps_model", entry_ideps_model);
	entry_ideps_model->set_text(hdbmodel);
	m_refGlade->get_widget("entry_ideps_capa", entry_ideps_capa);
	entry_ideps_capa->set_text(hdbcapa);
	m_refGlade->get_widget("entry_ideps_cache", entry_ideps_cache);
	entry_ideps_cache->set_text(hdbcache);
	m_refGlade->get_widget("label_ide_sm", label_ide_sm);
	label_ide_sm->set_text("Secondary Master /dev/hdc - " + hdcmedia);
	m_refGlade->get_widget("entry_idesm_model", entry_idesm_model);
	entry_idesm_model->set_text(hdcmodel);
	m_refGlade->get_widget("entry_idesm_capa", entry_idesm_capa);
	entry_idesm_capa->set_text(hdccapa);
	m_refGlade->get_widget("entry_idesm_cache", entry_idesm_cache);
	entry_idesm_cache->set_text(hdccache);
	m_refGlade->get_widget("label_ide_ss", label_ide_ss);
	label_ide_ss->set_text("Secondary Slave /dev/hdd - " + hddmedia);
	m_refGlade->get_widget("entry_idess_model", entry_idess_model);
	entry_idess_model->set_text(hddmodel);
	m_refGlade->get_widget("entry_idess_capa", entry_idess_capa);
	entry_idess_capa->set_text(hddcapa);
	m_refGlade->get_widget("entry_idess_cache", entry_idess_cache);
	entry_idess_cache->set_text(hddcache);
	
	//filesystem info
	Sysinfo::on_filesystem_set();
	
	//hardware info
	m_refGlade->get_widget("textview_hardware_mot", textview_hardware_mot);
	text_hardware_mot = Gtk::TextBuffer::create();
	if (motc1 != "")
		text_hardware_mot->set_text(motc1);
	if (motc2 != "")
		text_hardware_mot->set_text(motc1 + "\n" + motc2);
	if (motc3 != "")
		text_hardware_mot->set_text(motc1 + "\n" + motc2 + "\n" + motc3);
	textview_hardware_mot->set_buffer(text_hardware_mot);
	
	m_refGlade->get_widget("entry_hardware_ide", entry_hardware_ide);
	entry_hardware_ide->set_text(idec);
	m_refGlade->get_widget("entry_hardware_vga", entry_hardware_vga);
	entry_hardware_vga->set_text(vgac);
	
	m_refGlade->get_widget("textview_hardware_sound", textview_hardware_sound);
	text_hardware_sou = Gtk::TextBuffer::create();
	if (souc1 != "")
		text_hardware_sou->set_text(souc1);
	if (souc2 != "")
		text_hardware_sou->set_text(souc1 + "\n" + souc2);
	textview_hardware_sound->set_buffer(text_hardware_sou);
	
	m_refGlade->get_widget("textview_hardware_eth", textview_hardware_eth);
	text_hardware_eth = Gtk::TextBuffer::create();
	if (ethc1 != "")
		text_hardware_eth->set_text(ethc1);
	if (ethc2 != "")
		text_hardware_eth->set_text(ethc1 + "\n" + ethc2);
	textview_hardware_eth->set_buffer(text_hardware_eth);
	
	//usb info
	m_refGlade->get_widget("textview_usb", textview_usb);
	text_usb = Gtk::TextBuffer::create();
	if (usbc1 != "")
		text_usb->set_text(usbc1);
	if (usbc2 != "")
		text_usb->set_text(usbc1 + "\n" + usbc2);
	if (usbc3 != "")
		text_usb->set_text(usbc1 + "\n" + usbc2 + "\n" + usbc3);
	if (usbc4 != "")
		text_usb->set_text(usbc1 + "\n" + usbc2 + "\n" + usbc3 + "\n" + usbc4);
	if (usbc5 != "")
		text_usb->set_text(usbc1 + "\n" + usbc2 + "\n" + usbc3 + "\n" + usbc4 + "\n" + usbc5);
	if (usbc6 != "")
		text_usb->set_text(usbc1 + "\n" + usbc2 + "\n" + usbc3 + "\n" + usbc4 + "\n" + usbc5 + "\n" + usbc6);
	textview_usb->set_buffer(text_usb);
	
	//other info
	m_refGlade->get_widget("textview_other_sound", textview_other_sound);
	text_other_sound = Gtk::TextBuffer::create();
	if (sound1 != "")
		text_other_sound->set_text(sound1);
	if (sound2 != "")
		text_other_sound->set_text(sound1 + "\n" + sound2);
	textview_other_sound->set_buffer(text_other_sound);
	
	m_refGlade->get_widget("textview_other_input", textview_other_input);
	text_other_input = Gtk::TextBuffer::create();
	if (inp1 != "")
		text_other_input->set_text(inp1);
	if (inp2 != "")
		text_other_input->set_text(inp1 + "\n" + inp2);
	if (inp3 != "")
		text_other_input->set_text(inp1 + "\n" + inp2 + "\n" + inp3);
	if (inp4 != "")
		text_other_input->set_text(inp1 + "\n" + inp2 + "\n" + inp3 + "\n" + inp4);
	if (inp5 != "")
		text_other_input->set_text(inp1 + "\n" + inp2 + "\n" + inp3 + "\n" + inp4 + "\n" + inp5);
	if (inp6 != "")
		text_other_input->set_text(inp1 + "\n" + inp2 + "\n" + inp3 + "\n" + inp4 + "\n" + inp5 + "\n" + inp6);
	textview_other_input->set_buffer(text_other_input);
	
	m_refGlade->get_widget("entry_other_screen", entry_other_screen);
	entry_other_screen->set_alignment(0.5);
	entry_other_screen->set_text(sw + " x " + sh);
	
	//nvidia info
	m_refGlade->get_widget("entry_nvi_mod", entry_nvi_mod);
	entry_nvi_mod->set_text(nvi_mod);
	m_refGlade->get_widget("entry_nvi_agp", entry_nvi_agp);
	entry_nvi_agp->set_text(nvi_agp);
	m_refGlade->get_widget("entry_nvi_fw", entry_nvi_fw);
	entry_nvi_fw->set_text(nvi_fw);
	m_refGlade->get_widget("entry_nvi_sba", entry_nvi_sba);
	entry_nvi_sba->set_text(nvi_sba);
	m_refGlade->get_widget("entry_nvi_ver", entry_nvi_ver);
	entry_nvi_ver->set_text(nvi_ver);
	
	m_refGlade->get_widget("button_nvi", button_nvi);
	button_nvi->signal_clicked().connect( sigc::mem_fun(*this, &Sysinfo::on_button_nvi) );

	
	//statusbar
	m_refGlade->get_widget("statusbar1", statusbar);
	statusbar->push("Sysinfo - version " + sysinfo_version +  "    [ " + timedate + "]", 0);
}

//sysinfo destructior
Sysinfo::~Sysinfo() {
	
    delete m_TreeView;
	delete m_TreeView3;
	
	delete menuitem_quit;
	delete menuitem_save;
	delete menuitem_refresh;
	delete menuitem_about;
	delete aboutdialog;
	
	delete filechooserdialog;
	delete notebook;
	
	delete entry_ostype;
	delete entry_release;
	delete entry_kernel;
	delete entry_buildtime;
	delete entry_hostname;
	delete entry_domainname;
	delete entry_gnomeversion;
	delete entry_gccversion;
	delete entry_xorgversion;
	delete entry_uptime;
	
	delete entry_cpu_name;
	delete entry_cpu_vendor;
	delete entry_cpu_frequency;
	delete entry_cpu_cache;
	delete entry_cpu_bogomips;
	delete entry_cpu_model;
	delete entry_cpu_family;
	delete entry_cpu_stepping;
	
	delete entry_mem_total;
	delete progressbar_mem;
	delete entry_mem_cached;
	delete entry_mem_active;
	delete entry_mem_inactive;
	delete entry_mem_swaptotal;
	delete entry_mem_swapfree;
	
	delete entry_idepm_model;
	delete entry_idepm_capa;
	delete entry_idepm_cache;
	delete entry_ideps_model;
	delete entry_ideps_capa;
	delete entry_ideps_cache;
	delete entry_idesm_model;
	delete entry_idesm_capa;
	delete entry_idesm_cache;
	delete entry_idess_model;
	delete entry_idess_capa;
	delete entry_idess_cache;
	
	delete textview_hardware_mot;
	delete textview_hardware_sound;
	delete textview_hardware_eth;
	delete entry_hardware_ide;
	delete entry_hardware_vga;
	
	delete textview_usb;
	
	delete textview_other_sound;
	delete textview_other_input;
	delete entry_other_screen;
	
	delete entry_nvi_mod;
	delete entry_nvi_agp;
	delete entry_nvi_fw;
	delete entry_nvi_sba;
	delete entry_nvi_ver;
	delete button_nvi;
	
	delete statusbar;
}

//selection changed
void Sysinfo::on_selection_changed() {
    Gtk::TreeModel::iterator iter = m_refTreeSelection->get_selected();
	
	m_refGlade->get_widget("notebook1", notebook);
    if(notebook)
    if(iter) {
		
        Gtk::TreeModel::Row row2 = *iter;
        Glib::ustring temp = row2[m_Columns.m_col1];
        if (temp == "System")
			notebook->set_current_page(0);
		else if (temp == "CPU")
			notebook->set_current_page(1);
		else if (temp == "Memory")
			notebook->set_current_page(2);
		else if (temp == "IDE")
			notebook->set_current_page(3);
		else if (temp == "Filesystem")
			notebook->set_current_page(4);
		else if (temp == "Hardware")
			notebook->set_current_page(5);
		else if (temp == "USB")
			notebook->set_current_page(6);
		else if (temp == "Other")
			notebook->set_current_page(7);
		else if (temp == "NVIDIA")
			notebook->set_current_page(8);
    }
}


//menuitem quit
void Sysinfo::on_menuitem_quit() {
    hide();
}

//menuitem save
void Sysinfo::on_menuitem_save() {
	
	m_refGlade->get_widget("filechooserdialog1", filechooserdialog);
    if(filechooserdialog) {
		filechooserdialog->show();
    }
	Savetofile(filechooserdialog, sysinfo_version);
}

//menuitem refresh
void Sysinfo::on_menuitem_refresh() {
	//memory info refresh
	Meminfo2(); Meminfo3(); Meminfo4(); Meminfo5(); Meminfo7(); Meminfo_progress();
	m_refGlade->get_widget("progressbar1", progressbar_mem);
	progressbar_mem->set_text(meminfo2);
	progressbar_mem->set_fraction(mem);
	m_refGlade->get_widget("entry_mem_cached", entry_mem_cached);
	entry_mem_cached->set_text(meminfo3);
	m_refGlade->get_widget("entry_mem_active", entry_mem_active);
	entry_mem_active->set_text(meminfo4);
	m_refGlade->get_widget("entry_mem_inactive", entry_mem_inactive);
	entry_mem_inactive->set_text(meminfo5);
	m_refGlade->get_widget("entry_mem_swapfree", entry_mem_swapfree);
	entry_mem_swapfree->set_text(meminfo7);
	
	//filesystem refresh
	Df();
	m_refGlade->get_widget("treeview3", m_TreeView3);
	m_TreeView3->remove_all_columns();
	Sysinfo::on_filesystem_set();
	
	//ide refresh
	Hda(); Hdb(); Hdc(); Hdd();
	m_refGlade->get_widget("entry_idepm_capa", entry_idepm_capa);
	entry_idepm_capa->set_text(hdacapa);
	m_refGlade->get_widget("entry_ideps_capa", entry_ideps_capa);
	entry_ideps_capa->set_text(hdbcapa);
	m_refGlade->get_widget("entry_idesm_capa", entry_idesm_capa);
	entry_idesm_capa->set_text(hdccapa);
	m_refGlade->get_widget("entry_idess_capa", entry_idess_capa);
	entry_idess_capa->set_text(hddcapa);
	
	//screen resolution refresh
	Screen();
	m_refGlade->get_widget("entry_other_screen", entry_other_screen);
	entry_other_screen->set_text(sw + " x " + sh);
	
	//statusbar timedate
	Timedate();
	m_refGlade->get_widget("statusbar1", statusbar);
	statusbar->push("Sysinfo - version " + sysinfo_version +  "    [ " + timedate + "]", 0);
}

//filesystem set
void Sysinfo::on_filesystem_set() {
	
	m_refGlade->get_widget("treeview3", m_TreeView3);
    if(m_TreeView3) {
		m_refTreeModel3 = Gtk::ListStore::create(m_Columns3);
		m_TreeView3->set_model(m_refTreeModel3);
		
		Gtk::TreeModel::Row row3 = *(m_refTreeModel3->append());
		row3[m_Columns3.col_filesys] = filesys1;
		row3[m_Columns3.col_type] = type1;
		row3[m_Columns3.col_size] = size1;
		row3[m_Columns3.col_used] = used1;
		row3[m_Columns3.col_avalible] = avail1;
		row3[m_Columns3.col_use1] = use1;
		row3[m_Columns3.col_mounted] = mount1;
		
		if ( line2 > 0) {
			row3 = *(m_refTreeModel3->append());
			row3[m_Columns3.col_filesys] = filesys2;
			row3[m_Columns3.col_type] = type2;
			row3[m_Columns3.col_size] = size2;
			row3[m_Columns3.col_used] = used2;
			row3[m_Columns3.col_avalible] = avail2;
			row3[m_Columns3.col_use1] = use2;
			row3[m_Columns3.col_mounted] = mount2;
		}
		if ( line3 > 0) {
			row3 = *(m_refTreeModel3->append());
			row3[m_Columns3.col_filesys] = filesys3;
			row3[m_Columns3.col_type] = type3;
			row3[m_Columns3.col_size] = size3;
			row3[m_Columns3.col_used] = used3;
			row3[m_Columns3.col_avalible] = avail3;
			row3[m_Columns3.col_use1] = use3;
			row3[m_Columns3.col_mounted] = mount3;
		}
		if ( line4 > 0) {
			row3 = *(m_refTreeModel3->append());
			row3[m_Columns3.col_filesys] = filesys4;
			row3[m_Columns3.col_type] = type4;
			row3[m_Columns3.col_size] = size4;
			row3[m_Columns3.col_used] = used4;
			row3[m_Columns3.col_avalible] = avail4;
			row3[m_Columns3.col_use1] = use4;
			row3[m_Columns3.col_mounted] = mount4;
		}
		if ( line5 > 0) {
			row3 = *(m_refTreeModel3->append());
			row3[m_Columns3.col_filesys] = filesys5;
			row3[m_Columns3.col_type] = type5;
			row3[m_Columns3.col_size] = size5;
			row3[m_Columns3.col_used] = used5;
			row3[m_Columns3.col_avalible] = avail5;
			row3[m_Columns3.col_use1] = use5;
			row3[m_Columns3.col_mounted] = mount5;
		}
		if ( line6 > 0) {
			row3 = *(m_refTreeModel3->append());
			row3[m_Columns3.col_filesys] = filesys6;
			row3[m_Columns3.col_type] = type6;
			row3[m_Columns3.col_size] = size6;
			row3[m_Columns3.col_used] = used6;
			row3[m_Columns3.col_avalible] = avail6;
			row3[m_Columns3.col_use1] = use6;
			row3[m_Columns3.col_mounted] = mount6;
		}
		if ( line7 > 0) {
			row3 = *(m_refTreeModel3->append());
			row3[m_Columns3.col_filesys] = filesys7;
			row3[m_Columns3.col_type] = type7;
			row3[m_Columns3.col_size] = size7;
			row3[m_Columns3.col_used] = used7;
			row3[m_Columns3.col_avalible] = avail7;
			row3[m_Columns3.col_use1] = use7;
			row3[m_Columns3.col_mounted] = mount7;
		}
		if ( line8 > 0) {
			row3 = *(m_refTreeModel3->append());
			row3[m_Columns3.col_filesys] = filesys8;
			row3[m_Columns3.col_type] = type8;
			row3[m_Columns3.col_size] = size8;
			row3[m_Columns3.col_used] = used8;
			row3[m_Columns3.col_avalible] = avail8;
			row3[m_Columns3.col_use1] = use8;
			row3[m_Columns3.col_mounted] = mount8;
		}
		
		m_TreeView3->append_column("Filesystem", m_Columns3.col_filesys);
		m_TreeView3->append_column("Type", m_Columns3.col_type);
		m_TreeView3->append_column("Size", m_Columns3.col_size);
		m_TreeView3->append_column("Used", m_Columns3.col_used);
		m_TreeView3->append_column("Available", m_Columns3.col_avalible);
		m_TreeView3->append_column("Use %", m_Columns3.col_use1);
		m_TreeView3->append_column("Mounted on", m_Columns3.col_mounted);
	}
}	

//menuitem about
void Sysinfo::on_menuitem_about() {
	
	m_refGlade->get_widget("aboutdialog1", aboutdialog);
    if(aboutdialog) {
		aboutdialog->set_version(sysinfo_version);
		aboutdialog->show();
    }
}

//nvidia-settings button
void Sysinfo::on_button_nvi() {
	
	FILE *file;
	file = popen("nvidia-settings &", "r");
	pclose(file);
}


//ghaefb
