/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Sysinfo 0.6.1
 * Copyright (C) Nil Gradisnik 2005 <ghaefb@gmail.com>
 * 
 * Sysinfo is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * sysinfo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with main.cc.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */

#include <libglademm/xml.h>
#include <gtkmm.h>
#include <iostream>
#include "sysinfo.h"

#define GLADE_FILE PACKAGE_DATA_DIR"/sysinfo/glade/sysinfo.glade"

//main function
int 
main (int argc, char *argv[]) {
	
	Gtk::Main kit(argc, argv);
	
	//load the Glade file and instiate its widgets:
	Glib::RefPtr<Gnome::Glade::Xml> refXml;
	try {
		refXml = Gnome::Glade::Xml::create(GLADE_FILE);
	}
	catch(const Gnome::Glade::XmlError& ex) {
		std::cerr << ex.what() << std::endl;
		return 1;
	}
  
	//sysinfo window
	Sysinfo* pSysinfo = 0;
    refXml->get_widget_derived("main_window", pSysinfo);
    if(pSysinfo) {
        kit.run(*pSysinfo);
    }

}

//ghaefb
