C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=CBARY3,SSI=0
                        SUBROUTINE CBARY3
C                       *****************
C
C      --------------------------------------------------
     * (XX,YY,ZZ,XA,YA,ZA,XB,YB,ZB,XC,YC,ZC,XL1,XL2,XL3)
C      --------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            CALCUL DES COORDONNEES BARYCENTRIQUES D'UN POINT DANS     *
C            UN TRIANGLE                                               *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C ! XX,YY,ZZ  !  R ! D  ! COORDONNEES DU POINT DONT ON CHERCHE LES     !
C !           !    !    ! COORD. BARYCENTRIQUES                        !
C ! XA,YA,ZA, !  R ! D  ! COORD. DES 3 POINTS DU TRIANGLE PAR RAPPORT  !
C ! XB,YB,ZB, !  R ! D  ! AUXQUELS ON CHERCHE LES COORD. BARY.         !
C ! XC,YC,ZC  !  R ! D  !                                              !
C !XL1,XL2,XL3!  R ! R  ! COORDONNEES BARYCENTRIQUES                   !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : CORFS3
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C
      DOUBLE PRECISION XX,YY,ZZ,XA,YA,ZA,XB,YB,ZB,XC,YC,ZC
      DOUBLE PRECISION XL1,XL2,XL3,DENO
      DOUBLE PRECISION DETERM,X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3
C
C***********************************************************************
         DETERM (X1,Y1,Z1,X2,Y2,Z2,X3,Y3,Z3) = 
     &       X1*Y2*Z3 + X2*Y3*Z1 + Y1*Z2*X3
     &    -  Z1*Y2*X3 - Y1*X2*Z3 - Z2*Y3*X1
C
C***********************************************************************
C
C
      DENO = DETERM (XA,YA,1.D0,XB,YB,1.D0,XC,YC,1.D0)
C
      IF (ABS(DENO) .GT. 1.D-6) THEN
C      
         XL1  = DETERM (XX,YY,1.D0,XB,YB,1.D0,XC,YC,1.D0)
         XL2  = DETERM (XA,YA,1.D0,XX,YY,1.D0,XC,YC,1.D0)
C
      ELSE
C
         DENO = DETERM (YA,ZA,1.D0,YB,ZB,1.D0,YC,ZC,1.D0)
C
         IF (ABS(DENO) .GT. 1.D-6) THEN

           XL1  = DETERM (YY,ZZ,1.D0,YB,ZB,1.D0,YC,ZC,1.D0)
           XL2  = DETERM (YA,ZA,1.D0,YY,ZZ,1.D0,YC,ZC,1.D0)
C
         ELSE
C
           DENO = DETERM (XA,ZA,1.D0,XB,ZB,1.D0,XC,ZC,1.D0)
           XL1  = DETERM (XX,ZZ,1.D0,XB,ZB,1.D0,XC,ZC,1.D0)
           XL2  = DETERM (XA,ZA,1.D0,XX,ZZ,1.D0,XC,ZC,1.D0)
C
         ENDIF

      ENDIF
C 
      XL1 = XL1 / DENO
      XL2 = XL2 / DENO
      XL3 = 1.D0 - XL1 - XL2

      END





