/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
# include <stdio.h>
# include <stdlib.h>
# include <math.h>

# include "f2c_syrthes.h"
# include "abs.h"

/* tableaux */
extern int *ncoups,*nfluss,*ndirs,*nechs,*nfluvs,*nrescs,*nrayts;
extern int *nrayis,*nprios,*nmobil;
extern double *vfluss,*vdirs,*vechs,*vfluvs,*vrescs,*vrayts,*vrayis;
extern int *nrefac,*nrefal,*nfcous,*nfflus,*nfechs,*nfresc,*nfrays,*nfrais;
extern double *vfflus,*vfechs,*vfresc,*vfrays,*vfrais,*coords;
extern int *nrefs,*nrefe,*nodes,*nangle,*nodess,*nodeus,*noderc,*nodepr,*nodera;
extern double *physol,*tmpsa,*tmps,*tmpsc1,*tmpsc2,*tmpsc3,*volume,*surfus;
extern double *tmpmax, *tmpmin;
extern int *ngffir,*ngftir,*ngfper,*ngfpef;
extern int *ngfmst,*ngfmse;
extern double *vfmste,*phmstp,*phmsto;
extern double *emissi,*phfraf,*phfrae,*temray,*firay,*vfiray;
extern double *erayeq,*trayeq,*erayen,*trayen,*epropr;
extern int *nodray,*nrfray,*ityfar,*ncsray,*ncfray,*nesray;
extern double *cooray,*fdfray,*sufray;
extern int *ncfin,*ncgros,*itrav;
extern double *tabray,*radios,*flumst,*barygr,*baryfs;
extern double *b,*dmat,*xmat,*diag,*wct;
extern int *itrav1,*itrav2;
extern double *trav1,*trav2,*trav3,*trav4,*travf;
extern int *ncfinf,*ncgrof,*ncbors,*ncborf,*nodesf,*ncoupf,*nrapf,*nodraf;
extern double *baryfr,*baryff,*barys,*baryf,*vcoups,*vcoupf,*vfcous;
extern double *cooraf,*coordf,*vrapf;

/* constantes */
extern int ndim,nelesf,nbcouf,nbraf,nelraf,ndmasf;
extern int npoins,nelems,neless,neleus,nelepr,nelerc,nelera;
extern int nbcous,nbflus,nbdirs,nbechs,nbflvs,nbress;
extern int nbrays,nbrais,nbprio,nbmobs,nbfflu,nbfech,nbfrai;
extern int ndiele,ndmats,ndmass,ncoema,nbphys,nbface;
extern int nbcopr,nbicor,nppel,npoue,npfel;
extern int npoinr,nelray,nnsray,nnfray,nneray;
extern int nfcfra,nfcsra,nftira,nffira,nfpera,nfmst,nfmste;

extern int nbpaso,nbpara;
extern double timso,totso,totray;
extern double totsoi,totrai;

extern double *b,*trav1,*trav2,*trav3,*trav4,*dmat,*diag,*xmat,*wct,*travf;
extern int idtrav;

/*|======================================================================|
  | SYRTHES 3.4.2                                     COPYRIGHT EDF 2008 |
  |======================================================================|
  | AUTEURS  : C. PENIGUEL, I. RUPP                                      |
  |======================================================================|
  | syrtc2                                                               |
  |         Resolution Syrthes avec couplage avec Code_Saturne           |
  |======================================================================| */

proc(syrtc2,SYRTC2)(int *fin,int *npoinf,double *dtfluid,double *tf,double *hht)
{
  /* variable pour tests sorties */
  int test_sortie = 0;

  /* double *b,*trav1,*trav2,*trav3,*trav4,*dmat,*diag,*xmat,*wct,*travf; */
  double timra1,timra2,timso1,timso2;
  int un=1,deux=2,i,nb,nnn,prem=1;

  /* variables a recuperer des communs */
  int lcface,lray,ntsyr,ncthfs,ldern,lstops,lhisor,ltmax;
  int nchror,lsdepl,ntsmax,ntsyrd,lhisol,nhrmax,nbande,ndprop,nfreqs;
  double rdtts,tempss;
  int lsyrth=0;

  /* 0- MISE A JOUR DU TEMPS REEL 
     ============================*/

  proc(recusy,RECUSY)(&lsyrth,&lcface,&lray,&ntsyr,&ncthfs,&ldern,&lstops,&lhisor,
		      &nchror,&lsdepl,&ntsmax,&ntsyrd,&lhisol,&nhrmax,&nbande,&ndprop,
		      &rdtts,&tempss,&nfreqs,&ltmax);

  if (*fin) ldern = 1;

  ntsyr++;
  proc(cadtmy,CADTMY)(&ntsyr,&rdtts,dtfluid,&prem,&npoins,tmpsa,tmps);
  prem=0;tempss+=rdtts;
  proc(envosy,ENVOSY)(&lsyrth,&ntsyr,&ldern,&lstops,&tempss,&ntsmax);
  
  /* 1- BANNIERE
     ===========*/
  printf("\n ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
  printf(" ITERATION SOLIDE  NTSYR=%7d   TEMPSS=%14.8e  dt=%12.5e\n",ntsyr,tempss,rdtts);
  printf(" ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n\n");
  
  /* 2- Passage des conditions limites du fluide vers le solide
     ==========================================================*/
  proc(solflc,SOLFLC)(&deux,&un,
		      &ndim,&nbcouf,ncoupf,vcoupf,vcoupf+nbcouf,
		      npoinf,tf,hht,&un,&nbcouf);

  
  /* 2- RESOLUTION RAYONNEMENT
     ========================= */
  
  if (lray) 
    {
      proc(cpusyr,CPUSYR)(&timra1);

      nbpara++;
      printf("\n **TEMPS D'ENTREE RAYONNEMENT : %f\n",timra1);
      
      proc(solray,SOLRAY)(&ndim,&npoins,tmps,&nbrays,nrayts,vrayts);
      
      proc(limray,LIMRAY)(&ndim,&nelray,&npoinr,
			  &nfcfra,&nfcsra,&nftira,&nffira,&nfpera,
			  nodray,nrfray,ngffir,ngftir,ngfper,ngfpef,
			  cooray,emissi,temray,firay,phfraf,phfrae,vfiray);
      
      for (i=0;i<idtrav;i++) trav3[i]=trav4[i]=0;
      
      if (nfpera) proc(resrer,RESRER)(&un,&nfpera,&nelray,
				      ngfper,temray,trayeq,erayeq,phfrae,trav3,trav4);
      
      
      if (nbrays)  /* (ITRAV de dimension NELRAY) */
	proc(pasray,PASRAY)(&un,&ndim,&npoinr,&nbrays,
			    nrayts,vrayts,&nbraf,nrapf,vrapf,nrfray,
			    ityfar,&nelray,nodray,&nelraf,&ndmasf,
			    &nelera,&ndmass,nodera,nodraf,
			    &nnsray,&nnfray,&nfcfra,ngfpef,ncsray,ncfray,
			    ncfin,ncgros,barygr,ncfinf,ncgrof,baryfr,baryff,baryfs,
			    temray,firay,erayeq,trayeq,phfraf,trayen,erayen,sufray,
			    trav1,trav2,trav3,trav4);
      
      for (i=0;i<nelray;i++) {*(trav3+i)=0.;*(trav4+i)=0.;}
      
      if (nfpera>0)
	proc(resrer,RESRER)(&un,&nfpera,&nelray,
			    ngfper,temray,trayeq,erayeq,phfrae,trav3,trav4);
      
      if (nfcfra>0)
	proc(resrer,RESRER)(&deux,&nfcfra,&nelray,ngfper,
			    temray,trayeq,erayeq,phfrae,trav3,trav4);
      
      proc(resray,RESRAY)(&ndim,&nelray,&npoinr,
			  cooray,nodray,nrfray,
			  fdfray,sufray,temray,radios,firay,trayeq,erayeq,
			  emissi,epropr,&nffira,ngffir,vfiray,tabray,
			  &nfmst,ngfmst,flumst,phmsto);

      
      proc(pasray,PASRAY)(&deux,&ndim,&npoinr,&nbrays,
			  nrayts,vrayts,&nbraf,nrapf,vrapf,nrfray,
			  ityfar,&nelray,nodray,&nelraf,&ndmasf,
			  &nelera,&ndmass,nodera,nodraf,
			  &nnsray,&nnfray,&nfcfra,ngfpef,ncsray,ncfray,
			  ncfin,ncgros,barygr,ncfinf,ncgrof,baryfr,baryff,baryfs,
			  temray,firay,erayeq,trayeq,phfraf,trayen,erayen,sufray,
			  trav1,trav2,trav3,trav4);
      
      if (lcface) 
	proc(pssclf,PSSCLF)(&nbrays,vrayts,&nelera,&ndmass,vfrays,nodera);


      /* temps CPU rayonnement
	 --------------------- */
      proc(cpusyr,CPUSYR)(&timra2); totray+=abs(timra2-timra1); fflush(stdout);
    }
  
  
  /* 3- RESOLUTION CONDUCTION
     ======================== */
  
  proc(cpusyr,CPUSYR)(&timso1); 

  nbpaso++;

  proc(ressol, RESSOL) 
    (&ndim,&ndiele,&nbcouf,&nelesf,&ndmasf,&nbface,
     &nbcous,&nbflus,&nbdirs,&nbechs,&nbflvs,&npfel,&npoins,&nelems,&ndmats,
     &neless,&ndmass,&neleus,&nelerc,&nelepr,&nbress,&nbrays,&nbrais,
     &nbprio,&nbmobs,&nbcopr,&nbphys,&nppel,&npoue,&ncoema,&nbicor,
     nodesf,ncoupf,vcoupf,ncoups,nfluss,ndirs,nechs,nfluvs,
     nrescs,nrayts,nrayis,nprios,nmobil,
     vcoups,vfluss,vdirs,vechs,vfluvs,vrescs,vrayts,vrayis,nrefac,nrefal,
     nrefs,nrefe,coords,nodes,nodess,nodeus,noderc,nodepr,
     nangle,nfflus,vfflus,&nbfflu,nfechs,vfechs,&nbfech, nfresc,vfresc,
     nfrays,vfrays,&nelera,
     nfrais,vfrais,&nbfrai, nfcous,vfcous, ncbors,ncborf,barys,baryf,coordf,
     physol,tmpsa,tmps,tmpsc1,tmpsc2,tmpsc3, volume,surfus,
     b,dmat,xmat,diag, travf,trav1,trav2,trav3,trav4,wct,tmpmax,tmpmin);
  
  proc(cpusyr,CPUSYR)(&timso2);totso+=abs(timso2-timso1); timso=abs(timso2-timso1);
  
  /* Passage des conditions limites du solide vers le fluide
     =======================================================*/

  proc(solflc,SOLFLC)(&un,&un,
		      &ndim,&nbcouf,ncoupf,vcoupf,vcoupf+nbcouf,
		      npoinf,tf,hht,&un,&nbcouf);

  if (ntsyr==ntsmax)
    *fin=1;
  
  if (*fin)
    {
      proc(closct,CLOSCT)();
      printf("\n\n ============================================================================\n");
      proc(cpusyr,CPUSYR)(&timso2);
      printf("\n **TEMPS FINAL : %f\n",timso2);
      
      printf("\n\n          ================================================\n");
      printf("                       SYRTHES : BILAN DU CALCUL\n\n");
      printf("                  CONDUCTION :  %9d PAS DE TEMPS\n",nbpaso);
      printf("                                %9d       NOEUDS\n",npoins);
      printf("                                %9d     ELEMENTS\n",nelems);
      if (lray)
	{
	  printf("                 RAYONNEMENT :  %9d PAS DE TEMPS\n",nbpara);
	  printf("                                %9d     FACETTES\n",nelray);
	}
      printf("          ================================================\n\n\n\n");
      printf("     TEMPS CPU (secondes)\n");
      printf("     =========\n\n");
      printf("     PHASE INITIALE POUR LA CONDUCTION . . . . . . . . %12.4f\n",abs(totsoi-totrai));
      printf("     RESOLUTION DE LA CONDUCTION . . . . . . . . . . . %12.4f\n",abs(totso));
      if (lray)
	{
	  printf("     PHASE INITIALE POUR LE RAYONNEMENT. . . . . . . . %12.4f\n",abs(totrai));
	  printf("     RESOLUTION DU RAYONNEMENT . . . . . . . . . . . . %12.4f\n",abs(totray));
	}
      printf("     T E M P S   T O T A L   . . . . . . . . . . . . . %12.4f\n",abs(totsoi+totso+totray));
      printf("     D U R E E S M O Y E N N E S\n");                       
      printf("        - RESOLUTION DE LA CONDUCTION\n");                  
      printf("                             par pas de temps  . .%12.4f\n",abs(totso)/nbpaso);
      printf("            par pas de temps pour 1000 noeuds  . .%12.4f\n",abs(totso)*1000./(nbpaso*npoins));
      if (lray)
	{
	  printf("        - RESOLUTION DU RAYONNEMENT\n");              
	  printf("                             par pas de temps  . .%12.4f\n",abs(totray)/max(nbpara,1)); 
	}
    }

  fflush(stdout);

  return 0;

}


