C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE SOLFLC
C                       *****************
C
     * (MODE,ITYECH,
     *  NDIM,NBCOUF,NCOUPF,VCOUP1,VCOUP2,
     *  NPOINF,TF,HHT,NWDN,NWN1)
C      ----------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            PASSAGE DES DONNES VOL DU FLUIDE AU TABLEAU VCOUPF        *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  MODE     !  E ! D  ! SENS DE L'INTERPOLATION                      !
C !           !    !    !   = 1 PASSAGE SOLIDE --> FLUIDE              !
C !           !    !    !   = 2 PASSAGE FLUIDE --> SOLIDE              !
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NBCOUF   !  E ! D  ! NOMBRE DE NOEUDS FLUIDES COUPLES             !
C !  NCOUPF   ! TE ! D  ! NUMERO DES NOEUDS FLUIDES COUPLES            !
C !  VCOUPF   ! TR !D M ! VALEUR AUX NOEUDS FLUIDES COUPLES            !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : ---
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) : 
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
C
C **********************************************************************
C..Variables externes
      INTEGER MODE,NDIM,NBCOUF,ITYECH,NPOINF
      INTEGER NCOUPF(NBCOUF,2),NWDN,NWN1
      DOUBLE PRECISION VCOUP1(NBCOUF),VCOUP2(NBCOUF)
      DOUBLE PRECISION TF(NPOINF),HHT(NPOINF)
C
C..Variables internes
      INTEGER NF,NTP,N,NAFFIC
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
C
      IF (MODE.EQ.1) THEN
C
C      1- PASSAGE DU SOLIDE VERS LE FLUIDE
C      ===================================
C
        DO NF=NWDN,NWDN+NWN1-1
          NTP = NCOUPF(NF,1)
          TF(NTP) = VCOUP1(NF)
        ENDDO
C
C       IMPRESSIONS POUR CONTROLE
C       -------------------------
        IF (NBLBLA.EQ.14 .OR. NBLBLA.EQ.141) THEN
          IF (ITYECH.EQ.1) THEN
            WRITE(NFECRA,1010)
          ELSE
            WRITE(NFECRA,1011)
          ENDIF
          IF (NBLBLA.EQ.14) THEN
             NAFFIC=NPOINF
          ELSE
             NAFFIC=50
          ENDIF
          DO N=1,NAFFIC
             WRITE(NFECRA,1020) N,TF(N)
          ENDDO
          CALL FLUSHF(NFECRA)
        ENDIF
C
C
      ELSEIF (MODE.EQ.2) THEN
C
C     2- PASSAGE DU FLUIDE VERS LE SOLIDE
C     ===================================
C
       DO NF=NWDN,NWDN+NWN1-1
        NTP = NCOUPF(NF,1)
        VCOUP1(NF) =  TF(NTP)
        VCOUP2(NF) =  HHT(NTP)
       ENDDO
C
C
        IF (NBLBLA.EQ.14 .OR. NBLBLA.EQ.141) THEN
          IF (ITYECH.EQ.1) THEN
            WRITE(NFECRA,2010)
          ELSE
            WRITE(NFECRA,2011)
          ENDIF
          IF (NBLBLA.EQ.14) THEN
             NAFFIC=NWN1-1
          ELSE
             NAFFIC=50
          ENDIF
          DO N=NWDN,NWDN+NAFFIC
             WRITE(NFECRA,2020) N,VCOUP1(N),VCOUP2(N)
          ENDDO
          CALL FLUSHF(NFECRA)
        ENDIF
C

C     3- SORTIE EN ERREUR
C     ===================
      ELSE
C
        WRITE(NFECRA,3000)
        STOP
C
      ENDIF
C
C
C
C-------
C FORMAT
C-------
C
 1010 FORMAT(/,' *** SOLFLC : PASSAGE DES DONNEES DU SOLIDE',
     &         ' VERS LE FLUIDE',/,
     &          5X,' N fluide      UB3(5,..) ')
 1011 FORMAT(/,' *** SOLFLC : PASSAGE DES DONNEES DU SOLIDE',
     &         ' VERS LE FLUIDE POUR LE RAYONNEMENT EQUIVALENT 1D',/,
     &          5X,' N fluide      UB3(5,..)')
 1020 FORMAT(5X,3X,I10,6X,G13.7)
 2010 FORMAT(/,' *** SOLFLC : PASSAGE DES DONNEES DU FLUIDE',
     &         ' VERS LE SOLIDE  (TF,HHT --> vcoupf)',/,
     &          5X,' N fluide      T              h')
 2011 FORMAT(/,' *** SOLFLC : PASSAGE DES DONNEES DU FLUIDE',
     &         ' VERS LE SOLIDE 1D RAYONEMENT EQUIVALENT ',
     &         '  (TF,HHT --> vrapf)',/,
     &          5X,' N_loc  N_inumt   N_globfluide     T_fluide  ',
     &         '    h_fluide')
 2020 FORMAT(5X,3X,I10,6X,G13.7,3X,G13.7)
 3000 FORMAT(/,'  %% ERREUR SOLFLC : OPTION DE PASSAGE INCORRECTE ')
C
C----
C FIN
C----
      END
          
