C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=SMFCOQ,SSI=0
C
                     SUBROUTINE SMFCOQ
C                    *****************
C
C     ---------------------------------------------------
     * (FLUX,B,NODES,VOLUME,
     *  NPOINS,NELEMS,NDMATS,NDIELE,
     *  WCT)
C     ---------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DU SECOND MEMBRE                           *
C                    POUR LE MODEL COQUE                               *
C                                                                      *
C      Le flux volumique (constant dans l'epaisseur!)                  *
C                                                                      *
C      Les flux sur les surfaces exterieurs et interieures sont du type*
C          Flux dus au couplage thermique fluide -solide               *
C          Flux exterieurs imposes par l'utilisateur                   *
C          Flux ayant pour origine un coefficient d'echange            *
C                                                                      *
C          Le flux est impose sur les noeuds definis par l'utilisateur *
C                                                                      *
C      En surfacique:                                                  *
C      -------------                                                   *
C                          /      +            -                       *
C                 B =     /  ( PHI (+ ou -) PHI )  Phj  dx dy          *
C                        /                                             *
C                 k et q sont discretises en iso-P2                    *
C                 dS element de surface de la coque                    *
C                 Phj fonction de base iso-P2                          *
C                                                                      *
C  Rq : Lorsque le flux n'est pas defini, cela revient a dire          *
C       implicitement que ce flux est nul.                             *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   B       !  TR  ! R  ! SECOND MEMBRE                            !
C   !   NODES   !  TE  ! D  ! NOEUDS DE BORD( LOCALE 2D --> GLOBALE 3D)!
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE                      !
C   !   FLUX    !  TR  ! R  ! FLUX au second membre                    !
C   !   W1...W6 !  TR  ! M  ! TABLEAUX DE TRAVAIL.                     !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDMATS,NDIELE
      INTEGER NODES(NELEMS,NDMATS)
C
      DOUBLE PRECISION FLUX(NPOINS)
      DOUBLE PRECISION B(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
      DOUBLE PRECISION VOLUME(NELEMS)
C
C..Variables locales
      DOUBLE PRECISION ZERO
      DOUBLE PRECISION S48,SV48
      DOUBLE PRECISION F1,F2,F3,F4,F5,F6
      INTEGER I
      INTEGER N1,N2,N3,N4,N5,N6
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      ZERO = 0.D0
      S48 = 1.D0 / 48.D0
C                
C     3- CALCUL DU VECTEUR ELEMENTAIRE 
C     ================================
C
      DO 311 I=1,NELEMS
C
          N1 = NODES(I,1)
          N2 = NODES(I,2)
          N3 = NODES(I,3)
          N4 = NODES(I,4)
          N5 = NODES(I,5)
          N6 = NODES(I,6)                   
C
          SV48 = S48 * VOLUME(I)                                                                             
C            
          F1  = FLUX(N1) * SV48 
          F2  = FLUX(N2) * SV48 
          F3  = FLUX(N3) * SV48
          F4  = FLUX(N4) * SV48 
          F5  = FLUX(N5) * SV48 
          F6  = FLUX(N6) * SV48                   
C
C
C
          WCT(I,1) = 2 * F1 + F4 + F6
          WCT(I,2) = 2 * F2 + F4 + F5
          WCT(I,3) = 2 * F3 + F5 + F6
          WCT(I,4) = F1 + F2 + 6 * F4 + 2 * F5 + 2 * F6
          WCT(I,5) = F2 + F3 + 2 * F4 + 6 * F5 + 2 * F6
          WCT(I,6) = F1 + F3 + 2 * F4 + 2 * F5 + 6 * F6              
C            
  311 CONTINUE
C
C     Assemblage du vecteur au second membre
      CALL OV ( 'X=C     ',B,B,B,ZERO,NPOINS )
      CALL ASSEMB ( B,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT  )
C                               
      END
